/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.javatools.ui.UIBundle;

public final class FontManager {
    private static List<String> fixedList;
    private static List<String> allList;

    private FontManager() {
    }

    private static void updateFontInfo() {
        if (fixedList != null) {
            return;
        }
        FontDialog dialog = new FontDialog();
        dialog.showDialog();
    }

    public static synchronized String[] getFixedWidthFamilies() {
        FontManager.updateFontInfo();
        if (fixedList == null) {
            return new String[0];
        }
        return fixedList.toArray(new String[fixedList.size()]);
    }

    public static synchronized boolean isFontInfoComplete() {
        return fixedList != null;
    }

    public static String[] getAllFontFamilies() {
        if (allList == null) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            allList = new ArrayList<String>(Arrays.asList(graphicsEnvironment.getAvailableFontFamilyNames()));
            Collections.sort(allList);
        }
        return allList.toArray(new String[allList.size()]);
    }

    private static final class FontDialog {
        private JLabel statusLabel;
        private JProgressBar progressBar;
        private JEWTDialog statusDialog;

        private FontDialog() {
        }

        private void showDialog() {
            String initialText = UIBundle.get("FONT_DIALOG_INITIAL_LABEL");
            this.statusLabel = new JLabel(initialText);
            this.progressBar = new JProgressBar();
            this.progressBar.setValue(0);
            this.statusLabel.setLabelFor(this.progressBar);
            JPanel statusPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
            statusPanel.add((Component)this.statusLabel, constraints);
            constraints.gridy = 1;
            statusPanel.add((Component)this.progressBar, constraints);
            constraints.gridy = 2;
            statusPanel.add(Box.createHorizontalStrut(300), constraints);
            String titleText = UIBundle.get("FONT_DIALOG_TITLE");
            this.statusDialog = new JEWTDialog((Frame)null, titleText, 2);
            this.statusDialog.setContent((Component)statusPanel);
            this.statusDialog.setDefaultButton(2);
            CheckFontWorker worker = new CheckFontWorker();
            worker.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("progress")) {
                        progressBar.setValue((Integer)evt.getNewValue());
                    } else if (evt.getPropertyName().equals("state") && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                        statusDialog.setVisible(false);
                    }
                }
            });
            worker.execute();
            this.statusDialog.runDialog();
        }

        private class CheckFontWorker
        extends SwingWorker {
            private CheckFontWorker() {
            }

            protected Object doInBackground() {
                ArrayList<String> newFixedList = new ArrayList<String>();
                long lastPause = System.currentTimeMillis();
                String[] fontsToCheck = FontManager.getAllFontFamilies();
                for (int i = 0; i < fontsToCheck.length; ++i) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    float progress = (float)i / (float)fontsToCheck.length;
                    this.setProgress((int)(progress * 100.0f));
                    String fontToCheck = fontsToCheck[i];
                    Font font = new Font(fontToCheck, 0, 12);
                    FontMetrics metrics = FontDialog.this.statusDialog.getFontMetrics(font);
                    if (metrics.charWidth('l') != metrics.charWidth('w')) continue;
                    newFixedList.add(fontToCheck);
                }
                Collections.sort(newFixedList);
                fixedList = newFixedList;
                return fixedList;
            }
        }
    }
}

