/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

public class Scanner {
    private final String string;
    private final int offset;
    private final int endOffset;
    private final int last;
    private int index;
    private char current;
    private StringBuilder builder;

    public Scanner(String string) {
        this(string, 0, string.length(), false);
    }

    public Scanner(String string, int offset, int endOffset) {
        this(string, offset, endOffset, false);
    }

    public Scanner(String string, boolean trimWhiteSpace) {
        this(string, 0, string.length(), trimWhiteSpace);
    }

    public Scanner(String string, int offset, int endOffset, boolean trimWhiteSpace) {
        if (trimWhiteSpace) {
            while (endOffset > offset && Character.isWhitespace(string.charAt(endOffset - 1))) {
                --endOffset;
            }
            while (offset < endOffset && Character.isWhitespace(string.charAt(offset))) {
                ++offset;
            }
        }
        this.string = string;
        this.offset = offset;
        this.endOffset = endOffset;
        this.index = offset - 1;
        this.last = endOffset - 1;
    }

    public char current() {
        if (this.current == '\u0000') {
            throw new IllegalStateException("character consumed");
        }
        return this.current;
    }

    public char consume() {
        if (this.current == '\u0000') {
            throw new IllegalStateException("character consumed");
        }
        char result = this.current;
        this.current = '\u0000';
        return result;
    }

    public char next() {
        if (this.index < this.last) {
            if (this.current != '\u0000' && this.builder != null) {
                this.builder.append(this.current);
            }
            this.current = this.string.charAt(++this.index);
        } else {
            if (this.index > this.last) {
                throw new IllegalStateException("scanner exhausted");
            }
            if (this.current != '\u0000' && this.builder != null) {
                this.builder.append(this.current);
            }
            ++this.index;
            this.current = '\u0000';
        }
        return this.current;
    }

    public boolean done() {
        return this.index > this.last;
    }

    public int index() {
        return this.index;
    }

    public boolean isWhiteSpace() {
        if (this.current == '\u0000') {
            throw new IllegalStateException("character consumed");
        }
        return Character.isWhitespace(this.current);
    }

    public String getBackingString() {
        return this.string;
    }

    public String getTrimmedInitialString() {
        return this.string.substring(this.offset, this.endOffset);
    }

    public String substring(int offset) {
        return this.string.substring(offset, this.index);
    }

    public String substring(int offset, int endOffset) {
        return this.string.substring(offset, endOffset);
    }

    public String label() {
        return this.current == '\u0000' ? this.endLabel() : "'" + String.valueOf(this.current) + "'";
    }

    public String endLabel() {
        return "END-OF-TEXT";
    }

    public void reject(char c) {
        if (c != this.current) {
            throw new IllegalArgumentException("character not current");
        }
        if (this.builder == null) {
            this.builder = new StringBuilder(this.string.length());
            this.builder.append(this.string, 0, this.index);
        }
        this.current = '\u0000';
    }

    public void replace(char oldC, char newC) {
        if (oldC != this.current) {
            throw new IllegalArgumentException("character not current");
        }
        if (newC == this.current) {
            return;
        }
        if (this.builder == null) {
            this.builder = new StringBuilder(this.string.length());
            this.builder.append(this.string, 0, this.index);
        }
        this.current = newC;
    }

    public void rewrite(String prefix) {
        this.builder = new StringBuilder(this.string.length());
        this.builder.append(prefix);
    }

    public char rejectWhiteSpace() {
        if (this.current != '\u0000') {
            if (!Character.isWhitespace(this.current)) {
                return '\u0000';
            }
            this.reject(this.current);
        }
        while (this.index <= this.last && Character.isWhitespace(this.next())) {
            this.reject(this.current);
        }
        return this.current;
    }

    public char nextAndRejectWhiteSpace() {
        this.next();
        return this.rejectWhiteSpace();
    }

    public String toString() {
        return this.builder == null ? this.string.substring(this.offset, this.endOffset) : (this.current == '\u0000' ? this.builder.toString() : this.builder.append(this.current).toString());
    }
}

