/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.TypeExportSpecification;

public class PackageExportSpecification {
    public static final PackageExportSpecification EXPORTED_MEMBERS_EXPORTED = new PackageExportSpecification(CompatibilityAccess.EXPORTED, null, null, null);
    public static final PackageExportSpecification RESTRICTED_MEMBERS_RESTRICTED = new PackageExportSpecification(CompatibilityAccess.RESTRICTED, null, null, null);
    public static final PackageExportSpecification CONCEALED_MEMBERS_CONCEALED = new PackageExportSpecification(CompatibilityAccess.CONCEALED, null, null, null);
    public static final PackageExportSpecification NULL_MEMBERS_NULL = new PackageExportSpecification(null, null, null, null);
    private final Map<TypeName, TypeExportSpecification> types;
    private final Set<TypeName> interfaces;
    private final Map<String, CompatibilityAccess> resources;
    private final TypeExportSpecification defaultMemberAccess;

    public PackageExportSpecification(CompatibilityAccess defaultMemberAccess, Map<TypeName, TypeExportSpecification> types, Set<TypeName> interfaces, Map<String, CompatibilityAccess> resources) {
        if (types == null) {
            types = Collections.emptyMap();
        }
        if (interfaces == null) {
            interfaces = Collections.emptySet();
        }
        if (resources == null) {
            resources = Collections.emptyMap();
        }
        this.types = types;
        this.interfaces = interfaces;
        this.resources = resources;
        if (defaultMemberAccess == null) {
            this.defaultMemberAccess = TypeExportSpecification.DEFAULT_NULL;
        } else if (defaultMemberAccess == CompatibilityAccess.CONCEALED) {
            this.defaultMemberAccess = TypeExportSpecification.DEFAULT_CONCEALED;
        } else if (defaultMemberAccess == CompatibilityAccess.RESTRICTED) {
            this.defaultMemberAccess = TypeExportSpecification.DEFAULT_RESTRICTED;
        } else if (defaultMemberAccess == CompatibilityAccess.EXPORTED) {
            this.defaultMemberAccess = TypeExportSpecification.DEFAULT_EXPORTED;
        } else {
            throw new IllegalArgumentException("defaultMemberAccess == " + defaultMemberAccess);
        }
    }

    public Merge<PackageExportSpecification> merge(PackageExportSpecification that) {
        if (this.defaultMemberAccess == null) {
            throw new IllegalStateException("merging uncontrolled package: " + this);
        }
        if (this.defaultMemberAccess.getAccess().isConcealed() && this.types.isEmpty() && this.resources.isEmpty()) {
            throw new IllegalStateException("merging concealed package: " + this);
        }
        if (that.defaultMemberAccess == null) {
            throw new IllegalStateException("merging uncontrolled package: " + that);
        }
        if (that.defaultMemberAccess.getAccess().isConcealed() && that.types.isEmpty() && that.resources.isEmpty()) {
            throw new IllegalStateException("merging concealed package: " + that);
        }
        Merge<PackageExportSpecification> merge = new Merge<PackageExportSpecification>(this, that, "package export specification", new Object[0]);
        if (merge.completeIfEqual()) {
            return merge;
        }
        TypeExportSpecification thisDefaultMemberAccess = this.defaultMemberAccess;
        TypeExportSpecification thatDefaultMemberAccess = that.defaultMemberAccess;
        CompatibilityAccess thisAccess = thisDefaultMemberAccess.getDefaultMemberAccess();
        CompatibilityAccess thatAccess = thatDefaultMemberAccess.getDefaultMemberAccess();
        Merge<TypeExportSpecification> mergedDefaultMemberAccess = new Merge<TypeExportSpecification>(thisDefaultMemberAccess, thatDefaultMemberAccess, "defaultMemberAccess", new Object[0]);
        TypeExportSpecification adjustedAccess = null;
        if (!mergedDefaultMemberAccess.completeIfEqual()) {
            mergedDefaultMemberAccess.completeWarning(CompatibilityAccess.isMoreExported(thisAccess, thatAccess) ? thisDefaultMemberAccess : thatDefaultMemberAccess);
            adjustedAccess = mergedDefaultMemberAccess.getValue();
        }
        merge.addMerge(mergedDefaultMemberAccess);
        Map<TypeName, TypeExportSpecification> thisTypes = this.types;
        Map<TypeName, TypeExportSpecification> thatTypes = that.types;
        Merge<Map<TypeName, TypeExportSpecification>> mergedTypes = new Merge<Map<TypeName, TypeExportSpecification>>(thisTypes, thatTypes, "types", new Object[0]);
        if (!mergedTypes.completeIfEqual()) {
            if (thisTypes.isEmpty() && CompatibilityAccess.isExported(thisAccess)) {
                mergedTypes.complete(thisTypes);
            } else if (thatTypes.isEmpty() && CompatibilityAccess.isExported(thatAccess)) {
                mergedTypes.complete(thatTypes);
            } else if (thisTypes.isEmpty() && CompatibilityAccess.isConcealedOrNull(thisAccess)) {
                mergedTypes.complete(thatTypes);
            } else if (thatTypes.isEmpty() && CompatibilityAccess.isConcealedOrNull(thatAccess)) {
                mergedTypes.complete(thisTypes);
            } else {
                if (adjustedAccess != null) {
                    Map<TypeName, TypeExportSpecification> moreExportedTypes;
                    Object lessExportedTypes;
                    if (adjustedAccess == thisDefaultMemberAccess) {
                        lessExportedTypes = new LinkedHashMap<TypeName, TypeExportSpecification>(thatTypes);
                        thatTypes = lessExportedTypes;
                        moreExportedTypes = thisTypes;
                    } else {
                        lessExportedTypes = new LinkedHashMap<TypeName, TypeExportSpecification>(thisTypes);
                        thisTypes = lessExportedTypes;
                        moreExportedTypes = thatTypes;
                    }
                    Iterator iterator = lessExportedTypes.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        if (moreExportedTypes.containsKey(entry.getKey())) continue;
                        Merge<TypeExportSpecification> typeMerge = ((TypeExportSpecification)entry.getValue()).merge(adjustedAccess);
                        if (adjustedAccess == typeMerge.getValue()) {
                            iterator.remove();
                            continue;
                        }
                        entry.setValue(typeMerge.getValue());
                        mergedTypes.addMerge(typeMerge);
                    }
                }
                Map<TypeName, TypeExportSpecification> union = new LinkedHashMap<TypeName, TypeExportSpecification>(thisTypes);
                for (Map.Entry entry : thatTypes.entrySet()) {
                    TypeExportSpecification thatType;
                    TypeName typeName = (TypeName)entry.getKey();
                    TypeExportSpecification thisType = union.putIfAbsent(typeName, thatType = (TypeExportSpecification)entry.getValue());
                    if (thisType == null) continue;
                    Merge<TypeExportSpecification> mergedType = thisType.merge(thatType);
                    union.put(typeName, mergedType.getValue());
                    mergedTypes.addMerge(mergedType);
                }
                if (union.isEmpty()) {
                    union = Collections.emptyMap();
                }
                mergedTypes.complete(union);
            }
        }
        merge.addMerge(mergedTypes);
        Set<TypeName> thisInterfaces = this.interfaces;
        Set<TypeName> thatInterfaces = that.interfaces;
        Merge<Set<TypeName>> merge2 = new Merge<Set<TypeName>>(thisInterfaces, thatInterfaces, "interfaces", new Object[0]);
        TreeSet<TypeName> set = new TreeSet<TypeName>(thisInterfaces);
        set.addAll(thatInterfaces);
        set.retainAll(this.types.keySet());
        if (thisInterfaces.equals(thatInterfaces) && thisInterfaces.equals(set)) {
            merge2.complete(thisInterfaces);
        } else {
            merge2.completeWarning(set);
        }
        Map<String, CompatibilityAccess> thisResources = this.resources;
        Map<String, CompatibilityAccess> thatResources = that.resources;
        Merge<Map<String, CompatibilityAccess>> mergedResources = new Merge<Map<String, CompatibilityAccess>>(thisResources, thatResources, "resources", new Object[0]);
        if (!mergedResources.completeIfEqual()) {
            if (thisResources.isEmpty() && CompatibilityAccess.isExported(thisAccess)) {
                mergedResources.complete(thisResources);
            } else if (thatResources.isEmpty() && CompatibilityAccess.isExported(thatAccess)) {
                mergedResources.complete(thatResources);
            } else if (thisResources.isEmpty() && CompatibilityAccess.isConcealedOrNull(thisAccess)) {
                mergedResources.complete(thatResources);
            } else if (thatResources.isEmpty() && CompatibilityAccess.isConcealedOrNull(thatAccess)) {
                mergedResources.complete(thisResources);
            } else {
                if (adjustedAccess != null) {
                    Map<String, CompatibilityAccess> moreExportedResources;
                    LinkedHashMap<String, CompatibilityAccess> lessExportedResources;
                    if (adjustedAccess == thisDefaultMemberAccess) {
                        lessExportedResources = new LinkedHashMap<String, CompatibilityAccess>(thatResources);
                        thatResources = lessExportedResources;
                        moreExportedResources = thisResources;
                    } else {
                        lessExportedResources = new LinkedHashMap<String, CompatibilityAccess>(thisResources);
                        thisResources = lessExportedResources;
                        moreExportedResources = thatResources;
                    }
                    Iterator i = lessExportedResources.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = i.next();
                        if (moreExportedResources.containsKey(entry.getKey())) continue;
                        Merge<CompatibilityAccess> mergedResource = new Merge<CompatibilityAccess>((CompatibilityAccess)((Object)entry.getValue()), adjustedAccess.getAccess(), "resource", new Object[0]);
                        if (!mergedResource.completeIfEqual()) {
                            mergedResource.completeWarning(CompatibilityAccess.mostExported((CompatibilityAccess)((Object)entry.getValue()), adjustedAccess.getAccess()));
                        }
                        if (adjustedAccess.getAccess() == mergedResource.getValue()) {
                            i.remove();
                            continue;
                        }
                        entry.setValue(mergedResource.getValue());
                        merge.addMerge(mergedResource);
                    }
                }
                Map<String, CompatibilityAccess> union = new LinkedHashMap<String, CompatibilityAccess>(thisResources);
                for (Map.Entry<String, CompatibilityAccess> entry : thatResources.entrySet()) {
                    CompatibilityAccess thatResource;
                    String resourceName = entry.getKey();
                    CompatibilityAccess thisResource = union.putIfAbsent(resourceName, thatResource = entry.getValue());
                    if (thisResource == null) continue;
                    Merge<CompatibilityAccess> mergedResource = new Merge<CompatibilityAccess>(thisResource, thatResource, "resource", new Object[0]);
                    if (!mergedResource.completeIfEqual()) {
                        mergedResource.completeWarning(CompatibilityAccess.mostExported(thisResource, thatResource));
                    }
                    union.put(resourceName, mergedResource.getValue());
                    mergedResources.addMerge(mergedResource);
                }
                if (union.isEmpty()) {
                    union = Collections.emptyMap();
                }
                mergedResources.complete(union);
            }
        }
        merge.addMerge(mergedResources);
        merge.complete(new PackageExportSpecification(mergedDefaultMemberAccess.getValue().getAccess(), mergedTypes.getValue(), this.interfaces, mergedResources.getValue()));
        return merge;
    }

    public TypeExportSpecification getType(TypeName name) {
        return this.types.getOrDefault(name, this.defaultMemberAccess);
    }

    public boolean isInterface(TypeName name) {
        return this.interfaces.contains(name);
    }

    public CompatibilityAccess getResource(String name) {
        return this.resources.getOrDefault(name, this.defaultMemberAccess.getAccess());
    }

    public Set<TypeName> getTypeNames() {
        return this.types != null ? this.types.keySet() : null;
    }

    public Set<String> getResourceNames() {
        return this.resources.keySet();
    }

    public CompatibilityAccess getDefaultMemberAccess() {
        return this.defaultMemberAccess.getAccess();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PackageExportSpecification)) {
            return false;
        }
        PackageExportSpecification that = (PackageExportSpecification)object;
        if (!Objects.equals(this.defaultMemberAccess, that.defaultMemberAccess)) {
            return false;
        }
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        return this.types.equals(that.types);
    }

    public int hashCode() {
        int result = this.types.hashCode();
        result = 31 * result + this.resources.hashCode();
        result = 31 * result + this.defaultMemberAccess.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.types.isEmpty() ? "[*]" : this.types.keySet());
        builder.append(this.resources.isEmpty() ? "[*]" : this.resources.keySet());
        builder.append((Object)this.defaultMemberAccess.getAccess());
        return builder.toString();
    }
}

