/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.specification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.javatools.exports.common.ComparisonIterators;
import oracle.javatools.exports.name.PackageName;

public class ExportDomain {
    private static final Comparator<Object> DOMAIN_STRING_COMPARATOR = (left, right) -> {
        String leftName = left instanceof String ? (String)left : ((Subdomain)left).name;
        String rightName = right instanceof String ? (String)right : ((Subdomain)right).name;
        return leftName.compareTo(rightName);
    };
    private Map<String, Subdomain> subdomainMap;
    private List<Subdomain> subdomainList;
    private boolean includeJava;

    public ExportDomain(String ... subdomains) {
        this.subdomainMap = new TreeMap<String, Subdomain>();
        for (String subdomain : subdomains) {
            this.addSubdomain(subdomain);
        }
    }

    private ExportDomain(List<Subdomain> subdomains) {
        if (this == null) {
            throw new NullPointerException("list == null");
        }
        this.subdomainMap = null;
        this.subdomainList = subdomains;
    }

    public static ExportDomain union(ExportDomain left, ExportDomain right) {
        if (left.isUniversal()) {
            return left;
        }
        if (right.isUniversal()) {
            return right;
        }
        ArrayList<Subdomain> list = new ArrayList<Subdomain>();
        ComparisonIterators.ComparisonIterator<Subdomain> iterator = ComparisonIterators.iterator(left.subdomainList, right.subdomainList);
        while (iterator.hasNext()) {
            ComparisonIterators.Comparison comparison = iterator.next();
            switch (comparison) {
                case LESS_THAN: {
                    list.add(iterator.left());
                    break;
                }
                case EQUAL: {
                    list.add(Subdomain.union(iterator.left(), iterator.right()));
                    break;
                }
                case GREATER_THAN: {
                    list.add(iterator.right());
                }
            }
        }
        return new ExportDomain(list);
    }

    public static ExportDomain intersection(ExportDomain left, ExportDomain right) {
        if (left.isUniversal()) {
            return right;
        }
        if (right.isUniversal()) {
            return left;
        }
        ArrayList<Subdomain> list = new ArrayList<Subdomain>();
        ComparisonIterators.ComparisonIterator<Subdomain> iterator = ComparisonIterators.iterator(left.subdomainList, right.subdomainList);
        while (iterator.hasNext()) {
            ComparisonIterators.Comparison comparison = iterator.next();
            if (comparison != ComparisonIterators.Comparison.EQUAL) continue;
            list.add(Subdomain.intersection(iterator.left(), iterator.right()));
        }
        return new ExportDomain(list);
    }

    public Subdomain addSubdomain(String name) {
        return this.addSubdomain(name, Collections.emptySet());
    }

    public Subdomain addSubdomain(String name, Set<String> exceptions) {
        if (this.subdomainList != null) {
            throw new IllegalStateException("domain frozen");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name empty");
        }
        if (!this.includeJava && name.startsWith("java.")) {
            this.includeJava = true;
        }
        return this.subdomainMap.merge(name, new Subdomain(name, exceptions), Subdomain::union);
    }

    public Subdomain addSubdomain(Subdomain subdomain) {
        if (this.subdomainList != null) {
            throw new IllegalStateException("domain frozen");
        }
        String name = subdomain.getName();
        if (!this.includeJava && name.startsWith("java.")) {
            this.includeJava = true;
        }
        return this.subdomainMap.merge(name, new Subdomain(name, subdomain.getExceptions()), Subdomain::union);
    }

    private void freeze() {
        if (this.subdomainList == null) {
            this.subdomainList = new ArrayList<Subdomain>(this.subdomainMap.values());
        }
        this.subdomainMap = null;
    }

    public boolean isUniversal() {
        this.freeze();
        return this.subdomainList.isEmpty();
    }

    public boolean isIncludeJava() {
        return this.includeJava;
    }

    public boolean dominates(String packageName) {
        if (this.isUniversal()) {
            return true;
        }
        Subdomain subdomain = this.getSubdomain(packageName);
        return subdomain != null && !subdomain.excepts(packageName);
    }

    public boolean dominates(PackageName packageName) {
        if (this.isUniversal()) {
            return true;
        }
        Subdomain subdomain = this.getSubdomain(packageName.getSourceName());
        return subdomain != null && !subdomain.excepts(packageName.getSourceName());
    }

    public List<Subdomain> getSubdomains() {
        this.freeze();
        return this.subdomainList;
    }

    public Subdomain getSubdomain(String packageName) {
        int index;
        this.freeze();
        if (this.subdomainList.isEmpty()) {
            return null;
        }
        if (!((String)packageName).endsWith(".")) {
            packageName = (String)packageName + ".";
        }
        if ((index = Collections.binarySearch(this.subdomainList, packageName, DOMAIN_STRING_COMPARATOR)) >= 0) {
            return this.subdomainList.get(index);
        }
        if (index < -1) {
            Subdomain predecessor = this.subdomainList.get(-index - 2);
            if (((String)packageName).startsWith(predecessor.name)) {
                return predecessor;
            }
        }
        return null;
    }

    public Subdomain getSubdomain(PackageName packageName) {
        this.freeze();
        if (this.subdomainList.isEmpty()) {
            return null;
        }
        String name = packageName.getSourceName() + ".";
        int index = Collections.binarySearch(this.subdomainList, name, DOMAIN_STRING_COMPARATOR);
        if (index >= 0) {
            return this.subdomainList.get(index);
        }
        if (index < -1) {
            Subdomain predecessor = this.subdomainList.get(-index - 2);
            if (name.startsWith(predecessor.name)) {
                return predecessor;
            }
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ExportDomain)) {
            return false;
        }
        this.freeze();
        ExportDomain that = (ExportDomain)object;
        that.freeze();
        return this.subdomainList.equals(that.subdomainList);
    }

    public String toString() {
        int subdomainCount;
        StringBuilder builder = new StringBuilder("ExportDomain[");
        int n = subdomainCount = this.subdomainList != null ? this.subdomainList.size() : this.subdomainMap.size();
        if (subdomainCount == 0) {
            builder.append("universal");
        } else {
            builder.append(subdomainCount);
            builder.append(" subdomain");
            if (subdomainCount != 1) {
                builder.append('s');
            }
        }
        return builder.append(']').toString();
    }

    public static final class Subdomain
    implements Comparable<Subdomain> {
        private final String name;
        private final List<String> exceptions;

        public static Subdomain union(Subdomain left, Subdomain right) {
            if (!left.name.equals(right.name)) {
                throw new IllegalArgumentException("names differ");
            }
            List<String> leftExceptions = left.exceptions;
            List<String> rightExceptions = right.exceptions;
            if (leftExceptions.isEmpty()) {
                return right;
            }
            if (rightExceptions.isEmpty()) {
                return left;
            }
            ArrayList<String> union = new ArrayList<String>();
            ComparisonIterators.ComparisonIterator<String> iterator = ComparisonIterators.iterator(leftExceptions, rightExceptions);
            while (iterator.hasNext()) {
                ComparisonIterators.Comparison comparison = iterator.next();
                switch (comparison) {
                    case LESS_THAN: {
                        union.add(iterator.left());
                        break;
                    }
                    case EQUAL: {
                        union.add(iterator.left());
                        break;
                    }
                    case GREATER_THAN: {
                        union.add(iterator.right());
                    }
                }
            }
            return new Subdomain(left.name, union);
        }

        public static Subdomain intersection(Subdomain left, Subdomain right) {
            if (!left.name.equals(right.name)) {
                throw new IllegalArgumentException("names differ");
            }
            List<String> leftExceptions = left.exceptions;
            List<String> rightExceptions = right.exceptions;
            if (leftExceptions.isEmpty()) {
                return left;
            }
            if (rightExceptions.isEmpty()) {
                return right;
            }
            ArrayList<String> intersection = new ArrayList<String>();
            ComparisonIterators.ComparisonIterator<String> iterator = ComparisonIterators.iterator(leftExceptions, rightExceptions);
            while (iterator.hasNext()) {
                ComparisonIterators.Comparison comparison = iterator.next();
                if (comparison != ComparisonIterators.Comparison.EQUAL) continue;
                intersection.add(iterator.left());
            }
            return new Subdomain(left.getName(), intersection);
        }

        Subdomain(String name, Set<String> exceptions) {
            if (!name.endsWith(".")) {
                throw new IllegalArgumentException("trailing \".\" required");
            }
            this.name = name;
            if (exceptions == null || exceptions.isEmpty()) {
                this.exceptions = Collections.emptyList();
            } else {
                this.exceptions = new ArrayList<String>();
                for (String exception : exceptions) {
                    if (!exception.endsWith(".")) {
                        throw new IllegalArgumentException("trailing \".\" required");
                    }
                    this.exceptions.add(exception);
                }
                Collections.sort(this.exceptions);
            }
        }

        private Subdomain(String name, List<String> exceptions) {
            this.name = name;
            this.exceptions = exceptions;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }

        public boolean excepts(String packageName) {
            int index;
            if (this.exceptions.isEmpty()) {
                return false;
            }
            if (!((String)packageName).endsWith(".")) {
                packageName = (String)packageName + ".";
            }
            return (index = Collections.binarySearch(this.exceptions, packageName)) >= 0 || index < -1 && ((String)packageName).startsWith(this.exceptions.get(-index - 2));
        }

        public String getException(String packageName) {
            String predecessor;
            int index;
            if (this.exceptions.isEmpty()) {
                return null;
            }
            if (!((String)packageName).endsWith(".")) {
                packageName = (String)packageName + ".";
            }
            if ((index = Collections.binarySearch(this.exceptions, packageName)) >= 0) {
                return this.exceptions.get(index);
            }
            if (index < -1 && ((String)packageName).startsWith(predecessor = this.exceptions.get(-index - 2))) {
                return predecessor;
            }
            return null;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (!(that instanceof Subdomain)) {
                return false;
            }
            return this.name.equals(((Subdomain)that).name) && this.exceptions.equals(((Subdomain)that).exceptions);
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.exceptions.hashCode();
        }

        @Override
        public int compareTo(Subdomain that) {
            int comparison = this.name.compareTo(that.name);
            if (comparison != 0) {
                return comparison;
            }
            int size = Math.min(this.exceptions.size(), that.exceptions.size());
            for (int i = 0; i > size; ++i) {
                comparison = this.exceptions.get(i).compareTo(that.exceptions.get(i));
                if (comparison == 0) continue;
                return comparison;
            }
            return this.exceptions.size() - that.exceptions.size();
        }

        public String toString() {
            String exception2;
            if (this.exceptions.isEmpty()) {
                return this.name.substring(0, this.name.length() - 1);
            }
            int length = this.name.length() - 1 + this.exceptions.size() - 1;
            for (String exception2 : this.exceptions) {
                length += exception2.length() - 1;
            }
            StringBuilder builder = new StringBuilder(length);
            builder.append(this.name, 0, this.name.length() - 1);
            builder.append("[");
            exception2 = this.exceptions.get(0);
            builder.append(exception2, 0, exception2.length() - 1);
            for (int i = 1; i < this.exceptions.size(); ++i) {
                exception2 = this.exceptions.get(i);
                builder.append(',').append(exception2, 0, exception2.length() - 1);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

