/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.report;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.javatools.exports.common.ComparisonIterators;
import oracle.javatools.exports.report.IssueComparator;
import oracle.javatools.exports.report.IssueHandler;
import oracle.javatools.exports.report.IssueModel;
import oracle.javatools.exports.report.IssueProperty;
import oracle.javatools.exports.report.ReportReader;
import org.xml.sax.SAXException;

public class IssuesReport {
    public static final IssueProperty<Path> WORKSPACE = new IssueProperty<Path>("WORKSPACE"){

        @Override
        public Path getValue(IssueModel issue) {
            return issue.getWorkspace();
        }
    };
    public static final IssueProperty<Path> PROJECT = new IssueProperty<Path>("PROJECT"){

        @Override
        public Path getValue(IssueModel issue) {
            return issue.getProject();
        }
    };
    public static final IssueProperty<Path> DIRECTORY = new IssueProperty<Path>("DIRECTORY"){

        @Override
        public Path getValue(IssueModel issue) {
            return issue.getDirectory();
        }
    };
    public static final IssueProperty<Path> FILE = new IssueProperty<Path>("FILE"){

        @Override
        public Path getValue(IssueModel issue) {
            return issue.getFile();
        }
    };
    public static final IssueProperty<Integer> LINE = new IssueProperty<Integer>("LINE"){

        @Override
        public Integer getValue(IssueModel issue) {
            return issue.getLine();
        }

        @Override
        public int compareValue(IssueModel left, IssueModel right) {
            return Integer.compare(left.getLine(), right.getLine());
        }
    };
    public static final IssueProperty<Integer> COLUMN = new IssueProperty<Integer>("COLUMN"){

        @Override
        public Integer getValue(IssueModel issue) {
            return issue.getColumn();
        }

        @Override
        public int compareValue(IssueModel left, IssueModel right) {
            return Integer.compare(left.getColumn(), right.getColumn());
        }
    };
    public static final IssueProperty<String> RULE = new IssueProperty<String>("RULE"){

        @Override
        public String getValue(IssueModel issue) {
            return issue.getRule();
        }
    };
    public static final IssueProperty<String> VARIATION = new IssueProperty<String>("VARIATION"){

        @Override
        public String getValue(IssueModel issue) {
            return issue.getVariation();
        }
    };
    public static final IssueProperty<Boolean> SUPPRESSED = new IssueProperty<Boolean>("SUPPRESSED"){

        @Override
        public Boolean getValue(IssueModel issue) {
            return issue.isSuppressed();
        }
    };
    public static final IssueProperty<String> MESSAGE = new IssueProperty<String>("MESSAGE"){

        @Override
        public String getValue(IssueModel issue) {
            return issue.getMessage();
        }
    };
    private final Set<String> rules;
    private final String pathPrefixPattern;
    private final Map<String, IssueHandler> handlers;
    private final Map<String, IssueProperty<?>> properties;
    private final ArrayList<IssueModel> issues = new ArrayList();
    private boolean sorted = true;
    private ReportReader reader;

    public IssuesReport(Set<String> rules, String pathPrefixPattern) {
        this.rules = rules;
        this.pathPrefixPattern = pathPrefixPattern;
        this.handlers = new HashMap<String, IssueHandler>();
        this.properties = new HashMap();
        for (IssueProperty property : new IssueProperty[]{WORKSPACE, PROJECT, DIRECTORY, FILE, LINE, COLUMN, RULE, VARIATION, SUPPRESSED, MESSAGE}) {
            this.properties.put(property.getName(), property);
        }
    }

    public IssuesReport(IssuesReport report) {
        this.rules = report.rules;
        this.pathPrefixPattern = report.pathPrefixPattern;
        this.handlers = report.handlers;
        this.properties = report.properties;
    }

    public void addIssueHandler(IssueHandler handler) {
        if (this.reader != null) {
            throw new IllegalStateException("issues already read");
        }
        for (String rule : handler.getRules()) {
            this.handlers.putIfAbsent(rule, handler);
        }
        for (IssueProperty property : handler.getProperties()) {
            this.properties.putIfAbsent(property.getName(), property);
        }
    }

    public void issueReported(Path workspace, Path project, Path directory, Path file, int line, int column, String rule, String variation, boolean suppressed, String message) {
        if (this.rules.isEmpty() || this.rules.contains(rule)) {
            IssueHandler handler = this.handlers.get(rule);
            if (handler != null) {
                this.issues.add(handler.issueReported(workspace, project, directory, file, line, column, rule, variation, suppressed, message));
            } else {
                this.issues.add(new IssueModel(workspace, project, directory, file, line, column, rule, variation, suppressed, message));
            }
            this.sorted = false;
        }
    }

    public String getPathPrefixPattern() {
        return this.pathPrefixPattern;
    }

    public void read(Path path) throws SAXException {
        if (this.reader == null) {
            this.reader = new ReportReader(this);
        }
        this.reader.read(path);
    }

    public Collection<IssueModel> getIssues() {
        this.sorted = !this.sorted;
        if (this.sorted) {
            Collections.sort(this.issues);
        }
        return this.issues;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public IssueProperty<?> getProperty(String name) {
        return this.properties.get(name.toUpperCase());
    }

    public Collection<IssueModel> getIssues(IssueComparator comparator) {
        ArrayList<IssueModel> issues = new ArrayList<IssueModel>(this.issues);
        issues.sort(comparator);
        return issues;
    }

    public static Collection<Difference> compare(IssuesReport leftReport, IssuesReport rightReport, IssueProperty<?> ... properties) {
        IssueComparator comparator = new IssueComparator(properties);
        ComparisonIterators.ComparisonIterator<IssueModel> comparison = ComparisonIterators.iterator(leftReport.getIssues(comparator), rightReport.getIssues(comparator), comparator);
        ArrayList<Difference> differences = new ArrayList<Difference>();
        while (comparison.hasNext()) {
            IssueModel left = null;
            IssueModel right = null;
            switch (comparison.next()) {
                case LESS_THAN: {
                    left = comparison.left();
                    break;
                }
                case EQUAL: {
                    left = comparison.left();
                    right = comparison.right();
                    break;
                }
                case GREATER_THAN: {
                    right = comparison.right();
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected comparison type");
                }
            }
            differences.add(new Difference(left, right));
        }
        return differences;
    }

    public static class Difference {
        private final IssueModel left;
        private final IssueModel right;

        public Difference(IssueModel left, IssueModel right) {
            if (left == null && right == null) {
                throw new IllegalStateException("left and right null");
            }
            this.left = left;
            this.right = right;
        }

        public IssueModel getLeft() {
            return this.left;
        }

        public IssueModel getRight() {
            return this.right;
        }

        public IssueModel getLeftOrRight() {
            return this.left != null ? this.left : this.right;
        }

        public static Comparator<Difference> comparator(IssueProperty<?> ... properties) {
            return (left, right) -> {
                IssueModel leftIssue = left.getLeftOrRight();
                IssueModel rightIssue = right.getLeftOrRight();
                for (IssueProperty property : properties) {
                    int comparison = property.compareValue(leftIssue, rightIssue);
                    if (comparison == 0) continue;
                    return comparison;
                }
                return 0;
            };
        }
    }
}

