/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.PackageName;

public abstract class ElementName
implements Comparable<ElementName> {
    public abstract ElementKind getKind();

    public abstract int getLevel();

    public abstract ElementName getParent();

    public abstract PackageName getPackage();

    public abstract String getSimpleName();

    public abstract String getSourceName();

    public abstract void writeSourceName(Writer var1) throws IOException;

    public abstract String getQualifiedSourceName();

    public abstract StringBuilder appendQualifiedSourceName(StringBuilder var1);

    public abstract void writeQualifiedSourceName(Writer var1) throws IOException;

    public abstract String getBinaryName();

    public abstract void writeBinaryName(Writer var1) throws IOException;

    public abstract String getQualifiedBinaryName();

    public abstract StringBuilder appendQualifiedBinaryName(StringBuilder var1);

    public abstract void writeQualifiedBinaryName(Writer var1) throws IOException;

    public abstract String getHybridName();

    public abstract void writeHybridName(Writer var1) throws IOException;

    public abstract String getQualifiedHybridName();

    public abstract StringBuilder appendQualifiedHybridName(StringBuilder var1);

    public abstract void writeQualifiedHybridName(Writer var1) throws IOException;

    public String getName(NameFormat format) {
        switch (format) {
            case HYBRID: {
                return this.getHybridName();
            }
            case BINARY: {
                return this.getBinaryName();
            }
            case SOURCE: {
                return this.getSourceName();
            }
        }
        throw new IllegalStateException("format == " + format);
    }

    public String getQualifiedName(NameFormat format) {
        switch (format) {
            case HYBRID: {
                return this.getQualifiedHybridName();
            }
            case BINARY: {
                return this.getQualifiedBinaryName();
            }
            case SOURCE: {
                return this.getQualifiedSourceName();
            }
        }
        throw new IllegalStateException("format == " + format);
    }

    public StringBuilder appendQualifiedName(StringBuilder builder, NameFormat format) {
        switch (format) {
            case HYBRID: {
                return this.appendQualifiedHybridName(builder);
            }
            case BINARY: {
                return this.appendQualifiedBinaryName(builder);
            }
            case SOURCE: {
                return this.appendQualifiedSourceName(builder);
            }
        }
        throw new IllegalStateException("format == " + format);
    }

    public void writeQualifiedName(Writer writer, NameFormat format) throws IOException {
        switch (format) {
            case HYBRID: {
                this.writeQualifiedHybridName(writer);
                break;
            }
            case BINARY: {
                this.writeQualifiedBinaryName(writer);
                break;
            }
            case SOURCE: {
                this.writeQualifiedSourceName(writer);
                break;
            }
            default: {
                throw new IllegalStateException("format == " + format);
            }
        }
    }

    @Override
    public abstract int compareTo(ElementName var1);

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public String toString() {
        return this.getQualifiedSourceName();
    }
}

