/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.installation;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.common.Iterables;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.extension.Extension;
import oracle.javatools.exports.extension.ExtensionManifestReader;
import oracle.javatools.exports.file.NestedFileSystemProvider;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.installation.Macros;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import org.xml.sax.SAXException;

public class Installation {
    private final Path middlewareHome;
    private final Map<Object, List<Path>> additionalLibraries;
    private final Path baseDirectory;
    private final ExtensionManifestReader manifestReader;
    private final ExportSpecificationReader specificationReader;
    private final RemediationCommentsReader commentReader;
    private final Log log;
    private final Map<Path, FileExportLibrary> pathToManifestLibrary = new LinkedHashMap<Path, FileExportLibrary>();
    private final Map<Path, Extension> pathToExtension = new LinkedHashMap<Path, Extension>();
    private final Map<String, Extension> idToExtension = new LinkedHashMap<String, Extension>();
    private final Map<String, FileExportLibrary> idToLibrary = new LinkedHashMap<String, FileExportLibrary>();
    private final Map<String, FileExportLibrary> syntheticIdToLibrary = new LinkedHashMap<String, FileExportLibrary>();
    private final Map<String, FileExportLibrary> nameToLibrary = new LinkedHashMap<String, FileExportLibrary>();
    private final Map<String, String> aliasToName = new LinkedHashMap<String, String>();
    private final Macros macros;
    private boolean scanned;
    private Map.Entry<String, String>[] nameToAliases;
    private static final String[] NO_ALIASES = new String[0];
    private static final Comparator<Object> ALIAS_COMPARATOR = (o1, o2) -> {
        String s1 = o1 instanceof String ? (String)o1 : (String)((Map.Entry)o1).getValue();
        String s2 = o2 instanceof String ? (String)o2 : (String)((Map.Entry)o2).getValue();
        return s1.compareTo(s2);
    };

    public static Path inferEnclosingMiddlewareHome() {
        Path location;
        String override = System.getProperty("oracle.javatools.exports.middleware.home");
        if (override != null) {
            return Paths.get(override, new String[0]);
        }
        Class<URLFileSystem> WELL_KNOWN_CLASS = URLFileSystem.class;
        String JAR_RELATIVE_PATH = "oracle_common/modules/oracle.javatools/javatools-nodeps.jar";
        String DIR_RELATIVE_PATH = "built/javatools-nodeps/classes/";
        try {
            location = Paths.get(WELL_KNOWN_CLASS.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("middleware home inference failed", e);
        }
        if (location.endsWith("oracle_common/modules/oracle.javatools/javatools-nodeps.jar")) {
            return location.getParent().getParent().getParent().getParent();
        }
        if (location.endsWith("built/javatools-nodeps/classes/")) {
            return location.getParent().getParent().getParent();
        }
        throw new IllegalStateException("middleware home inference failed");
    }

    public Installation(Path middlewareHome, boolean validating, Log log) throws CommandException {
        this(middlewareHome, new ExportSpecificationReader(NameSpace.defaultNameSpace(), null, validating, false), StringPool.synchronizedPool(), log);
    }

    public Installation(Path middlewareHome, ExportSpecificationReader specificationReader, StringPool commentPool, Log log) throws CommandException {
        this(middlewareHome, true, null, null, specificationReader, commentPool, log);
    }

    public Installation(Path middlewareHome, boolean scanMiddlewareHome, Map<Object, List<Path>> additionalLibraries, Path baseDirectory, ExportSpecificationReader specificationReader, StringPool commentPool, Log log) throws CommandException {
        if (specificationReader == null) {
            throw new NullPointerException("specificationReader == null");
        }
        if (commentPool == null) {
            throw new NullPointerException("commentPool == null");
        }
        this.middlewareHome = middlewareHome;
        this.scanned = !scanMiddlewareHome;
        this.additionalLibraries = additionalLibraries;
        this.baseDirectory = baseDirectory != null ? baseDirectory : (middlewareHome != null ? middlewareHome : Paths.get(System.getProperty("java.io.tmpdir"), new String[0]));
        this.specificationReader = specificationReader;
        boolean validating = specificationReader.isSchemaValidating();
        this.commentReader = new RemediationCommentsReader(commentPool, validating, false);
        ExportLibraryReader libraryReader = new ExportLibraryReader(specificationReader, this.commentReader, validating, false);
        this.manifestReader = new ExtensionManifestReader(libraryReader);
        this.log = log;
        this.macros = new Macros(middlewareHome, log);
    }

    public void addMacro(String key, String value) {
        this.macros.addMacro(key, value);
    }

    public Path getMiddlewareHome() {
        return this.middlewareHome;
    }

    public Path getBaseDirectory() {
        return this.baseDirectory;
    }

    public Collection<FileExportLibrary> getLibraries() {
        this.scan();
        return this.idToLibrary.values();
    }

    public String[] getAliases(String name) {
        int index;
        this.scan();
        if (this.nameToAliases == null) {
            this.nameToAliases = this.aliasToName.entrySet().toArray(new Map.Entry[this.aliasToName.size()]);
            Arrays.sort(this.nameToAliases, ALIAS_COMPARATOR);
        }
        if ((index = Arrays.binarySearch(this.nameToAliases, name, ALIAS_COMPARATOR)) < 0) {
            return NO_ALIASES;
        }
        int count = 1;
        while (index > 0 && name.equals(this.nameToAliases[index - 1].getValue())) {
            ++count;
            --index;
        }
        while (index + count < this.nameToAliases.length && name.equals(this.nameToAliases[index + count].getValue())) {
            ++count;
        }
        Object[] aliases = new String[count];
        for (int i = 0; i < count; ++i) {
            aliases[i] = this.nameToAliases[index + i].getKey();
        }
        Arrays.sort(aliases);
        return aliases;
    }

    public FileExportLibrary findLibrary(String id) {
        this.scan();
        FileExportLibrary library = this.idToLibrary.get(id);
        if (library == null) {
            library = this.syntheticIdToLibrary.get(id);
        }
        if (library == null) {
            library = this.nameToLibrary.get(this.aliasToName.getOrDefault(id, id));
        }
        return library;
    }

    public FileExportLibrary findManifestLibrary(Path path) {
        this.scan();
        return this.pathToManifestLibrary.get(path);
    }

    public Extension findExtension(String id) {
        this.scan();
        return this.idToExtension.get(id);
    }

    public Extension findExtension(Path path) {
        this.scan();
        return this.pathToExtension.get(path);
    }

    public Extension getExtension(Object origin, Path filePath, Path manifestPath) throws CommandException {
        Extension existing = this.findExtension(filePath);
        if (existing != null) {
            return existing;
        }
        try {
            Extension extension = this.loadExtension(origin, filePath, manifestPath, true);
            for (FileExportLibrary library : extension.getLibraries()) {
                library.resolve(this.specificationReader, this.commentReader, this::findLibrary, null, this.log);
            }
            return extension;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CommandException(e, "extension %s not read: %s", filePath, e);
        }
    }

    public ExportLibrary getManifestLibrary(Path path) throws CommandException {
        FileExportLibrary existing = this.findManifestLibrary(path);
        if (existing != null) {
            return existing;
        }
        try {
            FileExportLibrary library = this.loadLibrary(path);
            if (library != null) {
                library.resolve(this.specificationReader, this.commentReader, this::findLibrary, null, this.log);
            }
            return library;
        }
        catch (NoSuchFileException e) {
            throw new CommandException(e, "library %s not found: %s", path, e);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CommandException(e, "library %s not read: %s", path, e);
        }
    }

    private FileExportLibrary loadLibrary(Path libraryPath) throws ParserConfigurationException, SAXException, IOException {
        FileExportLibrary library = this.manifestReader.getLibraryReader().read(libraryPath, this.macros.getMacros(), this.log);
        this.addLibrary(library, libraryPath);
        return library;
    }

    private Extension loadExtension(Object origin, Path filePath, Path manifestPath, boolean addLibraries) throws IOException, ParserConfigurationException, SAXException {
        String fileName = filePath.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        String id = fileName.substring(0, dot);
        HashMap<String, String> extensionMacros = new HashMap<String, String>(this.macros.getMacros());
        extensionMacros.put("ide.extension.install.home", id);
        ArrayList<FileExportLibrary> libraries = new ArrayList<FileExportLibrary>();
        this.manifestReader.scan(manifestPath, extensionMacros, libraries, this.aliasToName, this.log);
        Extension extension = new Extension(origin, id, filePath, libraries);
        Extension idPredecessor = this.idToExtension.putIfAbsent(id, extension);
        if (idPredecessor != null) {
            if (!Files.isSameFile(extension.getFilePath(), idPredecessor.getFilePath())) {
                this.log.warning("installation-duplicate-extension", "duplicate id \"%s\" from extensions %s and %s", id, this.path(idPredecessor), this.path(extension)).scope(filePath);
            } else {
                String originPredecessor = idPredecessor.getOrigin() instanceof Path ? Paths.relativize((Path)idPredecessor.getOrigin(), this.baseDirectory) : idPredecessor.getOrigin().toString();
                String originExtension = extension.getOrigin() instanceof Path ? Paths.relativize((Path)extension.getOrigin(), this.baseDirectory) : extension.getOrigin().toString();
                this.log.warning("installation-duplicate-extension", "duplicate extension \"%s\" at %s from bundles.info files %s and %s", id, extension.getFilePath(), originPredecessor, originExtension).scope(filePath);
            }
            return idPredecessor;
        }
        Extension pathPredecessor = this.pathToExtension.putIfAbsent(filePath, extension);
        if (pathPredecessor != null && pathPredecessor != extension) {
            this.log.error("installation-duplicate-path", "duplicate path \"%s\" from extensions %s and %s", Paths.relativize(filePath, this.baseDirectory), pathPredecessor.getId(), extension.getId()).scope(filePath);
            return pathPredecessor;
        }
        if (addLibraries) {
            for (FileExportLibrary library : libraries) {
                this.addLibrary(library, filePath);
            }
        }
        return extension;
    }

    private String path(Extension extension) {
        return Paths.relativize(extension.getFilePath(), this.baseDirectory);
    }

    private void addLibrary(FileExportLibrary library, Path libraryOrExtensionPath) {
        ExportLibrary pathPredecessor;
        String id = library.getId();
        FileExportLibrary idPredecessor = this.idToLibrary.putIfAbsent(id, library);
        String syntheticId = library.getSyntheticId();
        FileExportLibrary syntheticIdPredecessor = this.syntheticIdToLibrary.putIfAbsent(syntheticId, library);
        FileExportLibrary namePredecessor = this.nameToLibrary.putIfAbsent(library.getName(), library);
        if (idPredecessor != null && idPredecessor != library) {
            this.log.warning("installation-duplicate-library", "duplicate id \"%s\": library \"%s\" at %s precedes \"%s\" at %s", id, idPredecessor.getName(), this.path(idPredecessor), library.getName(), this.path(library)).scope(libraryOrExtensionPath);
        }
        if (syntheticIdPredecessor != null && syntheticIdPredecessor != library) {
            this.log.warning("installation-duplicate-library", "duplicate synthetic id \"%s\": library %s (\"%s\") at %s precedes %s (\"%s\") at %s", syntheticId, syntheticIdPredecessor.getId(), syntheticIdPredecessor.getName(), this.path(syntheticIdPredecessor), library.getId(), library.getName(), this.path(library)).scope(libraryOrExtensionPath);
        }
        if (namePredecessor != null && namePredecessor != library) {
            this.log.warning("installation-duplicate-library", "duplicate name \"%s\": library %s at %s precedes %s at %s", library.getName(), namePredecessor.getId(), this.path(namePredecessor), library.getId(), this.path(library)).scope(libraryOrExtensionPath);
        }
        if (Paths.hasSuffix(libraryOrExtensionPath, ".library") && (pathPredecessor = (ExportLibrary)this.pathToManifestLibrary.putIfAbsent(libraryOrExtensionPath, library)) != null && pathPredecessor != library) {
            this.log.error("installation-duplicate-library", "duplicate path \"%\": library %s (\"%s\") precedes %s (\"%s\"", libraryOrExtensionPath, pathPredecessor.getId(), pathPredecessor.getName(), library.getId(), library.getName()).scope(libraryOrExtensionPath);
        }
    }

    private String path(FileExportLibrary library) {
        return Paths.relativize(library.getOrigin(), this.baseDirectory);
    }

    private void scan() {
        if (this.scanned) {
            return;
        }
        this.scanned = true;
        if (this.middlewareHome != null) {
            this.log.note("installation-scanning", "Scanning installation at %s for extensions and libraries", this.middlewareHome);
            Path configurationDirectory = this.middlewareHome.resolve("jdeveloper/configuration");
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(configurationDirectory, "*bundles.info");){
                for (Path bundlesInfoFile : Iterables.sortedList(directoryStream)) {
                    Iterator<Path> reader = Files.newBufferedReader(bundlesInfoFile);
                    try {
                        try {
                            String line = ((BufferedReader)((Object)reader)).readLine();
                            while (line != null) {
                                String[] fields = line.split(",");
                                Path extensionPath = configurationDirectory.resolve(fields[2]).normalize();
                                Log log = this.log.child(new Tag("scope", new PathKey(bundlesInfoFile)));
                                try (FileSystem containerFileSystem = NestedFileSystemProvider.newFileSystem(extensionPath);){
                                    Path manifestPath = containerFileSystem.getPath("/", new String[0]).resolve("META-INF/extension.xml");
                                    if (Files.exists(manifestPath, new LinkOption[0])) {
                                        try {
                                            this.loadExtension(bundlesInfoFile, extensionPath, manifestPath, true);
                                        }
                                        catch (IOException | ParserConfigurationException | SAXException e) {
                                            log.error("extension-unread", "extension %s not scanned: %s", new PathKey(extensionPath), e);
                                        }
                                    }
                                }
                                catch (FileSystemNotFoundException | NoSuchFileException e) {
                                    log.error("installation-bundle-absent", "bundle file %s not found", new PathKey(extensionPath));
                                }
                                catch (IOException e) {
                                    log.error("installation-bundle-unread", "bundle file %s not read: %s", new PathKey(extensionPath), e);
                                }
                                line = ((BufferedReader)((Object)reader)).readLine();
                            }
                        }
                        catch (IOException e) {
                            this.log.error("bundle-info-unread", "bundles.info file %s not scanned: %s", new PathKey(bundlesInfoFile), e).scope(bundlesInfoFile);
                        }
                    }
                    finally {
                        if (reader == null) continue;
                        ((BufferedReader)((Object)reader)).close();
                    }
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                this.log.error("installation-config-absent", "JDeveloper configuration directory %s not present", new PathKey(configurationDirectory)).scope(configurationDirectory);
            }
            catch (IOException iOException) {
                this.log.error("installation-config-unread", "JDeveloper configuration directory %s not scanned: %s", new PathKey(configurationDirectory), iOException).scope(configurationDirectory);
            }
            long l = System.currentTimeMillis();
            try (DirectoryStream<Path> productStream = Files.newDirectoryStream(this.middlewareHome, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                for (Path productDirectory : Iterables.sortedList(productStream)) {
                    Path productLibraryDirectory;
                    Path productLibrariesDirectory;
                    Path productJDeveloperDirectory = productDirectory.resolve("plugins/jdeveloper");
                    Path productConfigurationDirectory = productJDeveloperDirectory.resolve("configuration");
                    if (Files.isDirectory(productConfigurationDirectory, new LinkOption[0])) {
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(productConfigurationDirectory, "*bundles.info");){
                            for (Path bundlesInfoFile : Iterables.sortedList(stream)) {
                                BufferedReader reader = Files.newBufferedReader(bundlesInfoFile);
                                try {
                                    try {
                                        String line = reader.readLine();
                                        while (line != null) {
                                            String[] fields = line.split(",");
                                            Path extensionPath = productConfigurationDirectory.resolve(fields[2]).normalize();
                                            Log log = this.log.child(new Tag("scope", new PathKey(bundlesInfoFile)));
                                            try (FileSystem containerFileSystem = NestedFileSystemProvider.newFileSystem(extensionPath);){
                                                Path manifestPath = containerFileSystem.getPath("/", new String[0]).resolve("META-INF/extension.xml");
                                                if (Files.exists(manifestPath, new LinkOption[0])) {
                                                    try {
                                                        this.loadExtension(bundlesInfoFile, extensionPath, manifestPath, true);
                                                    }
                                                    catch (IOException | ParserConfigurationException | SAXException e) {
                                                        log.error("extension-unread", "extension %s not scanned: %s", new PathKey(extensionPath), e);
                                                    }
                                                }
                                            }
                                            catch (FileSystemNotFoundException | NoSuchFileException e) {
                                                log.error("installation-bundle-absent", "bundle file %s not found", new PathKey(extensionPath));
                                            }
                                            catch (IOException e) {
                                                log.error("installation-bundle-unread", "bundle file %s not read: %s", new PathKey(extensionPath), e);
                                            }
                                            line = reader.readLine();
                                        }
                                    }
                                    catch (IOException e) {
                                        this.log.error("bundlesinfo-unread", "bundles.info file %s not scanned: %s", new PathKey(bundlesInfoFile), e).scope(bundlesInfoFile);
                                    }
                                }
                                finally {
                                    if (reader == null) continue;
                                    reader.close();
                                }
                            }
                        }
                        catch (IOException e) {
                            this.log.error("installation-configuration-unread", "middleware configuration directory %s not scanned: %s", new PathKey(productConfigurationDirectory), e).scope(productConfigurationDirectory);
                        }
                    }
                    if (Files.isDirectory(productLibrariesDirectory = productJDeveloperDirectory.resolve("libraries"), new LinkOption[0])) {
                        try (DirectoryStream<Path> libraryStream = Files.newDirectoryStream(productLibrariesDirectory, "*.library");){
                            for (Path libraryPath : Iterables.sortedList(libraryStream)) {
                                try {
                                    this.loadLibrary(libraryPath);
                                }
                                catch (IOException | ParserConfigurationException | SAXException e) {
                                    this.log.error("installation-library-unread", "library %s not read: %s", new PathKey(libraryPath), e).scope(libraryPath);
                                }
                            }
                        }
                        catch (IOException e) {
                            this.log.error("installation-libraries-unread", "middleware libraries directory %s not scanned: %s", new PathKey(productLibrariesDirectory), e).scope(productLibrariesDirectory);
                        }
                    }
                    if (!Files.isDirectory(productLibraryDirectory = productJDeveloperDirectory.resolve("library"), new LinkOption[0])) continue;
                    this.log.warning("installation-bogus-directory", "\"library\" directory in middleware plugin directory %s ignored: possibly \"libraries\" directory was intended", new PathKey(productJDeveloperDirectory)).scope(productLibraryDirectory);
                }
            }
            catch (IOException e) {
                this.log.error("installation-unread", "middleware home %s plugin directories not scanned: %s", this.middlewareHome, e).scope(this.middlewareHome);
            }
            long end = System.currentTimeMillis();
            this.log.note("installation-scan-time", "time to scan installation for libraries: %dms", end - l);
        } else {
            this.log.note("installation-not-scanned", "Not scanning installation: no middleware home supplied", new Object[0]);
        }
        if (this.additionalLibraries != null) {
            for (Map.Entry entry : this.additionalLibraries.entrySet()) {
                block92: for (Path path : (List)entry.getValue()) {
                    switch (Paths.getSuffix(path)) {
                        case ".library": {
                            ExportLibrary library = this.pathToManifestLibrary.get(path);
                            if (library != null) continue block92;
                            try {
                                this.loadLibrary(path);
                            }
                            catch (IOException | ParserConfigurationException | SAXException e) {
                                this.log.error("installation-library-unread", "library %s not read: %s", new PathKey(path), e).scope(path);
                            }
                            break;
                        }
                        case ".jar": {
                            Extension extension = this.pathToExtension.get(path);
                            if (extension != null) continue block92;
                            try {
                                FileSystem containerFileSystem = NestedFileSystemProvider.newFileSystem(path);
                                try {
                                    Path manifestPath = containerFileSystem.getPath("/", new String[0]).resolve("META-INF/extension.xml");
                                    if (!Files.exists(manifestPath, new LinkOption[0])) continue block92;
                                    try {
                                        this.loadExtension(entry.getKey(), path, manifestPath, true);
                                    }
                                    catch (IOException | ParserConfigurationException | SAXException e) {
                                        this.log.error("installation-extension-unread", "extension %s not scanned: %s", new PathKey(path), e);
                                    }
                                    continue block92;
                                }
                                finally {
                                    if (containerFileSystem == null) continue block92;
                                    containerFileSystem.close();
                                    continue block92;
                                }
                            }
                            catch (FileSystemNotFoundException | NoSuchFileException e) {
                                this.log.error("installation-extension-absent", "bundle file %s not found", new PathKey(path));
                                break;
                            }
                            catch (IOException e) {
                                this.log.error("installation-extension-unread", "bundle file %s not read: %s", new PathKey(path), e);
                                break;
                            }
                        }
                        default: {
                            throw new IllegalStateException("\".library\" or \".jar\" suffix required: " + path);
                        }
                    }
                }
            }
        }
        LinkedHashMap<String, FileExportLibrary> resolver = new LinkedHashMap<String, FileExportLibrary>();
        for (FileExportLibrary fileExportLibrary : this.nameToLibrary.values()) {
            resolver.putIfAbsent(fileExportLibrary.getId(), fileExportLibrary);
            resolver.putIfAbsent(fileExportLibrary.getName(), fileExportLibrary);
            resolver.putIfAbsent(fileExportLibrary.getSyntheticId(), fileExportLibrary);
        }
        block94: for (Map.Entry<String, String> entry : this.aliasToName.entrySet()) {
            String alias = entry.getKey();
            String target = entry.getValue();
            FileExportLibrary overriddenLibrary = (FileExportLibrary)resolver.get(alias);
            if (overriddenLibrary != null) {
                this.log.warning("installation-alias-override", "library alias \"%s\" (to \"%s\") overrides explicit definition of \"%s\" from %s", alias, target, alias, Paths.relativize(overriddenLibrary.getOrigin(), this.baseDirectory));
            }
            ArrayList<String> targets = new ArrayList<String>();
            String name = target;
            while (true) {
                if (targets.contains(name)) {
                    targets.add(name);
                    this.log.error("installation-alias-cycle", "library alias \"%s\" is cyclical: %s", alias, Installation.chain(alias, targets, ""));
                    continue block94;
                }
                targets.add(name);
                if (!resolver.containsKey(name)) {
                    if (!this.aliasToName.containsKey(name)) {
                        this.log.error("installation-alias-unresolved", "library alias \"%s\" does not resolve to a library: %s", alias, Installation.chain(alias, targets, " (undefined)"));
                        continue block94;
                    }
                } else {
                    if (targets.size() <= 1) continue block94;
                    this.log.warning("installation-alias-indirect", "library alias \"%s\" resolves indirectly: %s", alias, Installation.chain(alias, targets, ""));
                    continue block94;
                }
                name = this.aliasToName.get(name);
            }
        }
        HashMap<URLKey, URL[]> hashMap = new HashMap<URLKey, URL[]>();
        long l = System.currentTimeMillis();
        for (FileExportLibrary library : this.idToLibrary.values()) {
            library.resolve(this.specificationReader, this.commentReader, this::findLibrary, hashMap, this.log);
        }
        this.log.note("installation-resolution-complete", "Library resolution completed in {0}ms", (int)(System.currentTimeMillis() - l));
    }

    private static String chain(String alias, List<String> targets, String tail) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"').append(alias).append("\" -> ");
        for (int i = 0; i < targets.size() - 1; ++i) {
            builder.append('\"').append(targets.get(i)).append("\" -> ");
        }
        builder.append('\"').append(targets.get(targets.size() - 1)).append('\"').append(tail);
        return builder.toString();
    }
}

