/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.spi.FileSystemProvider;

public class NestedFileSystemProvider {
    private static boolean tried;
    private static FileSystemProvider provider;

    public static synchronized FileSystem newFileSystem(Path path) throws IOException {
        if (!tried) {
            tried = true;
            try {
                return FileSystems.newFileSystem(path, (ClassLoader)null);
            }
            catch (ProviderNotFoundException providerNotFoundException) {
                try {
                    Class<?> providerClass = ClassLoader.getSystemClassLoader().loadClass("jdk.nio.zipfs.ZipFileSystemProvider");
                    provider = (FileSystemProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new ProviderNotFoundException("Provider not found");
                }
                return provider.newFileSystem(path, null);
            }
        }
        if (provider == null) {
            return FileSystems.newFileSystem(path, (ClassLoader)null);
        }
        return provider.newFileSystem(path, null);
    }
}

