/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.classpath.TypeOrMember;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.TypeName;

public abstract class Member<T>
extends TypeOrMember {
    public static final Comparator<Member> COMPARATOR = (left, right) -> left.compareTo((Member)right);
    public static final Comparator<Member> UNQUALIFIED_COMPARATOR = (left, right) -> left.compareToUnqualified((Member)right);
    private final Type parent;

    Member(Type parent, Escalation escalation, boolean deprecated, CompatibilityAccess access, boolean escalated, boolean suppressed, String accessComment) {
        super(deprecated, parent.isExportable(), access, accessComment);
        this.parent = parent;
        this.setEscalation(escalation);
        this.set('\u0200', escalated);
        this.set('\u0400', suppressed);
    }

    Member(Type parent, char flags) {
        super(flags);
        this.parent = parent;
    }

    @Override
    public Type getParent() {
        return this.parent;
    }

    @Override
    public Package getPackage() {
        return this.parent.getPackage();
    }

    @Override
    public abstract MemberName getName();

    @Override
    public boolean containsExported() {
        return false;
    }

    @Override
    public boolean containsRestricted() {
        return false;
    }

    @Override
    public boolean containsConcealed() {
        return false;
    }

    @Override
    public boolean containsEscalated() {
        return false;
    }

    @Override
    public boolean hasOrContainsEscalated() {
        return this.isEscalated();
    }

    @Override
    public boolean isJDK() {
        return this.parent.isJDK();
    }

    public final boolean isFinal() {
        return this.is('\u0002');
    }

    public final boolean isStatic() {
        return this.is('\b');
    }

    public boolean isDefault() {
        return false;
    }

    public Type getType() {
        return this.parent;
    }

    public abstract TypeName getMemberTypeName();

    public abstract Type getMemberType();

    public abstract int getArity();

    public abstract boolean isVariableArity();

    public boolean isFixedArity() {
        return !this.isVariableArity();
    }

    public abstract MemberName getResolvedName();

    public abstract Iterable<Type> getParameterTypes();

    public Set<Type> getProblemTypes() {
        TreeSet<Type> types = new TreeSet<Type>();
        for (Type parameterType : this.getParameterTypes()) {
            this.maybeAddProblemType(parameterType, types);
        }
        Type memberType = this.getMemberType();
        if (memberType != null) {
            switch (this.getKind()) {
                case METHOD: {
                    this.maybeAddProblemType(memberType, types);
                    break;
                }
                case FIELD: {
                    this.maybeAddProblemType(memberType, types);
                }
            }
        }
        return types.isEmpty() ? Collections.emptySet() : types;
    }

    void maybeAddProblemType(Type type, Set<Type> problemTypes) {
        if (type.isPrimitive() || type.isJDK()) {
            return;
        }
        if (type.isArray()) {
            this.maybeAddProblemType(type.getComponentType(), problemTypes);
        } else if (type.isUnresolved()) {
            problemTypes.add(type);
        } else if (!type.isControlled()) {
            problemTypes.add(type);
        } else if (CompatibilityAccess.isMoreExported(this.getReferenceAccess(), type.getReferenceAccess())) {
            problemTypes.add(type);
        }
    }

    public Escalation getEscalation() {
        switch (this.is('\u0007', '\u0003')) {
            case 0: {
                return Escalation.NONE;
            }
            case 1: {
                return Escalation.PRIVATE;
            }
            case 2: {
                return Escalation.DEFAULT;
            }
            case 3: {
                return Escalation.PUBLIC;
            }
        }
        throw new IllegalStateException("unexpected flag value " + this.is('\u0007', '\u0003') + " at \u0007 value");
    }

    public void setEscalation(Escalation escalation) {
        this.set('\u0007', '\u0003', escalation.ordinal());
    }

    public boolean isEscalated() {
        return this.is('\u0200');
    }

    public boolean isSuppressed() {
        return this.is('\u0400');
    }

    @Override
    public int compareTo(Member that) {
        return this.getName().compareTo(that.getName());
    }

    public int compareToUnqualified(Member that) {
        return this.getName().compareToUnqualified(that.getName());
    }

    public static enum Escalation {
        NONE("none"),
        PRIVATE("private"),
        DEFAULT("default"),
        PUBLIC("public");

        private final String lowerCase;

        private Escalation(String lowerCase) {
            this.lowerCase = lowerCase;
        }

        public String toUpperCase() {
            return this.toString();
        }

        public String toLowerCase() {
            return this.lowerCase;
        }
    }
}

