/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import oracle.javatools.exports.common.ArrayIteratorIterator;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.util.ArrayMap;

public class FileTree {
    private final Map<PackageName, TypeName[]> typeNames;
    private final int typeNameCount;
    private final Map<Path, IOException> errors;

    public FileTree(Path basePath, NameSpace nameSpace) throws IOException {
        if (basePath != null) {
            Visitor visitor = new Visitor(nameSpace, basePath);
            Files.walkFileTree(basePath, visitor);
            this.typeNames = visitor.getTypeNames();
            this.typeNameCount = visitor.getTypeNameCount();
            this.errors = visitor.getErrors();
        } else {
            this.typeNames = Collections.emptyMap();
            this.typeNameCount = 0;
            this.errors = Collections.emptyMap();
        }
    }

    public FileTree(TypeName[] typeNameBuffer, int typeCount) {
        if (typeCount > 0) {
            this.typeNames = new TreeMap<PackageName, TypeName[]>();
            Arrays.sort(typeNameBuffer, 0, typeCount);
            PackageName pendingPackage = typeNameBuffer[0].getPackage();
            int pendingOffset = 0;
            for (int i = 1; i < typeCount; ++i) {
                TypeName nextType = typeNameBuffer[i];
                PackageName nextPackage = nextType.getPackage();
                if (nextPackage.equals(pendingPackage)) continue;
                int length = i - pendingOffset;
                TypeName[] types = new TypeName[length];
                System.arraycopy(typeNameBuffer, pendingOffset, types, 0, length);
                this.typeNames.put(pendingPackage, types);
                pendingPackage = nextPackage;
                pendingOffset = i;
            }
            int length = typeCount - pendingOffset;
            TypeName[] names = new TypeName[length];
            System.arraycopy(typeNameBuffer, pendingOffset, names, 0, length);
            this.typeNames.put(pendingPackage, names);
        } else {
            this.typeNames = Collections.emptyMap();
        }
        this.typeNameCount = typeCount;
        this.errors = Collections.emptyMap();
    }

    public FileTree() {
        this.typeNames = Collections.emptyMap();
        this.typeNameCount = 0;
        this.errors = Collections.emptyMap();
    }

    public int getTypeCount() {
        return this.typeNameCount;
    }

    public boolean contains(TypeName name) {
        Object[] names = this.typeNames.get(name.getPackage());
        if (names == null) {
            return false;
        }
        return Arrays.binarySearch(names, name) >= 0;
    }

    public TypeName getTypeName(TypeName name) {
        Object[] names = this.typeNames.get(name.getPackage());
        if (names == null) {
            return null;
        }
        int index = Arrays.binarySearch(names, name);
        return index >= 0 ? names[index] : null;
    }

    public Iterable<TypeName> getTypeNames() {
        return () -> new ArrayIteratorIterator(this.typeNames.values().iterator());
    }

    public Collection<PackageName> getPackageNames() {
        return this.typeNames.keySet();
    }

    public Map<Path, IOException> getErrors() {
        return this.errors;
    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private NameSpace nameSpace;
        private final Path basePath;
        private final char separator;
        private final Map<PackageName, TypeName[]> typeNames;
        private int typeNameCount;
        private Map<Path, IOException> errors = Collections.emptyMap();
        private final Stack<Data> packageStack = new Stack();

        public Visitor(NameSpace nameSpace, Path basePath) {
            this.nameSpace = nameSpace;
            this.basePath = basePath;
            this.separator = basePath.getFileSystem().getSeparator().charAt(0);
            this.typeNames = new TreeMap<PackageName, TypeName[]>();
        }

        public Map<PackageName, TypeName[]> getTypeNames() {
            return this.typeNames;
        }

        public int getTypeNameCount() {
            return this.typeNameCount;
        }

        public Map<Path, IOException> getErrors() {
            return this.errors;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attributes) throws IOException {
            if (this.packageStack.isEmpty()) {
                this.packageStack.push(null);
                return FileVisitResult.CONTINUE;
            }
            String directoryName = path.getFileName().toString();
            if (!Character.isJavaIdentifierStart(directoryName.charAt(0))) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            int length = directoryName.length();
            int delta = directoryName.charAt(length - 1) == this.separator ? -1 : 0;
            int i = length + delta;
            while (--i >= 1) {
                if (Character.isJavaIdentifierPart(directoryName.charAt(i))) continue;
                return FileVisitResult.SKIP_SUBTREE;
            }
            this.packageStack.push(null);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attributes) {
            String fileName = path.getFileName().toString();
            if (!fileName.endsWith(".class") || "package-info.class".equals(fileName)) {
                return FileVisitResult.CONTINUE;
            }
            String typeName = fileName.substring(0, fileName.length() - 6);
            Data data = this.packageStack.peek();
            if (data == null) {
                String relativeDirectory = this.basePath.relativize(path.getParent()).toString().replace(this.separator, '.');
                PackageName packageName = this.nameSpace.packageNameHybrid(relativeDirectory);
                data = new Data(packageName, typeName);
                this.packageStack.set(this.packageStack.size() - 1, data);
            } else {
                data.add(typeName);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException e) {
            if (this.errors.isEmpty()) {
                this.errors = new ArrayMap<Path, IOException>();
            }
            this.errors.put(path, e);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
            Data data = this.packageStack.pop();
            if (data == null) {
                return FileVisitResult.CONTINUE;
            }
            int count = data.count;
            PackageName packageName = data.packageName;
            Object[] buffer = data.buffer;
            Arrays.sort(buffer, 0, count);
            TypeName[] names = new TypeName[count];
            Stack<Integer> stack = new Stack<Integer>();
            int nullCount = 0;
            names[0] = this.nameSpace.typeNameGetOrCreate(packageName, null, NameFormat.HYBRID, (String)buffer[0]);
            assert (names[0].getFormat() != NameFormat.SOURCE);
            stack.push(0);
            block0: for (int i = 1; i < count; ++i) {
                TypeName outerType = null;
                Object name = buffer[i];
                do {
                    int topLength;
                    int top;
                    Object topName;
                    if (((String)name).startsWith((String)(topName = buffer[top = ((Integer)stack.peek()).intValue()])) && ((String)name).charAt(topLength = ((String)topName).length()) == '$') {
                        outerType = names[top];
                        String innerName = ((String)name).substring(topLength + 1);
                        if (outerType != null && !Character.isDigit(innerName.charAt(0))) {
                            name = outerType.getSourceName() + "." + innerName;
                            break;
                        }
                        ++nullCount;
                        continue block0;
                    }
                    stack.pop();
                } while (!stack.isEmpty());
                names[i] = this.nameSpace.typeNameGetOrCreate(packageName, outerType, NameFormat.HYBRID, (String)name);
                assert (names[i].getFormat() != NameFormat.SOURCE);
                stack.push(i);
            }
            if (nullCount > 0) {
                TypeName[] sparseNames = names;
                int sparseCount = count;
                names = new TypeName[sparseCount - nullCount];
                count = 0;
                for (int i = 0; i < sparseCount; ++i) {
                    TypeName name = sparseNames[i];
                    if (name == null) continue;
                    names[count++] = name;
                }
                assert (count == sparseCount - nullCount);
            }
            this.typeNames.put(packageName, names);
            this.typeNameCount += count;
            return FileVisitResult.CONTINUE;
        }

        private static class Data {
            private PackageName packageName;
            private String[] buffer;
            private int count;

            private Data(PackageName packageName, String typeName) {
                this.packageName = packageName;
                this.buffer = new String[16];
                this.buffer[0] = typeName;
                this.count = 1;
            }

            private void add(String typeName) {
                int length = this.buffer.length;
                if (this.count == length) {
                    this.buffer = new String[length * 16];
                    System.arraycopy(this.buffer, 0, this.buffer, 0, length);
                }
                this.buffer[this.count++] = typeName;
            }
        }
    }
}

