/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.TypeExportSpecification;

public class FileAccessPolicy
implements AccessPolicy {
    private final ExportSpecification delegate;

    public FileAccessPolicy(ExportSpecification delegate) {
        this.delegate = delegate;
    }

    @Override
    public ExportSpecification getExportSpecification() {
        return this.delegate;
    }

    @Override
    public AccessPolicy.PackageAccessPolicy getPolicyForPackage(Package packag, PackageName name, AccessPolicy.Annotations annotations) {
        return new FilePackageAccessPolicy(this.delegate.getPackage(name));
    }

    public String toString() {
        return this.delegate.toString();
    }

    static class FilePackageAccessPolicy
    implements AccessPolicy.PackageAccessPolicy {
        private final PackageExportSpecification delegate;

        FilePackageAccessPolicy(PackageExportSpecification delegate) {
            this.delegate = delegate;
        }

        @Override
        public CompatibilityAccess getDefaultMemberAccess() {
            return this.delegate.getDefaultMemberAccess();
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public AccessPolicy.TypeAccessPolicy getPolicyForType(Package packag, Type outerType, TypeName name, AccessPolicy.Annotations annotations, Log log) {
            return new FileTypeAccessPolicy(this.delegate.getType(name));
        }
    }

    private static class FileMemberAccessPolicy
    implements AccessPolicy.MemberAccessPolicy {
        private final CompatibilityAccess access;

        public FileMemberAccessPolicy(CompatibilityAccess access) {
            this.access = access;
        }

        @Override
        public CompatibilityAccess getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return null;
        }
    }

    static class FileTypeAccessPolicy
    implements AccessPolicy.TypeAccessPolicy {
        private static final AccessPolicy.MemberAccessPolicy MEMBER_EXPORTED_POLICY = new FileMemberAccessPolicy(CompatibilityAccess.EXPORTED);
        private static final AccessPolicy.MemberAccessPolicy MEMBER_RESTRICTED_POLICY = new FileMemberAccessPolicy(CompatibilityAccess.RESTRICTED);
        private static final AccessPolicy.MemberAccessPolicy MEMBER_NULL_POLICY = new FileMemberAccessPolicy(null);
        private static final AccessPolicy.MemberAccessPolicy MEMBER_CONCEALED_POLICY = new FileMemberAccessPolicy(CompatibilityAccess.CONCEALED);
        private final TypeExportSpecification delegate;

        FileTypeAccessPolicy(TypeExportSpecification delegate) {
            this.delegate = delegate;
        }

        @Override
        public CompatibilityAccess getAccess() {
            return this.delegate.getAccess();
        }

        @Override
        public CompatibilityAccess getExtension() {
            return this.delegate.getExtension();
        }

        @Override
        public String getComment() {
            return null;
        }

        @Override
        public AccessPolicy.MemberAccessPolicy getPolicyForMember(Type type, MemberName name, AccessPolicy.Annotations annotations) {
            CompatibilityAccess access = this.delegate.getMember(name);
            if (access == null) {
                return MEMBER_NULL_POLICY;
            }
            switch (access) {
                case EXPORTED: {
                    return MEMBER_EXPORTED_POLICY;
                }
                case RESTRICTED: {
                    return MEMBER_RESTRICTED_POLICY;
                }
                case CONCEALED: {
                    return MEMBER_CONCEALED_POLICY;
                }
            }
            throw new IllegalStateException("unexpected access " + access);
        }

        @Override
        public boolean isPolicyForMemberExplicit(Type type, MemberName name, AccessPolicy.Annotations annotations) {
            return this.delegate.isMemberExplicit(name);
        }
    }
}

