/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import oracle.javatools.exports.classpath.Constructor;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.OverrideEquivalentMethod;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.name.MemberName;

public class Conversions {
    static boolean isIdentityConversion(Type source, Type target) {
        return Objects.equals(source, target);
    }

    static boolean isWideningPrimitiveConversion(Type source, Type target) {
        if (!source.isPrimitive() || !target.isPrimitive()) {
            return false;
        }
        String sourceName = source.getSourceName();
        String targetName = target.getSourceName();
        switch (sourceName) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return Arrays.isContained(targetName, "short", "int", "long", "float", "double");
            }
            case "short": {
                return Arrays.isContained(targetName, "int", "long", "float", "double");
            }
            case "char": {
                return Arrays.isContained(targetName, "int", "long", "float", "double");
            }
            case "int": {
                return Arrays.isContained(targetName, "long", "float", "double");
            }
            case "long": {
                return Arrays.isContained(targetName, "float", "double");
            }
            case "float": {
                return Arrays.isContained(targetName, "double");
            }
            case "double": {
                return false;
            }
        }
        return false;
    }

    static boolean isWideningReferenceConversion(Type source, Type target) {
        Type c;
        if (target.isArray()) {
            return source.isArray() && Conversions.isWideningReferenceConversion(source.getComponentType(), target.getComponentType());
        }
        if (!source.isReferenceType() && !source.isArray() || !target.isReferenceType()) {
            return false;
        }
        for (c = source.getSuperClass(); c != null; c = c.getSuperClass()) {
            if (!target.equals(c)) continue;
            return true;
        }
        for (c = source; c != null; c = c.getSuperClass()) {
            for (Type i : c.getInterfaces()) {
                if (!target.equals(i)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isBoxingConversion(Type source, Type target) {
        if (!source.isPrimitive() || target.isPrimitive()) {
            return false;
        }
        String targetKey = target.getSourceName();
        switch (target.getParent().getSourceName()) {
            case "java.io": {
                return "Serializable".equals(targetKey);
            }
            case "java.lang": {
                switch (source.getSourceName()) {
                    case "boolean": {
                        return Arrays.isContained(targetKey, "Boolean", "Object", "Comparable");
                    }
                    case "byte": {
                        return Arrays.isContained(targetKey, "Byte", "Number", "Object", "Comparable");
                    }
                    case "short": {
                        return Arrays.isContained(targetKey, "Short", "Number", "Object", "Comparable");
                    }
                    case "char": {
                        return Arrays.isContained(targetKey, "Character", "Object", "Comparable");
                    }
                    case "int": {
                        return Arrays.isContained(targetKey, "Integer", "Number", "Object", "Comparable");
                    }
                    case "long": {
                        return Arrays.isContained(targetKey, "Long", "Number", "Object", "Comparable");
                    }
                    case "float": {
                        return Arrays.isContained(targetKey, "Float", "Number", "Object", "Comparable");
                    }
                    case "double": {
                        return Arrays.isContained(targetKey, "Double", "Number", "Object", "Comparable");
                    }
                }
            }
        }
        return false;
    }

    static boolean isUnboxingConversion(Type source, Type target) {
        if (source.isPrimitive() || !"java.lang".equals(source.getPackage().getSourceName()) || !target.isPrimitive()) {
            return false;
        }
        String targetKey = target.getSourceName();
        switch (source.getSourceName()) {
            case "Boolean": {
                return Arrays.isContained(targetKey, "boolean");
            }
            case "Byte": {
                return Arrays.isContained(targetKey, "byte", "short", "int", "long", "float", "double");
            }
            case "Short": {
                return Arrays.isContained(targetKey, "short", "int", "long", "float", "double");
            }
            case "Character": {
                return Arrays.isContained(targetKey, "char", "int", "long", "float", "double");
            }
            case "Integer": {
                return Arrays.isContained(targetKey, "int", "long", "float", "double");
            }
            case "Long": {
                return Arrays.isContained(targetKey, "long", "float", "double");
            }
            case "Float": {
                return Arrays.isContained(targetKey, "float", "double");
            }
            case "Double": {
                return Arrays.isContained(targetKey, "double");
            }
        }
        return false;
    }

    static MemberTypeConversion memberTypeConversion(Type source, Type target) {
        if (Conversions.isIdentityConversion(source, target)) {
            return MemberTypeConversion.IDENTICAL;
        }
        if (source == null) {
            return MemberTypeConversion.UNVOIDED;
        }
        if (target == null) {
            return MemberTypeConversion.VOIDED;
        }
        if (Conversions.isWideningPrimitiveConversion(target, source)) {
            return MemberTypeConversion.NARROWED;
        }
        if (Conversions.isWideningReferenceConversion(target, source)) {
            return MemberTypeConversion.NARROWED;
        }
        if (Conversions.isWideningPrimitiveConversion(source, target)) {
            return MemberTypeConversion.WIDENED;
        }
        if (Conversions.isWideningReferenceConversion(source, target)) {
            return MemberTypeConversion.WIDENED;
        }
        if (Conversions.isBoxingConversion(source, target)) {
            return MemberTypeConversion.BOXED;
        }
        if (Conversions.isUnboxingConversion(source, target)) {
            return MemberTypeConversion.UNBOXED;
        }
        return MemberTypeConversion.INCOMPATIBLE;
    }

    static ConversionCategory typeConversionCategory(Type source, Type target) {
        if (Conversions.isIdentityConversion(source, target)) {
            return ConversionCategory.IDENTICAL;
        }
        if (Conversions.isWideningPrimitiveConversion(source, target)) {
            return ConversionCategory.STRICT;
        }
        if (Conversions.isWideningReferenceConversion(source, target)) {
            return ConversionCategory.STRICT;
        }
        if (Conversions.isBoxingConversion(source, target)) {
            return ConversionCategory.LOOSE;
        }
        if (Conversions.isUnboxingConversion(source, target)) {
            return ConversionCategory.LOOSE;
        }
        return ConversionCategory.INCOMPATIBLE;
    }

    static <T extends Member<T>> ConversionCategory memberConversionCategory(T source, T target) {
        MemberName sourceName = source.getName();
        Iterable<Type> sourceParameterTypes = source.getParameterTypes();
        return Conversions.memberConversionCategory(sourceName, sourceParameterTypes, target);
    }

    static <T extends Member<T>> ConversionCategory memberConversionCategory(MemberName sourceName, Iterable<Type> sourceParameterTypes, T target) {
        if (!sourceName.getSimpleName().equals(target.getSimpleName())) {
            return ConversionCategory.INCOMPATIBLE;
        }
        Iterator<Type> sourceParameters = sourceParameterTypes.iterator();
        Iterator<Type> targetParameters = target.getParameterTypes().iterator();
        if (sourceName.isFixedArity() && target.isFixedArity()) {
            if (sourceName.getArity() != target.getArity()) {
                return ConversionCategory.INCOMPATIBLE;
            }
            ConversionCategory compatibility = ConversionCategory.IDENTICAL;
            for (int i = 0; i < sourceName.getArity(); ++i) {
                if (!(compatibility = ConversionCategory.worst(compatibility, Conversions.typeConversionCategory(sourceParameters.next(), targetParameters.next()))).isIncompatible()) continue;
                return ConversionCategory.INCOMPATIBLE;
            }
            return compatibility;
        }
        if (sourceName.isFixedArity() && target.isVariableArity()) {
            if (sourceName.getArity() < target.getArity() - 1) {
                return ConversionCategory.INCOMPATIBLE;
            }
            for (int i = 0; i < target.getArity() - 1; ++i) {
                if (!Conversions.typeConversionCategory(sourceParameters.next(), targetParameters.next()).isIncompatible()) continue;
                return ConversionCategory.INCOMPATIBLE;
            }
            Type arrayType = targetParameters.next();
            Type componentType = arrayType.getComponentType();
            if (sourceName.getArity() == target.getArity()) {
                Type type = sourceParameters.next();
                if (ConversionCategory.best(Conversions.typeConversionCategory(type, arrayType), Conversions.typeConversionCategory(type, componentType)).isIncompatible()) {
                    return ConversionCategory.INCOMPATIBLE;
                }
            } else if (sourceName.getArity() > target.getArity()) {
                while (sourceParameters.hasNext()) {
                    if (!Conversions.typeConversionCategory(sourceParameters.next(), componentType).isIncompatible()) continue;
                    return ConversionCategory.INCOMPATIBLE;
                }
            }
            return ConversionCategory.VARIABLE;
        }
        if (sourceName.isVariableArity() && target.isFixedArity()) {
            return ConversionCategory.INCOMPATIBLE;
        }
        if (target.getArity() > sourceName.getArity()) {
            return ConversionCategory.INCOMPATIBLE;
        }
        for (int i = 0; i < target.getArity() - 1; ++i) {
            if (!Conversions.typeConversionCategory(sourceParameters.next(), targetParameters.next()).isIncompatible()) continue;
            return ConversionCategory.INCOMPATIBLE;
        }
        Type targetArrayType = targetParameters.next();
        Type targetComponentType = targetArrayType.getComponentType();
        for (int i = target.getArity(); i < sourceName.getArity() - 1; ++i) {
            if (!Conversions.typeConversionCategory(sourceParameters.next(), targetComponentType).isIncompatible()) continue;
            return ConversionCategory.INCOMPATIBLE;
        }
        if (Conversions.typeConversionCategory(sourceParameters.next(), targetArrayType).isIncompatible()) {
            return ConversionCategory.INCOMPATIBLE;
        }
        return ConversionCategory.VARIABLE;
    }

    static Collection<Constructor> maximallySpecificConstructor(Collection<Constructor> members) {
        if (members.size() <= 1) {
            return members;
        }
        LinkedHashSet<Constructor> moreSpecific = new LinkedHashSet<Constructor>(members);
        for (Constructor source : members) {
            for (Constructor target : members) {
                if (source == target) continue;
                switch (Conversions.memberConversionCategory(source, target)) {
                    case IDENTICAL: 
                    case INCOMPATIBLE: {
                        break;
                    }
                    case VARIABLE: 
                    case LOOSE: 
                    case STRICT: {
                        moreSpecific.remove(target);
                    }
                }
            }
        }
        return moreSpecific;
    }

    static Collection<OverrideEquivalentMethod> maximallySpecificMethod(Collection<OverrideEquivalentMethod> methods) {
        if (methods.size() <= 1) {
            return methods;
        }
        LinkedHashSet<OverrideEquivalentMethod> moreSpecific = new LinkedHashSet<OverrideEquivalentMethod>(methods);
        for (OverrideEquivalentMethod sourceOem : methods) {
            Method source = sourceOem.getMethod();
            if (source == null) continue;
            for (OverrideEquivalentMethod targetOem : methods) {
                Method target = targetOem.getMethod();
                if (target == null) continue;
                switch (Conversions.memberConversionCategory(source, target)) {
                    case IDENTICAL: 
                    case INCOMPATIBLE: {
                        break;
                    }
                    case VARIABLE: 
                    case LOOSE: 
                    case STRICT: {
                        moreSpecific.remove(targetOem);
                    }
                }
            }
        }
        return moreSpecific;
    }

    static enum MemberTypeConversion {
        IDENTICAL,
        NARROWED,
        WIDENED,
        BOXED,
        UNBOXED,
        UNVOIDED,
        VOIDED,
        INCOMPATIBLE;

    }

    static enum ConversionCategory {
        INCOMPATIBLE,
        VARIABLE,
        LOOSE,
        STRICT,
        IDENTICAL;


        public boolean isIncompatible() {
            return this == INCOMPATIBLE;
        }

        public boolean isIdentical() {
            return this == IDENTICAL;
        }

        public static ConversionCategory worst(ConversionCategory left, ConversionCategory right) {
            return left.compareTo(right) < 0 ? left : right;
        }

        public static ConversionCategory best(ConversionCategory left, ConversionCategory right) {
            return left.compareTo(right) > 0 ? left : right;
        }
    }
}

