/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.AnnotationAccessPolicy;
import oracle.javatools.exports.classpath.FileAccessPolicy;
import oracle.javatools.exports.classpath.FileTree;
import oracle.javatools.exports.classpath.NestedFileSystemPool;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.file.NestedFileSystemProvider;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.Merge;
import oracle.javatools.exports.specification.SpecificationScope;

public class ClassPathRoot {
    private final Scope scope;
    private final Path path;
    private final PathKey key;
    private final boolean exists;
    private final boolean directory;
    private final boolean jdk;
    private final NameSpace nameSpace;
    private final NestedFileSystemPool nestedFileSystemPool;
    private final Log log;
    private final String nestedName;
    private Path nestedPath;
    private boolean failed;
    private int zfsOpenCount;
    private int zfsOpenTotalTime;
    private int zfsOpenMaxTime;
    private final Deque<String> nestedFileSystemOpens = new LinkedList<String>();
    private FileTree fileTree;
    private AccessPolicy accessPolicy;
    private Set<ClassPathRoot> occludedRoots = Collections.emptySet();
    private final ClassPathRoot[] singletonArray;
    private static List<Path> defaultBootClassPath;

    public ClassPathRoot(Scope scope, Path path, Status status, FileTree fileTree, AccessPolicy accessPolicy, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, Log log) {
        this.scope = scope;
        this.path = path;
        switch (status) {
            case FILE: 
            case JDK: {
                this.nestedName = path.getFileName().toString().endsWith(".jmod") ? "/classes/" : "/";
                break;
            }
            default: {
                this.nestedName = "";
            }
        }
        this.nestedPath = null;
        this.fileTree = fileTree;
        this.jdk = false;
        this.accessPolicy = accessPolicy;
        this.nestedFileSystemPool = nestedFileSystemPool;
        this.nameSpace = nameSpace;
        this.log = log;
        this.key = new PathKey(path);
        this.exists = status != Status.UNRESOLVED;
        this.directory = status == Status.DIRECTORY;
        this.singletonArray = new ClassPathRoot[]{this};
    }

    public ClassPathRoot(Scope scope, Path path, Map<Path, FileTree> fileTrees, AccessPolicy accessPolicy, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, Log log) {
        boolean directory;
        String nestedName;
        PathKey key;
        Path realPath;
        this.scope = scope;
        this.path = path;
        if (fileTrees != null) {
            this.fileTree = fileTrees.get(path);
        }
        this.jdk = accessPolicy == null;
        this.accessPolicy = this.jdk ? new FileAccessPolicy(new ExportSpecification(scope, null, null)) : accessPolicy;
        this.nestedFileSystemPool = nestedFileSystemPool;
        this.nameSpace = nameSpace;
        this.log = log;
        try {
            FileSystem fileSystem;
            realPath = path.toRealPath(new LinkOption[0]);
            key = new PathKey(realPath);
            if (this.fileTree == null && fileTrees != null) {
                fileTrees.get(realPath);
            }
            if ((fileSystem = path.getFileSystem()) != FileSystems.getDefault() && fileSystem.isOpen()) {
                nestedName = path.getFileName().toString().endsWith(".jmod") ? "/classes/" : "/";
                this.nestedPath = path;
                directory = false;
                this.nestedFileSystemPool.addTransient(this);
                log.trace("model-open-nested", "nested file system initially open at %s", key);
            } else if (Files.isDirectory(path, new LinkOption[0])) {
                directory = true;
                nestedName = "";
            } else {
                directory = false;
                nestedName = path.getFileName().toString().endsWith(".jmod") ? "/classes/" : "/";
            }
        }
        catch (NoSuchFileException e) {
            realPath = null;
            key = new PathKey(path);
            directory = true;
            nestedName = "";
            this.failed = true;
            log.warning("model-root-not-found", "root %s does not exist", key).scope(scope);
        }
        catch (IOException e) {
            realPath = null;
            key = new PathKey(path);
            directory = true;
            nestedName = "";
            this.failed = true;
            log.warning("model-root-not-read", "root %s is not readable: %s", key, e).scope(scope);
        }
        this.nestedName = nestedName;
        this.key = key;
        this.exists = realPath != null;
        this.directory = directory;
        this.singletonArray = new ClassPathRoot[]{this};
    }

    ClassPathRoot[] singletonArray() {
        return this.singletonArray;
    }

    public Merge<?> merge(Scope scope, ClassPathRoot that) {
        if (this.occludedRoots.isEmpty()) {
            this.occludedRoots = new LinkedHashSet<ClassPathRoot>();
        }
        this.occludedRoots.add(that);
        AccessPolicy thisPolicy = this.accessPolicy;
        AccessPolicy thatPolicy = that.accessPolicy;
        ExportSpecification thisSpecification = thisPolicy.getExportSpecification();
        ExportSpecification thatSpecification = thatPolicy.getExportSpecification();
        if (thisSpecification == null || thatSpecification == null) {
            throw new IllegalStateException("merging annotation access policy");
        }
        Merge<AccessPolicy> policyMerge = new Merge<AccessPolicy>(thisPolicy, thatPolicy, "access policy for %s", this.key);
        Merge<ExportSpecification> specificationMerge = ExportSpecification.merge(new SpecificationScope(scope, "merge"), thisSpecification, thatSpecification);
        policyMerge.addNestedMerges(specificationMerge);
        policyMerge.complete(new FileAccessPolicy(specificationMerge.getValue()));
        this.accessPolicy = policyMerge.getValue();
        return policyMerge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitFiles(BiConsumer<TypeName, Path> visitor) {
        Path basePath = this.acquireFileSystem("visitFiles");
        if (basePath == null) {
            return;
        }
        char separator = basePath.getFileSystem().getSeparator().charAt(0);
        try {
            long loadsStart = System.currentTimeMillis();
            for (TypeName typeName : this.fileTree.getTypeNames()) {
                visitor.accept(typeName, basePath.resolve(typeName.getQualifiedClassName(separator)));
            }
            this.log.trace("model-loaded-types", "loaded types in %dms at %s", System.currentTimeMillis() - loadsStart, new PathKey(this.path));
        }
        finally {
            this.releaseFileSystem("visitFiles");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeName getTypeName(TypeName typeName) {
        if (this.fileTree != null) {
            return this.fileTree.getTypeName(typeName);
        }
        Path basePath = this.acquireFileSystem("getTypeName");
        if (basePath == null) {
            return null;
        }
        try {
            TypeName typeName2 = this.fileTree.getTypeName(typeName);
            return typeName2;
        }
        finally {
            this.releaseFileSystem("isFilePresent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R visitFileIfPresent(TypeName typeName, BiFunction<TypeName, Path, R> visitor) {
        assert (typeName.getFormat() != NameFormat.SOURCE);
        TypeName resolvedTypeName = null;
        if (this.fileTree != null && (resolvedTypeName = this.fileTree.getTypeName(typeName)) == null) {
            return null;
        }
        Path basePath = this.acquireFileSystem("visitFileIfPresent");
        if (basePath == null) {
            return null;
        }
        try {
            TypeName typeName2 = typeName = resolvedTypeName != null ? resolvedTypeName : this.fileTree.getTypeName(typeName);
            if (typeName == null) {
                R r = null;
                return r;
            }
            char separator = basePath.getFileSystem().getSeparator().charAt(0);
            long loadStart = System.currentTimeMillis();
            String fileName = typeName.getQualifiedClassName(separator);
            Path path = basePath.resolve(fileName);
            R result = visitor.apply(typeName, path);
            this.log.trace("model-loaded-type", "loaded type %s in %dms at %s", typeName, System.currentTimeMillis() - loadStart, new PathKey(path));
            R r = result;
            return r;
        }
        finally {
            this.releaseFileSystem("visitFileIfPresent");
        }
    }

    public int getTypeNameCount() {
        if (this.fileTree == null) {
            Path basePath = this.acquireFileSystem("getTypeNameCount");
            if (basePath == null) {
                return 0;
            }
            this.releaseFileSystem("getTypeNameCount");
        }
        return this.fileTree.getTypeCount();
    }

    public Collection<PackageName> getPackageNames() {
        if (this.fileTree == null) {
            Path basePath = this.acquireFileSystem("getPackageNames");
            if (basePath == null) {
                return Collections.emptyList();
            }
            this.releaseFileSystem("getPackageNames");
        }
        return this.fileTree.getPackageNames();
    }

    public Iterable<TypeName> getTypeNames() {
        if (this.fileTree == null) {
            Path basePath = this.acquireFileSystem("getTypeNames");
            if (basePath == null) {
                return Collections.emptyList();
            }
            this.releaseFileSystem("getTypeNames");
        }
        return this.fileTree.getTypeNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path acquireFileSystem(String reason) {
        Path basePath;
        if (this.failed) {
            return null;
        }
        if (this.directory) {
            basePath = this.path;
        } else {
            NestedFileSystemPool nestedFileSystemPool = this.nestedFileSystemPool;
            synchronized (nestedFileSystemPool) {
                try {
                    if (this.nestedPath == null) {
                        long openStart = System.currentTimeMillis();
                        this.nestedPath = NestedFileSystemProvider.newFileSystem(this.path).getPath(this.nestedName, new String[0]);
                        int openTime = (int)(System.currentTimeMillis() - openStart);
                        this.log.trace("model-open-nested", "opened nested file system (%s) in %dms at %s", reason, openTime, this.key);
                        ++this.zfsOpenCount;
                        this.zfsOpenTotalTime += openTime;
                        if (openTime > this.zfsOpenMaxTime) {
                            this.zfsOpenMaxTime = openTime;
                        }
                        this.nestedFileSystemPool.addTransient(this);
                    }
                    basePath = this.nestedPath;
                }
                catch (IOException | UnsupportedOperationException | ProviderNotFoundException e) {
                    if (!this.failed) {
                        this.log.warning("model-root-not-read", "root %s is not readable: %s", this.key, e).scope(this.key);
                    }
                    this.failed = true;
                    if (this.fileTree == null) {
                        this.fileTree = new FileTree();
                    }
                    return null;
                }
            }
        }
        this.nestedFileSystemOpens.push(reason);
        if (this.fileTree == null) {
            long collectionStart = System.currentTimeMillis();
            try {
                this.fileTree = new FileTree(basePath, this.nameSpace);
                for (Map.Entry<Path, IOException> error : this.fileTree.getErrors().entrySet()) {
                    this.log.error("model-type-uncollected", "collecting type failed at %s: %s", error.getKey(), error.getValue()).scope(this.path);
                }
            }
            catch (Exception e) {
                try {
                    this.fileTree = new FileTree();
                    this.log.error("model-types-uncollected", "collecting types failed in %s: %s", this, e).exception(e);
                }
                catch (Throwable throwable) {
                    this.log.trace("model-collected-types", "collected %d types in %dms in %s", this.fileTree.getTypeCount(), System.currentTimeMillis() - collectionStart, new PathKey(this.path));
                    throw throwable;
                }
                this.log.trace("model-collected-types", "collected %d types in %dms in %s", this.fileTree.getTypeCount(), System.currentTimeMillis() - collectionStart, new PathKey(this.path));
            }
            this.log.trace("model-collected-types", "collected %d types in %dms in %s", this.fileTree.getTypeCount(), System.currentTimeMillis() - collectionStart, new PathKey(this.path));
        }
        return basePath;
    }

    void closeNestedFileSystem(String reason) {
        try {
            this.nestedPath.getFileSystem().close();
            this.nestedPath = null;
            this.log.trace("model-close-nested", "close nested file system %s (%s)", this.key, reason);
        }
        catch (IOException e) {
            this.log.trace("model-close-exception", "close nested file system failed at %s: %s", this.key, e);
        }
    }

    private void releaseFileSystem(String reason) {
        String matchingReason = this.nestedFileSystemOpens.peekFirst();
        if (matchingReason == null) {
            throw new IllegalStateException("no matching acquire for " + reason + " release");
        }
        if (!reason.equals(matchingReason)) {
            throw new IllegalStateException("close for " + reason + " does not match open for " + matchingReason);
        }
        this.nestedFileSystemOpens.pop();
    }

    public Scope getScope() {
        return this.scope;
    }

    public Path getPath() {
        return this.path;
    }

    public Status getStatus() {
        if (this.jdk) {
            return Status.JDK;
        }
        if (!this.exists) {
            return Status.UNRESOLVED;
        }
        if (this.directory) {
            return Status.DIRECTORY;
        }
        return Status.FILE;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public boolean isControlled() {
        return this.accessPolicy instanceof AnnotationAccessPolicy || this.accessPolicy.getExportSpecification().isControlling();
    }

    public boolean isJDK() {
        return this.jdk;
    }

    public AccessPolicy getAccessPolicy() {
        return this.accessPolicy;
    }

    public PathKey getReferencePath() {
        return this.key;
    }

    public int getZFSOpenCount() {
        return this.zfsOpenCount;
    }

    public int getZFSOpenTotalTime() {
        return this.zfsOpenTotalTime;
    }

    public int getZFSOpenMaxTime() {
        return this.zfsOpenMaxTime;
    }

    public String toString() {
        return Paths.toString(this.path) + " " + this.accessPolicy;
    }

    public static AccessPolicy annotationAccessPolicy(String owner, ExportDomain domain) {
        return new AnnotationAccessPolicy(owner, domain);
    }

    public static List<Path> getDefaultBootClassPath() throws CommandException {
        if (defaultBootClassPath != null) {
            return defaultBootClassPath;
        }
        ArrayList<Path> bootClassPath = new ArrayList<Path>();
        if (System.getProperty("java.version").startsWith("1.")) {
            String property = System.getProperty("sun.boot.class.path");
            if (property == null) {
                throw new CommandException("Boot class path unspecified and JVM fallback property \"sun.boot.class.path\" undefined");
            }
            for (String path : property.split(File.pathSeparator)) {
                bootClassPath.add(Paths.get(path, new String[0]));
            }
        } else {
            String javaHome = System.getProperty("java.home");
            Path jmods = Paths.get(javaHome, new String[0]).resolve("jmods");
            if (!Files.isDirectory(jmods, new LinkOption[0])) {
                throw new CommandException("Boot class path unspecified and no jmods directory fond in Java home %s", javaHome);
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(jmods);){
                for (Path path : stream) {
                    bootClassPath.add(path);
                }
            }
            catch (IOException e) {
                throw new CommandException(e, "Boot class path unspecified and jmods directory %s not read: %s", jmods, e);
            }
        }
        defaultBootClassPath = Collections.unmodifiableList(bootClassPath);
        return defaultBootClassPath;
    }

    static enum Status {
        DIRECTORY,
        FILE,
        UNRESOLVED,
        JDK;

    }
}

