/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.AccessPolicy;
import oracle.javatools.exports.classpath.AnnotationAccessPolicy;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.classpath.ClassPool;
import oracle.javatools.exports.classpath.ClassReader;
import oracle.javatools.exports.classpath.Constructor;
import oracle.javatools.exports.classpath.Element;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.NestedFileSystemPool;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Scope;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.FieldName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.specification.ExportSpecification;
import oracle.javatools.exports.specification.PackageExportSpecification;
import oracle.javatools.exports.specification.TypeExportSpecification;
import oracle.javatools.parser.java.v2.classfile.ClassFile;

public class ClassPathModel {
    private final String source;
    private final SortedSet<LibraryDescription> libraries;
    private final ExportDomain domain;
    private final boolean rooted;
    private final LinkedHashMap<PathKey, ClassPathRoot> allRoots;
    private final NestedFileSystemPool nestedFileSystemPool;
    private final NameSpace nameSpace;
    private final Log log;
    private final List<Package> controlledPackages;
    private final NavigableMap<PackageName, Package> allPackages;
    private final Map<String, MisplacedType> misplacedTypesByPath = new LinkedHashMap<String, MisplacedType>();
    private final Annotator annotator;
    private final ClassPool classPool = new ClassPool();
    private Map<TypeName, Type[]> SINGLETON_TYPE_ARRAYS = new HashMap<TypeName, Type[]>();
    private Type[] DOUBLE_STRING_TYPE_ARRAY;

    public ClassPathModel(String source, ExportDomain domain, SortedSet<LibraryDescription> libraries, LinkedHashMap<PathKey, ClassPathRoot> roots, Monitor monitor, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, StringPool commentPool, Log log) throws CommandException {
        this(source, domain, libraries, roots, nameSpace, nestedFileSystemPool, commentPool, log);
        ArrayList<ClassPathRoot> controlledRoots = new ArrayList<ClassPathRoot>();
        ArrayList<ClassPathRoot> uncontrolledRoots = new ArrayList<ClassPathRoot>();
        for (ClassPathRoot root : this.allRoots.values()) {
            (root.isControlled() ? controlledRoots : uncontrolledRoots).add(root);
        }
        if (monitor != null) {
            monitor.beginTraversal(controlledRoots, uncontrolledRoots);
        }
        for (ClassPathRoot root : controlledRoots) {
            int typesAlreadyProcessed = Type.getTypesCreatedCount();
            int misplacedTypesAlreadyFound = this.misplacedTypesByPath.size();
            root.visitFiles((name, path) -> this.createType((TypeName)name, (Path)path, root));
            int count = Type.getTypesCreatedCount() - typesAlreadyProcessed;
            log.note("model-scanned-classes", "scanned %d class%s under %s", count, count == 1 ? "" : "es", new PathKey(root.getPath()));
            int misplacedCount = this.misplacedTypesByPath.size() - misplacedTypesAlreadyFound;
            if (misplacedCount > 0) {
                log.trace("model-misplaced-classes", "scanned but ignored %d misplaced class%s under %s", misplacedCount, misplacedCount == 1 ? "" : "es", new PathKey(root.getPath()));
            }
            if (monitor == null) continue;
            monitor.rootTraversed(root);
        }
        if (monitor != null) {
            monitor.endTraversal();
        }
        for (Package packag : this.allPackages.values()) {
            if (!packag.containsControlled()) continue;
            this.controlledPackages.add(packag);
            packag.resolve();
        }
        this.verify();
    }

    ClassPathModel(String source, ExportDomain domain, SortedSet<LibraryDescription> libraries, LinkedHashMap<PathKey, ClassPathRoot> roots, TreeMap<PackageName, Package> packages, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, StringPool commentPool, Log log) {
        this(source, domain, libraries, roots, nameSpace, nestedFileSystemPool, commentPool, log);
        this.allPackages.putAll(packages);
        for (Package packag : this.allPackages.values()) {
            packag.setModel(this);
            if (!packag.containsControlled()) continue;
            this.controlledPackages.add(packag);
            packag.resolve();
        }
    }

    private ClassPathModel(String source, ExportDomain domain, SortedSet<LibraryDescription> libraries, LinkedHashMap<PathKey, ClassPathRoot> roots, NameSpace nameSpace, NestedFileSystemPool nestedFileSystemPool, StringPool commentPool, Log log) {
        this.source = source != null && !source.isEmpty() ? source : "unspecified";
        this.libraries = libraries;
        this.domain = domain;
        this.rooted = false;
        this.nameSpace = nameSpace;
        this.nestedFileSystemPool = nestedFileSystemPool;
        this.annotator = new Annotator(commentPool);
        this.log = log;
        this.allRoots = roots;
        this.allPackages = new ConcurrentSkipListMap<PackageName, Package>();
        Package defaultPackage = new Package(this, PackageName.DEFAULT_PACKAGE, false, null, null);
        for (TypeName primitive : TypeName.PRIMITIVES) {
            defaultPackage.addOrGetType(new Type(defaultPackage, primitive));
        }
        this.allPackages.put(PackageName.DEFAULT_PACKAGE, defaultPackage);
        this.controlledPackages = new ArrayList<Package>();
    }

    public void closeNestedFileSystems() {
        this.nestedFileSystemPool.close("model nested file system close");
    }

    public ExportSpecification createExportSpecification(Scope scope, String owner, String source, Set<String> consumers, ExportDomain domain, CompatibilityAccess restrictedAs) {
        LinkedHashMap<PackageName, PackageExportSpecification> packages = new LinkedHashMap<PackageName, PackageExportSpecification>();
        for (Package packag : this.getControlledPackages()) {
            PackageName packageName = packag.getName();
            assert (packag.getReferenceAccess() != null);
            assert (domain.dominates(packageName)) : "package " + packageName + " controlled but outside domain";
            if (!packag.isExportedOrRestricted(restrictedAs)) continue;
            packages.put(packageName, packag.inferExportSpecification(restrictedAs, true));
        }
        return new ExportSpecification(scope, owner, source, consumers, domain, packages.isEmpty() ? Collections.emptyMap() : packages);
    }

    public void verify() {
        for (Package packag : this.allPackages.values()) {
            CompatibilityAccess expectedPackageAccess = null;
            CompatibilityAccess expectedPackageMemberAccess = null;
            boolean expectedPackageContainsControlled = false;
            boolean expectedPackageContainsExported = false;
            boolean expectedPackageContainsRestricted = false;
            boolean expectedPackageContainsConcealed = false;
            boolean expectedPackageContainsEscalated = false;
            for (Type type : packag.getDeclaredTypes()) {
                if (!type.isReferenceType()) continue;
                Iterable<ClassPathRoot> roots = type.getRoots();
                CompatibilityAccess expectedTypeAccess = null;
                CompatibilityAccess expectedTypeExtension = null;
                for (ClassPathRoot root : roots) {
                    PackageExportSpecification packageSpecification = this.getPackageSpecification(root, packag);
                    TypeExportSpecification typeSpecification = packageSpecification.getType(type.getName());
                    Object rootTypeAccess = typeSpecification.getAccess();
                    CompatibilityAccess rootTypeExtension = typeSpecification.getExtension();
                    if (!type.isExportable()) continue;
                    expectedTypeAccess = CompatibilityAccess.mostExported(expectedTypeAccess, rootTypeAccess);
                    expectedTypeExtension = CompatibilityAccess.mostExported(expectedTypeExtension, rootTypeExtension);
                }
                boolean expectedTypeContainsExported = false;
                boolean expectedTypeContainsRestricted = false;
                boolean expectedTypeContainsConcealed = false;
                boolean expectedTypeContainsEscalated = false;
                for (Member<?> member : type.getDeclaredMembers()) {
                    if (!member.isExportable()) continue;
                    CompatibilityAccess expectedMemberAccess = null;
                    boolean expectedMemberAccessExplicit = false;
                    for (ClassPathRoot root : roots) {
                        PackageExportSpecification packageSpecification = this.getPackageSpecification(root, packag);
                        TypeExportSpecification typeSpecification = packageSpecification.getType(type.getName());
                        CompatibilityAccess rootMemberAccess = typeSpecification.getMember(member.getName());
                        if (!CompatibilityAccess.isMoreExported(rootMemberAccess, expectedMemberAccess)) continue;
                        expectedMemberAccess = rootMemberAccess;
                        expectedMemberAccessExplicit = typeSpecification.isMemberExplicit(member.getName());
                    }
                    boolean expectedMemberSuppressed = false;
                    boolean expectedMemberEscalated = false;
                    if (expectedMemberAccess != null) {
                        CompatibilityAccess memberAccessDefault = CompatibilityAccess.CONCEALED;
                        boolean memberAccessExplicit = false;
                        switch (member.getEscalation()) {
                            case PUBLIC: {
                                memberAccessDefault = expectedTypeExtension;
                                if (member instanceof Constructor) {
                                    memberAccessExplicit = expectedMemberAccessExplicit;
                                }
                            }
                            case DEFAULT: {
                                if (!(member instanceof Constructor)) {
                                    memberAccessExplicit = expectedMemberAccessExplicit;
                                }
                            }
                            case PRIVATE: {
                                boolean bl = expectedMemberSuppressed = memberAccessDefault == CompatibilityAccess.CONCEALED;
                                if (!CompatibilityAccess.isMoreExported(expectedMemberAccess, memberAccessDefault) || (expectedMemberEscalated = memberAccessExplicit)) break;
                                expectedMemberAccess = memberAccessDefault;
                            }
                        }
                    }
                    this.verify(member, "Member.getReferenceAccess()", expectedMemberAccess, member.getReferenceAccess());
                    this.verify((Element)member, "Member.isEscalated()", expectedMemberEscalated, member.isEscalated());
                    this.verify((Element)member, "Member.isSuppressed()", expectedMemberSuppressed, member.isSuppressed());
                    expectedTypeContainsExported |= expectedMemberAccess == CompatibilityAccess.EXPORTED;
                    expectedTypeContainsRestricted |= expectedMemberAccess == CompatibilityAccess.RESTRICTED;
                    if (!expectedMemberSuppressed) {
                        expectedTypeContainsConcealed |= expectedMemberAccess == CompatibilityAccess.CONCEALED;
                    }
                    expectedTypeContainsEscalated |= expectedMemberEscalated;
                }
                boolean expectedTypeHasOrContainsExported = type.getReferenceAccess() == CompatibilityAccess.EXPORTED || type.getExtensionAccess() == CompatibilityAccess.EXPORTED || expectedTypeContainsExported;
                boolean expectedTypeHasOrContainsRestricted = type.getReferenceAccess() == CompatibilityAccess.RESTRICTED || type.getExtensionAccess() == CompatibilityAccess.RESTRICTED || expectedTypeContainsRestricted;
                boolean expectedTypeHasOrContainsConcealed = type.getReferenceAccess() == CompatibilityAccess.CONCEALED || type.getExtensionAccess() == CompatibilityAccess.CONCEALED || expectedTypeContainsConcealed;
                boolean expectedTypeHasOrContainsEscalated = expectedTypeContainsEscalated;
                this.verify((Element)type, "Type.isControlled()", expectedTypeAccess != null, type.isControlled());
                this.verify((Element)type, "Type.getReferenceAccess()", expectedTypeAccess, type.getReferenceAccess());
                this.verify((Element)type, "Type.getExtensionAccess()", expectedTypeExtension != null ? expectedTypeExtension : expectedTypeAccess, type.getExtensionAccess());
                this.verify((Element)type, "Type.containsExported", expectedTypeContainsExported, type.containsExported());
                this.verify((Element)type, "Type.containsRestricted", expectedTypeContainsRestricted, type.containsRestricted());
                this.verify((Element)type, "Type.containsConcealed", expectedTypeContainsConcealed, type.containsConcealed());
                this.verify((Element)type, "Type.containsEscalated", expectedTypeContainsEscalated, type.containsEscalated());
                this.verify((Element)type, "Type.hasOrContainsExported", expectedTypeHasOrContainsExported, type.hasOrContainsExported());
                this.verify((Element)type, "Type.hasOrContainsRestricted", expectedTypeHasOrContainsRestricted, type.hasOrContainsRestricted());
                this.verify((Element)type, "Type.hasOrContainsConcealed", expectedTypeHasOrContainsConcealed, type.hasOrContainsConcealed());
                this.verify((Element)type, "Type.hasOrContainsEscalated", expectedTypeHasOrContainsEscalated, type.hasOrContainsEscalated());
                expectedPackageAccess = CompatibilityAccess.mostExported(expectedPackageMemberAccess, expectedTypeAccess);
                expectedPackageMemberAccess = CompatibilityAccess.mostExported(expectedPackageMemberAccess, expectedTypeAccess);
                expectedPackageContainsControlled |= type.isControlled();
                expectedPackageContainsExported |= expectedTypeAccess == CompatibilityAccess.EXPORTED || expectedTypeExtension == CompatibilityAccess.EXPORTED || expectedTypeContainsExported;
                expectedPackageContainsRestricted |= expectedTypeAccess == CompatibilityAccess.RESTRICTED || expectedTypeExtension == CompatibilityAccess.RESTRICTED || expectedTypeContainsRestricted;
                expectedPackageContainsConcealed |= expectedTypeAccess == CompatibilityAccess.CONCEALED || expectedTypeExtension == CompatibilityAccess.CONCEALED || expectedTypeContainsConcealed;
                expectedPackageContainsEscalated |= expectedTypeContainsEscalated;
            }
            this.verify((Element)packag, "Package.getReferenceAccess()", expectedPackageAccess, packag.getReferenceAccess());
            this.verify((Element)packag, "Package.getMemberAccess()", expectedPackageMemberAccess, packag.getMemberAccess());
            this.verify((Element)packag, "Package.containsControlled()", expectedPackageContainsControlled, packag.containsControlled());
            this.verify((Element)packag, "Package.containsExported()", expectedPackageContainsExported, packag.containsExported());
            this.verify((Element)packag, "Package.containsRestricted()", expectedPackageContainsRestricted, packag.containsRestricted());
            this.verify((Element)packag, "Package.containsConcealed()", expectedPackageContainsConcealed, packag.containsConcealed());
            this.verify((Element)packag, "Package.containsEscalated()", expectedPackageContainsEscalated, packag.containsEscalated());
        }
    }

    private PackageExportSpecification getPackageSpecification(ClassPathRoot root, Package packag) {
        AccessPolicy policy = root.getAccessPolicy();
        if (policy instanceof AnnotationAccessPolicy) {
            return packag.inferExportSpecification(CompatibilityAccess.RESTRICTED, false);
        }
        return policy.getExportSpecification().getPackage(packag.getName());
    }

    private void verify(Element element, String description, boolean expected, boolean actual) {
        if (expected == actual) {
            return;
        }
        this.log.error("element-verify-failed", "verification of %s for %s failed: expected %s; actual %s", description, element.getQualifiedSourceName(), expected, actual).scope(element.getQualifiedSourceName());
    }

    private <T> void verify(Element element, String description, T expected, T actual) {
        if (expected != null ? expected.equals(actual) : null == actual) {
            return;
        }
        this.log.error("element-verify-failed", "verification of %s for %s failed: expected %s; actual %s", description, element.getQualifiedSourceName(), expected, actual).scope(element.getQualifiedSourceName());
    }

    Type findType(TypeName typeName, String context, ElementName element) {
        Type type;
        assert (typeName.getFormat() != NameFormat.SOURCE);
        Package packag = (Package)this.allPackages.get(typeName.getPackage());
        if (packag != null && (type = packag.getType(typeName)) != null) {
            return type;
        }
        if (typeName.isArray()) {
            TypeName componentName = typeName.getComponentType();
            Type componentType = this.findType(componentName, context, element);
            packag = componentType.getParent();
            Type type2 = new Type(componentType, this.nameSpace);
            packag.addOrGetType(type2);
            return type2;
        }
        for (ClassPathRoot root : this.allRoots.values()) {
            Type type3 = root.visitFileIfPresent(typeName, (name, path) -> this.createType((TypeName)name, (Path)path, root));
            if (type3 == null) continue;
            return type3;
        }
        if (packag == null) {
            packag = (Package)this.allPackages.get(typeName.getPackage());
        }
        if (packag != null && (type = packag.getType(typeName)) != null) {
            return type;
        }
        if (packag == null) {
            packag = new Package(this, typeName.getPackage(), false, null, null);
            this.allPackages.put(packag.getName(), packag);
        }
        type = new Type(packag, typeName, null);
        packag.addOrGetType(type);
        this.log.warning("model-type-unresolved", "unresolved type %s (%s of %s in %s)", type.getQualifiedSourceName(), context, element, this).element(type.getQualifiedSourceName());
        return type;
    }

    public Type[] findTypes(TypeName[] typeNames, String context, ElementName element) {
        int length = typeNames.length;
        switch (length) {
            case 0: {
                return Type.EMPTY_TYPES;
            }
            case 1: {
                TypeName typeName = typeNames[0];
                if (!typeName.isPrimitiveOrString() && !typeName.equals(TypeName.JAVA_LANG_OBJECT)) break;
                Type[] types = this.SINGLETON_TYPE_ARRAYS.get(typeName);
                if (types == null) {
                    Type type = this.findType(typeName, context, element);
                    types = new Type[]{type};
                    this.SINGLETON_TYPE_ARRAYS.put(type.getName(), types);
                }
                return types;
            }
            case 2: {
                if (!typeNames[0].equals(TypeName.JAVA_LANG_STRING) || !typeNames[1].equals(TypeName.JAVA_LANG_STRING)) break;
                if (this.DOUBLE_STRING_TYPE_ARRAY == null) {
                    Type type = this.findType(TypeName.JAVA_LANG_STRING, context, element);
                    this.DOUBLE_STRING_TYPE_ARRAY = new Type[]{type, type};
                }
                return this.DOUBLE_STRING_TYPE_ARRAY;
            }
        }
        Type[] parameterTypes = new Type[length];
        for (int i = 0; i < length; ++i) {
            Type parameterType;
            TypeName oldType = typeNames[i];
            parameterTypes[i] = parameterType = this.findType(oldType, context, element);
            TypeName newType = parameterType.getName();
            if (newType.getFormat().ordinal() >= oldType.getFormat().ordinal()) continue;
            if (!newType.equals(oldType) || newType.hashCode() != oldType.hashCode() || newType.compareTo(oldType) != 0) {
                throw new IllegalStateException("new type not equal to old type");
            }
            typeNames[i] = newType;
        }
        return parameterTypes;
    }

    private Type createType(TypeName typeName, Path path, ClassPathRoot root) {
        Type type;
        AccessPolicy.Annotations packageAnnotations;
        boolean packageDeprecated;
        PackageName packageName = typeName.getPackage();
        Package packag = (Package)this.allPackages.get(packageName);
        if (packag != null) {
            Type type2 = packag.getType(typeName);
            if (type2 != null) {
                packag.getType(typeName).addOccludedRoot(root, packag);
            } else {
                AccessPolicy.PackageAccessPolicy packageAccessPolicy = root.getAccessPolicy().getPolicyForPackage(packag, packageName, null);
                try {
                    type2 = this.createTypeInPackage(root, path, typeName, packag, packageAccessPolicy, 0);
                }
                catch (IOException e) {
                    this.log.error("model-type-not-read", "type %s not read: %s", new PathKey(path), e).element(typeName);
                    type2 = new Type(packag, typeName, root);
                    packag.addOrGetType(type2);
                }
            }
            return type2;
        }
        Path info = path.resolveSibling("package-info.class");
        if (Files.exists(info, new LinkOption[0])) {
            try (ClassReader reader = new ClassReader(this.classPool, this.nameSpace);){
                ClassFile file = reader.parseClassFile(info, this.log);
                packageDeprecated = file.isDeprecated();
                packageAnnotations = this.annotator.annotations(file.getDeclaredAnnotations());
            }
            catch (IOException e) {
                this.log.error("model-package-info-not-read", "package info file %s not read: %s", new PathKey(info), e).scope(packageName);
                packageDeprecated = false;
                packageAnnotations = null;
            }
        } else {
            packageDeprecated = false;
            packageAnnotations = null;
        }
        AccessPolicy.PackageAccessPolicy packageAccessPolicy = root.getAccessPolicy().getPolicyForPackage(null, packageName, packageAnnotations);
        if (root.isControlled() && packageAccessPolicy.getDefaultMemberAccess() == null) {
            this.log.warning("model-package-outside-domain", "package %s not in domain", packageName).scope(packageName);
        }
        String packageComment = packageAccessPolicy.getComment();
        packag = new Package(this, packageName, packageDeprecated, packageAccessPolicy.getDefaultMemberAccess(), packageComment);
        this.allPackages.put(packageName, packag);
        if (packageName == PackageName.JAVA_LANG) {
            this.nestedFileSystemPool.addPermanent(root);
        }
        try {
            type = this.createTypeInPackage(root, path, typeName, packag, packageAccessPolicy, 0);
        }
        catch (IOException e) {
            this.log.error("model-type-not-read", "type %s not read: %s", new PathKey(path), e).element(typeName);
            type = new Type(packag, typeName, root);
            packag.addOrGetType(type);
        }
        return type;
    }

    private Type createTypeInPackage(ClassPathRoot root, Path path, TypeName typeName, Package packag, AccessPolicy.PackageAccessPolicy packageAccessPolicy, int depth) throws IOException {
        if (depth >= 100) {
            throw new IOException("create type recursion on " + typeName + " in " + root);
        }
        try (ClassReader reader = new ClassReader(this.classPool, this.nameSpace);){
            boolean membersEscalated;
            EnumSet<CompatibilityAccess> memberAccessTypes;
            TreeMap<MemberName, Member> members;
            Type type;
            CompatibilityAccess typeExtension;
            CompatibilityAccess typeAccess;
            AccessPolicy.TypeAccessPolicy typeAccessPolicy;
            boolean typeExportable;
            ClassFile file = reader.parseClassFile(path, this.log);
            if (!typeName.matchesQualifiedBinaryName(file.getFullClassName())) {
                this.log.warning("model-type-misplaced", "ignoring type %s misplaced at %s", file.getFullClassName(), new PathKey(path)).scope(root.getPath()).element(typeName);
                this.misplacedTypesByPath.put(file.getFullClassName(), new MisplacedType(file.getFullClassName(), root, typeName.getClassName()));
                Type type2 = null;
                return type2;
            }
            Type outerType = null;
            if (typeName.isInner()) {
                TypeName outerTypeName = typeName.getOuterType();
                if (file.getOuterClass() == null || !outerTypeName.matchesQualifiedBinaryName(file.getOuterClass().toString())) {
                    this.log.error("model-type-unsupported", "ignored type %s appears to be inner type but unsupported in %s", typeName, new PathKey(path)).scope(typeName);
                    Type type3 = null;
                    return type3;
                }
                outerType = packag.getType(outerTypeName);
                if (outerType == null && ((outerType = this.createTypeInPackage(root, path.resolveSibling(outerTypeName.getClassName()), outerTypeName, packag, packageAccessPolicy, depth + 1)) == null || outerType.isUnresolved())) {
                    this.log.error("model-outer-type-unresolved", "outer type %s of %s not resolved", outerTypeName, new PathKey(path)).scope(typeName);
                }
            } else if (!file.isAnonymous() && !file.isLocal() && file.getOuterClass() != null) {
                this.log.error("model-outer-type-unexpected", "outer type %s unexpected in %s", file.getOuterClass(), new PathKey(path)).scope(typeName);
            }
            int modifiers = file.getModifiers();
            String sourceFileName = file.getSourceFilename();
            if (sourceFileName == null) {
                sourceFileName = "";
            }
            TypeName superClassName = !Modifier.isInterface(modifiers) ? reader.parseClassName(file.getBaseClass()) : TypeName.JAVA_LANG_OBJECT;
            TypeName[] interfaceNames = reader.parseNames(file.getBaseInterfaces());
            boolean typeDeprecated = file.isDeprecated();
            boolean typeLocaleSpecific = this.isLocaleSpecific(typeName, root);
            boolean bl = typeExportable = !(!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || packag.isDefault() || file.isAnonymous() || file.isLocal() || outerType != null && !outerType.isExportable() || sourceFileName.endsWith(".groovy") || typeLocaleSpecific);
            if (typeExportable) {
                typeAccessPolicy = packageAccessPolicy.getPolicyForType(packag, outerType, typeName, this.annotator.annotations(file.getDeclaredAnnotations()), this.log);
                typeAccess = typeAccessPolicy.getAccess();
                String typeComment = typeAccessPolicy.getComment();
                typeExtension = typeAccessPolicy.getExtension();
                type = new Type(packag, outerType, root, typeName, modifiers, superClassName, interfaceNames, true, root.isJDK(), typeAccess, typeDeprecated, typeComment, typeExtension);
                if (outerType != null && outerType.getReferenceAccess() == CompatibilityAccess.CONCEALED && typeAccess == CompatibilityAccess.EXPORTED) {
                    this.log.warning("model-type-expands-access", "inner type %s expands access", type.getQualifiedSourceName()).scope(type.getQualifiedSourceName());
                }
            } else {
                ClassFile.ClassMethod[] annotationName;
                typeAccessPolicy = null;
                typeExtension = typeAccess = packageAccessPolicy.getDefaultMemberAccess();
                type = new Type(packag, outerType, root, typeName, modifiers, superClassName, interfaceNames, typeExportable, root.isJDK(), typeAccess, typeDeprecated, null, typeExtension);
                switch (annotationName = this.accessAnnotationName(file)) {
                    case "Exported": 
                    case "Restricted": {
                        if (packag.isDefault()) {
                            this.log.error("model-annotation-ignored-default", "@%s ignored on type in default package %s", annotationName, type.getQualifiedSourceName()).scope(type.getQualifiedSourceName());
                            break;
                        }
                        if (sourceFileName.endsWith(".groovy")) {
                            this.log.error("model-annotation-ignored-groovy", "@%s ignored on Groovy type %s", annotationName, type.getQualifiedSourceName()).scope(type.getQualifiedSourceName());
                            break;
                        }
                        if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
                            this.log.error("model-annotation-ignored-private", "@%s ignored on private type %s: type must be public or protected", annotationName, type.getQualifiedSourceName()).scope(type.getQualifiedSourceName());
                            break;
                        }
                        this.log.error("model-annotation-ignored-outer", "@%s ignored on inner type %s: outer type must be public or protected", annotationName, type.getQualifiedSourceName()).scope(type.getQualifiedSourceName());
                    }
                }
            }
            Member.Escalation protectedEscalation = Member.Escalation.PRIVATE;
            for (ClassFile.ClassMethod classMethod : file.getDeclaredConstructors()) {
                int memberModifiers = classMethod.getModifiers();
                if (ClassReader.publicOrProtected(memberModifiers)) {
                    protectedEscalation = Member.Escalation.PUBLIC;
                    break;
                }
                if (!ClassReader.packagePrivate(memberModifiers)) continue;
                protectedEscalation = Member.Escalation.DEFAULT;
            }
            while (true) {
                CompatibilityAccess compatibilityAccess;
                Member member;
                boolean memberEscalated;
                CompatibilityAccess memberAccess;
                AccessPolicy.MemberAccessPolicy memberAccessPolicy;
                Member.Escalation memberEscalation;
                AccessPolicy.Annotations annotations;
                int memberModifiers;
                members = new TreeMap<MemberName, Member>(MemberName.UNQUALIFIED_COMPARATOR);
                memberAccessTypes = EnumSet.noneOf(CompatibilityAccess.class);
                membersEscalated = false;
                for (ClassFile.ClassMethod classMethod : file.getDeclaredConstructors()) {
                    memberModifiers = classMethod.getModifiers();
                    if (!ClassReader.publicOrProtected(memberModifiers)) continue;
                    ClassReader.MethodSignature signature = reader.parseMethodDescriptor(classMethod.getDescriptor(), true, type);
                    TypeName[] parameterTypeNames = signature.getParameterTypeNames();
                    ConstructorName memberKey = this.nameSpace.constructorName(typeName, parameterTypeNames, ClassReader.varargs(memberModifiers));
                    annotations = this.annotator.annotations(classMethod.getDeclaredAnnotations());
                    Member.Escalation escalation = memberEscalation = Modifier.isPublic(memberModifiers) ? Member.Escalation.NONE : protectedEscalation;
                    if (typeExportable && typeAccess != null) {
                        memberAccessPolicy = typeAccessPolicy.getPolicyForMember(type, memberKey, annotations);
                        memberAccess = memberAccessPolicy.getAccess();
                        boolean memberSuppressed = false;
                        memberEscalated = false;
                        CompatibilityAccess memberAccessDefault = CompatibilityAccess.CONCEALED;
                        boolean memberAccessExplicit = false;
                        switch (memberEscalation) {
                            case PUBLIC: {
                                memberAccessDefault = typeExtension != null ? typeExtension : typeAccess;
                                memberAccessExplicit = typeAccessPolicy.isPolicyForMemberExplicit(type, memberKey, annotations);
                            }
                            case DEFAULT: 
                            case PRIVATE: {
                                boolean bl2 = memberSuppressed = memberAccessDefault == CompatibilityAccess.CONCEALED;
                                if (!CompatibilityAccess.isMoreExported(memberAccess, memberAccessDefault) || (memberEscalated = memberAccessExplicit)) break;
                                memberAccess = memberAccessDefault;
                            }
                        }
                        String memberComment = memberAccessPolicy.getComment();
                        member = new Constructor(type, memberKey, memberEscalation, classMethod.isDeprecated(), memberAccess, memberEscalated, memberSuppressed, memberComment);
                        if (!memberSuppressed || !memberAccess.isConcealed()) {
                            memberAccessTypes.add(memberAccess);
                        }
                        membersEscalated |= memberEscalated;
                        if (typeAccess == CompatibilityAccess.CONCEALED && memberAccess == CompatibilityAccess.EXPORTED) {
                            this.log.warning("model-expands-access", "constructor %s expands access", member.getQualifiedSourceName()).scope(member.getQualifiedSourceName());
                        }
                    } else {
                        member = new Constructor(type, memberKey, memberEscalation, classMethod.isDeprecated(), null, false, false, annotations.getComment());
                        if (typeAccess != null && CompatibilityAccess.isExportedOrRestricted(annotations.getAccess())) {
                            this.log.error("model-access-ignored", "%s ignored on constructor of unexportable type %s", annotations.getAnnotationSimpleName(), member.getQualifiedSourceName()).scope(member.getQualifiedSourceName());
                        }
                    }
                    members.putIfAbsent(((Constructor)member).getName(), member);
                }
                for (ClassFile.ClassMethod classMethod : file.getDeclaredMethods()) {
                    Method member2;
                    Member.Escalation memberEscalation2;
                    memberModifiers = classMethod.getModifiers();
                    if (!ClassReader.publicOrProtected(memberModifiers) || ClassReader.bridge(memberModifiers)) continue;
                    String methodName = classMethod.getMethodName();
                    ClassReader.MethodSignature signature = reader.parseMethodDescriptor(classMethod.getDescriptor(), false, type);
                    TypeName[] parameterTypeNames = signature.getParameterTypeNames();
                    MethodName memberName = this.nameSpace.methodName(typeName, methodName, parameterTypeNames, ClassReader.varargs(memberModifiers));
                    AccessPolicy.Annotations annotations2 = this.annotator.annotations(classMethod.getDeclaredAnnotations());
                    Member.Escalation escalation = memberEscalation2 = Modifier.isPublic(memberModifiers) ? Member.Escalation.NONE : protectedEscalation;
                    if (typeExportable && typeAccess != null) {
                        AccessPolicy.MemberAccessPolicy memberAccessPolicy2 = typeAccessPolicy.getPolicyForMember(type, memberName, annotations2);
                        CompatibilityAccess memberAccess2 = memberAccessPolicy2.getAccess();
                        boolean memberSuppressed = false;
                        boolean memberEscalated2 = false;
                        CompatibilityAccess memberAccessDefault = CompatibilityAccess.CONCEALED;
                        boolean memberAccessExplicit = false;
                        switch (memberEscalation2) {
                            case PUBLIC: {
                                memberAccessDefault = typeExtension != null ? typeExtension : typeAccess;
                            }
                            case DEFAULT: {
                                memberAccessExplicit = typeAccessPolicy.isPolicyForMemberExplicit(type, memberName, annotations2);
                            }
                            case PRIVATE: {
                                boolean bl3 = memberSuppressed = memberAccessDefault == CompatibilityAccess.CONCEALED;
                                if (!CompatibilityAccess.isMoreExported(memberAccess2, memberAccessDefault) || (memberEscalated2 = memberAccessExplicit)) break;
                                memberAccess2 = memberAccessDefault;
                            }
                        }
                        String memberComment = memberAccessPolicy2.getComment();
                        Method member3 = new Method(type, memberName, signature.getReturnTypeName(), Modifier.isStatic(memberModifiers), Modifier.isFinal(memberModifiers), Modifier.isAbstract(memberModifiers), memberEscalation2, classMethod.isDeprecated(), memberAccess2, memberEscalated2, memberSuppressed, memberComment);
                        if (!memberSuppressed || !memberAccess2.isConcealed()) {
                            memberAccessTypes.add(memberAccess2);
                        }
                        membersEscalated |= memberEscalated2;
                        if (typeAccess == CompatibilityAccess.CONCEALED && memberAccess2 == CompatibilityAccess.EXPORTED) {
                            this.log.warning("model-expands-access", "method %s expands access", member3.getQualifiedSourceName()).scope(member3.getQualifiedSourceName());
                        }
                    } else {
                        member2 = new Method(type, memberName, signature.getReturnTypeName(), Modifier.isStatic(memberModifiers), Modifier.isFinal(memberModifiers), Modifier.isAbstract(memberModifiers), memberEscalation2, classMethod.isDeprecated(), null, false, false, annotations2.getComment());
                        if (typeAccess != null && CompatibilityAccess.isExportedOrRestricted(annotations2.getAccess())) {
                            this.log.error("model-access-ignored", "%s ignored on method of unexportable type %s", annotations2.getAnnotationSimpleName(), member2.getQualifiedSourceName()).scope(member2.getQualifiedSourceName());
                        }
                    }
                    members.putIfAbsent(member2.getName(), member2);
                }
                for (ClassFile.ClassField classField : file.getDeclaredFields()) {
                    memberModifiers = classField.getModifiers();
                    if (!ClassReader.publicOrProtected(memberModifiers)) continue;
                    FieldName memberKey = this.nameSpace.fieldName(typeName, classField.getFieldName());
                    TypeName fieldTypeName = reader.parseFieldDescriptor(classField.getDescriptor());
                    Object constantValue = typeLocaleSpecific ? null : classField.getConstantValue();
                    annotations = this.annotator.annotations(classField.getDeclaredAnnotations());
                    Member.Escalation escalation = memberEscalation = Modifier.isPublic(memberModifiers) ? Member.Escalation.NONE : protectedEscalation;
                    if (typeExportable && typeAccess != null) {
                        memberAccessPolicy = typeAccessPolicy.getPolicyForMember(type, memberKey, annotations);
                        memberAccess = memberAccessPolicy.getAccess();
                        boolean memberSuppressed = false;
                        memberEscalated = false;
                        CompatibilityAccess memberAccessDefault = CompatibilityAccess.CONCEALED;
                        boolean memberAccessExplicit = false;
                        switch (memberEscalation) {
                            case PUBLIC: {
                                memberAccessDefault = typeExtension != null ? typeExtension : typeAccess;
                            }
                            case DEFAULT: {
                                memberAccessExplicit = typeAccessPolicy.isPolicyForMemberExplicit(type, memberKey, annotations);
                            }
                            case PRIVATE: {
                                boolean bl4 = memberSuppressed = memberAccessDefault == CompatibilityAccess.CONCEALED;
                                if (!CompatibilityAccess.isMoreExported(memberAccess, memberAccessDefault) || (memberEscalated = memberAccessExplicit)) break;
                                memberAccess = memberAccessDefault;
                            }
                        }
                        String memberComment = memberAccessPolicy.getComment();
                        member = new Field(type, memberKey, fieldTypeName, constantValue, Modifier.isStatic(memberModifiers), Modifier.isFinal(memberModifiers), memberEscalation, classField.isDeprecated(), memberAccess, memberEscalated, memberSuppressed, memberComment);
                        if (!memberSuppressed || !memberAccess.isConcealed()) {
                            memberAccessTypes.add(memberAccess);
                        }
                        membersEscalated |= memberEscalated;
                        if (typeAccess == CompatibilityAccess.CONCEALED && memberAccess == CompatibilityAccess.EXPORTED) {
                            this.log.warning("model-expands-access", "field %s expands access", member.getQualifiedSourceName()).scope(member.getQualifiedSourceName());
                        }
                    } else {
                        member = new Field(type, memberKey, fieldTypeName, constantValue, Modifier.isStatic(memberModifiers), Modifier.isFinal(memberModifiers), memberEscalation, classField.isDeprecated(), null, false, false, annotations.getComment());
                        if (typeAccess != null && CompatibilityAccess.isExportedOrRestricted(annotations.getAccess())) {
                            this.log.error("model-access-ignored", "%s ignored on field of unexportable type %s", annotations.getAnnotationSimpleName(), member.getQualifiedSourceName()).scope(member.getQualifiedSourceName());
                        }
                    }
                    members.putIfAbsent(((Field)member).getName(), member);
                    membersEscalated |= member.isEscalated();
                }
                if (typeExtension != null || memberAccessTypes.isEmpty() || !CompatibilityAccess.isMoreExported(compatibilityAccess = CompatibilityAccess.mostExported(memberAccessTypes.toArray(new CompatibilityAccess[memberAccessTypes.size()])), typeAccess)) break;
                typeAccess = compatibilityAccess;
            }
            type.addMembers(members.values(), memberAccessTypes, membersEscalated);
            Type type2 = packag.addOrGetType(type);
            if (type2 != type) {
                String predecessorPath = type2.getRoot() != null ? type2.getRoot().getPath() : "unspecified";
                String successorPath = type.getRoot() != null ? type.getRoot().getPath() : "unspecified";
                this.log.warning("model-type-duplicated", "type %s duplicated (%s precedes %s)", type.getQualifiedSourceName(), predecessorPath, successorPath).element(type.getQualifiedSourceName());
                Type type3 = type2;
                return type3;
            }
            Type type4 = type;
            return type4;
        }
    }

    private boolean isLocaleSpecific(TypeName typeName, ClassPathRoot root) {
        TypeName familyName = this.nameSpace.familyName(typeName);
        return familyName != typeName && root.getTypeName(familyName) != null;
    }

    private String accessAnnotationName(ClassFile file) {
        for (ClassFile.ClassAnnotation annotation : file.getDeclaredAnnotations()) {
            switch (annotation.getAnnotationType().toString()) {
                case "Loracle/javatools/annotations/Concealed;": {
                    return "Concealed";
                }
                case "Loracle/javatools/annotations/Exported;": {
                    return "Exported";
                }
                case "Loracle/javatools/annotations/Restricted;": {
                    return "Restricted";
                }
            }
        }
        return "null";
    }

    public String getSource() {
        return this.source;
    }

    public ExportDomain getDomain() {
        return this.domain;
    }

    public SortedSet<LibraryDescription> getLibraries() {
        return this.libraries;
    }

    public NameSpace getNameSpace() {
        return this.nameSpace;
    }

    public NestedFileSystemPool getNestedFileSystemPool() {
        return this.nestedFileSystemPool;
    }

    public StringPool getCommentPool() {
        return this.annotator.commentPool;
    }

    public boolean isRooted() {
        return this.rooted;
    }

    public Collection<ClassPathRoot> getRoots() {
        return this.allRoots.values();
    }

    public List<ClassPathRoot> getBootRoots() {
        ArrayList<ClassPathRoot> roots = new ArrayList<ClassPathRoot>();
        for (ClassPathRoot root : this.allRoots.values()) {
            if (!root.isJDK()) continue;
            roots.add(root);
        }
        return roots;
    }

    public Log getLog() {
        return this.log;
    }

    public Iterable<Package> getPackages() {
        return this.allPackages.values();
    }

    public Iterable<Package> getControlledPackages() {
        return this.controlledPackages;
    }

    public Package getPackage(PackageName name) {
        return (Package)this.allPackages.get(name);
    }

    public Type getType(TypeName name) {
        Type type;
        assert (name.getFormat() != NameFormat.SOURCE);
        Package packag = (Package)this.allPackages.get(name.getPackage());
        if (packag != null && (type = packag.getType(name)) != null) {
            return type;
        }
        if (name.isArray()) {
            TypeName componentName = name.getComponentType();
            Type componentType = this.getType(componentName);
            packag = componentType.getParent();
            Type type2 = new Type(componentType, this.nameSpace);
            packag.addOrGetType(type2);
            return type2;
        }
        return null;
    }

    public Member<?> getMember(MemberName name) {
        Type type = this.getType(name.getType());
        if (type == null) {
            return null;
        }
        return type.getDeclaredMember(name);
    }

    Element getElement(ElementName name) {
        switch (name.getLevel()) {
            case 0: {
                return this.getPackage((PackageName)name);
            }
            case 1: {
                return this.getType((TypeName)name);
            }
            case 2: {
                return this.getMember((MemberName)name);
            }
        }
        throw new IllegalStateException("unexpected level " + name.getLevel());
    }

    public void logStatistics() {
        this.log.note("model-class-statistics", "%s: %d class files read, %d bytes average, %d bytes max", this.source, this.classPool.getClassFileCount(), this.classPool.getClassFileAverageSize(), this.classPool.getClassFileMaxSize());
        this.log.trace("model-class-statistics", "%s: %d class files read, %d bytes average, %d bytes max", this.source, this.classPool.getClassFileCount(), this.classPool.getClassFileAverageSize(), this.classPool.getClassFileMaxSize());
        this.log.trace("model-root-statistics", "%s: %s", this.source, new Object(){
            private static final String SPACES = "                 ";

            public String toString() {
                ArrayList<ClassPathRoot> roots = new ArrayList<ClassPathRoot>(ClassPathModel.this.allRoots.values());
                Collections.sort(roots, (l, r) -> Integer.compare(r.getZFSOpenCount(), l.getZFSOpenCount()));
                int summedOpens = 0;
                long summedTotalTime = 0L;
                int maxOpens = 0;
                int maxTotalTime = 0;
                int maxMaxTime = 0;
                for (ClassPathRoot root : roots) {
                    int maxTime;
                    int totalTime;
                    int opens = root.getZFSOpenCount();
                    if (opens > maxOpens) {
                        maxOpens = opens;
                    }
                    if ((totalTime = root.getZFSOpenTotalTime()) > maxTotalTime) {
                        maxTotalTime = totalTime;
                    }
                    if ((maxTime = root.getZFSOpenMaxTime()) > maxMaxTime) {
                        maxMaxTime = maxTime;
                    }
                    summedOpens += opens;
                    summedTotalTime += (long)totalTime;
                }
                StringBuilder builder = new StringBuilder();
                builder.append(roots.size() + " class path roots, ").append(summedOpens);
                builder.append(" ZFS opens consuming ").append(summedTotalTime).append("ms");
                builder.append("; costliest roots (rt.jar excluded):");
                int opensWidth = String.valueOf(1 << 32 - Integer.numberOfLeadingZeros(maxOpens - 1)).length();
                int totalTimeWidth = String.valueOf(1 << 32 - Integer.numberOfLeadingZeros(maxTotalTime - 1)).length();
                int maxTimeWidth = String.valueOf(1 << 32 - Integer.numberOfLeadingZeros(maxMaxTime - 1)).length();
                int count = 0;
                for (ClassPathRoot root : roots) {
                    int openCount = root.getZFSOpenCount();
                    int totalTime = root.getZFSOpenTotalTime();
                    int maxTime = root.getZFSOpenMaxTime();
                    if (openCount <= 1 && totalTime <= 1) continue;
                    builder.append('\n');
                    this.append(builder, openCount, opensWidth, null).append(" ");
                    this.append(builder, totalTime, totalTimeWidth, null).append("ms total  [");
                    this.append(builder, maxTime, maxTimeWidth, null).append("ms max]  ");
                    builder.append(root.getPath());
                    if (++count < 32) continue;
                    break;
                }
                return builder.toString();
            }

            StringBuilder append(StringBuilder builder, int n, int width, String stem) {
                String image = String.valueOf(n);
                builder.append(SPACES, 0, Math.min(width, SPACES.length()) - Math.min(image.length(), width));
                builder.append(image);
                if (stem != null) {
                    builder.append(stem).append(n != 1 ? (char)'s' : ' ');
                }
                return builder;
            }
        });
        this.log.trace("model-buffer-statistics", "%s: %s", this.source, this.classPool.summary());
    }

    public String toString() {
        return this.source;
    }

    public static interface Monitor {
        public void beginTraversal(List<ClassPathRoot> var1, List<ClassPathRoot> var2);

        public void rootTraversed(ClassPathRoot var1);

        public void endTraversal();
    }

    private static class Annotator
    implements AccessPolicy.Annotations {
        private CompatibilityAccess access;
        private CompatibilityAccess extension;
        private String comment;
        private boolean exportedExtensionExpandsRestricted;
        private final StringPool commentPool;
        private static final Map<CompatibilityAccess, String> ANNOTATION_NAME = new EnumMap<CompatibilityAccess, String>(CompatibilityAccess.class);

        private Annotator(StringPool commentPool) {
            this.commentPool = commentPool;
        }

        AccessPolicy.Annotations annotations(ClassFile.ClassAnnotation[] annotations) {
            this.access = null;
            this.extension = null;
            this.comment = null;
            this.exportedExtensionExpandsRestricted = false;
            block28: for (ClassFile.ClassAnnotation annotation : annotations) {
                String[] componentNames = annotation.getComponentNames();
                ClassFile.ComponentValue[] componentValues = annotation.getComponentValues();
                CompatibilityAccess annotationAccess = CompatibilityAccess.EXPORTED;
                switch (annotation.getAnnotationType().toString()) {
                    case "Loracle/javatools/annotations/Concealed;": {
                        this.access = CompatibilityAccess.CONCEALED;
                        this.extractComment(componentNames, componentValues);
                        continue block28;
                    }
                    case "Loracle/javatools/annotations/Comment;": {
                        this.extractComment(componentNames, componentValues);
                        continue block28;
                    }
                    case "Loracle/javatools/annotations/Restricted;": {
                        annotationAccess = CompatibilityAccess.RESTRICTED;
                        this.extractComment(componentNames, componentValues);
                    }
                    case "Loracle/javatools/annotations/Exported;": {
                        this.access = annotationAccess;
                        this.extension = null;
                        block29: for (int i = 0; i < componentNames.length; ++i) {
                            switch (componentNames[i]) {
                                case "extension": {
                                    Object value = componentValues[i].getComponentValue();
                                    if (!(value instanceof ClassFile.EnumReference)) continue block29;
                                    switch (((ClassFile.EnumReference)value).getName().toString()) {
                                        case "EXPORTED": {
                                            if (annotationAccess == CompatibilityAccess.EXPORTED) {
                                                this.extension = CompatibilityAccess.EXPORTED;
                                                break;
                                            }
                                            this.exportedExtensionExpandsRestricted = true;
                                            break;
                                        }
                                        case "RESTRICTED": {
                                            this.extension = CompatibilityAccess.RESTRICTED;
                                            break;
                                        }
                                        case "CONCEALED": {
                                            this.extension = CompatibilityAccess.CONCEALED;
                                        }
                                    }
                                    if (this.extension != this.access) continue block29;
                                    this.extension = null;
                                }
                            }
                        }
                        continue block28;
                    }
                }
            }
            return this;
        }

        private void extractComment(String[] componentNames, ClassFile.ComponentValue[] componentValues) {
            for (int i = 0; i < componentNames.length; ++i) {
                if (!componentNames[i].equals("value")) continue;
                String text = componentValues[i].getComponentValue().toString().trim();
                if (text.isEmpty()) break;
                if (this.comment == null) {
                    this.comment = text;
                    break;
                }
                if (this.comment.endsWith(".")) {
                    this.comment = this.comment + " " + text;
                    break;
                }
                this.comment = this.comment + ". " + text;
                break;
            }
        }

        @Override
        public CompatibilityAccess getAccess() {
            return this.access;
        }

        @Override
        public String getComment() {
            return this.commentPool.pool(this.comment);
        }

        @Override
        public CompatibilityAccess getExtension() {
            return this.extension;
        }

        @Override
        public boolean isExportedExtensionExpandsRestricted() {
            return this.exportedExtensionExpandsRestricted;
        }

        @Override
        public String getAnnotationSimpleName() {
            return Annotator.annotationName(this.access);
        }

        private static String annotationName(CompatibilityAccess access) {
            return access == null ? "null" : ANNOTATION_NAME.get((Object)access);
        }

        static {
            ANNOTATION_NAME.put(CompatibilityAccess.EXPORTED, "@Exported");
            ANNOTATION_NAME.put(CompatibilityAccess.RESTRICTED, "@Restricted");
            ANNOTATION_NAME.put(CompatibilityAccess.CONCEALED, "@Concealed");
        }
    }

    private static class MisplacedType {
        private final String relativePath;
        private final ClassPathRoot root;
        private final String actualRelativePath;

        public MisplacedType(String relativePath, ClassPathRoot root, String actualRelativePath) {
            this.relativePath = relativePath;
            this.root = root;
            this.actualRelativePath = actualRelativePath;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        public ClassPathRoot getRoot() {
            return this.root;
        }

        public String getActualRelativePath() {
            return this.actualRelativePath;
        }
    }

    public static final class LibraryDescription
    implements Comparable<LibraryDescription> {
        private final ExportLibrary library;
        private final String id;
        private final String path;
        private final String name;
        private final String[] aliases;

        public LibraryDescription(ExportLibrary library, Path baseDirectory, String ... aliases) {
            this.library = library;
            this.id = library.getId();
            this.path = Paths.relativize(library.getOrigin(), baseDirectory);
            this.name = library.getName();
            this.aliases = aliases;
        }

        public LibraryDescription(String id, String path, String name, String ... aliases) {
            this.library = null;
            this.id = id;
            this.path = path;
            this.name = name;
            this.aliases = aliases;
        }

        public ExportLibrary getLibrary() {
            return this.library;
        }

        public String getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String[] getAliases() {
            return this.aliases;
        }

        @Override
        public int compareTo(LibraryDescription that) {
            int comparison = this.name.compareTo(that.name);
            if (comparison != 0) {
                return comparison;
            }
            return this.path.compareTo(that.path);
        }

        public boolean equals(Object object) {
            if (!(object instanceof LibraryDescription)) {
                return false;
            }
            LibraryDescription that = (LibraryDescription)object;
            return this.name.equals(that.getName()) && this.path.equals(that.path);
        }

        public int hashCode() {
            return this.name.hashCode() * 31 + this.path.hashCode();
        }
    }
}

