/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.exports.CompatibilityAccess;
import oracle.javatools.exports.classpath.BaselineReaderWriter;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.Constructor;
import oracle.javatools.exports.classpath.Conversions;
import oracle.javatools.exports.classpath.Field;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Method;
import oracle.javatools.exports.classpath.OverrideEquivalentMethod;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.classpath.TypeKind;
import oracle.javatools.exports.common.ComparisonIterators;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.name.ConstructorName;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.MethodName;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.uses.LibraryUses;
import oracle.javatools.exports.uses.MemberUses;
import oracle.javatools.exports.uses.TypeOrMemberUses;
import oracle.javatools.exports.uses.TypeUses;
import oracle.javatools.exports.uses.UsesModel;
import oracle.javatools.util.MultiMap;

public class BaselineComparison {
    private final UsesModel uses;
    private final Log log;
    private final List<Message> errors = new ArrayList<Message>();
    private int errorsWithUsesCount;
    private final List<Message> warnings = new ArrayList<Message>();
    private final List<Message> notes = new ArrayList<Message>();
    private final MultiMap<String, String> approvals = new MultiMap(LinkedHashSet.class);
    private final List<Message> matchedApprovals = new ArrayList<Message>();
    private final MultiMap<String, String> unmatchedApprovals = new MultiMap(LinkedHashSet.class);
    private static final Map<String, Change> ID_TO_CHANGE = new LinkedHashMap<String, Change>();
    private final Matcher USES_MATCHER = Pattern.compile(": [0-9]+ (?:reference|extension)s?[, ]").matcher("");
    private static final TypeKind[] TYPE_KINDS = new TypeKind[]{TypeKind.CLASS, TypeKind.INTERFACE};
    private static final ElementKind[] MEMBER_KINDS = new ElementKind[]{ElementKind.CONSTRUCTOR, ElementKind.METHOD, ElementKind.FIELD};
    private static final Enum<?>[] ELEMENT_KINDS = new Enum[]{TypeKind.CLASS, TypeKind.INTERFACE, ElementKind.CONSTRUCTOR, ElementKind.METHOD, ElementKind.FIELD};
    private static final ElementKind[] FIELD_KINDS = new ElementKind[]{ElementKind.FIELD};
    private static final ElementKind[] METHOD_KINDS = new ElementKind[]{ElementKind.METHOD};

    public BaselineComparison(UsesModel uses, Log log) {
        this.uses = uses;
        this.log = log;
    }

    public void readApprovals(Path path) throws IOException {
        int count = 0;
        for (String line : Files.readAllLines(path)) {
            ++count;
            if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
            int colon = line.indexOf(58);
            if (colon < 0) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, expected \"<id>: <message>\" at %s:%d", path, count);
                continue;
            }
            Object id = line.substring(0, colon).trim();
            Change change = Change.getChange((String)id);
            if (change == null) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, id \"%s\" not valid at %s:%d", id, path, count);
                continue;
            }
            if (change == Change.CHANGE_RETRACTED) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, approval not applicable to retracted approval at %s:%d", path, count);
                continue;
            }
            if (change == Change.APPROVAL_INVALID) {
                this.error(Change.APPROVAL_INVALID, "invalid approval, approval not applicable to invalid approval at %s:%d", path, count);
                continue;
            }
            int end = line.length();
            int used = ((String)id).indexOf("-used-");
            if (used > 0) {
                id = ((String)id).substring(0, used) + ((String)id).substring(used + 5);
                this.USES_MATCHER.reset(line);
                if (this.USES_MATCHER.find(colon + 1)) {
                    end = this.USES_MATCHER.start();
                }
            }
            String message = line.substring(colon + 1, end).trim();
            this.approvals.add((String)id, message);
            this.unmatchedApprovals.add((String)id, message);
        }
    }

    public int getErrorsCount() {
        return this.errors.size();
    }

    public int getErrorsWithUsesCount() {
        return this.errorsWithUsesCount;
    }

    public int getWarningsCount() {
        return this.warnings.size();
    }

    public int getNotesCount() {
        return this.notes.size();
    }

    public int getApprovalsCount() {
        return this.approvals.valuesSize();
    }

    public int getMatchedApprovalsCount() {
        return this.matchedApprovals.size();
    }

    public int getUnmatchedApprovalsCount() {
        return this.unmatchedApprovals.valuesSize();
    }

    public Iterable<String> getErrors() {
        return () -> new ChangeIterator(this.errors);
    }

    public Iterable<String> getErrorsWithUses() {
        return () -> new ChangeIterator(this.errors, m -> m.getId().contains("used"));
    }

    public Iterable<String> getWarnings() {
        return () -> new ChangeIterator(this.warnings);
    }

    public Iterable<String> getNotes() {
        return () -> new ChangeIterator(this.notes);
    }

    public Iterable<String> getMatchedApprovals() {
        return () -> new ChangeIterator(this.matchedApprovals);
    }

    public Iterable<String> getUnmatchedApprovals() {
        ArrayList<String> messages = new ArrayList<String>();
        Iterator<Map.Entry<String, String>> i = this.unmatchedApprovals.keyValueIterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            messages.add(BaselineComparison.format(entry.getKey(), entry.getValue()));
        }
        Collections.sort(messages);
        return messages;
    }

    /*
     * Unable to fully structure code
     */
    public void compare(ClassPathModel referenceModel, ClassPathModel revisedModel) {
        removedSubdomains = new ExportDomain(new String[0]);
        domains = ComparisonIterators.iterator(referenceModel.getDomain().getSubdomains(), revisedModel.getDomain().getSubdomains(), Comparator.comparing((Function<ExportDomain.Subdomain, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Loracle/javatools/exports/specification/ExportDomain$Subdomain;)Ljava/lang/String;)()));
        block45: while (domains.hasNext()) {
            switch (1.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[domains.next().ordinal()]) {
                case 1: {
                    removedSubdomain = domains.left();
                    removedSubdomains.addSubdomain(removedSubdomain);
                    removedName = removedSubdomain.getName();
                    this.warning(Change.DOMAIN_REMOVED, "subdomain %s removed", new Object[]{removedName}).element(removedName);
                    continue block45;
                }
                case 2: {
                    exceptions = ComparisonIterators.iterator(domains.left().getExceptions(), domains.right().getExceptions());
                    block46: while (exceptions.hasNext()) {
                        switch (1.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[exceptions.next().ordinal()]) {
                            case 1: {
                                removedException = (String)exceptions.left();
                                this.note(Change.DOMAIN_EXCEPT_REMOVED, "subdomain %s exception %s removed", new Object[]{domains.left().getName(), removedException}).element(removedException);
                                continue block46;
                            }
                            case 2: {
                                continue block46;
                            }
                            case 3: {
                                addedException = (String)exceptions.right();
                                this.note(Change.DOMAIN_EXCEPT_ADDED, "subdomain %s exception %s added", new Object[]{addedException, domains.left().getName(), addedException}).element(addedException);
                                continue block46;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    continue block45;
                }
                case 3: {
                    addedName = domains.right().getName();
                    this.note(Change.DOMAIN_ADDED, "subdomain %s added", new Object[]{addedName}).element(addedName);
                    continue block45;
                }
            }
            throw new IllegalStateException();
        }
        referenceByName = new TreeMap<Object, ClassPathModel.LibraryDescription>();
        referenceByPath = new HashMap<String, ClassPathModel.LibraryDescription>();
        for (ClassPathModel.LibraryDescription library : referenceModel.getLibraries()) {
            referenceByName.put(library.getName(), library);
            for (String name : library.getAliases()) {
                referenceByName.put(name, library);
            }
            if (!library.getPath().endsWith(".library")) continue;
            referenceByPath.put(library.getPath(), library);
        }
        revisedByName = new TreeMap<String, ClassPathModel.LibraryDescription>();
        revisedByPath = new HashMap<String, ClassPathModel.LibraryDescription>();
        for (ClassPathModel.LibraryDescription library : revisedModel.getLibraries()) {
            revisedByName.put(library.getName(), library);
            for (String name : library.getAliases()) {
                revisedByName.put(name, library);
            }
            if (!library.getPath().endsWith(".library")) continue;
            revisedByPath.put(library.getPath(), library);
        }
        libraries = ComparisonIterators.mapIterator(referenceByName, revisedByName);
        block51: while (libraries.hasNext()) {
            switch (1.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[libraries.next().ordinal()]) {
                case 1: {
                    removed = (ClassPathModel.LibraryDescription)libraries.left().getValue();
                    if (!revisedByPath.containsKey(removed.getPath())) {
                        this.error(Change.LIBRARY_REMOVED, "library \"%s\" at %s removed", new Object[]{removed.getName(), removed.getPath(), this.uses.getLibraryUses(removed.getName())}).element(removed.getPath());
                        continue block51;
                    }
                    this.error(Change.LIBRARY_RENAMED, "library \"%s\" at %s renamed to \"%s\"", new Object[]{removed.getName(), removed.getPath(), ((ClassPathModel.LibraryDescription)revisedByPath.get(removed.getPath())).getName(), this.uses.getLibraryUses(removed.getName())}).element(removed.getPath());
                    continue block51;
                }
                case 2: {
                    reference = (ClassPathModel.LibraryDescription)libraries.left().getValue();
                    revised = (ClassPathModel.LibraryDescription)libraries.right().getValue();
                    if (reference.getPath().equals(revised.getPath())) continue block51;
                    this.warning(Change.LIBRARY_MOVED, "library \"%s\" moved from %s to %s", new Object[]{reference.getName(), reference.getPath(), revised.getPath(), this.uses.getLibraryUses(reference.getName())}).element(reference.getPath());
                    continue block51;
                }
                case 3: {
                    addedName = (String)libraries.right().getKey();
                    addedLibrary = (ClassPathModel.LibraryDescription)libraries.right().getValue();
                    if (addedName.equals(addedLibrary.getName())) {
                        this.note(Change.LIBRARY_ADDED, "library \"%s\" added at %s", new Object[]{addedName, addedLibrary.getPath(), this.uses.getLibraryUses(addedName)}).element(addedLibrary.getPath());
                        continue block51;
                    }
                    this.note(Change.LIBRARY_ALIAS_ADDED, "library alias \"%s\" (to library \"%s\") added at %s", new Object[]{addedName, addedLibrary.getName(), addedLibrary.getPath(), this.uses.getLibraryUses(addedLibrary.getName())}).element(addedLibrary.getPath());
                    continue block51;
                }
            }
            throw new IllegalStateException();
        }
        referenceByName = null;
        referenceByPath = null;
        revisedByName = null;
        revisedByPath = null;
        packages = ComparisonIterators.iterator(referenceModel.getControlledPackages(), revisedModel.getControlledPackages(), Comparator.comparing((Function<Package, PackageName>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Loracle/javatools/exports/classpath/Package;)Loracle/javatools/exports/name/PackageName;)()));
        while (packages.hasNext()) {
            packageComparison = packages.next();
            referencePackage = packages.left();
            revisedPackage = packages.right();
            switch (1.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[packageComparison.ordinal()]) {
                case 1: {
                    packageName = referencePackage.getName();
                    break;
                }
                case 2: {
                    packageName = referencePackage.getName();
                    break;
                }
                case 3: {
                    packageName = revisedPackage.getName();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            types = ComparisonIterators.iterator(referencePackage, revisedPackage, (Function<Package, Iterable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compare$6(oracle.javatools.exports.classpath.Package ), (Loracle/javatools/exports/classpath/Package;)Ljava/lang/Iterable;)(), Type.UNQUALIFIED_COMPARATOR);
            block53: while (types.hasNext()) {
                typeComparison = types.next();
                referenceType = types.left();
                revisedType = types.right();
                switch (1.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[typeComparison.ordinal()]) {
                    case 1: {
                        typeKind = referenceType.getTypeKind();
                        typeName = referenceType.getName();
                        typeAccess = referenceType.getReferenceAccess();
                        typeUses = this.uses.getTypeUses(referenceType.getName());
                        if (revisedModel.getDomain().dominates(packageName)) {
                            condition = CompatibilityAccess.isExportedOrRestricted(typeAccess) != false || typeUses != null;
                            this.errorOrNote(condition, Change.ELEMENT_REMOVED, "%s %s %s removed", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                            continue block53;
                        }
                        if (revisedModel.findType(referenceType.getName(), "comparison", referenceType.getName()) != null) {
                            this.note(Change.ELEMENT_EXCLUDED, "%s %s %s excluded by domain", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                            continue block53;
                        }
                        if (revisedModel.isRooted()) {
                            this.errorOrNote(typeUses != null, Change.ELEMENT_REMOVED, "%s %s %s removed", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                            continue block53;
                        }
                        condition = typeUses != null;
                        this.errorOrNote(condition, Change.TYPE_MAYBE_REMOVED, "%s %s %s maybe removed", new Object[]{typeAccess, typeKind, typeName, typeUses}).element(typeName);
                        continue block53;
                    }
                    case 2: {
                        typeKind = referenceType.getTypeKind();
                        typeName = referenceType.getName();
                        typeUses = this.uses.getTypeUses(referenceType.getName());
                        typeAccess = referenceType.getReferenceAccess();
                        revisedAccess = revisedType.getReferenceAccess();
                        if (CompatibilityAccess.isMoreExported(typeAccess, revisedAccess)) {
                            this.error(Change.ELEMENT_REDUCED, "%s %s %s %s", new Object[]{typeAccess, typeKind, typeName, revisedAccess, typeUses}).element(typeName);
                            break;
                        }
                        if (!CompatibilityAccess.isMoreConcealed(typeAccess, revisedAccess)) break;
                        this.note(Change.ELEMENT_EXPANDED, "%s %s %s %s", new Object[]{typeAccess, typeKind, typeName, revisedAccess}).element(typeName);
                        break;
                    }
                    case 3: {
                        typeKind = revisedType.getTypeKind();
                        typeName = revisedType.getName();
                        typeAccess = revisedType.getReferenceAccess();
                        typeUses = this.uses.getTypeUses(revisedType.getName());
                        if (referenceModel.getDomain().dominates(packageName)) {
                            this.note(Change.ELEMENT_ADDED, "%s %s %s added", new Object[]{typeAccess, typeKind, typeName}).element(typeName);
                            break;
                        }
                        this.note(Change.ELEMENT_INCLUDED, "%s %s %s added by domain %s", new Object[]{typeAccess, typeKind, typeName, revisedModel.getDomain().getSubdomain(packageName).getName()}).element(typeName);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                members = ComparisonIterators.iterator(referenceType, revisedType, (Function<Type, Iterable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$compare$7(oracle.javatools.exports.classpath.Type ), (Loracle/javatools/exports/classpath/Type;)Ljava/lang/Iterable;)(), Member.UNQUALIFIED_COMPARATOR);
                block54: while (members.hasNext()) {
                    switch (1.$SwitchMap$oracle$javatools$exports$common$ComparisonIterators$Comparison[members.next().ordinal()]) {
                        case 1: {
                            removedMember = members.left();
                            memberKind = removedMember.getKind();
                            memberName = removedMember.getName();
                            referenceMemberAccess = removedMember.getReferenceAccess();
                            memberUses = this.uses.getMemberUses(memberName);
                            if (CompatibilityAccess.isConcealedOrNull(referenceMemberAccess) && memberUses == null) continue block54;
                            switch (1.$SwitchMap$oracle$javatools$exports$name$ElementKind[removedMember.getKind().ordinal()]) {
                                case 1: {
                                    constructors = revisedType.getApplicableConstructors((ConstructorName)removedMember.getName(), removedMember.getParameterTypes());
                                    replacement = constructors.isEmpty() != false ? null : (Member)constructors.iterator().next();
                                    break;
                                }
                                case 2: {
                                    replacement = null;
                                    for (OverrideEquivalentMethod oem : revisedType.getApplicableMethods((MethodName)removedMember.getName(), removedMember.getParameterTypes())) {
                                        replacement = oem.getMethod();
                                    }
                                    break;
                                }
                                case 3: {
                                    replacement = revisedType.getDeclaredOrInheritedField(((Field)removedMember).getName());
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("unexpected label " + removedMember.getKind());
                                }
                            }
                            if (replacement == null || !replacement.isExportable()) {
                                this.error(Change.ELEMENT_REMOVED, "%s %s %s removed", new Object[]{referenceMemberAccess, memberKind, memberName, memberUses}).element(memberName);
                                continue block54;
                            }
                            revisedMemberAccess = replacement.getReferenceAccess();
                            if (!BaselineComparison.$assertionsDisabled && referenceMemberAccess == null && revisedMemberAccess == null) {
                                throw new AssertionError();
                            }
                            change = Change.MEMBER_REPLACED;
                            severity = Severity.WARNING;
                            if (CompatibilityAccess.isMoreConcealed(revisedMemberAccess, referenceMemberAccess)) {
                                change = revisedMemberAccess != null ? Change.MEMBER_REDUCED_REPLACED : Change.MEMBER_EXCLUDED_REPLACED;
                                severity = Severity.ERROR;
                            } else if (CompatibilityAccess.isMoreExported(revisedMemberAccess, referenceMemberAccess)) {
                                change = referenceMemberAccess != null ? Change.MEMBER_EXPANDED_REPLACED : Change.MEMBER_INCLUDED_REPLACED;
                            }
                            switch (1.$SwitchMap$oracle$javatools$exports$classpath$BaselineComparison$Change[change.ordinal()]) {
                                case 1: {
                                    this.warning(change, "%s %s %s removed, replaced by %s", new Object[]{referenceMemberAccess, memberKind, memberName, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                                    break;
                                }
                                case 2: 
                                case 3: {
                                    this.message(severity, change, "%s %s %s removed, replaced by %s %s", new Object[]{referenceMemberAccess, memberKind, memberName, revisedMemberAccess, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                                    break;
                                }
                                case 4: {
                                    this.message(severity, change, "%s %s %s removed, replaced by (excluded from domain) %s", new Object[]{referenceMemberAccess, memberKind, memberName, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                                    break;
                                }
                                case 5: {
                                    this.message(severity, change, "%s %s (excluded from domain) removed, replaced by %s %s", new Object[]{memberKind, memberName, revisedMemberAccess, replacement.getQualifiedSourceName(), memberUses}).element(memberName);
                                }
                            }
                            continue block54;
                        }
                        case 2: {
                            referenceMember = members.left();
                            revisedMember = members.right();
                            memberKind = referenceMember.getKind();
                            memberName = referenceMember.getName();
                            memberUses = this.uses.getMemberUses(referenceMember.getName());
                            referenceMemberAccess = referenceMember.getReferenceAccess();
                            revisedMemberAccess = revisedMember.getReferenceAccess();
                            if (referenceType != null && memberKind.isMethod()) {
                                this.checkAbstractionOfNewOrChangedMethod((Method)referenceMember, referenceType, (Method)revisedMember, revisedType, typeUses);
                            }
                            if ((CompatibilityAccess.isExportedOrRestricted(revisedMemberAccess) || memberUses != null) && CompatibilityAccess.isMoreExported(revisedMemberAccess, referenceMemberAccess)) {
                                this.note(Change.ELEMENT_EXPANDED, "%s %s %s %s", new Object[]{referenceMemberAccess, memberKind, memberName, revisedMemberAccess}).element(memberName);
                            }
                            if (CompatibilityAccess.isConcealedOrNull(referenceMemberAccess) && memberUses == null) continue block54;
                            if (CompatibilityAccess.isMoreConcealed(revisedMemberAccess, referenceMemberAccess)) {
                                this.error(Change.ELEMENT_REDUCED, "%s %s %s %s", new Object[]{referenceMemberAccess, memberKind, memberName, revisedMemberAccess, memberUses}).element(memberName);
                            }
                            switch (1.$SwitchMap$oracle$javatools$exports$name$ElementKind[referenceMember.getKind().ordinal()]) {
                                case 3: {
                                    referenceField = (Field)referenceMember;
                                    revisedField = (Field)revisedMember;
                                    referenceConstantValue = referenceField.getConstantValue();
                                    revisedConstantValue = revisedField.getConstantValue();
                                    if (Objects.equals(referenceConstantValue, revisedConstantValue)) ** GOTO lbl262
                                    if (!referenceField.isConstant() || !revisedField.isConstant()) ** GOTO lbl256
                                    this.note(Change.FIELD_CHANGED, "%s %s %s constant value changed to %s", new Object[]{referenceMemberAccess, memberKind, memberName, this.image(revisedConstantValue), memberUses}).element(memberName);
                                    ** GOTO lbl262
lbl256:
                                    // 1 sources

                                    if (referenceField.isConstant()) {
                                        this.note(Change.FIELD_CHANGED, "%s %s %s no longer constant", new Object[]{referenceMemberAccess, memberKind, memberName, memberUses}).element(memberName);
                                    } else {
                                        this.note(Change.FIELD_CHANGED, "%s %s %s newly constant", new Object[]{referenceMemberAccess, memberKind, memberName, memberUses}).element(memberName);
                                    }
                                }
lbl262:
                                // 5 sources

                                case 2: {
                                    if (!referenceMember.isFinal() && revisedMember.isFinal()) {
                                        this.error(Change.MEMBER_FINAL_ADDED, "%s %s %s final modifier added", new Object[]{referenceMemberAccess, referenceMember.getKind(), memberName, memberUses}).element(memberName);
                                    }
                                    if (referenceMember.isStatic() != revisedMember.isStatic()) {
                                        if (referenceMember.isStatic()) {
                                            this.error(Change.MEMBER_STATIC_REMOVED, "%s %s %s static modifier removed", new Object[]{referenceMemberAccess, referenceMember.getKind(), memberName, memberUses}).element(memberName);
                                        } else {
                                            this.error(Change.MEMBER_STATIC_ADDED, "%s %s %s static modifier added", new Object[]{referenceMemberAccess, referenceMember.getKind(), memberName, memberUses}).element(memberName);
                                        }
                                    }
                                    leftType = referenceMember.getMemberType();
                                    rightType = revisedMember.getMemberType();
                                    if (leftType != null) {
                                        revisedLeftType = revisedModel.findType(leftType.getName(), "member type", revisedMember.getName());
                                        if (revisedLeftType.isUnresolved()) {
                                            if (leftType.isInnerStatic() && rightType.isInnerStatic() && leftType.getSimpleName().equals(rightType.getSimpleName()) && !(revisedOuterType = revisedModel.findType(leftType.getOuterType().getName(), "outer member type", revisedMember.getName())).isUnresolved() && Conversions.isWideningReferenceConversion(revisedOuterType, rightType.getOuterType())) {
                                                this.warning(Change.MEMBER_TYPE_MOVED, "%s %s %s type moved from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(memberName);
                                                break;
                                            }
                                        } else {
                                            leftType = revisedLeftType;
                                        }
                                    }
                                    if (Objects.equals(leftType, rightType)) break;
                                    if (leftType == null) {
                                        this.note(Change.MEMBER_UNVOIDED, "%s %s %s type changed from void to %s", new Object[]{referenceMemberAccess, memberKind, memberName, rightType.getName(), memberUses}).element(typeName);
                                        break;
                                    }
                                    if (rightType == null) {
                                        this.error(Change.MEMBER_VOIDED, "%s %s %s type changed from %s to void", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), memberUses}).element(typeName);
                                        break;
                                    }
                                    if (Conversions.isWideningPrimitiveConversion(leftType, rightType) || Conversions.isWideningReferenceConversion(leftType, rightType)) {
                                        this.error(Change.MEMBER_WIDENED, "%s %s %s type widened from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(typeName);
                                        break;
                                    }
                                    if (Conversions.isWideningPrimitiveConversion(rightType, leftType) || Conversions.isWideningReferenceConversion(rightType, leftType)) {
                                        this.warning(Change.MEMBER_NARROWED, "%s %s %s type narrowed from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(typeName);
                                        break;
                                    }
                                    if (Conversions.isBoxingConversion(leftType, rightType)) {
                                        this.error(Change.MEMBER_BOXED, "%s %s %s boxed to %s", new Object[]{referenceMemberAccess, memberKind, memberName, rightType.getName(), memberUses}).element(memberName);
                                        break;
                                    }
                                    if (Conversions.isUnboxingConversion(leftType, rightType)) {
                                        this.note(Change.MEMBER_UNBOXED, "%s %s %s unboxed to %s", new Object[]{referenceMemberAccess, memberKind, memberName, rightType.getName(), memberUses}).element(memberName);
                                        break;
                                    }
                                    this.error(Change.MEMBER_RETYPED, "%s %s %s type changed from %s to %s", new Object[]{referenceMemberAccess, memberKind, memberName, leftType.getName(), rightType.getName(), memberUses}).element(typeName);
                                }
                            }
                            continue block54;
                        }
                        case 3: {
                            addedMember = members.right();
                            memberName = addedMember.getName();
                            referenceMemberAccess = addedMember.getReferenceAccess();
                            memberKind = addedMember.getKind();
                            if (referenceType != null && memberKind.isMethod()) {
                                this.checkAbstractionOfNewOrChangedMethod(null, referenceType, (Method)addedMember, revisedType, typeUses);
                            }
                            if (!CompatibilityAccess.isExportedOrRestricted(referenceMemberAccess)) continue block54;
                            this.note(Change.ELEMENT_ADDED, "%s %s %s added", new Object[]{referenceMemberAccess, memberKind, memberName}).element(memberName);
                            continue block54;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
        }
        this.sort(this.errors);
        this.sort(this.warnings);
        this.sort(this.notes);
        this.sort(this.matchedApprovals);
    }

    public static int[] difference(ClassPathModel referenceModel, ClassPathModel revisedModel, UsesModel uses, BufferedWriter writer) throws IOException {
        class Writer {
            final BufferedWriter writer;
            final char direction;
            int count = 0;

            Writer(BufferedWriter writer, char direction) {
                this.writer = writer;
                this.direction = direction;
            }

            void accept(String kind, String name) throws IOException {
                this.accept(this.direction, kind, name);
            }

            void accept(char direction, String kind, String name) throws IOException {
                this.writer.write(direction);
                this.writer.write(32);
                this.writer.write(kind);
                this.writer.write(32);
                this.writer.write(name);
                this.writer.newLine();
                ++this.count;
            }

            int count() {
                return this.count;
            }
        }
        Writer added = new Writer(writer, '+');
        Writer removed = new Writer(writer, '-');
        ExportDomain removedSubdomains = new ExportDomain(new String[0]);
        ComparisonIterators.ComparisonIterator<ExportDomain.Subdomain> domains = ComparisonIterators.iterator(referenceModel.getDomain().getSubdomains(), revisedModel.getDomain().getSubdomains(), Comparator.comparing(ExportDomain.Subdomain::getName));
        block35: while (domains.hasNext()) {
            switch (domains.next()) {
                case LESS_THAN: {
                    ExportDomain.Subdomain removedSubdomain = domains.left();
                    removedSubdomains.addSubdomain(removedSubdomain);
                    String removedName = removedSubdomain.getName();
                    removed.accept("domain", removedName);
                    continue block35;
                }
                case EQUAL: {
                    String string = domains.left().getName();
                    String[] exceptions = ComparisonIterators.iterator(domains.left().getExceptions(), domains.right().getExceptions());
                    block36: while (exceptions.hasNext()) {
                        switch (exceptions.next()) {
                            case LESS_THAN: {
                                String removedException = ((String)exceptions.left()).substring(string.length() + 1);
                                removed.accept('<', "domain", string + "[" + removedException + "]");
                                continue block36;
                            }
                            case EQUAL: {
                                continue block36;
                            }
                            case GREATER_THAN: {
                                String addedException = ((String)exceptions.right()).substring(string.length() + 1);
                                added.accept('>', "domain", string + "[" + addedException + "]");
                                continue block36;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    continue block35;
                }
                case GREATER_THAN: {
                    String addedName = domains.right().getName();
                    added.accept("domain", addedName);
                    continue block35;
                }
            }
            throw new IllegalStateException();
        }
        TreeMap<String, ClassPathModel.LibraryDescription> referenceByName = new TreeMap<String, ClassPathModel.LibraryDescription>();
        for (ClassPathModel.LibraryDescription libraryDescription : referenceModel.getLibraries()) {
            referenceByName.put(libraryDescription.getName(), libraryDescription);
            for (String name : libraryDescription.getAliases()) {
                referenceByName.put(name, libraryDescription);
            }
        }
        TreeMap<String, ClassPathModel.LibraryDescription> revisedByName = new TreeMap<String, ClassPathModel.LibraryDescription>();
        for (ClassPathModel.LibraryDescription library : revisedModel.getLibraries()) {
            revisedByName.put(library.getName(), library);
            for (String name : library.getAliases()) {
                revisedByName.put(name, library);
            }
        }
        ComparisonIterators.MapComparisonIterator mapComparisonIterator = ComparisonIterators.mapIterator(referenceByName, revisedByName);
        block41: while (mapComparisonIterator.hasNext()) {
            switch (mapComparisonIterator.next()) {
                case LESS_THAN: {
                    String removedName = (String)mapComparisonIterator.left().getKey();
                    ClassPathModel.LibraryDescription removedLibrary = (ClassPathModel.LibraryDescription)mapComparisonIterator.left().getValue();
                    removed.accept(removedName.equals(removedLibrary.getName()) ? "library" : "alias", removedName);
                    continue block41;
                }
                case EQUAL: {
                    continue block41;
                }
                case GREATER_THAN: {
                    String addedName = (String)mapComparisonIterator.right().getKey();
                    ClassPathModel.LibraryDescription addedLibrary = (ClassPathModel.LibraryDescription)mapComparisonIterator.right().getValue();
                    added.accept(addedName.equals(addedLibrary.getName()) ? "library" : "alias", addedName);
                    continue block41;
                }
            }
            throw new IllegalStateException();
        }
        revisedByName = null;
        referenceByName = null;
        ComparisonIterators.ComparisonIterator<Package> packages = ComparisonIterators.iterator(referenceModel.getControlledPackages(), revisedModel.getControlledPackages(), Comparator.comparing(Package::getName));
        while (packages.hasNext()) {
            ComparisonIterators.Comparison packageComparison = packages.next();
            Package referencePackage = packages.left();
            Package revisedPackage = packages.right();
            switch (packageComparison) {
                case LESS_THAN: {
                    break;
                }
                case EQUAL: {
                    break;
                }
                case GREATER_THAN: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ComparisonIterators.ComparisonIterator<Type> types = ComparisonIterators.iterator(referencePackage, revisedPackage, p -> p != null ? p.getExportableControlledTypes() : null, Type.UNQUALIFIED_COMPARATOR);
            block43: while (types.hasNext()) {
                ComparisonIterators.Comparison typeComparison = types.next();
                Type referenceType = types.left();
                Type revisedType = types.right();
                switch (typeComparison) {
                    case LESS_THAN: {
                        TypeName typeName = referenceType.getName();
                        CompatibilityAccess typeAccess = referenceType.getReferenceAccess();
                        TypeUses typeUses = uses.getTypeUses(referenceType.getName());
                        if (CompatibilityAccess.isExportedOrRestricted(typeAccess)) {
                            removed.accept(typeAccess.toLowerCase(), typeName.toString());
                            continue block43;
                        }
                        if (typeUses == null) continue block43;
                        removed.accept("used", typeName.toString());
                        continue block43;
                    }
                    case EQUAL: {
                        TypeName typeName = referenceType.getName();
                        CompatibilityAccess typeAccess = referenceType.getReferenceAccess();
                        CompatibilityAccess revisedAccess = revisedType.getReferenceAccess();
                        if (CompatibilityAccess.isMoreExported(typeAccess, revisedAccess)) {
                            removed.accept('<', CompatibilityAccess.toLowerCase(revisedAccess, "(excluded from domain)"), typeName.toString());
                            break;
                        }
                        if (!CompatibilityAccess.isMoreConcealed(typeAccess, revisedAccess)) break;
                        added.accept('>', revisedAccess.toLowerCase(), typeName.toString());
                        break;
                    }
                    case GREATER_THAN: {
                        TypeName typeName = revisedType.getName();
                        CompatibilityAccess typeAccess = revisedType.getReferenceAccess();
                        if (!CompatibilityAccess.isExportedOrRestricted(typeAccess)) break;
                        added.accept(typeAccess.toLowerCase(), typeName.toString());
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                ComparisonIterators.ComparisonIterator<Member> members = ComparisonIterators.iterator(referenceType, revisedType, t -> t != null ? t.getDeclaredMembers() : null, Member.UNQUALIFIED_COMPARATOR);
                block44: while (members.hasNext()) {
                    switch (members.next()) {
                        case LESS_THAN: {
                            Member replacement;
                            Member removedMember = members.left();
                            MemberName memberName = removedMember.getName();
                            CompatibilityAccess memberAccess = removedMember.getReferenceAccess();
                            MemberUses memberUses = uses.getMemberUses(memberName);
                            if (CompatibilityAccess.isConcealedOrNull(memberAccess) && memberUses == null) continue block44;
                            switch (removedMember.getKind()) {
                                case CONSTRUCTOR: {
                                    Collection<Constructor> constructors = revisedType.getApplicableConstructors((ConstructorName)removedMember.getName(), removedMember.getParameterTypes());
                                    replacement = constructors.isEmpty() ? null : (Member)constructors.iterator().next();
                                    break;
                                }
                                case METHOD: {
                                    replacement = null;
                                    CompatibilityAccess access = null;
                                    for (OverrideEquivalentMethod oem : revisedType.getApplicableMethods((MethodName)removedMember.getName(), removedMember.getParameterTypes())) {
                                        if (!CompatibilityAccess.isMoreExported(oem.getMethod().getReferenceAccess(), access)) continue;
                                        replacement = oem.getMethod();
                                        access = replacement.getReferenceAccess();
                                    }
                                    break;
                                }
                                case FIELD: {
                                    replacement = revisedType.getDeclaredOrInheritedField(((Field)removedMember).getName());
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("unexpected label " + removedMember.getKind());
                                }
                            }
                            assert (CompatibilityAccess.isExportedOrRestricted(memberAccess) || memberUses != null);
                            if (replacement == null) {
                                removed.accept(CompatibilityAccess.isExportedOrRestricted(memberAccess) ? memberAccess.toLowerCase() : "used", memberName.toString());
                                continue block44;
                            }
                            CompatibilityAccess revisedAccess = replacement.getReferenceAccess();
                            if (CompatibilityAccess.isMoreConcealed(revisedAccess, memberAccess)) {
                                removed.accept('<', CompatibilityAccess.toLowerCase(revisedAccess, "(excluded from domain)"), memberName.toString());
                                continue block44;
                            }
                            if (!CompatibilityAccess.isMoreExported(revisedAccess, memberAccess)) continue block44;
                            added.accept('>', revisedAccess.toLowerCase(), memberName.toString());
                            continue block44;
                        }
                        case EQUAL: {
                            Member referenceMember = members.left();
                            Member revisedMember = members.right();
                            MemberName memberName = referenceMember.getName();
                            MemberUses memberUses = uses.getMemberUses(referenceMember.getName());
                            CompatibilityAccess referenceMemberAccess = referenceMember.getReferenceAccess();
                            CompatibilityAccess revisedMemberAccess = revisedMember.getReferenceAccess();
                            if ((CompatibilityAccess.isExportedOrRestricted(revisedMemberAccess) || memberUses != null) && CompatibilityAccess.isMoreExported(revisedMemberAccess, referenceMemberAccess)) {
                                added.accept('>', CompatibilityAccess.toLowerCase(revisedMemberAccess), memberName.toString());
                            }
                            if (CompatibilityAccess.isConcealedOrNull(referenceMemberAccess) && memberUses == null) continue block44;
                            if (CompatibilityAccess.isMoreConcealed(revisedMemberAccess, referenceMemberAccess)) {
                                removed.accept('<', CompatibilityAccess.toLowerCase(revisedMemberAccess, "(excluded from domain)"), memberName.toString());
                            }
                            if (referenceMember.getKind().isConstructor()) continue block44;
                            if (referenceMember.isFinal() != revisedMember.isFinal()) {
                                if (referenceMember.isFinal()) {
                                    removed.accept('<', "final", memberName.toString());
                                } else {
                                    added.accept('>', "final", memberName.toString());
                                }
                            }
                            if (referenceMember.isStatic() == revisedMember.isStatic()) continue block44;
                            if (referenceMember.isStatic()) {
                                removed.accept('<', "static", memberName.toString());
                                continue block44;
                            }
                            added.accept('>', "static", memberName.toString());
                            continue block44;
                        }
                        case GREATER_THAN: {
                            Member addedMember = members.right();
                            MemberName memberName = addedMember.getName();
                            CompatibilityAccess memberAccess = addedMember.getReferenceAccess();
                            if (!CompatibilityAccess.isExportedOrRestricted(memberAccess)) continue block44;
                            added.accept(memberAccess.toLowerCase(), memberName.toString());
                            continue block44;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return new int[]{added.count(), removed.count()};
    }

    protected void checkAbstractionOfNewOrChangedMethod(Method referenceMethod, Type referenceType, Method revisedMethod, Type revisedType, TypeUses typeUses) {
        boolean concreteUses;
        OverrideEquivalentMethod methods;
        MethodName methodName = revisedMethod.getName();
        if (referenceMethod != null && referenceMethod.isAbstract()) {
            return;
        }
        if (!revisedMethod.isAbstract()) {
            return;
        }
        if (referenceMethod == null && (methods = referenceType.getDeclaredOrInheritedMethod(methodName)).isAbstract()) {
            return;
        }
        ExtensionUses extensionUses = new ExtensionUses(typeUses);
        HashSet<Type> visited = new HashSet<Type>();
        visited.add(revisedType);
        for (Type extendingType : revisedType.getExtendingTypes()) {
            this.searchExtendingTypesForExtensionUses(extendingType, methodName, extensionUses, visited);
        }
        if (extensionUses.getConcrete() > 0) {
            concreteUses = true;
        } else if (extensionUses.getExtensions() > 0) {
            concreteUses = false;
        } else if (CompatibilityAccess.isExportedOrRestricted(CompatibilityAccess.mostConcealed(referenceType.getExtensionAccess(), revisedType.getExtensionAccess()))) {
            concreteUses = false;
            extensionUses = null;
        } else {
            return;
        }
        if (referenceMethod == null) {
            this.errorOrWarning(concreteUses, Change.METHOD_UNIMPLEMENTED, "%s %s %s added with no implementation", new Object[]{revisedMethod.getReferenceAccess(), ElementKind.METHOD, methodName, extensionUses}).element(methodName);
        } else {
            this.errorOrWarning(concreteUses, Change.METHOD_ABSTRACTED, "%s %s %s implementation removed", new Object[]{referenceMethod.getReferenceAccess(), ElementKind.METHOD, methodName, extensionUses}).element(methodName);
        }
    }

    private void searchExtendingTypesForExtensionUses(Type type, MethodName methodName, ExtensionUses extensionUses, Set<Type> visited) {
        if (!visited.add(type)) {
            return;
        }
        OverrideEquivalentMethod inheritedMethods = type.getDeclaredOrInheritedMethod(methodName);
        if (!inheritedMethods.isAbstract()) {
            return;
        }
        TypeUses typeUses = this.uses.getTypeUses(type.getName());
        extensionUses.addUses(type.getName(), typeUses);
        for (Type extendingType : type.getExtendingTypes()) {
            this.searchExtendingTypesForExtensionUses(extendingType, methodName, extensionUses, visited);
        }
    }

    private String image(Object constantValue) {
        if (constantValue == null) {
            return "null";
        }
        if (constantValue instanceof Character) {
            return BaselineReaderWriter.encode(constantValue.toString(), '\'');
        }
        if (constantValue instanceof String) {
            return BaselineReaderWriter.encode((String)constantValue, '\"');
        }
        return constantValue.toString();
    }

    private Message message(Severity severity, Change type, String format, Object ... arguments) {
        return this.message(type, true, severity, Severity.NOTE, format, arguments);
    }

    private Message error(Change type, String format, Object ... arguments) {
        return this.message(type, true, Severity.ERROR, Severity.NOTE, format, arguments);
    }

    private Message errorOrNote(boolean condition, Change type, String format, Object ... arguments) {
        return this.message(type, condition, Severity.ERROR, Severity.NOTE, format, arguments);
    }

    private Message errorOrWarning(boolean condition, Change type, String format, Object ... arguments) {
        return this.message(type, condition, Severity.ERROR, Severity.WARNING, format, arguments);
    }

    private Message warning(Change type, String format, Object ... arguments) {
        return this.message(type, true, Severity.WARNING, Severity.NOTE, format, arguments);
    }

    private Message note(Change type, String format, Object ... arguments) {
        return this.message(type, true, Severity.NOTE, Severity.NOTE, format, arguments);
    }

    private Message message(Change change, boolean condition, Severity severityTrue, Severity severityFalse, String format, Object ... arguments) {
        String matchId;
        Object access1 = "";
        Object access2 = "";
        Object label = "";
        boolean used = false;
        for (int i = 0; i < arguments.length; ++i) {
            String image;
            Object argument = arguments[i];
            if (argument instanceof TypeOrMemberUses || argument instanceof ExtensionUses || argument instanceof LibraryUses) {
                used = true;
                continue;
            }
            if (argument instanceof ElementKind) {
                if (!((String)label).isEmpty()) continue;
                image = ((ElementKind)((Object)argument)).toLowerCase();
                label = "-" + image;
                arguments[i] = image;
                continue;
            }
            if (argument instanceof TypeKind) {
                if (!((String)label).isEmpty()) continue;
                image = ((TypeKind)((Object)argument)).toLowerCase();
                label = "-" + image;
                arguments[i] = image;
                continue;
            }
            if (!(argument instanceof CompatibilityAccess)) continue;
            if (((String)access1).isEmpty()) {
                access1 = "-" + CompatibilityAccess.toLowerCase((CompatibilityAccess)((Object)argument));
                continue;
            }
            if (!((String)access2).isEmpty()) continue;
            access2 = "-" + CompatibilityAccess.toLowerCase((CompatibilityAccess)((Object)argument));
        }
        StringBuilder idBuilder = new StringBuilder("baseline");
        boolean accessed = false;
        int usedIndex = 0;
        for (Object generator : change.generators) {
            if (generator.equals("?used")) {
                if (!used) continue;
                usedIndex = idBuilder.length();
                idBuilder.append("-used");
                continue;
            }
            if (generator == CompatibilityAccess.class) {
                idBuilder.append((String)(accessed ? access2 : access1));
                accessed = true;
                continue;
            }
            if (generator.getClass().isArray()) {
                idBuilder.append((String)label);
                continue;
            }
            idBuilder.append('-').append(generator);
        }
        String id = idBuilder.toString();
        String string = matchId = used ? id.substring(0, usedIndex) + id.substring(usedIndex + 5) : id;
        if (used) {
            format = (String)format + ": %s";
        }
        Message message = this.log.message(condition ? severityTrue : severityFalse, id, (String)format, arguments);
        String matchText = null;
        boolean matched = false;
        if (!this.approvals.isEmpty() && this.approvals.valuesSize(matchId) > 0) {
            matchText = message.getMessage();
            if (used) {
                this.USES_MATCHER.reset(matchText);
                if (this.USES_MATCHER.find()) {
                    matchText = matchText.substring(0, this.USES_MATCHER.start());
                }
            }
            matched = this.approvals.contains(matchId, matchText);
        }
        if (matched) {
            this.matchedApprovals.add(message);
            this.unmatchedApprovals.removeValue(matchId, matchText);
        } else {
            switch (message.getSeverity()) {
                case ERROR: {
                    this.errors.add(message);
                    if (!used) break;
                    ++this.errorsWithUsesCount;
                    break;
                }
                case WARNING: {
                    this.warnings.add(message);
                    break;
                }
                case NOTE: {
                    this.notes.add(message);
                }
            }
        }
        return message;
    }

    protected void sort(List<Message> list) {
        list.sort((l, r) -> {
            Object lo = l.getValue("element", Object.class);
            String ls = lo instanceof ElementName ? ((ElementName)lo).getQualifiedSourceName() : (lo instanceof Path ? Paths.toString((Path)lo) : String.valueOf(lo));
            Object ro = r.getValue("element", Object.class);
            String rs = ro instanceof ElementName ? ((ElementName)ro).getQualifiedSourceName() : (ro instanceof Path ? Paths.toString((Path)ro) : String.valueOf(ro));
            return ls.compareTo(rs);
        });
    }

    private static String format(String id, String message) {
        StringBuilder builder = new StringBuilder(id).append(": ");
        int i = "baseline-used-exported-constructor-restricted: ".length() - builder.length();
        while (--i > 0) {
            builder.append(' ');
        }
        builder.append(message);
        return builder.toString();
    }

    private static /* synthetic */ Iterable lambda$compare$7(Type t) {
        return t != null ? t.getDeclaredMembers() : null;
    }

    private static /* synthetic */ Iterable lambda$compare$6(Package p) {
        return p != null ? p.getExportableControlledTypes() : null;
    }

    public static enum Change {
        DOMAIN_ADDED(1, true, c -> true, "domain-added"),
        DOMAIN_REMOVED(1, false, c -> true, "domain-removed"),
        DOMAIN_EXCEPT_ADDED(1, true, c -> true, "domain-except-added"),
        DOMAIN_EXCEPT_REMOVED(1, false, c -> true, "domain-except-removed"),
        LIBRARY_ADDED(1, true, c -> true, "?used", "library-added"),
        LIBRARY_ALIAS_ADDED(1, true, c -> true, "?used", "library-alias-added"),
        LIBRARY_REMOVED(1, false, c -> true, "?used", "library-removed"),
        LIBRARY_RENAMED(1, false, c -> true, "?used", "library-renamed"),
        LIBRARY_MOVED(1, false, c -> true, "?used", "library-moved"),
        LIBRARY_CHANGED(1, false, c -> true, "?used", "library-changed"),
        ELEMENT_ADDED(2, true, c -> true, "?used", CompatibilityAccess.class, ELEMENT_KINDS, "added"),
        ELEMENT_REMOVED(2, false, c -> true, "?used", CompatibilityAccess.class, ELEMENT_KINDS, "removed"),
        ELEMENT_EXCLUDED(2, true, c -> true, "?used", CompatibilityAccess.class, ELEMENT_KINDS, "excluded"),
        ELEMENT_EXPANDED(2, true, Change::lt, "?used", CompatibilityAccess.class, ELEMENT_KINDS, CompatibilityAccess.class),
        ELEMENT_INCLUDED(2, false, c -> true, "?used", CompatibilityAccess.class, ELEMENT_KINDS, "included"),
        TYPE_MAYBE_REMOVED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, TYPE_KINDS, "maybe"}),
        ELEMENT_REDUCED(2, false, Change::gt, "?used", CompatibilityAccess.class, ELEMENT_KINDS, CompatibilityAccess.class),
        MEMBER_TYPE_MOVED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "type-moved"}),
        MEMBER_REPLACED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "replaced"}),
        MEMBER_EXPANDED_REPLACED(2, true, Change::lt, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "replaced", CompatibilityAccess.class}),
        MEMBER_REDUCED_REPLACED(2, true, Change::gt, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "replaced", CompatibilityAccess.class}),
        MEMBER_EXCLUDED_REPLACED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "replaced", "excluded"}),
        MEMBER_INCLUDED_REPLACED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "replaced", "included"}),
        TYPE_REPLACED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, TYPE_KINDS, "replaced"}),
        METHOD_ABSTRACTED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, METHOD_KINDS, "abstracted"}),
        METHOD_UNIMPLEMENTED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, METHOD_KINDS, "unimplemented"}),
        MEMBER_BOXED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "boxed"}),
        MEMBER_UNBOXED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "unboxed"}),
        MEMBER_WIDENED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "widened"}),
        MEMBER_NARROWED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "narrowed"}),
        MEMBER_VOIDED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "voided"}),
        MEMBER_UNVOIDED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "unvoided"}),
        FIELD_CHANGED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, FIELD_KINDS, "changed"}),
        MEMBER_RETYPED(2, true, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "retyped"}),
        MEMBER_FINAL_ADDED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "final-added"}),
        MEMBER_STATIC_ADDED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "static-added"}),
        MEMBER_STATIC_REMOVED(2, false, c -> true, new Object[]{"?used", CompatibilityAccess.class, MEMBER_KINDS, "static-removed"}),
        CHANGE_RETRACTED(0, false, c -> true, "change-retracted"),
        APPROVAL_INVALID(0, false, c -> true, "approval-invalid");

        private final int nameIndex;
        private final boolean expandsAccess;
        private final Object[] generators;

        private Change(int element, boolean expandsAccess, PermutationFilter permutationFilter, Object ... idGenerators) {
            this.nameIndex = element;
            this.expandsAccess = expandsAccess;
            this.generators = idGenerators;
            Change.branch(idGenerators, 0, new Object[idGenerators.length], 0, permutationFilter, this);
        }

        private static boolean lt(Object ... values) {
            ArrayList<CompatibilityAccess> access = new ArrayList<CompatibilityAccess>(2);
            for (Object value : values) {
                if (!(value instanceof CompatibilityAccess)) continue;
                access.add((CompatibilityAccess)((Object)value));
            }
            return CompatibilityAccess.isMoreConcealed((CompatibilityAccess)((Object)access.get(0)), (CompatibilityAccess)((Object)access.get(1)));
        }

        private static boolean gt(Object ... values) {
            ArrayList<CompatibilityAccess> access = new ArrayList<CompatibilityAccess>(2);
            for (Object value : values) {
                if (!(value instanceof CompatibilityAccess)) continue;
                access.add((CompatibilityAccess)((Object)value));
            }
            return CompatibilityAccess.isMoreExported((CompatibilityAccess)((Object)access.get(0)), (CompatibilityAccess)((Object)access.get(1)));
        }

        private static void branch(Object[] idGenerators, int index, Object[] values, int vi, PermutationFilter filter, Change change) {
            if (index < idGenerators.length) {
                Object generator;
                if ((generator = idGenerators[index++]) instanceof Class) {
                    for (Enum value : (Enum[])((Class)generator).getEnumConstants()) {
                        values[vi] = value;
                        Change.branch(idGenerators, index, values, vi + 1, filter, change);
                    }
                } else if (generator.getClass().isArray()) {
                    Object[] objectArray = (Object[])generator;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object value;
                        values[vi] = value = objectArray[i];
                        Change.branch(idGenerators, index, values, vi + 1, filter, change);
                    }
                } else {
                    String string = generator.toString();
                    if (string.charAt(0) == '?') {
                        Change.branch(idGenerators, index, values, vi, filter, change);
                        values[vi] = string.substring(1);
                    } else {
                        values[vi] = string;
                    }
                    Change.branch(idGenerators, index, values, vi + 1, filter, change);
                }
            } else if (filter.accept(values)) {
                StringBuilder builder = new StringBuilder("baseline");
                for (int i = 0; i < vi; ++i) {
                    Object value = values[i];
                    if (value instanceof Enum) {
                        value = value.toString().toLowerCase();
                    }
                    builder.append('-').append(value);
                }
                ID_TO_CHANGE.put(builder.toString(), change);
            }
        }

        public int getNameIndex() {
            return this.nameIndex;
        }

        public boolean isExpandsAccess() {
            return this.expandsAccess;
        }

        public static Change getChange(String id) {
            return ID_TO_CHANGE.get(id);
        }

        private static interface PermutationFilter {
            public boolean accept(Object ... var1);
        }
    }

    private static class ExtensionUses {
        private final Map<TypeName, TypeUses> uses = new LinkedHashMap<TypeName, TypeUses>();
        private int directExtensions;
        private int directConcrete;
        private int extensions;
        private int concrete;

        ExtensionUses(TypeUses uses) {
            if (uses != null) {
                short s = uses.getExtensions();
                this.directExtensions = s;
                this.extensions = s;
                short s2 = uses.getConcrete();
                this.directConcrete = s2;
                this.concrete = s2;
            }
        }

        void addUses(TypeName name, TypeUses uses) {
            if (uses == null) {
                return;
            }
            short extensions = uses.getExtensions();
            if (extensions == 0) {
                return;
            }
            this.extensions += extensions;
            this.concrete += uses.getConcrete();
            this.uses.put(name, uses);
        }

        int getExtensions() {
            return this.extensions;
        }

        int getConcrete() {
            return this.concrete;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getExtensions());
            builder.append(" extension");
            if (this.getExtensions() != 1) {
                builder.append('s');
            }
            if (this.getExtensions() > 0) {
                builder.append(" (");
                builder.append(this.getConcrete());
                builder.append(" concrete)");
            }
            if (this.directExtensions < this.extensions) {
                builder.append(": ");
                if (this.directExtensions > 0) {
                    builder.append("direct ");
                    builder.append(this.directExtensions);
                    builder.append(" (");
                    builder.append(this.directConcrete);
                    builder.append("), ");
                }
                for (Map.Entry<TypeName, TypeUses> entry : this.uses.entrySet()) {
                    short extensions = entry.getValue().getExtensions();
                    if (extensions == 0) continue;
                    builder.append(entry.getKey());
                    builder.append(", ");
                    builder.append(extensions);
                    builder.append(" (").append(entry.getValue().getConcrete()).append("), ");
                }
                builder.setLength(builder.length() - 2);
                builder.append(')');
            }
            return builder.toString();
        }
    }

    private static class ChangeIterator
    implements Iterator<String> {
        private final Iterator<Message> iterator;
        private final Predicate<Message> filter;
        private String next;

        public ChangeIterator(List<Message> changes) {
            this(changes, m -> true);
        }

        public ChangeIterator(List<Message> changes, Predicate<Message> filter) {
            this.iterator = changes.iterator();
            this.filter = filter;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            String result = this.next;
            this.next = null;
            this.advance();
            return result;
        }

        private void advance() {
            assert (this.next == null);
            while (this.iterator.hasNext()) {
                Message message = this.iterator.next();
                if (!this.filter.test(message)) continue;
                this.next = BaselineComparison.format(message.getId(), message.getMessage());
                break;
            }
        }
    }
}

