/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.model;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.jdv.ddl.Quoting;
import oracle.dbtools.jdv.ddl.SQLProcessor;
import oracle.dbtools.jdv.model.JDVConstants;
import oracle.dbtools.jdv.model.JDVObject;

public class JDVElement
extends JDVObject
implements JDVConstants,
PropertiesObject.PropsVarsSynch {
    private String view_owner = null;
    private String view_name = null;
    private String table_owner = null;
    private String table_name = null;
    private String allow_insert = null;
    private String allow_update = null;
    private String allow_delete = null;
    private String read_only = null;
    private String has_flex_col = null;
    private String root_table = null;
    private String table_number = null;
    private String parent_table_number = null;
    private String relationship = null;
    private String column_name = null;
    private String data_type = null;
    private String length = null;
    private String json_key_name = null;
    private String is_flex_col = null;
    private String primary_key_pos = null;
    private String etag_pos = null;
    private String linkType = null;
    private String pkColumns = null;
    private String pkName = null;
    private String fkColumns = null;
    private String fkName = null;
    private String other_fkColumns = null;
    private String other_fkName = null;
    private String objectType = "table";
    private String nested = null;
    private String unnested = null;
    private String check = null;
    private String nestedKey = null;
    private String commentInRDBMS = null;
    private String tableFilter = null;
    private boolean gqlTablefilter = false;
    private String conflictResolutionOnFlex = null;
    private List<JDVElement> elements = null;
    static final String ELEMENTS = "elements";
    private Table table = null;
    private transient int tableId = -1;
    private int parseFrom = 0;
    private int parseTo = 0;
    private boolean rootTable = false;
    private String required = null;
    private String linkJoinType = null;
    private String jsonSchema = null;
    private String description = null;
    private String allOf = null;
    private String tableAlias = null;
    private boolean generatedOnNull = false;
    private SQLProcessor.Condition condition = null;

    @Override
    public void initPropsList() {
        this.propsList.add("OBJECT_TYPE");
        this.propsList.add("VIEW_OWNER");
        this.propsList.add("VIEW_NAME");
        this.propsList.add("TABLE_OWNER");
        this.propsList.add("TABLE_NAME");
        this.propsList.add("COLUMN_NAME");
        this.propsList.add("ALLOW_INSERT");
        this.propsList.add("ALLOW_UPDATE");
        this.propsList.add("ALLOW_DELETE");
        this.propsList.add("READ_ONLY");
        this.propsList.add("HAS_FLEX_COL");
        this.propsList.add("ROOT_TABLE");
        this.propsList.add("TABLE_NUMBER");
        this.propsList.add("PARENT_TABLE_NUMBER");
        this.propsList.add("RELATIONSHIP");
        this.propsList.add("DATA_TYPE");
        this.propsList.add("LENGTH");
        this.propsList.add("JSON_KEY_NAME");
        this.propsList.add("IS_FLEX_COL");
        this.propsList.add("PRIMARY_KEY_POS");
        this.propsList.add("ETAG_POS");
        this.propsList.add("LINKTYPE");
        this.propsList.add("PKCOLUMNS");
        this.propsList.add("PKNAME");
        this.propsList.add("FKCOLUMNS");
        this.propsList.add("FKNAME");
        this.propsList.add("OTHER_FKCOLUMNS");
        this.propsList.add("OTHER_FKNAME");
        this.propsList.add("NESTED");
        this.propsList.add("UNNESTED");
        this.propsList.add("NESTEDKEY");
        this.propsList.add("CHECK");
        this.propsList.add("conflictResolutionOnFlex");
        this.propsList.add("tableFilter");
        this.propsList.add("tableAlias");
        this.propsList.add("generatedOnNull");
        this.propsList.add("commentInRDBMS");
        this.propsList.add("JSON_SCHEMA");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OBJECT_TYPE", "VARCHAR2");
        this.dataTypes.put("VIEW_OWNER", "VARCHAR2");
        this.dataTypes.put("VIEW_NAME", "VARCHAR2");
        this.dataTypes.put("TABLE_OWNER", "VARCHAR2");
        this.dataTypes.put("TABLE_NAME", "VARCHAR2");
        this.dataTypes.put("ALLOW_INSERT", "BOOLEAN");
        this.dataTypes.put("ALLOW_UPDATE", "BOOLEAN");
        this.dataTypes.put("ALLOW_DELETE", "BOOLEAN");
        this.dataTypes.put("READ_ONLY", "BOOLEAN");
        this.dataTypes.put("HAS_FLEX_COL", "BOOLEAN");
        this.dataTypes.put("ROOT_TABLE", "BOOLEAN");
        this.dataTypes.put("TABLE_NUMBER", "NUMBER");
        this.dataTypes.put("PARENT_TABLE_NUMBER", "NUMBER");
        this.dataTypes.put("RELATIONSHIP", "VARCHAR2");
        this.dataTypes.put("COLUMN_NAME", "VARCHAR2");
        this.dataTypes.put("DATA_TYPE", "VARCHAR2");
        this.dataTypes.put("LENGTH", "NUMBER");
        this.dataTypes.put("JSON_KEY_NAME", "NVARCHAR2");
        this.dataTypes.put("IS_FLEX_COL", "BOOLEAN");
        this.dataTypes.put("PRIMARY_KEY_POS", "NUMBER");
        this.dataTypes.put("ETAG_POS", "NUMBER");
        this.dataTypes.put("LINKTYPE", "VARCHAR2");
        this.dataTypes.put("PKCOLUMNS", "VARCHAR2");
        this.dataTypes.put("PKNAME", "VARCHAR2");
        this.dataTypes.put("FKCOLUMNS", "VARCHAR2");
        this.dataTypes.put("FKNAME", "VARCHAR2");
        this.dataTypes.put("OTHER_FKCOLUMNS", "VARCHAR2");
        this.dataTypes.put("OTHER_FKNAME", "VARCHAR2");
        this.dataTypes.put("NESTED", "BOOLEAN");
        this.dataTypes.put("NESTEDKEY", "VARCHAR2");
        this.dataTypes.put("CHECK", "BOOLEAN");
        this.dataTypes.put("conflictResolutionOnFlex", "VARCHAR2");
        this.dataTypes.put("tableFilter", "VARCHAR2");
        this.dataTypes.put("tableAlias", "VARCHAR2");
        this.dataTypes.put("generatedOnNull", "BOOLEAN");
        this.dataTypes.put("commentInRDBMS", "VARCHAR2");
        this.dataTypes.put("JSON_SCHEMA", "JSON");
    }

    @Override
    public void initPropertyToJsonMap() {
        this.propToJsonMap.put("OBJECT_TYPE", "objectType");
        this.propToJsonMap.put("VIEW_OWNER", "viewOwner");
        this.propToJsonMap.put("VIEW_NAME", "viewName");
        this.propToJsonMap.put("TABLE_OWNER", "tableOwner");
        this.propToJsonMap.put("TABLE_NAME", "tableName");
        this.propToJsonMap.put("ALLOW_INSERT", "allowInsert");
        this.propToJsonMap.put("ALLOW_UPDATE", "allowUpdate");
        this.propToJsonMap.put("ALLOW_DELETE", "allowDelete");
        this.propToJsonMap.put("READ_ONLY", "readOnly");
        this.propToJsonMap.put("HAS_FLEX_COL", "hasFlexCol");
        this.propToJsonMap.put("ROOT_TABLE", "rootTable");
        this.propToJsonMap.put("TABLE_NUMBER", "tableNumber");
        this.propToJsonMap.put("PARENT_TABLE_NUMBER", "parentTableNumber");
        this.propToJsonMap.put("RELATIONSHIP", "relationship");
        this.propToJsonMap.put("COLUMN_NAME", "columnName");
        this.propToJsonMap.put("DATA_TYPE", "dataType");
        this.propToJsonMap.put("LENGTH", "length");
        this.propToJsonMap.put("JSON_KEY_NAME", "jsonKeyName");
        this.propToJsonMap.put("IS_FLEX_COL", "isFlexCol");
        this.propToJsonMap.put("PRIMARY_KEY_POS", "primaryKeyPos");
        this.propToJsonMap.put("ETAG_POS", "etagPos");
        this.propToJsonMap.put("LINKTYPE", "linkType");
        this.propToJsonMap.put("PKCOLUMNS", "pkColumns");
        this.propToJsonMap.put("PKNAME", "pkName");
        this.propToJsonMap.put("FKCOLUMNS", "fkColumns");
        this.propToJsonMap.put("FKNAME", "fkName");
        this.propToJsonMap.put("OTHER_FKCOLUMNS", "otherFkColumns");
        this.propToJsonMap.put("OTHER_FKNAME", "otherFkName");
        this.propToJsonMap.put("NESTED", "nested");
        this.propToJsonMap.put("NESTEDKEY", "nestedKey");
        this.propToJsonMap.put("UNNESTED", "unnested");
        this.propToJsonMap.put("CHECK", "check");
        this.propToJsonMap.put("generatedOnNull", "generatedOnNull");
        this.propToJsonMap.put("tableFilter", "tableFilter");
        this.propToJsonMap.put("tableAlias", "tableAlias");
        super.initPropertyToJsonMap();
    }

    @Override
    public void propsToVars() {
        this.objectType = this.getProperty("OBJECT_TYPE");
        this.view_owner = this.getProperty("VIEW_OWNER");
        this.view_name = this.getProperty("VIEW_NAME");
        this.table_owner = this.getProperty("TABLE_OWNER");
        this.table_name = this.getProperty("TABLE_NAME");
        this.allow_insert = this.getProperty("ALLOW_INSERT");
        this.allow_update = this.getProperty("ALLOW_UPDATE");
        this.allow_delete = this.getProperty("ALLOW_DELETE");
        this.read_only = this.getProperty("READ_ONLY");
        this.has_flex_col = this.getProperty("HAS_FLEX_COL");
        this.root_table = this.getProperty("ROOT_TABLE");
        this.rootTable = "TABLE".equalsIgnoreCase(this.objectType) && ("true".equalsIgnoreCase(this.root_table) || "1".equalsIgnoreCase(this.root_table));
        this.table_number = this.getProperty("TABLE_NUMBER");
        this.parent_table_number = this.getProperty("PARENT_TABLE_NUMBER");
        this.relationship = this.getProperty("RELATIONSHIP");
        this.column_name = this.getProperty("COLUMN_NAME");
        this.data_type = this.getProperty("DATA_TYPE");
        this.length = this.getProperty("LENGTH");
        this.json_key_name = this.getProperty("JSON_KEY_NAME");
        this.is_flex_col = this.getProperty("IS_FLEX_COL");
        this.primary_key_pos = this.getProperty("PRIMARY_KEY_POS");
        this.etag_pos = this.getProperty("ETAG_POS");
        this.fkColumns = this.getProperty("FKCOLUMNS");
        this.other_fkColumns = this.getProperty("OTHER_FKCOLUMNS");
        this.linkType = this.getProperty("LINKTYPE");
        this.pkColumns = this.getProperty("PKCOLUMNS");
        this.pkName = this.getProperty("PKNAME");
        this.fkName = this.getProperty("FKNAME");
        this.other_fkName = this.getProperty("OTHER_FKNAME");
        this.nestedKey = this.getProperty("NESTEDKEY");
        this.nested = this.getProperty("NESTED");
        this.unnested = this.getProperty("UNNESTED");
        this.check = this.getProperty("CHECK");
        this.conflictResolutionOnFlex = this.getProperty("conflictResolutionOnFlex");
        this.tableFilter = this.getProperty("tableFilter");
        this.generatedOnNull = JDVElement.getBoolean(this.getProperty("generatedOnNull"), false);
        this.tableAlias = this.getProperty("tableAlias");
        this.commentInRDBMS = this.getProperty("commentInRDBMS");
    }

    @Override
    public void setProperty(String key, String value) {
        super.setProperty(key, value);
        if ("ROOT_TABLE".equalsIgnoreCase(key)) {
            this.root_table = value;
            this.rootTable = "true".equalsIgnoreCase(this.root_table) || "1".equalsIgnoreCase(this.root_table);
        }
    }

    @Override
    public String getName() {
        if (this.isTable()) {
            return this.getTable_name();
        }
        return this.getColumn_name();
    }

    @Override
    public void varsToProps() {
    }

    public void setView_owner(String view_owner) {
        this.view_owner = view_owner;
        super.setProperty("VIEW_OWNER", view_owner);
    }

    public void setView_name(String view_name) {
        this.view_name = view_name;
        super.setProperty("VIEW_NAME", view_name);
    }

    public void setTable_owner(String table_owner) {
        this.table_owner = table_owner;
        super.setProperty("TABLE_OWNER", table_owner);
    }

    public void setTable_name(String table_name) {
        this.table_name = table_name;
        super.setProperty("TABLE_NAME", table_name);
    }

    public void setAllow_insert(String allow_insert) {
        this.allow_insert = allow_insert;
        super.setProperty("ALLOW_INSERT", allow_insert);
    }

    public void setAllow_update(String allow_update) {
        this.allow_update = allow_update;
        super.setProperty("ALLOW_UPDATE", allow_update);
    }

    public void setAllow_delete(String allow_delete) {
        this.allow_delete = allow_delete;
        super.setProperty("ALLOW_DELETE", allow_delete);
    }

    public void setRead_only(String read_only) {
        this.read_only = read_only;
        super.setProperty("READ_ONLY", read_only);
    }

    public void setHas_flex_col(String has_flex_col) {
        this.has_flex_col = has_flex_col;
        super.setProperty("HAS_FLEX_COL", has_flex_col);
    }

    public void setRoot_table(String root_table) {
        this.root_table = root_table;
        super.setProperty("ROOT_TABLE", root_table);
    }

    public void setTable_number(String table_number) {
        this.table_number = table_number;
        super.setProperty("TABLE_NUMBER", table_number);
    }

    public void setParent_table_number(String parent_table_number) {
        this.parent_table_number = parent_table_number;
        super.setProperty("PARENT_TABLE_NUMBER", parent_table_number);
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
        super.setProperty("RELATIONSHIP", relationship);
    }

    public String getView_owner() {
        return this.view_owner;
    }

    public String getView_name() {
        return this.view_name;
    }

    public String getTable_owner() {
        return this.table_owner;
    }

    public String getTable_name() {
        return this.table_name;
    }

    public String getAllow_insert() {
        return this.allow_insert;
    }

    public String getAllow_update() {
        return this.allow_update;
    }

    public String getAllow_delete() {
        return this.allow_delete;
    }

    public String getRead_only() {
        return this.read_only;
    }

    public String getHas_flex_col() {
        return this.has_flex_col;
    }

    public boolean hasFlexColumn() {
        if (this.isTable()) {
            if (this.has_flex_col == null) {
                this.has_flex_col = this.getProperty("HAS_FLEX_COL");
            }
            if (this.has_flex_col != null && "true".equalsIgnoreCase(this.has_flex_col) || "1".equalsIgnoreCase(this.has_flex_col)) {
                return true;
            }
        }
        return false;
    }

    public String getRoot_table() {
        return this.root_table;
    }

    public String getTable_number() {
        return this.table_number;
    }

    public String getParent_table_number() {
        return this.parent_table_number;
    }

    public String getRelationship() {
        return this.relationship;
    }

    public void setColumn_name(String column_name) {
        this.column_name = column_name;
        super.setProperty("COLUMN_NAME", column_name);
    }

    public void setData_type(String data_type) {
        this.data_type = data_type;
        super.setProperty("DATA_TYPE", data_type);
    }

    public void setLength(String length) {
        this.length = length;
        super.setProperty("LENGTH", length);
    }

    public void setJson_key_name(String json_key_name) {
        this.json_key_name = json_key_name;
        super.setProperty("JSON_KEY_NAME", json_key_name);
    }

    public void setIs_flex_col(String is_flex_col) {
        this.is_flex_col = is_flex_col;
        super.setProperty("IS_FLEX_COL", is_flex_col);
    }

    public void setPrimary_key_pos(String primary_key_pos) {
        this.primary_key_pos = primary_key_pos;
        super.setProperty("PRIMARY_KEY_POS", primary_key_pos);
    }

    public void setEtag_pos(String etag_pos) {
        this.etag_pos = etag_pos;
        super.setProperty("ETAG_POS", etag_pos);
    }

    public String getColumn_name() {
        return this.column_name;
    }

    public String getData_type() {
        return this.data_type;
    }

    public String getLength() {
        return this.length;
    }

    public String getJson_key_name() {
        return this.json_key_name;
    }

    public String getIs_flex_col() {
        if (this.is_flex_col == null) {
            this.is_flex_col = this.getProperty("IS_FLEX_COL");
        }
        return this.is_flex_col;
    }

    public String getPrimary_key_pos() {
        return this.primary_key_pos;
    }

    public String getEtag_pos() {
        return this.etag_pos;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
        super.setProperty("LINKTYPE", linkType);
    }

    public void setPkColumns(String pkColumns) {
        this.pkColumns = pkColumns;
        super.setProperty("PKCOLUMNS", pkColumns);
    }

    public void setPkName(String pkName) {
        this.pkName = pkName;
        super.setProperty("PKNAME", pkName);
    }

    public void setFkColumns(String fkColumns) {
        this.fkColumns = fkColumns;
        super.setProperty("FKCOLUMNS", fkColumns);
    }

    public void setFkName(String fkName) {
        this.fkName = fkName;
        super.setProperty("FKNAME", fkName);
    }

    public void setOther_FkColumns(String fkColumns) {
        this.other_fkColumns = fkColumns;
        super.setProperty("OTHER_FKCOLUMNS", fkColumns);
    }

    public void setOther_FkName(String fkName) {
        this.other_fkName = fkName;
        super.setProperty("OTHER_FKNAME", fkName);
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
        super.setProperty("OBJECT_TYPE", objectType);
    }

    public void setNested(String nested) {
        this.nested = nested;
        super.setProperty("NESTED", nested);
    }

    public void setUnnested(String nested) {
        this.nested = nested;
        super.setProperty("UNNESTED", nested);
    }

    public void setNestedKey(String nestedKey) {
        this.nestedKey = nestedKey;
        super.setProperty("NESTEDKEY", nestedKey);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getPkColumns() {
        return this.pkColumns;
    }

    public String getPkName() {
        return this.pkName;
    }

    public String getFkColumns() {
        return this.fkColumns;
    }

    public String[] getForeignKeyColumns() {
        String[] cols = new String[]{};
        if (this.isTable()) {
            String fcols = this.getFkColumns();
            if (fcols == null || fcols.isEmpty()) {
                fcols = this.getOther_FkColumns();
            }
            if (fcols != null && !fcols.isEmpty()) {
                return fcols.split(",");
            }
        }
        return cols;
    }

    public String[] getPKColumns() {
        String[] cols = new String[]{};
        if (this.isTable()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("___");
            for (JDVElement el : this.getElements()) {
                String pos;
                if (el.isTable() || (pos = el.getPrimary_key_pos()) == null) continue;
                try {
                    int position = Integer.valueOf(pos);
                    if (position >= list.size()) {
                        list.add(el.getName());
                        continue;
                    }
                    if (position >= list.size()) continue;
                    list.add(position, el.getName());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            list.remove(0);
            return list.toArray(cols);
        }
        return cols;
    }

    public List<JDVElement> getPKCulumnsList() {
        ArrayList<JDVElement> res = new ArrayList<JDVElement>();
        if (this.isTable()) {
            for (JDVElement el : this.getElements()) {
                if ((!el.isColumn() || el.getPrimary_key_pos() == null) && !"_id".equals(el.getJson_key_name()) && !"_id".equals(el.getNestedKey())) continue;
                res.add(el);
            }
        }
        return res;
    }

    public String getFkName() {
        return this.fkName;
    }

    public String getOther_FkColumns() {
        return this.other_fkColumns;
    }

    public String getOther_FkName() {
        return this.other_fkName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getUnnested() {
        if (this.unnested == null) {
            this.unnested = this.getProperty("UNNESTED");
        }
        return this.unnested;
    }

    public String getNested() {
        return this.nested;
    }

    public String getNestedKey() {
        return this.nestedKey;
    }

    public List<JDVElement> getElements() {
        if (this.elements == null) {
            this.elements = new ArrayList<JDVElement>();
        }
        return this.elements;
    }

    public void setElements(List<JDVElement> elements) {
        this.elements = elements;
    }

    @Override
    public List<PropertiesObject.CollectionDescriptor> getCollectionDescriptors() {
        ArrayList<PropertiesObject.CollectionDescriptor> list = new ArrayList<PropertiesObject.CollectionDescriptor>();
        PropertiesObject.CollectionDescriptor cd = new PropertiesObject.CollectionDescriptor();
        cd.name = ELEMENTS;
        cd.coll = this::getElements;
        list.add(cd);
        return list;
    }

    @Override
    public PropertiesObject createObjectForCollection(String collName) {
        if (collName != null && ELEMENTS.equalsIgnoreCase(collName)) {
            return new JDVElement();
        }
        return super.createObjectForCollection(collName);
    }

    @Override
    public void addObject(String collName, PropertiesObject obj) {
        if (collName != null && ELEMENTS.equalsIgnoreCase(collName) && obj instanceof JDVElement) {
            this.getElements().add((JDVElement)obj);
            return;
        }
        super.addObject(collName, obj);
    }

    public boolean isTable() {
        if (this.objectType == null) {
            this.objectType = this.getProperty("OBJECT_TYPE");
        }
        return "table".equalsIgnoreCase(this.objectType);
    }

    public boolean isColumn() {
        if (this.objectType == null) {
            this.objectType = this.getProperty("OBJECT_TYPE");
        }
        return "column".equalsIgnoreCase(this.objectType);
    }

    public String getLongName() {
        Object longName = "";
        if (this.getTable_owner() != null) {
            longName = this.getTable_owner() + ".";
        }
        longName = (String)longName + this.getTable_name();
        if (this.isTable()) {
            return longName;
        }
        return (String)longName + "." + this.getColumn_name();
    }

    public String getLongName(String defaultOwner) {
        Object longName = "";
        longName = this.getTable_owner() != null ? this.getTable_owner() + "." : defaultOwner + ".";
        longName = (String)longName + this.getTable_name();
        if (this.isTable()) {
            return longName;
        }
        return (String)longName + "." + this.getColumn_name();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public JDVElement getChildTableWithNumber(String number) {
        for (JDVElement el : this.getElements()) {
            if (!el.isTable() || !el.getTable_number().equals(number)) continue;
            return el;
        }
        return null;
    }

    public JDVElement getChildTable(String owner, String name, String relationship) {
        for (JDVElement el : this.getElements()) {
            if (!el.isTable() || !el.getTable_owner().equals(owner) || !el.getTable_name().equals(name) || !relationship.equals(el.getRelationship())) continue;
            return el;
        }
        return null;
    }

    public JDVElement getFirstPKColumn() {
        for (JDVElement el : this.getElements()) {
            if (el.isTable() || !"1".equals(el.getPrimary_key_pos())) continue;
            return el;
        }
        return null;
    }

    public void clearRedundantProperties() {
        String val = this.getProperty("OBJECT_TYPE");
        if ("column".equalsIgnoreCase(val)) {
            this.setCheck(String.valueOf(this.getProperty("ETAG_POS") != null));
            this.removeProperty("TABLE_OWNER");
            this.removeProperty("TABLE_NAME");
            this.removeProperty("ALLOW_INSERT");
            this.removeProperty("ALLOW_DELETE");
            this.removeProperty("ETAG_POS");
        }
        this.removeProperty("VIEW_OWNER");
        this.removeProperty("VIEW_NAME");
        this.removeProperty("TABLE_NUMBER");
        this.removeProperty("PARENT_TABLE_NUMBER");
        this.removeProperty("LENGTH");
        this.removeProperty("ROOT_TABLE");
        this.removeProperty("READ_ONLY");
    }

    @Override
    public void validate() {
        String tableFilter;
        super.validate();
        if (this.isColumn()) {
            if (this.etag_pos != null) {
                this.check = "true";
                this.setProperty("CHECK", "true");
            }
        } else if (this.isTable() && (tableFilter = this.getProperty("WHERE_CLAUSE")) != null) {
            this.setProperty("tableFilter", tableFilter);
        }
    }

    public String getCheck() {
        if ("COLUMN".equalsIgnoreCase(this.objectType) && (this.etag_pos != null || "true".equalsIgnoreCase(this.check) || "1".equalsIgnoreCase(this.check))) {
            return "true";
        }
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
        super.setProperty("CHECK", check);
    }

    public static JDVElement createTable(String owner, String name) {
        JDVElement el = new JDVElement();
        el.setObjectType("TABLE");
        el.setTable_name(name);
        el.setTable_owner(owner);
        return el;
    }

    public static JDVElement createColumn(String name) {
        JDVElement el = new JDVElement();
        el.setObjectType("COLUMN");
        el.setColumn_name(name);
        return el;
    }

    public Map<String, JDVElement> getElmentsMap(List<JDVElement> elements) {
        HashMap<String, JDVElement> map = new HashMap<String, JDVElement>();
        if (elements != null) {
            for (JDVElement el : elements) {
                String key = el.getJson_key_name();
                if (key == null) continue;
                map.put(key, el);
            }
        }
        return map;
    }

    public String getTableId() {
        return String.valueOf(this.tableId);
    }

    public void setTableId(int tableId) {
        this.tableId = tableId;
    }

    public void initIdForTables(int id) {
        int _id = id;
        for (JDVElement table : this.getAllTables()) {
            table.setTableId(_id);
            ++_id;
        }
    }

    public List<JDVElement> getAllTables() {
        ArrayList<JDVElement> tables = new ArrayList<JDVElement>();
        this.addTables(tables);
        return tables;
    }

    private void addTables(List<JDVElement> tables) {
        if (this.isTable()) {
            tables.add(this);
            for (JDVElement element : this.getElements()) {
                element.addTables(tables);
            }
        }
    }

    public boolean isPkColumn() {
        if (!this.isTable()) {
            return this.getPrimary_key_pos() != null && !this.getPrimary_key_pos().isEmpty();
        }
        return false;
    }

    public void validateTableCheckFromDatabase() {
        int count = 0;
        if (this.isTable()) {
            for (JDVElement el : this.getElements()) {
                if (el.isTable()) {
                    el.validateTableCheckFromDatabase();
                    continue;
                }
                if (el.isPkColumn() || el.getCheck() == null || !"false".equals(el.getCheck())) continue;
                ++count;
            }
            if (count == 0) {
                this.setCheck("true");
            } else {
                this.setCheck("false");
            }
        }
    }

    public JDVElement getFlexColumn() {
        if (this.isTable()) {
            for (JDVElement el : this.getElements()) {
                if (!el.isColumn() || !JDVElement.getBoolean(el.getIs_flex_col(), false)) continue;
                return el;
            }
        }
        return null;
    }

    private static boolean getBoolean(String value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        return "true".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
    }

    public String getConflictResolutionOnFlex() {
        return this.conflictResolutionOnFlex;
    }

    public void setConflictResolutionOnFlex(String conflictResolutionOnFlex) {
        this.conflictResolutionOnFlex = conflictResolutionOnFlex;
        super.setProperty("conflictResolutionOnFlex", conflictResolutionOnFlex);
    }

    public boolean isFlexColumn() {
        return this.isColumn() && JDVElement.getBoolean(this.getIs_flex_col(), false);
    }

    public String getCommentInRDBMS() {
        return this.commentInRDBMS;
    }

    public void setCommentInRDBMS(String commentInRDBMS) {
        this.commentInRDBMS = commentInRDBMS;
        super.setProperty("commentInRDBMS", commentInRDBMS);
    }

    public String getTableFilter() {
        if (this.tableFilter == null) {
            this.tableFilter = this.getProperty("WHERE_CLAUSE");
            if (this.tableFilter != null) {
                this.setProperty("tableFilter", this.tableFilter);
            }
        }
        return this.tableFilter;
    }

    public void setTableFilter(String tableFilter) {
        this.tableFilter = tableFilter;
        super.setProperty("tableFilter", tableFilter);
    }

    @Override
    public String toJSONString(boolean excludeNulls) {
        this.getTableFilter();
        this.removeProperty("WHERE_CLAUSE");
        return super.toJSONString(excludeNulls);
    }

    public int getParseFrom() {
        return this.parseFrom;
    }

    public void setParseFrom(int parseFrom) {
        this.parseFrom = parseFrom;
    }

    public int getParseTo() {
        return this.parseTo;
    }

    public void setParseTo(int parseTo) {
        this.parseTo = parseTo;
    }

    public boolean isNested() {
        return this.isTable() && JDVElement.getBoolean(this.getNested(), false) && this.getJson_key_name() != null;
    }

    public void synchPropsToVarsForTree() {
        this.propsToVars();
        for (JDVElement el : this.getElements()) {
            if (el.isTable()) {
                el.synchPropsToVarsForTree();
                continue;
            }
            el.propsToVars();
        }
    }

    public JDVElement getFlexElementByColumnName(JDVElement source) {
        if (this.isTable()) {
            String columnName = source.getColumn_name();
            if ((columnName = Quoting.unQuote(columnName)) != null) {
                for (JDVElement el : this.getElements()) {
                    String name;
                    if (!el.isColumn() || !el.isFlexColumn() || !columnName.equalsIgnoreCase(name = Quoting.unQuote(el.getColumn_name()))) continue;
                    return el;
                }
            }
        }
        return null;
    }

    public JDVElement getColumnElementByJsonAlias(JDVElement source) {
        if (this.isTable()) {
            String columnName = source.getJsonAlias();
            if ((columnName = Quoting.unQuote(columnName)) != null) {
                for (JDVElement el : this.getElements()) {
                    String name;
                    if (!el.isColumn() || !columnName.equalsIgnoreCase(name = Quoting.unQuote(el.getJsonAlias()))) continue;
                    return el;
                }
            }
        }
        return null;
    }

    public JDVElement getColumnElementByName(String cname) {
        String columnName;
        if (this.isTable() && (columnName = Quoting.unQuote(cname)) != null) {
            for (JDVElement el : this.getElements()) {
                String name;
                if (!el.isColumn() || !columnName.equalsIgnoreCase(name = Quoting.unQuote(el.getColumn_name()))) continue;
                return el;
            }
        }
        return null;
    }

    public JDVElement getTableByNames(String jsonKey, String tableOwner, String tableName) {
        if (this.isTable()) {
            String key;
            String name = tableName;
            if (name != null) {
                name = Quoting.unQuote(name);
            }
            key = (key = jsonKey) != null ? Quoting.unQuote(key) : name;
            for (JDVElement el : this.getElements()) {
                if (!el.isTable()) continue;
                String elKey = el.getJson_key_name();
                if (elKey == null) {
                    elKey = el.getTable_name();
                }
                if (elKey != null) {
                    elKey = Quoting.unQuote(elKey);
                    if (key == null || !key.equalsIgnoreCase(elKey)) continue;
                    return el;
                }
                String elName = Quoting.unQuote(el.getTable_name());
                if (!elName.equalsIgnoreCase(name)) continue;
                if (tableOwner != null) {
                    String owner = Quoting.unQuote(tableOwner);
                    String elOwner = el.getTable_owner();
                    if (elOwner != null) {
                        elOwner = Quoting.unQuote(elOwner);
                    }
                    if (!owner.equalsIgnoreCase(elOwner)) continue;
                    return el;
                }
                return el;
            }
        }
        return null;
    }

    public boolean isUnnested() {
        return JDVElement.getBoolean(this.getUnnested(), false);
    }

    public boolean isRootTable() {
        return this.rootTable;
    }

    public void setRootTable(boolean rootTable) {
        this.setProperty("ROOT_TABLE", "true");
        this.rootTable = rootTable;
    }

    public String getJsonAlias() {
        if (this.isRootTable() || this.isTable() && this.isUnnested()) {
            return null;
        }
        if (this.getJson_key_name() != null) {
            return this.getJson_key_name();
        }
        return this.getName();
    }

    public void reorderTree(JDVElement parsedTable, boolean graphQLFilter) {
        if (parsedTable.isTable()) {
            ArrayList<JDVElement> temp = new ArrayList<JDVElement>();
            HashMap<String, JDVElement> map = new HashMap<String, JDVElement>();
            if (parsedTable.getTableFilter() != null) {
                this.setTableFilter(parsedTable.getTableFilter());
                this.setGqlTablefilter(graphQLFilter);
            }
            for (JDVElement el : parsedTable.getElements()) {
                JDVElement column;
                if (el.isTable()) {
                    JDVElement table = this.getTableByNames(el.getJson_key_name(), el.getTable_owner(), el.getTable_name());
                    if (table == null) continue;
                    temp.add(table);
                    map.put(table.getJsonAlias(), table);
                    table.reorderTree(el, graphQLFilter);
                    if (el.getTableFilter() == null) continue;
                    table.setTableFilter(el.getTableFilter());
                    table.setGqlTablefilter(true);
                    continue;
                }
                if (!el.isColumn() || (column = this.getColumnElementByJsonAlias(el)) == null) continue;
                temp.add(column);
                map.put(column.getJsonAlias(), column);
                if (el.getNestedKey() == null) continue;
                column.setNestedKey(el.getNestedKey());
            }
            for (JDVElement el : this.getElements()) {
                if (map.containsKey(el.getJsonAlias())) continue;
                temp.add(el);
            }
            this.getElements().clear();
            this.getElements().addAll(temp);
        }
    }

    public void relocateUnnested() {
        ArrayList<JDVElement> temp = new ArrayList<JDVElement>();
        for (JDVElement el : this.getElements()) {
            if (el.isTable()) {
                el.relocateUnnested();
                if (el.isUnnested()) {
                    temp.addAll(el.getElements());
                    continue;
                }
                temp.add(el);
                continue;
            }
            temp.add(el);
        }
        this.getElements().clear();
        this.getElements().addAll(temp);
    }

    public String getRequired() {
        return this.required;
    }

    public void setRequired(String required) {
        this.required = required;
    }

    public boolean isGqlTablefilter() {
        return this.gqlTablefilter;
    }

    public void setGqlTablefilter(boolean gqlTablefilter) {
        this.gqlTablefilter = gqlTablefilter;
    }

    public String getLinkJoinType() {
        if (this.linkJoinType == null) {
            this.linkJoinType = this.getProperty("linkJoinType");
        }
        return this.linkJoinType;
    }

    public void setLinkJoinType(String linkJoinType) {
        this.linkJoinType = linkJoinType;
        this.setProperty("linkJoinType", linkJoinType);
    }

    Set<String> getPKColumnNames() {
        HashSet<String> names = new HashSet<String>();
        for (JDVElement el : this.getElements()) {
            String pkPos;
            if (!el.isColumn() || (pkPos = el.getPrimary_key_pos()) == null || "0".equals(pkPos)) continue;
            names.add(el.getName().toUpperCase(Locale.ROOT));
        }
        return names;
    }

    public boolean isOneToOneCardinality() {
        String[] names;
        String cols;
        Set<String> pkNames;
        if (this.isTable() && (pkNames = this.getPKColumnNames()).size() > 0 && (cols = this.getFkColumns()) != null && !cols.isEmpty() && (names = cols.split(",")).length == pkNames.size()) {
            for (String name : names) {
                if (pkNames.contains(name.trim().toUpperCase(Locale.ROOT))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getJsonSchema() {
        return this.jsonSchema;
    }

    public void setJsonSchema(String jsonSchema) {
        this.jsonSchema = jsonSchema;
    }

    public void applyPropertiesFromTableSchema(JsonObject jobj) {
        JsonObject props;
        if (this.isTable() && (props = jobj.getJsonObject("properties")) != null) {
            for (Map.Entry item : props.entrySet()) {
                JsonValue allOf;
                JDVElement col = this.getColumnElementByName((String)item.getKey());
                if (col == null || !(item.getValue() instanceof JsonObject)) continue;
                JsonObject valObject = (JsonObject)item.getValue();
                JsonValue description = (JsonValue)valObject.get((Object)"description");
                if (description != null) {
                    col.setDescription(Quoting.unQuote(description.toString()));
                }
                if ((allOf = (JsonValue)valObject.get((Object)"allOf")) == null) continue;
                col.setAllOf(allOf.toString());
            }
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAllOf() {
        return this.allOf;
    }

    public void setAllOf(String allOf) {
        this.allOf = allOf;
    }

    public String getTableAlias() {
        if (this.tableAlias == null) {
            this.tableAlias = this.getProperty("tableAlias");
        }
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.setProperty("tableAlias", tableAlias);
        this.tableAlias = tableAlias;
    }

    public boolean isCheckSet() {
        return this.getProperty("CHECK") != null;
    }

    public boolean isUpdateSet() {
        return this.getProperty("ALLOW_UPDATE") != null;
    }

    public boolean isInsertSet() {
        return this.getProperty("ALLOW_INSERT") != null;
    }

    public boolean isDeleteSet() {
        return this.getProperty("ALLOW_DELETE") != null;
    }

    public boolean isGeneratedOnNull() {
        return this.generatedOnNull;
    }

    public void setGeneratedOnNull(boolean generatedOnNull) {
        this.generatedOnNull = generatedOnNull;
        this.setProperty("generatedOnNull", generatedOnNull ? "true" : "false");
    }

    public SQLProcessor.Condition getCondition() {
        return this.condition;
    }

    public void setCondition(SQLProcessor.Condition condition) {
        this.condition = condition;
    }
}

