/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.ddl;

import java.util.Locale;
import oracle.dbtools.common.utils.StringUtils;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;

public interface Quoting {
    public static final String SINGLE_QUOTE = "'";

    public static boolean isValidIdentifier(String name) {
        return StorageDesignOracle.isValidIdentifier(name);
    }

    public static boolean isQuoted(String name) {
        if (name == null) {
            return false;
        }
        return name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"';
    }

    public static String unQuote(String name) {
        return StringUtils.unQuote((String)name);
    }

    public static boolean isMixedCase(String name) {
        return !name.equals(name.toUpperCase(Locale.ROOT));
    }

    public static String removeSingleQuotes(String name) {
        if (name != null && !name.isEmpty() && name.startsWith(SINGLE_QUOTE) && name.endsWith(SINGLE_QUOTE) && name.length() > 1) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }
}

