/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdv.dbimport;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.oracle.MOHTableOracle;
import oracle.dbtools.crest.imports.metadata.oracle.SchemaDDLGenerator;
import oracle.dbtools.crest.model.PropertiesObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.metadata.MetaFileLoader;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.jdv.JDVUtil;
import oracle.dbtools.jdv.dbimport.DBMExtractionHandlerJDV;
import oracle.dbtools.jdv.dbimport.MOHJDVHandler;
import oracle.dbtools.jdv.dbimport.Transform;
import oracle.dbtools.jdv.ddl.GQLProcessor;
import oracle.dbtools.jdv.ddl.SQLProcessor;
import oracle.dbtools.jdv.model.JDVElement;
import oracle.dbtools.jdv.model.JDVLink;
import oracle.dbtools.jdv.model.JDVView;

public class MOHJDViewHandler
extends MOHJDVHandler {
    public static final String OBJECT_TYPE = "DUALITY_VIEW";
    public static final String DBA_TABLE = "SYS.DBA_JSON_DUALITY_VIEWS";
    public static final String ALL_TABLE = "SYS.ALL_JSON_DUALITY_VIEWS";
    public static final String DBA_JDV_TABLES = "SYS.DBA_JSON_DUALITY_VIEW_TABS";
    public static final String ALL_JDV_TABLES = "SYS.ALL_JSON_DUALITY_VIEW_TABS";
    public static final String DBA_JDV_TAB_COLS = "SYS.DBA_JSON_DUALITY_VIEW_TAB_COLS";
    public static final String ALL_JDV_TAB_COLS = "SYS.ALL_JSON_DUALITY_VIEW_TAB_COLS";
    public static final String DBA_JDV_LINKS = "SYS.DBA_JSON_DUALITY_VIEW_LINKS";
    public static final String ALL_JDV_LINKS = "SYS.ALL_JSON_DUALITY_VIEW_LINKS";
    public static final String ALL_OBJECTS = "SYS.ALL_OBJECTS";
    public static final String DBA_OBJECTS = "SYS.DBA_OBJECTS";

    public MOHJDViewHandler(DBMExtractionHandlerJDV dbmeHandler) {
        super(dbmeHandler);
    }

    @Override
    public List<PropertiesObject> generate(Connection conn, List<DBObject> selectedObjects) throws SQLException, IOException {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<PropertiesObject> res = new ArrayList<PropertiesObject>();
        List dbos = selectedObjects.stream().filter(dbo -> OBJECT_TYPE.equalsIgnoreCase(dbo.getType())).collect(Collectors.toList());
        if (dbos.size() > 0) {
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                for (DBObject dbo2 : dbos) {
                    String schema = dbo2.getSchema();
                    String name = dbo2.getName();
                    ps.setString(1, schema);
                    ps.setString(2, name);
                    ResultSet rs = ps.executeQuery();
                    try {
                        int count = rs.getMetaData().getColumnCount();
                        ResultSetMetaData meta = rs.getMetaData();
                        if (!rs.next()) continue;
                        JDVView view = new JDVView();
                        for (int i = 1; i <= count; ++i) {
                            String cname = meta.getColumnName(i);
                            String value = rs.getString(cname);
                            view.setProperty(cname, value);
                        }
                        view.validate();
                        view.propsToVars();
                        if (!"VALID".equalsIgnoreCase(view.getStatus()) && view.getJson_column_name() == null) {
                            throw new IllegalStateException("Error - View is invalid and details are not available");
                        }
                        res.add(view);
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
            }
            for (PropertiesObject obj : res) {
                JDVView view = (JDVView)obj;
                this.buildView(conn, view, dba, true);
            }
        }
        return res;
    }

    public Map<String, Table> buildView(Connection conn, JDVView view, boolean dba, boolean removeJsonSchema) throws SQLException, IOException {
        List<JDVElement> tables = this.getTables(conn, view, dba);
        view.setDefinition(tables.get(0));
        List<JDVElement> columns = this.getColumns(conn, view, dba);
        List<JDVLink> links = this.getLinks(conn, view, dba);
        Map<String, Table> map = this.buildView(conn, view, tables, columns, links);
        this.checkForOneToOneUnnested(view, links);
        MOHJDViewHandler.checkForNested(view);
        this.clearSomeProperties(tables, columns);
        view.getDefinition().validateTableCheckFromDatabase();
        String comment = MOHTableOracle.getTableComment(conn, view.getView_owner(), view.getView_name(), null, dba);
        if (comment != null) {
            view.setCommentInRDBMS(comment);
        }
        String viewDef = MOHJDViewHandler.getViewDefinitionFromDB(conn, view.getView_owner(), view.getView_name(), dba);
        JDVElement parsedRoot = null;
        parsedRoot = viewDef.toUpperCase(Locale.ROOT).indexOf("SELECT ") < 0 ? GQLProcessor.getDVRootDefinition(viewDef) : SQLProcessor.getDVRootDefinition(viewDef, view.getView_owner(), view.getView_name());
        if (parsedRoot != null) {
            view.setParsedRoot(parsedRoot);
            if (MOHJDViewHandler.hasFlexColumn(view.getDefinition())) {
                MOHJDViewHandler.copyFlexSetting(view.getDefinition(), parsedRoot);
            }
            view.getDefinition().reorderTree(parsedRoot, true);
        }
        if (removeJsonSchema) {
            view.removeProperty("JSON_SCHEMA");
        }
        return map;
    }

    void checkForOneToOneUnnested(JDVView view, List<JDVLink> links) {
        JDVElement table = view.getDefinition();
        if (table != null) {
            for (JDVElement el : table.getElements()) {
                if (!el.isTable()) continue;
                this.verifyFKSettings(table, el, links);
            }
        }
    }

    void verifyFKSettings(JDVElement parentTable, JDVElement table, List<JDVLink> links) {
        List<JDVLink> list;
        String fkColumns = table.getFkColumns();
        String otherFkColumns = table.getOther_FkColumns();
        if ((fkColumns == null || fkColumns.isEmpty()) && (otherFkColumns == null || otherFkColumns.isEmpty()) && (list = this.getLinkByJoinType(links, parentTable.getTable_owner(), parentTable.getName(), table.getTable_owner(), table.getName(), "reverse")) != null) {
            Object cols = null;
            for (JDVLink link : list) {
                if (link.getTo_column() == null) continue;
                if (cols == null) {
                    cols = link.getTo_column();
                    continue;
                }
                cols = (String)cols + "," + link.getTo_column();
            }
            if (cols != null) {
                FKIndexAssociation fk = table.getTable().getFKforColumns((String)cols);
                if (fk != null) {
                    table.setFkName(fk.getName());
                } else {
                    table.setFkName("");
                }
                table.setFkColumns((String)cols);
                table.setUnnested("true");
                table.setLinkJoinType("reverse");
            }
        }
        for (JDVElement el : table.getElements()) {
            if (!el.isTable()) continue;
            this.verifyFKSettings(table, el, links);
        }
    }

    static boolean hasFlexColumn(JDVElement table) {
        if (table.isTable()) {
            if (table.hasFlexColumn()) {
                return true;
            }
            for (JDVElement el : table.getElements()) {
                if (!MOHJDViewHandler.hasFlexColumn(el)) continue;
                return true;
            }
        }
        return false;
    }

    static void processFlexColumnFromDefinition(Connection conn, JDVView view, boolean dba) throws SQLException, IOException {
        JDVElement parsedRoot;
        String viewDef;
        if (MOHJDViewHandler.hasFlexColumn(view.getDefinition()) && (viewDef = MOHJDViewHandler.getViewDefinitionFromDB(conn, view.getView_owner(), view.getView_name(), dba)).toUpperCase(Locale.ROOT).indexOf("SELECT ") < 0 && (parsedRoot = GQLProcessor.getDVRootDefinition(viewDef)) != null) {
            MOHJDViewHandler.copyFlexSetting(view.getDefinition(), parsedRoot);
        }
    }

    static void copyFlexSetting(JDVElement targetTable, JDVElement parsedTable) {
        if (parsedTable.isTable()) {
            for (JDVElement el : parsedTable.getElements()) {
                JDVElement column;
                if (el.isTable()) {
                    JDVElement table = targetTable.getTableByNames(el.getJson_key_name(), el.getTable_owner(), el.getTable_name());
                    if (table == null) continue;
                    MOHJDViewHandler.copyFlexSetting(table, el);
                    continue;
                }
                if (!el.isFlexColumn() || (column = targetTable.getFlexElementByColumnName(el)) == null) continue;
                column.setConflictResolutionOnFlex(el.getConflictResolutionOnFlex());
            }
        }
    }

    static String getViewDefinitionFromDB(Connection conn, String owner, String name, boolean dba) throws SQLException {
        String sql = "select text from SYS." + (dba ? "DBA_VIEWS" : "ALL_VIEWS") + " \r\n where owner =  ? and view_name = ? and duality_view = 'YES'";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, owner);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
        }
        return null;
    }

    private static void checkForNested(JDVView view) throws IOException {
        JsonObject jdoc = null;
        String json = view.getJson_schema();
        if (json != null && !json.isEmpty()) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
                jdoc = Json.createReader((InputStream)stream).readObject();
                JsonArray required = jdoc.getJsonArray("required");
                if (required != null) {
                    view.getDefinition().setRequired(required.toString());
                }
                MOHJDViewHandler.processJsonValue(view.getDefinition(), null, (JsonValue)jdoc);
            }
        }
    }

    static void processJsonValue(JDVElement element, String key, JsonValue jv) {
        if (key == null && jv instanceof JsonObject) {
            JsonObject props = ((JsonObject)jv).getJsonObject("properties");
            if (props != null) {
                MOHJDViewHandler.checkTableForNested(element, props);
            }
            return;
        }
        Map<String, JDVElement> map = element.getElmentsMap(element.getElements());
        if (!"_metadata".equals(key)) {
            JDVElement elem = map.get(key);
            if (jv instanceof JsonObject) {
                JsonObject jobj = (JsonObject)jv;
                if (elem == null) {
                    JsonObject props;
                    String type;
                    boolean found = false;
                    if (jv instanceof JsonObject && "object".equalsIgnoreCase(type = jobj.getString("type", "")) && (props = jobj.getJsonObject("properties")) != null) {
                        for (Map.Entry oval : props.entrySet()) {
                            JDVElement el;
                            if (!map.containsKey(oval.getKey()) || (el = map.get(oval.getKey())) == null) continue;
                            el.setNested("true");
                            el.setNestedKey(key);
                            found = true;
                        }
                        if (!found && element.isTable()) {
                            for (JDVElement el : element.getElements()) {
                                if (!el.isTable() || !el.isUnnested()) continue;
                                MOHJDViewHandler.processJsonValue(el, key, (JsonValue)jobj);
                            }
                        }
                    }
                } else if (elem.isTable() && jv instanceof JsonObject) {
                    String type = jobj.getString("type", "");
                    JsonObject props = null;
                    if ("object".equalsIgnoreCase(type)) {
                        JsonArray required;
                        props = jobj.getJsonObject("properties");
                        if (props != null && (required = jobj.getJsonArray("required")) != null) {
                            elem.setRequired(required.toString());
                        }
                    } else if ("array".equalsIgnoreCase(type)) {
                        JsonObject items = jobj.getJsonObject("items");
                        String itype = items.getString("type");
                        if (items != null && "object".equalsIgnoreCase(itype)) {
                            props = items.getJsonObject("properties");
                            JsonArray required = items.getJsonArray("required");
                            if (required != null) {
                                elem.setRequired(required.toString());
                            }
                        }
                    }
                    if (props != null) {
                        MOHJDViewHandler.checkTableForNested(elem, props);
                    }
                }
            }
        }
    }

    private static void checkTableForNested(JDVElement element, JsonObject jobj) {
        for (Map.Entry val : jobj.entrySet()) {
            String key = (String)val.getKey();
            JsonValue jv = (JsonValue)val.getValue();
            if ("_metadata".equals(key)) continue;
            MOHJDViewHandler.processJsonValue(element, key, jv);
        }
    }

    private void clearSomeProperties(List<JDVElement> tables, List<JDVElement> columns) {
        for (JDVElement el : tables) {
            el.clearRedundantProperties();
        }
        for (JDVElement el : columns) {
            el.clearRedundantProperties();
        }
    }

    Map<String, Table> buildView(Connection conn, JDVView view, List<JDVElement> tables, List<JDVElement> columns, List<JDVLink> links) throws SQLException {
        Map<String, Table> map = MOHJDViewHandler.getTablesMap(conn, tables);
        this.setDesignTables(tables, map);
        HashMap<String, JDVElement> tablesNumberMap = new HashMap<String, JDVElement>();
        for (JDVElement el : tables) {
            tablesNumberMap.put(el.getTable_number(), el);
        }
        for (JDVElement el : columns) {
            JDVElement usedTable;
            JDVElement t = (JDVElement)tablesNumberMap.get(el.getTable_number());
            JDVElement parentt = null;
            if (t.getParent_table_number() != null) {
                parentt = (JDVElement)tablesNumberMap.get(t.getParent_table_number());
            }
            if (parentt != null && (usedTable = parentt.getChildTableWithNumber(el.getTable_number())) == null) {
                parentt.getElements().add(t);
            }
            if (el.getJson_key_name() == null) {
                Table table = map.get(t.getLongName());
                Column col = (Column)table.getElementByName(el.getColumn_name());
                if (col == null) continue;
                FKIndexAssociation fk = col.getFKIndexAssociation();
                if (fk != null) {
                    JDVLink link;
                    JDVElement vtab;
                    Table rt = (Table)fk.getRemoteTable();
                    if (!"nested".equalsIgnoreCase(t.getRelationship()) || parentt != null && !rt.getLongName().equalsIgnoreCase(parentt.getLongName())) {
                        vtab = this.getTable(tables, el.getTable_number(), rt.getSchema(), rt.getName(), "singleton");
                        if (vtab == null) continue;
                        JDVElement usedTable2 = t.getChildTableWithNumber(vtab.getTable_number());
                        if (usedTable2 == null) {
                            t.getElements().add(vtab);
                        }
                        FKElement[] cols = fk.getColumns();
                        Object names = "";
                        for (int i = 0; i < cols.length; ++i) {
                            if (i > 0) {
                                names = (String)names + ",";
                            }
                            names = (String)names + cols[i].getName();
                        }
                        ContainedObject[] cobs = fk.getRemoteIndex().getColumns();
                        Column pkCol = (Column)cobs[0];
                        link = this.getLink(links, t.getTable_owner(), t.getTable_name(), vtab.getTable_owner(), vtab.getTable_name(), col.getName(), pkCol.getName());
                        if (link == null) continue;
                        if (link.getKey_name() != null) {
                            vtab.setJson_key_name(link.getKey_name());
                        }
                        if (link.getJoin_type().equalsIgnoreCase("inner")) {
                            vtab.setUnnested("true");
                        }
                        vtab.setLinkJoinType(link.getJoin_type());
                        vtab.setOther_FkColumns((String)names);
                        vtab.setOther_FkName(fk.getName());
                        continue;
                    }
                    if (!t.getRelationship().equalsIgnoreCase("nested") || parentt == null || (vtab = t) == null) continue;
                    FKElement[] cols = fk.getColumns();
                    Object names = "";
                    for (int i = 0; i < cols.length; ++i) {
                        if (i > 0) {
                            names = (String)names + ",";
                        }
                        names = (String)names + cols[i].getName();
                    }
                    Column fcol = (Column)cols[0];
                    JDVElement pkel = parentt.getFirstPKColumn();
                    String pkColName = null;
                    if (pkel == null) {
                        ContainedObject[] cobs = fk.getRemoteIndex().getColumns();
                        Column pkCol = (Column)cobs[0];
                        pkColName = pkCol.getName();
                    } else {
                        pkColName = pkel.getColumn_name();
                    }
                    if ((link = this.getLink(links, parentt.getTable_owner(), parentt.getTable_name(), vtab.getTable_owner(), vtab.getTable_name(), pkColName, fcol.getName())) == null) continue;
                    if (link.getKey_name() != null) {
                        vtab.setJson_key_name(link.getKey_name());
                    }
                    vtab.setFkColumns((String)names);
                    vtab.setFkName(fk.getName());
                    continue;
                }
                t.getElements().add(el);
                continue;
            }
            t.getElements().add(el);
        }
        return map;
    }

    JDVElement getTable(List<JDVElement> tables, String parentNumber, String owner, String name, String relationship) {
        for (JDVElement el : tables) {
            if (!parentNumber.equals(el.getParent_table_number()) || !owner.equals(el.getTable_owner()) || !name.equals(el.getTable_name()) || !relationship.equalsIgnoreCase(el.getRelationship()) || el.getJson_key_name() != null) continue;
            return el;
        }
        return null;
    }

    private JDVLink getLink(List<JDVLink> links, String parOwner, String parTable, String chOwner, String chTable, String parColumn, String chColumn) {
        for (JDVLink link : links) {
            if (!parOwner.equals(link.getParent_table_owner()) || !parTable.equals(link.getParent_table_name()) || !chOwner.equals(link.getChild_table_owner()) || !chTable.equals(link.getChild_table_name()) || !parColumn.equals(link.getFrom_column()) || !chColumn.equals(link.getTo_column())) continue;
            return link;
        }
        return null;
    }

    private List<JDVLink> getLinkByJoinType(List<JDVLink> links, String parOwner, String parTable, String chOwner, String chTable, String joinType) {
        ArrayList<JDVLink> list = new ArrayList<JDVLink>();
        for (JDVLink link : links) {
            if (!parOwner.equals(link.getParent_table_owner()) || !parTable.equals(link.getParent_table_name()) || !chOwner.equals(link.getChild_table_owner()) || !chTable.equals(link.getChild_table_name()) || !joinType.equals(link.getJoin_type())) continue;
            list.add(link);
        }
        if (list.size() > 0) {
            return list;
        }
        return null;
    }

    List<JDVElement> getTables(Connection conn, JDVView view, boolean dba) throws SQLException {
        return this.getTables(conn, view.getView_owner(), view.getView_name(), dba);
    }

    List<JDVElement> getTables(Connection conn, String owner, String name, boolean dba) throws SQLException {
        double dbVersion = this.getDBVersion();
        double versionForWhereClause = 22.4;
        ArrayList<JDVElement> res = new ArrayList<JDVElement>();
        String sql = this.getTablesSQL(dba);
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setFetchSize(100);
            ps.setString(1, owner);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                int count = rs.getMetaData().getColumnCount();
                ResultSetMetaData meta = rs.getMetaData();
                while (rs.next()) {
                    JDVElement elem = new JDVElement();
                    for (int i = 1; i <= count; ++i) {
                        String cname = meta.getColumnName(i);
                        String value = rs.getString(cname);
                        elem.setProperty(cname, value);
                    }
                    if (dbVersion < 22.4) {
                        elem.removeProperty("tableFilter");
                        elem.removeProperty("WHERE_CLAUSE");
                    }
                    elem.propsToVars();
                    elem.validate();
                    res.add(elem);
                }
            }
        }
        return res;
    }

    public String getUsedTablesJSON(Connection conn, String owner, String name) throws SQLException, IOException {
        List<JDVElement> tables = this.getTables(conn, owner, name, this.isDBA(conn));
        Map<String, Table> map = MOHJDViewHandler.getTablesMap(conn, tables);
        ArrayList<Table> list = new ArrayList<Table>(map.values());
        if (list.size() > 0) {
            try (StringWriter sw = new StringWriter();){
                String res;
                Transform.transformFromListOfObjects(list, "usedTables", sw, false);
                String string = res = sw.toString();
                return string;
            }
        }
        return "{}";
    }

    List<JDVElement> getColumns(Connection conn, JDVView view, boolean dba) throws SQLException {
        ArrayList<JDVElement> res = new ArrayList<JDVElement>();
        String sql = this.getColumnsSQL(dba);
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setFetchSize(100);
            String schema = view.getView_owner();
            String name = view.getView_name();
            ps.setString(1, schema);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                int count = rs.getMetaData().getColumnCount();
                ResultSetMetaData meta = rs.getMetaData();
                while (rs.next()) {
                    JDVElement elem = new JDVElement();
                    for (int i = 1; i <= count; ++i) {
                        String cname = meta.getColumnName(i);
                        String value = rs.getString(cname);
                        elem.setProperty(cname, value);
                    }
                    elem.propsToVars();
                    elem.validate();
                    res.add(elem);
                }
            }
        }
        return res;
    }

    List<JDVLink> getLinks(Connection conn, JDVView view, boolean dba) throws SQLException {
        ArrayList<JDVLink> res = new ArrayList<JDVLink>();
        String sql = this.getLinksSQL(dba);
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setFetchSize(100);
            String schema = view.getView_owner();
            String name = view.getView_name();
            ps.setString(1, schema);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                int count = rs.getMetaData().getColumnCount();
                ResultSetMetaData meta = rs.getMetaData();
                while (rs.next()) {
                    JDVLink elem = new JDVLink();
                    for (int i = 1; i <= count; ++i) {
                        String cname = meta.getColumnName(i);
                        String value = rs.getString(cname);
                        elem.setProperty(cname, value);
                    }
                    elem.validate();
                    elem.propsToVars();
                    res.add(elem);
                }
            }
        }
        return res;
    }

    public JDVView getJDVView(Connection conn, String schema, String name) throws SQLException, IOException {
        DBObject dbo = new DBObject(true, name, OBJECT_TYPE, schema);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        list.add(dbo);
        List<PropertiesObject> res = this.generate(conn, list);
        if (res != null && res.size() > 0) {
            return (JDVView)res.get(0);
        }
        return null;
    }

    private JDVView getDualityView(Connection conn, String schema, String name, boolean dba) throws SQLException {
        String sql = this.getSQL(dba);
        JDVView view = null;
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, schema);
            ps.setString(2, name);
            try (ResultSet rs = ps.executeQuery();){
                int count = rs.getMetaData().getColumnCount();
                ResultSetMetaData meta = rs.getMetaData();
                if (rs.next()) {
                    view = new JDVView();
                    for (int i = 1; i <= count; ++i) {
                        String cname = meta.getColumnName(i);
                        String value = rs.getString(cname);
                        view.setProperty(cname, value);
                    }
                    view.validate();
                    view.propsToVars();
                    if (!"VALID".equalsIgnoreCase(view.getStatus()) && view.getJson_column_name() == null) {
                        throw new IllegalStateException("Error - View is invalid and details are not available");
                    }
                }
            }
        }
        return view;
    }

    public JDVView getDualityViewWithJsonSchema(Connection conn, String schema, String name) throws SQLException, IOException {
        boolean dba = this.isDBA(conn);
        JDVView view = this.getDualityView(conn, schema, name, dba);
        this.buildView(conn, view, dba, false);
        return view;
    }

    public String getJDVViewAndUsedTablesDetails(Connection conn, String schema, String name) throws SQLException, IOException {
        boolean dba = this.isDBA(conn);
        JDVView view = this.getDualityView(conn, schema, name, dba);
        if (view != null) {
            Map<String, Table> map = this.buildView(conn, view, dba, true);
            Object res = "{\"objectType\":\"JDV_CONTEXT\",";
            res = (String)res + "\n\"view\":" + view.toJSONString(true);
            res = (String)res + ",\n\"usedTables\":" + Transform.getUsedTablesAsJSONArray(map.values()) + "\n}";
            return res;
        }
        return "{}";
    }

    String getSQL(boolean dba) {
        String sql = "select o.owner VIEW_OWNER, o.object_name VIEW_NAME,  JSON_COLUMN_NAME,\r\nROOT_TABLE_NAME,\r\nROOT_TABLE_OWNER,\r\nALLOW_INSERT,\r\nALLOW_UPDATE,\r\nALLOW_DELETE,\r\nREAD_ONLY,\r\nJSON_SCHEMA, o.EDITIONABLE, o.status STATUS, o.EDITIONABLE EDITIONABLE  from " + (dba ? DBA_TABLE : ALL_TABLE) + " v," + (dba ? DBA_OBJECTS : ALL_OBJECTS) + " o \r\n where O.OWNER = ? and O.OBJECT_NAME = ? \r\n and V.VIEW_OWNER(+) = O.OWNER and V.VIEW_NAME(+) = O.OBJECT_NAME";
        return sql;
    }

    String getTablesSQL(boolean dba) {
        String sql = "select v.*, 'TABLE' as object_type from \r\n" + (dba ? DBA_JDV_TABLES : ALL_JDV_TABLES) + " v \r\nwhere view_owner = ? and view_name = ? \r\norder by table_number";
        return sql;
    }

    String getColumnsSQL(boolean dba) {
        String sql = "select v.*, 'COLUMN' as object_type from \r\n" + (dba ? DBA_JDV_TAB_COLS : ALL_JDV_TAB_COLS) + " v \r\nwhere view_owner = ? and view_name = ? \r\norder by table_number";
        return sql;
    }

    String getLinksSQL(boolean dba) {
        String sql = "select v.* from \r\n" + (dba ? DBA_JDV_LINKS : ALL_JDV_LINKS) + " v \r\nwhere view_owner = ? and view_name = ? ";
        return sql;
    }

    static Map<String, Table> getTablesMap(Connection conn, List<JDVElement> tables) throws SQLException {
        HashMap<String, Table> map = new HashMap<String, Table>();
        Design.dmInternalsDistDir = SchemaDDLGenerator.webPath;
        MetaFileLoader.DMWEB = true;
        Design des = JDVUtil.getDesign();
        RelationalDesign relModel = des.getRelationalDesign();
        DBMExtractionHandlerOracle handler = new DBMExtractionHandlerOracle(des);
        handler.init(conn);
        relModel.setSelectedRDBMSSite(handler.getRDBMSSite());
        StorageDesign sd = relModel.getStorageDesign();
        sd.openStorageDesign();
        List<DBObject> objects = MOHJDViewHandler.getObjectsToImport(tables);
        ImportLogger importLog = new ImportLogger();
        handler.generateDesign(conn, objects, importLog);
        TableSet ts = relModel.getTableSet();
        for (int i = 0; i < ts.size(); ++i) {
            Table t = (Table)ts.getElement(i);
            map.put(t.getLongName(), t);
        }
        return map;
    }

    private void setDesignTables(List<JDVElement> tables, Map<String, Table> map) {
        for (JDVElement el : tables) {
            Table t = map.get(el.getLongName());
            if (t == null) continue;
            el.setTable(t);
        }
    }

    private static List<DBObject> getObjectsToImport(List<JDVElement> tables) {
        ArrayList<DBObject> res = new ArrayList<DBObject>();
        HashSet<String> set = new HashSet<String>();
        for (JDVElement el : tables) {
            if (set.contains(el.getLongName())) continue;
            res.add(new DBObject(true, el.getTable_name(), "TABLE", el.getTable_owner()));
            set.add(el.getLongName());
        }
        return res;
    }

    public String getJsonSchemaWithOrder(Connection conn, String owner, String name) throws SQLException, IOException {
        Object res = "";
        boolean dba = this.isDBA(conn);
        String sql = "select sys.dbms_json_schema.describe(?,?) from dual";
        String jsonSchema = null;
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(2, owner);
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    jsonSchema = rs.getString(1);
                }
            }
        }
        if (jsonSchema != null) {
            String viewDef = MOHJDViewHandler.getViewDefinitionFromDB(conn, owner, name, dba);
            String ordered = null;
            if (viewDef != null) {
                JDVElement parsedRoot = null;
                parsedRoot = viewDef.toUpperCase(Locale.ROOT).indexOf("SELECT ") < 0 ? GQLProcessor.getDVRootDefinition(viewDef) : SQLProcessor.getDVRootDefinition(viewDef, owner, name);
                if (parsedRoot != null) {
                    parsedRoot.setRootTable(true);
                    this.processSchemaConstraints(conn, owner, parsedRoot);
                    this.checkPKColumnGeneratedOnNull(conn, owner, parsedRoot);
                    parsedRoot.relocateUnnested();
                    ordered = Transform.rootToJsonSchema(parsedRoot);
                }
                res = "{\"jsonSchema\":" + jsonSchema;
            }
            if (ordered != null && !ordered.isEmpty()) {
                res = (String)res + ",\"propertiesOrder\":" + ordered;
            }
            res = (String)res + "}";
        }
        return res;
    }

    public List<JDVElement> getTables(JDVElement root) {
        ArrayList<JDVElement> tables = new ArrayList<JDVElement>();
        this.addTables(root, tables);
        return tables;
    }

    void addTables(JDVElement table, List<JDVElement> tables) {
        if (table.isTable()) {
            tables.add(table);
            for (JDVElement el : table.getElements()) {
                this.addTables(el, tables);
            }
        }
    }

    private static JsonObject getParsedSchema(String json) throws IOException {
        JsonObject jdoc = null;
        if (json != null && !json.isEmpty()) {
            try (ByteArrayInputStream stream = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));){
                jdoc = Json.createReader((InputStream)stream).readObject();
            }
        }
        return jdoc;
    }

    void processSchemaConstraints(Connection conn, String owner, JDVElement root) throws SQLException, IOException {
        String sql = "select sys.dbms_json_schema.describe(?,?) from dual";
        List<JDVElement> tables = this.getTables(root);
        HashMap<String, JsonObject> map = new HashMap<String, JsonObject>();
        try (PreparedStatement ps = conn.prepareStatement("select sys.dbms_json_schema.describe(?,?) from dual");){
            for (JDVElement table : tables) {
                String longName = table.getLongName(owner);
                JsonObject parsed = (JsonObject)map.get(longName);
                if (parsed == null) {
                    String schema = table.getTable_owner() != null ? table.getTable_owner().toUpperCase(Locale.ROOT) : owner;
                    ps.setString(2, schema);
                    ps.setString(1, table.getName().toUpperCase(Locale.ROOT));
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs != null && rs.next()) {
                            String jsonSchema = rs.getString(1);
                            parsed = MOHJDViewHandler.getParsedSchema(jsonSchema);
                            map.put(longName, parsed);
                        }
                    }
                }
                if (parsed == null) continue;
                table.applyPropertiesFromTableSchema(parsed);
            }
        }
    }

    void checkPKColumnGeneratedOnNull(Connection conn, String owner, JDVElement root) throws SQLException, IOException {
        block13: {
            String sql = "with FUNCTION alaways_generated (\r\n    T_OWNER IN VARCHAR2, T_NAME IN VARCHAR2, C_NAME IN VARCHAR2\r\n) RETURN VARCHAR2 \r\nAS\r\nres varchar2(3) := 'NO';\r\nidentity_column boolean := false;\r\ncursor tabcols(oname varchar2, tname varchar2 ,cname varchar2) is\r\n select a.DEFAULT_ON_NULL, a.identity_column from SYS.ALL_TAB_COLS a where \r\n  a.owner = oname and a.table_name = tname and a.column_name = cname ;\r\ncursor ident_cols(oname varchar2, tname varchar2 ,cname varchar2) is\r\n select a.GENERATION_TYPE from SYS.ALL_TAB_IDENTITY_COLS a where \r\n  a.owner = oname and a.table_name = tname and a.column_name = cname ;\r\n begin\r\n  for rec in tabcols(t_owner, t_name, c_name)\r\n    loop\r\n        res := rec.DEFAULT_ON_NULL;\r\n        identity_column := rec.identity_column = 'YES';\r\n    end loop;\r\n    if identity_column and 'NO' = res then\r\n     for rec in ident_cols(t_owner, t_name, c_name)\r\n        loop\r\n            if 'ALWAYS' = rec.GENERATION_TYPE then\r\n                res := 'YES';\r\n            end if;\r\n        end loop;\r\n    end if;\r\n  return res;\r\n end alaways_generated;\r\nSELECT\r\n    alaways_generated(?,?,?) generated\r\nFROM\r\n    DUAL";
            try (PreparedStatement ps = conn.prepareStatement("with FUNCTION alaways_generated (\r\n    T_OWNER IN VARCHAR2, T_NAME IN VARCHAR2, C_NAME IN VARCHAR2\r\n) RETURN VARCHAR2 \r\nAS\r\nres varchar2(3) := 'NO';\r\nidentity_column boolean := false;\r\ncursor tabcols(oname varchar2, tname varchar2 ,cname varchar2) is\r\n select a.DEFAULT_ON_NULL, a.identity_column from SYS.ALL_TAB_COLS a where \r\n  a.owner = oname and a.table_name = tname and a.column_name = cname ;\r\ncursor ident_cols(oname varchar2, tname varchar2 ,cname varchar2) is\r\n select a.GENERATION_TYPE from SYS.ALL_TAB_IDENTITY_COLS a where \r\n  a.owner = oname and a.table_name = tname and a.column_name = cname ;\r\n begin\r\n  for rec in tabcols(t_owner, t_name, c_name)\r\n    loop\r\n        res := rec.DEFAULT_ON_NULL;\r\n        identity_column := rec.identity_column = 'YES';\r\n    end loop;\r\n    if identity_column and 'NO' = res then\r\n     for rec in ident_cols(t_owner, t_name, c_name)\r\n        loop\r\n            if 'ALWAYS' = rec.GENERATION_TYPE then\r\n                res := 'YES';\r\n            end if;\r\n        end loop;\r\n    end if;\r\n  return res;\r\n end alaways_generated;\r\nSELECT\r\n    alaways_generated(?,?,?) generated\r\nFROM\r\n    DUAL");){
                JDVElement column;
                List<JDVElement> pkColumns = root.getPKCulumnsList();
                if (pkColumns.size() != 1 || (column = pkColumns.get(0)) == null) break block13;
                String schema = root.getTable_owner() != null ? root.getTable_owner().toUpperCase(Locale.ROOT) : owner;
                ps.setString(1, schema);
                ps.setString(2, root.getName().toUpperCase(Locale.ROOT));
                ps.setString(3, column.getColumn_name().toUpperCase(Locale.ROOT));
                try (ResultSet rs = ps.executeQuery();){
                    String generated;
                    if (rs != null && rs.next() && "YES".equalsIgnoreCase(generated = rs.getString(1))) {
                        column.setGeneratedOnNull(true);
                    }
                }
            }
        }
    }
}

