/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.relational;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.relational.TVFKContainer;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.util.logging.Logger;

public class TVTable
extends TVFKContainer {
    private Collection conns = new ArrayList();
    private Set listeners = new HashSet();
    private static final Logger LOGGER = new Logger(TVTable.class);

    public TVTable(DesignPartView dpv) {
        super(dpv);
    }

    public void addConnection(FKIndexAssociation.FKConnection connection) {
        this.conns.add(connection);
        ++connection.countAdded;
        if (connection.countAdded < 2 && connection.getChildTable() == this.getModel()) {
            TVTable srcView = (TVTable)connection.getSourceTV(this.getDesignPartView());
            if (srcView == null) {
                srcView = (TVTable)this.getDesignPartView().openViewFor(connection.getParentTable());
            }
            srcView.addConnection(connection);
        }
    }

    public void remConnection(FKIndexAssociation.FKConnection connection) {
        this.conns.remove(connection);
        --connection.countAdded;
    }

    public void addJustConnection(FKIndexAssociation.FKConnection connection) {
        this.conns.add(connection);
        ++connection.countAdded;
    }

    public void removeConnection(FKIndexAssociation.FKConnection connection) {
        TVTable srcView;
        this.conns.remove(connection);
        --connection.countAdded;
        if (connection.countAdded > 0 && connection.getChildTable() == this.getModel() && (srcView = (TVTable)connection.getSourceTV(this.getDesignPartView())) != null) {
            srcView.removeConnection(connection);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    @Override
    public DesignPartView getDesignPartView() {
        return this.dpv;
    }

    @Override
    public void setModel(DesignObject object) {
        super.setModel(object);
    }

    protected FKIndexAssociation.FKConnection[] getConnections() {
        FKIndexAssociation[] fkar = ((Table)this.getModel()).getFKAssociations();
        FKIndexAssociation.FKConnection[] fkConAr = new FKIndexAssociation.FKConnection[fkar.length];
        for (int i = 0; i < fkar.length; ++i) {
            fkConAr[i] = fkar[i].getFKConnection();
        }
        return fkConAr;
    }

    public void redistributePoints() {
    }

    public Collection getAllConnections() {
        return this.conns;
    }

    public void addTVFKRelations() {
        Table tab = (Table)this.getModel();
        DesignPartView dpv = this.getDesignPartView();
        FKIndexAssociation[] fkass = tab.getFKAssociations();
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTV(dpv) == null) {
                fkass[i].setTargetTVTable(this);
            }
            fkass[i].getSourceTV(dpv);
            TopView tv = fkass[i].getFirstViewForDPV(dpv);
            if (tv != null) continue;
            dpv.add(tv);
        }
        Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab);
        for (FKIndexAssociation fk : col) {
            if (fk.getSourceTV(dpv) == null) {
                fk.setSourceTVTable(this);
            }
            fk.getTargetTV(dpv);
            TopView tv = fk.getFirstViewForDPV(dpv);
            if (tv == null) {
                dpv.add(tv);
            }
            if (fk.getContainerWithKeyObject() != fk.getRemoteTable()) continue;
            ((TVFKRelation)fk.getViewFor(dpv)).repairSelfReference(this);
        }
    }

    public void addTVFKRelations(DesignPartView dpv) {
        Table tab = (Table)this.getModel();
        FKIndexAssociation[] fkass = tab.getFKAssociations();
        for (int i = 0; i < fkass.length; ++i) {
            if (fkass[i].getTargetTV(dpv) != null) continue;
            fkass[i].setTargetTVTable(this);
        }
        Collection col = ((RelationalDesign)this.getModel().getDesignPart()).getFKIndexAssociationSet().getAssociationsWith(tab);
        for (FKIndexAssociation fk : col) {
            if (fk.getSourceTV(dpv) == null) {
                fk.setSourceTVTable(this);
            }
            if (fk.getContainerWithKeyObject() != fk.getRemoteTable()) continue;
            ((TVFKRelation)fk.getViewFor(dpv)).repairSelfReference(this);
        }
    }

    @Override
    protected void doPrivateActions() {
        this.reassignFKs();
    }

    public ContainerView createViewSynonim(DesignPartView dpv) {
        return new TVTable(dpv);
    }

    public void reassignFKs() {
    }

    @Override
    public String toString() {
        int i = this.getViewNumber();
        Object s = i == 0 ? "" : ":" + i;
        return this.getModel().getName() + (String)s;
    }

    @Override
    protected void hideRelations() {
    }
}

