/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.scheduling;

import oracle.dbtools.crest.model.scheduling.SchedulerObject;

public class SchedulerFileWatcher
extends SchedulerObject {
    @Override
    public void initPropsList() {
        this.propsList.add("OWNER");
        this.propsList.add("FILE_WATCHER_NAME");
        this.propsList.add("ENABLED");
        this.propsList.add("DESTINATION_OWNER");
        this.propsList.add("DESTINATION");
        this.propsList.add("DIRECTORY_PATH");
        this.propsList.add("FILE_NAME");
        this.propsList.add("CREDENTIAL_OWNER");
        this.propsList.add("CREDENTIAL_NAME");
        this.propsList.add("MIN_FILE_SIZE");
        this.propsList.add("STEADY_STATE_DURATION");
        this.propsList.add("COMMENTS");
    }

    @Override
    public void initDataTypes() {
        this.dataTypes.put("OWNER", "VARCHAR2");
        this.dataTypes.put("FILE_WATCHER_NAME", "VARCHAR2");
        this.dataTypes.put("ENABLED", "VARCHAR2");
        this.dataTypes.put("DESTINATION_OWNER", "VARCHAR2");
        this.dataTypes.put("DESTINATION", "VARCHAR2");
        this.dataTypes.put("DIRECTORY_PATH", "VARCHAR2");
        this.dataTypes.put("FILE_NAME", "VARCHAR2");
        this.dataTypes.put("CREDENTIAL_OWNER", "VARCHAR2");
        this.dataTypes.put("CREDENTIAL_NAME", "VARCHAR2");
        this.dataTypes.put("MIN_FILE_SIZE", "NUMBER");
        this.dataTypes.put("STEADY_STATE_DURATION", "INTERVAL DAY(3) TO SECOND(0)");
        this.dataTypes.put("LAST_MODIFIED_TIME", "TIMESTAMP(6) WITH TIME ZONE");
        this.dataTypes.put("COMMENTS", "VARCHAR2");
    }

    @Override
    public String getName() {
        return this.getProperty("FILE_WATCHER_NAME");
    }

    @Override
    public boolean isMinimumDefined() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return false;
        }
        String value = this.getProperty("DIRECTORY_PATH");
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = this.getProperty("FILE_NAME");
        if (value == null || value.isEmpty()) {
            return false;
        }
        value = this.getProperty("CREDENTIAL_NAME");
        return value != null && !value.isEmpty();
    }

    public String getFormatedCredentialName() {
        return this.getFormattedName("CREDENTIAL_OWNER", "CREDENTIAL_NAME");
    }

    public String getFormatedFileWatcherName() {
        return this.getFormattedName("OWNER", "FILE_WATCHER_NAME");
    }

    public String getFormatedDestinationName() {
        return this.getFormattedName("DESTINATION_OWNER", "DESTINATION");
    }

    public String getEventQueueSpecNameFormatted() {
        String name = this.getProperty("EVENT_QUEUE_NAME");
        if (name != null && !name.isEmpty()) {
            Object res = "";
            String owner = this.getProperty("EVENT_QUEUE_OWNER");
            if (owner != null && !owner.isEmpty()) {
                res = SchedulerFileWatcher.getFormatedSimpleName(owner) + ".";
            }
            res = (String)res + SchedulerFileWatcher.getFormatedSimpleName(name);
            String agent = this.getProperty("EVENT_QUEUE_AGENT");
            if (agent != null && !agent.isEmpty()) {
                res = (String)res + "," + SchedulerFileWatcher.getFormatedSimpleName(agent);
            }
            return res;
        }
        return null;
    }
}

