/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle.v10g;

import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.ConstantsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TriggerOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.UserOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableViewProxyOraclev9i;

public class TableViewProxyOraclev10g
extends TableViewProxyOraclev9i {
    private String editioning = "NO";

    public TableViewProxyOraclev10g(TableView view, StorageDesign storage) {
        super(view, storage);
    }

    public TableViewProxyOraclev10g(Design design, String id, String longName, StorageDesign storage) {
        super(design, id, longName, storage);
    }

    public void setEditioning(String value) {
        if (ConstantsOracle.checkYesNo(value)) {
            this.editioning = value;
        }
    }

    public String getEditioning() {
        return this.editioning;
    }

    @Override
    public void copy(StorageDesign targetDesign) {
        TableView tableView = (TableView)targetDesign.getPhysicalDesign().getTableViewSet().getByName(this.getObject().getName());
        TableViewProxyOraclev10g tableViewProxy = null;
        RelationalObjectProxy storageObject = ((StorageDesignOraclev10g)targetDesign).getTableViewProxySet().getProxy(tableView.getObjectID());
        if (storageObject != null && !this.isRawObject()) {
            tableViewProxy = (TableViewProxyOraclev10g)storageObject;
        }
        if (tableViewProxy != null) {
            tableViewProxy.setName(this.getName());
            for (TriggerOraclev10g trigger : this.triggers) {
                TriggerOraclev10g targetTrigger = (TriggerOraclev10g)((StorageDesignOraclev10g)targetDesign).getTriggerSet().getByName(trigger.getName());
                if (targetTrigger == null) {
                    TriggerOraclev10g newTrigger = (TriggerOraclev10g)((StorageDesignOraclev10g)targetDesign).getTriggerSet().createTrigger();
                    newTrigger.setName(trigger.getName());
                    newTrigger.setRawObject(true);
                    newTrigger.setView(tableViewProxy);
                    tableViewProxy.addTriggersFromDesign(((StorageDesignOraclev10g)targetDesign).getTriggerSet());
                    continue;
                }
                targetTrigger.setView(tableViewProxy);
                tableViewProxy.addTriggersFromDesign(((StorageDesignOraclev10g)targetDesign).getTriggerSet());
            }
            if (this.getUser() != null) {
                UserOraclev10g user = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().getByName(this.getUser().getName());
                if (user == null) {
                    UserOraclev10g newUser = (UserOraclev10g)((StorageDesignOraclev10g)targetDesign).getUserSet().createUser();
                    newUser.setName(this.getUser().getName());
                    newUser.setRawObject(true);
                    tableViewProxy.setUser(newUser);
                } else {
                    tableViewProxy.setUser(user);
                }
            }
            tableViewProxy.setCheckOption(this.getCheckOption());
            tableViewProxy.setDefinition(this.getDefinition());
            tableViewProxy.setForce(this.getForce());
            tableViewProxy.setReadOnly(this.getReadOnly());
            tableViewProxy.setCheckOptionName(this.getCheckOptionName());
            tableViewProxy.setUseOID(this.getUseOID());
            tableViewProxy.setOidAttributes(this.getOidAttributes());
            tableViewProxy.setEditioning(this.getEditioning());
            tableViewProxy.setComment(this.getComment());
            tableViewProxy.setCommentInRDBMS(this.getCommentInRDBMS());
            tableViewProxy.setRawObject(false);
        }
    }
}

