/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.SegmentNameManager;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetEvent;
import oracle.dbtools.crest.model.design.storage.StorageObjectSetListener;
import oracle.dbtools.crest.model.design.storage.StorageSet;

public abstract class StorageObjectSet
extends ModelIDObjectSet
implements StorageSet {
    private StorageDesign storageDesign = null;
    private Map adapterMap = new HashMap();
    private Map longNameMap;
    protected StorageObject nullInstance;
    private SegmentNameManager segManager = new SegmentNameManager();
    private Boolean containsTopLevelStorableObjects = null;

    public void setStorageDesign(StorageDesign storageDesign) {
        if (this.storageDesign != null) {
            this.removeSetListener(storageDesign);
        }
        this.storageDesign = storageDesign;
        if (storageDesign != null) {
            this.addSetListener(storageDesign);
        }
    }

    @Override
    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    @Override
    public abstract Object[] getProtoTypeArray();

    public void addSetListener(StorageObjectSetListener listener) {
        if (this.adapterMap.containsKey(listener)) {
            return;
        }
        if (listener == null) {
            throw new RuntimeException("listener == null, check if inner class is registered during construction.");
        }
        ListenerAdapter adapted = new ListenerAdapter(listener);
        this.adapterMap.put(listener, adapted);
        super.addSetListener(adapted);
    }

    public void removeSetListener(StorageObjectSetListener listener) {
        if (!this.adapterMap.containsKey(listener)) {
            return;
        }
        ListenerAdapter adapted = (ListenerAdapter)this.adapterMap.remove(listener);
        super.removeSetListener(adapted);
    }

    @Override
    public String getSeparator() {
        return "";
    }

    @Override
    public boolean isWriteable() {
        return true;
    }

    public String getNullInstanceName() {
        return "[None]";
    }

    public String getNullInstanceComment() {
        return "No value";
    }

    public StorageObject getNullInstance() {
        return this.getNullInstance(this.getNullInstanceName());
    }

    public void clearNullInstance() {
        this.nullInstance = null;
    }

    public StorageObject getNullInstance(String name) {
        if (this.nullInstance == null) {
            this.nullInstance = (StorageObject)this.createElement(this.getDefaultNamePrefix() + "_NULLELEMENT");
            this.nullInstance.setName(name);
            this.nullInstance.setComment(this.getNullInstanceComment());
            this.nullInstance.setIsNullInstance(true);
            this.nameCounterDecrement();
            this.nullInstance.setOwnerDesignName(Design.getSystemDesignName());
        }
        return this.nullInstance;
    }

    public boolean hasNullInstance() {
        return this.nullInstance != null;
    }

    @Override
    public boolean containsSiteStorageObjects() {
        return true;
    }

    @Override
    public final boolean containsDesignStorageObjects() {
        return !this.containsSiteStorageObjects();
    }

    @Override
    public void add(ModelObject object) {
        object.setParent(this);
        super.add(object);
        ((StorageObject)object).setObjectSet(this);
        this.getStorageDesign().registerModelIDObject((StorageObject)object);
    }

    @Override
    public boolean remove(ModelObject object) {
        boolean result = super.remove(object);
        if (result) {
            this.getStorageDesign().unregisterModelIDObject((StorageObject)object);
        }
        return result;
    }

    public void justAdd(ModelObject object) {
        super.add(object);
    }

    public boolean justRemove(ModelObject object) {
        return super.remove(object);
    }

    @Override
    public void sort() {
        Collections.sort(this.elements, ModelObjectSet.NAME_COMPARATOR);
    }

    @Override
    public boolean canCreateElement() {
        return true;
    }

    public StorageObject getByNameAndDatabase(String name, String databaseName) {
        if (name == null || databaseName != null) {
            // empty if block
        }
        return null;
    }

    public String getSegmentName(ModelIDObject object) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(object);
        }
        return "";
    }

    public String getSegmentName(String id) {
        if (this.isContainsTopLevelStorableObjects()) {
            return this.segManager.getSegmentName(id);
        }
        return "";
    }

    public void addSegmentEntry(String segment, String id) {
        this.addSegmentEntry(segment, id, false);
    }

    public void addSegmentEntry(String segment, String id, boolean clear) {
        if (this.isContainsTopLevelStorableObjects()) {
            if (clear) {
                this.segManager.removeID(id);
            }
            this.segManager.add(segment, id);
        }
    }

    public boolean isContainsTopLevelStorableObjects() {
        if (this.containsTopLevelStorableObjects == null) {
            this.containsTopLevelStorableObjects = this.getStorageDesign().getStorableSetsList().contains(this) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.containsTopLevelStorableObjects;
    }

    public StorageObject getBySchemaObject(SchemaObject so) {
        if (so != null) {
            for (StorageObject user : this) {
                if (so != user.getSchemaObject()) continue;
                return user;
            }
        }
        return null;
    }

    public StorageObject getBySchemaObjectName(String name) {
        if (name != null && !"".equals(name)) {
            for (StorageObject user : this) {
                if (user.getSchemaObject() == null || !name.equalsIgnoreCase(user.getSchemaObject().getName())) continue;
                return user;
            }
        }
        return null;
    }

    @Override
    protected String createName() {
        if (this.getStorageDesign().isLoading() || this.getStorageDesign().isImporting()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getDefaultNamePrefix());
            buffer.append(this.getSeparator());
            buffer.append(this.count++);
            return buffer.toString();
        }
        return super.createName();
    }

    @Override
    public void doAdd() {
        if (this.canSort()) {
            this.sort();
        }
    }

    @Override
    public boolean canSort() {
        return this.getStorageDesign() != null && !this.getStorageDesign().isLoading();
    }

    public Map getLongNameMap() {
        if (this.longNameMap == null) {
            this.longNameMap = new HashMap(10000);
        }
        return this.longNameMap;
    }

    public void refreshLongNameMap() {
        Map map = this.getLongNameMap();
        map.clear();
        for (ModelIDObject obj : this) {
            String lname = obj.getLongName();
            map.put(lname.toUpperCase(), obj);
        }
    }

    public ModelIDObject getObjectFromLongNameMap(String longName) {
        return (ModelIDObject)this.getLongNameMap().get(longName.toUpperCase());
    }

    static class EventAdapter
    extends StorageObjectSetEvent {
        private EventAdapter(ModelObjectSetEvent event) {
            super((StorageObject)event.getAffected(), event.getType());
        }
    }

    static class ListenerAdapter
    implements ModelObjectSetListener {
        private StorageObjectSetListener listener = null;

        private ListenerAdapter(StorageObjectSetListener listener) {
            this.listener = listener;
        }

        @Override
        public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
            this.listener.changed((StorageObjectSet)set, new EventAdapter(event));
        }
    }
}

