/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.DBConnectionStamp;
import oracle.dbtools.crest.imports.DDLFileStamp;
import oracle.dbtools.crest.imports.metadata.DiagramProcessor;
import oracle.dbtools.crest.model.IndexAndConstraintNameController;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.ModelObjectSetEvent;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.StorableObject;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.TypeSubstitutionSet;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.NoteSet;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnSet;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.ColumnViewSet;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKArcSet;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociationSet;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.IndexSet;
import oracle.dbtools.crest.model.design.relational.RelTypeSubstitutionSet;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SchemaObjectSet;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableSet;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.TableViewSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageDesignFactory;
import oracle.dbtools.crest.model.design.storage.StorageDesignSet;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.search.SearchSet;
import oracle.dbtools.crest.swingui.wizards.reports.ReportConstants;

public class RelationalDesign
extends DesignPart
implements SetListener,
ModelObjectSetListener {
    public static final String OBJECT_TYPE_NAME = "RelationalModel";
    public static final String TABLE_SET_NAME = Messages.getString("RelationalDesign.Tables");
    public static final String SCHEMA_SET_NAME = Messages.getString("RelationalDesign.Schemas");
    public static final String FK_SET_NAME = Messages.getString("RelationalDesign.ForeignKeys");
    public static final String TYPE_SUBSTITUTION_NAME = Messages.getString("RelationalDesign.TypeSubstitutions");
    public static final String INDEX_SET_NAME = Messages.getString("RelationalDesign.Indexes");
    public static final String COLUMN_SET_NAME = Messages.getString("RelationalDesign.Columns");
    public static final String COLUMN_VIEW_SET_NAME = Messages.getString("RelationalDesign.ColumnViews");
    public static final String VIEW_SET_NAME = Messages.getString("RelationalDesign.Views");
    public static final String NOTE_SET_NAME = Messages.getString("RelationalDesign.Notes");
    public static final String IMAGE_SET_NAME = Messages.getString("RelationalDesign.Images");
    public static final String MEASUREMENT_SET_NAME = Messages.getString("RelationalDesign.Measurement");
    public static final String ARC_SET_NAME = Messages.getString("RelationalDesign.Arcs");
    public static final String DIAGRAM_SET_NAME = "Diagrams";
    public static final String TEMPLATE_COL_PROP = "ctemplateID";
    private RDBMSSite selectedRDBMSSite;
    private DBConnectionStamp redirectConnectionStamp;
    private boolean useTemplateTable = false;
    private String templateTableID;
    private List<DBConnectionStamp> importConnectionStamps = new ArrayList<DBConnectionStamp>();
    private int importConnectionStampIndex = -1;
    private List<DDLFileStamp> importDDLFileStamps = new ArrayList<DDLFileStamp>();
    private int importDDLFileStampIndex = -1;
    private SchemaObjectSet schemas;
    private TableSet tables;
    private TableViewSet tableViews;
    private FKIndexAssociationSet foreignKeys;
    private FKArcSet fKArcs;
    private StorageDesignSet storageDesigns;
    private RelationalDesign importTo = null;
    private TableSet tableSet;
    private ColumnSet columnSet;
    private ColumnViewSet columnViewSet;
    private TableViewSet viewSet;
    private FKIndexAssociationSet fkAssociationSet;
    private TypeSubstitutionSet typeSubstitutionSet;
    private DesignObjectCollection indexOnlySet;
    private FKArcSet arcSet;
    private SchemaObjectSet schemaObjectSet;
    private IndexAndConstraintNameController indexAndConstraintNameController;
    private NameSpaceController tablesAndViewsNameController;
    private StorageDesignFactory storageDesignFactory = null;
    private RelationalDesign relatedSyncModel;
    private NoteSet noteSet;
    private boolean isSDWCompare = false;

    public RelationalDesign(Design design) {
        this.setDesign(design);
        this.getStorageDesignFactory().getSorageDesigns().setParent(this);
    }

    public StorageDesignFactory getStorageDesignFactory() {
        if (this.storageDesignFactory == null) {
            this.storageDesignFactory = new StorageDesignFactory(this);
        }
        return this.storageDesignFactory;
    }

    public void setSelectedRDBMSSite(RDBMSSite selectedRDBMSSite) {
        this.selectedRDBMSSite = selectedRDBMSSite;
    }

    public void setUseTemplateTable(boolean useTemplateTable) {
        this.useTemplateTable = useTemplateTable;
    }

    public String getTemplateTableID() {
        return this.templateTableID;
    }

    public void setTemplateTableID(String templateTableID) {
        this.templateTableID = templateTableID;
    }

    public DDLFileStamp createImportDDLFileStamp() {
        DDLFileStamp dDLFileStamp = new DDLFileStamp();
        return dDLFileStamp;
    }

    public Table createTable() {
        return this.getTableSet().createTable(null);
    }

    public Table createTable(String name) {
        Table table = this.createTable();
        table.setName(name);
        return table;
    }

    public FKIndexAssociation createForeignKey() {
        FKIndexAssociation fk = new FKIndexAssociation(this);
        return fk;
    }

    public TableView createTableView() {
        return this.getTableViewSet().createTableView(null);
    }

    public TableView createTableView(String name) {
        TableView tableView = this.createTableView();
        tableView.setName(name);
        return tableView;
    }

    public SchemaObject createSchemaObject() {
        return this.getSchemaObjectSet().createSchemaObject(null);
    }

    public FKArc createArc() {
        return this.getArcSet().createArc(null);
    }

    public FKArc createArc(String name) {
        FKArc arc = this.getArcSet().createArc(null);
        arc.setName(name);
        return arc;
    }

    public FKArc recreateArc(String id) {
        return this.getArcSet().createArc(id);
    }

    public FKArc createArc(Object[] selectedObjects) {
        FKContainer table;
        List fkeys;
        List tables = this.getSelectedTables(selectedObjects);
        List sel_fkeys = this.getSelectedFKeys(selectedObjects);
        if (tables.size() == 0 && sel_fkeys.size() > 0) {
            tables.add(((FKIndexAssociation)sel_fkeys.get(0)).getContainerWithKeyObject());
        }
        if (tables.size() == 1 && (fkeys = this.getSelectedFKeys(selectedObjects, table = (FKContainer)tables.get(0))).size() > 1 && fkeys.size() == sel_fkeys.size()) {
            FKArc arc = this.createArc();
            table.addArc(arc);
            for (FKIndexAssociation fkey : fkeys) {
                arc.addFkey(fkey);
            }
            arc.addToAllDPVs();
            return arc;
        }
        if (tables.size() == 1 && sel_fkeys.size() > 1) {
            ArrayList<FKContainer> list = new ArrayList<FKContainer>();
            for (int i = 0; i < sel_fkeys.size(); ++i) {
                FKIndexAssociation fk = (FKIndexAssociation)sel_fkeys.get(i);
                FKContainer table2 = fk.getRemoteTable();
                if (list.contains(table2)) continue;
                list.add(table2);
            }
            if (list.size() == 1) {
                FKArc arc = this.createArc();
                arc.setReverse(true);
                FKContainer table3 = (FKContainer)list.get(0);
                table3.addArc(arc);
                for (FKIndexAssociation fkey : sel_fkeys) {
                    arc.addFkey(fkey);
                }
                arc.addToAllDPVs();
                return arc;
            }
        }
        return null;
    }

    private List getSelectedTables(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof FKContainer)) continue;
            list.add(object);
        }
        return list;
    }

    private List getSelectedArcs(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof FKArc)) continue;
            list.add(object);
        }
        return list;
    }

    private List getSelectedFKeys(Object[] selectedObjects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            Object object = selectedObjects[i];
            if (!(object instanceof FKIndexAssociation)) continue;
            list.add(object);
        }
        return list;
    }

    private List getSelectedFKeys(Object[] selectedObjects, FKContainer table) {
        ArrayList<FKIndexAssociation> list = new ArrayList<FKIndexAssociation>();
        for (int i = 0; i < selectedObjects.length; ++i) {
            FKIndexAssociation fkey;
            Object object = selectedObjects[i];
            if (!(object instanceof FKIndexAssociation) || (fkey = (FKIndexAssociation)object).getContainerWithKeyObject() != table) continue;
            list.add(fkey);
        }
        return list;
    }

    public void addToArc(Object[] selectedObjects) {
    }

    public void removeFromArc(Object[] selectedObjects) {
    }

    public SchemaObject createSchemaObject(String name) {
        SchemaObject schemaObject = this.createSchemaObject();
        schemaObject.setName(name);
        return schemaObject;
    }

    public FKArcSet getArcSet() {
        if (this.fKArcs == null) {
            this.fKArcs = new FKArcSet(this);
            this.fKArcs.setDesign(this.getDesign());
        }
        return this.fKArcs;
    }

    public StorageDesignSet getSorageDesigns() {
        if (this.storageDesigns == null) {
            this.storageDesigns = new StorageDesignSet();
            this.storageDesigns.setDesign(this.getDesign());
        }
        return this.storageDesigns;
    }

    public TableSet getTableSet() {
        if (this.tableSet == null) {
            this.tableSet = new TableSet(this);
            this.tableSet.setDesign(this.getDesign());
            this.tableSet.setName(TABLE_SET_NAME);
            this.tableSet.addSetListener(this);
            this.tableSet.setParent(this);
        }
        return this.tableSet;
    }

    public SchemaObjectSet getSchemaObjectSet() {
        if (this.schemaObjectSet == null) {
            this.schemaObjectSet = new SchemaObjectSet(this);
            this.schemaObjectSet.setDesign(this.getDesign());
            this.schemaObjectSet.setName(SCHEMA_SET_NAME);
            this.schemaObjectSet.addSetListener(this);
            this.schemaObjectSet.setParent(this);
        }
        return this.schemaObjectSet;
    }

    public TableViewSet getTableViewSet() {
        if (this.viewSet == null) {
            this.viewSet = new TableViewSet(this);
            this.viewSet.setDesign(this.getDesign());
            this.viewSet.setParent(this);
            this.viewSet.addSetListener(this);
            this.viewSet.setName(VIEW_SET_NAME);
        }
        return this.viewSet;
    }

    public FKIndexAssociationSet getFKIndexAssociationSet() {
        if (this.fkAssociationSet == null) {
            this.fkAssociationSet = new FKIndexAssociationSet(this);
            this.fkAssociationSet.setDesign(this.getDesign());
            this.fkAssociationSet.setName(FK_SET_NAME);
            this.fkAssociationSet.setParent(this);
            this.fkAssociationSet.addSetListener(this);
        }
        return this.fkAssociationSet;
    }

    public TypeSubstitutionSet getTypeSubstitutionSet() {
        if (this.typeSubstitutionSet == null) {
            this.typeSubstitutionSet = new RelTypeSubstitutionSet(this);
            this.typeSubstitutionSet.setDesign(this.getDesign());
            this.typeSubstitutionSet.setName(TYPE_SUBSTITUTION_NAME);
            this.typeSubstitutionSet.setParent(this);
            this.typeSubstitutionSet.addSetListener(this);
        }
        return this.typeSubstitutionSet;
    }

    public TypeSubstitution createTypeSubstitution() {
        return this.getTypeSubstitutionSet().createTypeSubstitution(null);
    }

    public TypeSubstitution createTypeSubstitution(String id) {
        return this.getTypeSubstitutionSet().createTypeSubstitution(id);
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    @Override
    protected void fireChange(ObjectChangeEvent event) {
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    @Override
    public List getStorableSets() {
        ArrayList<DesignObjectSet> list = new ArrayList<DesignObjectSet>();
        list.add(this.getSchemaObjectSet());
        list.add(this.getTableSet());
        list.add(this.getTableViewSet());
        list.add(this.getFKIndexAssociationSet());
        list.add(this.getArcSet());
        return list;
    }

    public RelationalDesign getImportTo() {
        return this.importTo;
    }

    public void setImportTo(RelationalDesign importTo) {
        this.importTo = importTo;
    }

    public List<DBConnectionStamp> getImportConnectionStamps() {
        return this.importConnectionStamps;
    }

    public void setImportConnectionStamps(List<DBConnectionStamp> importConnectionStamps) {
        this.importConnectionStamps = importConnectionStamps;
    }

    public DBConnectionStamp createImportConnectionStamp() {
        DBConnectionStamp stamp = new DBConnectionStamp();
        this.importConnectionStamps.add(stamp);
        return stamp;
    }

    public DBConnectionStamp getImportConnectionStamp(int index) {
        if (!this.importConnectionStamps.isEmpty() && index != -1 && index < this.importConnectionStamps.size()) {
            return this.importConnectionStamps.get(index);
        }
        return null;
    }

    public void setImportConnectionStamp(DBConnectionStamp stamp, int index) {
        if (!this.importConnectionStamps.isEmpty() && index != -1 && index < this.importConnectionStamps.size()) {
            this.importConnectionStamps.set(index, stamp);
        }
    }

    public int findImportConnectionStamp(String importConnectionName) {
        if (importConnectionName != null) {
            for (int i = 0; i < this.importConnectionStamps.size(); ++i) {
                DBConnectionStamp stamp = this.importConnectionStamps.get(i);
                if (!importConnectionName.equals(stamp.getConnName())) continue;
                return i;
            }
        }
        return -1;
    }

    public int addImportConnectionStamp(DBConnectionStamp importConnectionStamp) {
        int index = this.findImportConnectionStamp(importConnectionStamp.getConnName());
        if (index == -1) {
            this.importConnectionStamps.add(importConnectionStamp);
            index = this.importConnectionStamps.size() - 1;
            this.setDirty(true);
        }
        return index;
    }

    public int getImportConnectionStampIndex() {
        return this.importConnectionStampIndex;
    }

    public void setImportConnectionStampIndex(int index) {
        this.importConnectionStampIndex = index;
    }

    public DBConnectionStamp getRedirectConnectionStamp() {
        return this.redirectConnectionStamp;
    }

    public void setRedirectConnectionStamp(DBConnectionStamp stamp) {
        this.redirectConnectionStamp = stamp;
    }

    public DBConnectionStamp createRedirectConnectionStamp() {
        return new DBConnectionStamp();
    }

    public List<DDLFileStamp> getImportDDLFileStamps() {
        return this.importDDLFileStamps;
    }

    public List getAllImportedObjects() {
        ArrayList list = new ArrayList();
        list.addAll(this.getImportedObjects(this.getSchemaObjectSet()));
        list.addAll(this.getImportedObjects(this.getTableSet()));
        list.addAll(this.getImportedObjects(this.getTableViewSet()));
        list.addAll(this.getImportedObjects(this.getFKIndexAssociationSet()));
        list.addAll(this.getImportedObjects(this.getArcSet()));
        list.addAll(this.getImportedObjects(this.getColumnSet()));
        list.addAll(this.getImportedObjects(this.getColumnViewSet()));
        list.addAll(this.getImportedObjects(this.getTypeSubstitutionSet()));
        return list;
    }

    private List getImportedObjects(DesignObjectSet set) {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        for (int i = 0; i < set.size(); ++i) {
            ModelObject obj = set.getElement(i);
            if (obj.getSourceConnName().equals("")) continue;
            list.add(obj);
        }
        return list;
    }

    private List getImportedObjects(ModelObjectSet set) {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        for (int i = 0; i < set.size(); ++i) {
            ModelObject obj = set.getElement(i);
            if (obj.getSourceConnName().equals("")) continue;
            list.add(obj);
        }
        return list;
    }

    public ColumnSet getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new ColumnSet(this);
            this.columnSet.setDesign(this.getDesign());
            this.columnSet.setName(COLUMN_SET_NAME);
            this.columnSet.setParent(this);
            this.columnSet.addSetListener(this);
        }
        return this.columnSet;
    }

    public ColumnViewSet getColumnViewSet() {
        if (this.columnViewSet == null) {
            this.columnViewSet = new ColumnViewSet(this);
            this.columnViewSet.setDesign(this.getDesign());
            this.columnViewSet.setName(COLUMN_VIEW_SET_NAME);
            this.columnViewSet.setParent(this);
            this.columnViewSet.addSetListener(this);
        }
        return this.columnViewSet;
    }

    public IndexAndConstraintNameController getIndexAndConstraintNameController() {
        if (this.indexAndConstraintNameController == null) {
            this.indexAndConstraintNameController = new IndexAndConstraintNameController();
        }
        return this.indexAndConstraintNameController;
    }

    public void setIndexAndConstraintNameController(IndexAndConstraintNameController indexAndConstraintNameController) {
        this.indexAndConstraintNameController = indexAndConstraintNameController;
    }

    public NameSpaceController getTablesAndViewsNameController() {
        if (this.tablesAndViewsNameController == null) {
            this.tablesAndViewsNameController = new NameSpaceController();
        }
        return this.tablesAndViewsNameController;
    }

    public GlobalIndexSet getGlobalIndexSet() {
        return this.getTableSet().getGlobalIndexSet();
    }

    public DesignObjectCollection getIndexOnlyPlaceHolderSet() {
        if (this.indexOnlySet == null) {
            this.indexOnlySet = new DesignObjectCollection();
            this.indexOnlySet.setDesign(this.getDesign());
            this.indexOnlySet.setName(INDEX_SET_NAME);
            this.indexOnlySet.setElementDescriptor(IndexSet.class);
            this.indexOnlySet.setParent(this);
        }
        return this.indexOnlySet;
    }

    @Override
    public RDBMSSite getSelectedRDBMSSite() {
        if (this.selectedRDBMSSite == null) {
            this.selectedRDBMSSite = this.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite();
        }
        return this.selectedRDBMSSite;
    }

    public StorageDesign getStorageDesign(RDBMSSite site) {
        StorageDesign storageDesign = this.getStorageDesignFactory().getStorageDesign(site);
        return storageDesign;
    }

    public StorageDesign getStorageDesign() {
        return this.getStorageDesign(this.getSelectedRDBMSSite());
    }

    public RelationalDesign getRelatedSyncModel() {
        return this.relatedSyncModel;
    }

    public void setRelatedSyncModel(RelationalDesign relatedSyncModel) {
        this.relatedSyncModel = relatedSyncModel;
    }

    public KeyObject getViewIndexByMatchingColumns(String schema, String table, List<String> columns) {
        if (schema != null && table != null && !columns.isEmpty()) {
            Object[] keys = this.getPKUK(schema, table);
            for (int i = 0; i < keys.length; ++i) {
                FKElement[] keyColumns = (FKElement[])((KeyObject)keys[i]).getColumns();
                if (keyColumns.length != columns.size()) continue;
                boolean mismatch = false;
                for (int j = 0; j < columns.size(); ++j) {
                    if (columns.get(j).equalsIgnoreCase(keyColumns[j].getName())) continue;
                    mismatch = true;
                    break;
                }
                if (mismatch) continue;
                return (KeyObject)keys[i];
            }
        }
        return null;
    }

    public Object[] getPKUK(String schema, String tableName) {
        ArrayList<KeyObject> list = new ArrayList<KeyObject>();
        FKContainer fkc = this.getTableSet().getBySchemaAndName(schema, tableName);
        if (fkc == null) {
            fkc = (FKContainer)this.getTableViewSet().getBySchemaAndName(schema, tableName);
        }
        if (fkc != null) {
            KeyObject[] keys = fkc.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                if (!keys[i].isPK() && !keys[i].isUnique()) continue;
                list.add(keys[i]);
            }
        }
        return list.toArray();
    }

    public DesignObjectCollection getIndexesWithoutFKIndexes() {
        DesignObjectCollection l = new DesignObjectCollection();
        for (Index idx : this.getTableSet().getGlobalIndexSet()) {
            if (idx.isFK()) continue;
            l.add(idx);
        }
        return l;
    }

    @Override
    public List getSearchableSets() {
        return this.getSearchableSets(false);
    }

    public List getSearchableSets(boolean global) {
        ArrayList<SearchSet> sets = new ArrayList<SearchSet>();
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Table.class), Table.class, this, this.getTableSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Column.class), Column.class, this, this.getColumnSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(ColumnView.class), ColumnView.class, this, this.getColumnViewSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(TableView.class), TableView.class, this, this.getTableViewSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(FKIndexAssociation.class), FKIndexAssociation.class, this, this.getFKIndexAssociationSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(Index.class), Index.class, this, this.getIndexesWithoutFKIndexes()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(SchemaObject.class), SchemaObject.class, this, this.getSchemaObjectSet()));
        sets.add(new SearchSet(ReportConstants.classToNameMap.get(FKArc.class), FKArc.class, this, this.getArcSet()));
        if (!global) {
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(Domain.class), Domain.class, this, this.getDesign().getDomainSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(StructuredType.class), StructuredType.class, this, this.getDesign().getDataTypesDesign().getStructuredTypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(CollectionType.class), CollectionType.class, this, this.getDesign().getDataTypesDesign().getCollectionTypeSet()));
            sets.add(new SearchSet(ReportConstants.classToNameMap.get(DistinctType.class), DistinctType.class, this, this.getDesign().getDataTypesDesign().getDistinctTypeSet()));
        }
        StorageDesign[] storageDesigns = this.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < storageDesigns.length; ++i) {
            StorageDesignOracle sdo;
            StorageDesign sd = storageDesigns[i];
            if (!sd.isOpen()) continue;
            if (sd instanceof StorageDesignOraclev9i) {
                sdo = (StorageDesignOraclev9i)sd;
                sets.addAll(((StorageDesignOraclev9i)sdo).getSearchableSets());
                continue;
            }
            if (sd instanceof StorageDesignOraclev10g) {
                sdo = (StorageDesignOraclev10g)sd;
                sets.addAll(((StorageDesignOraclev10g)sdo).getSearchableSets());
                continue;
            }
            if (!(sd instanceof StorageDesignOraclev11g)) continue;
            sdo = (StorageDesignOraclev11g)sd;
            sets.addAll(((StorageDesignOraclev11g)sdo).getSearchableSets());
        }
        return sets;
    }

    @Override
    public void changed(ModelObjectSet set, ModelObjectSetEvent event) {
    }

    @Override
    public StorableObject createObject(String objectType, String objectID, String name) {
        DesignObject object = null;
        if ("Table".equalsIgnoreCase(objectType)) {
            object = this.getTableSet().createTable(objectID);
        } else if ("View".equalsIgnoreCase(objectType)) {
            object = this.getTableViewSet().createTableView(objectID);
        } else if ("FKIndexAssociation".equalsIgnoreCase(objectType)) {
            FKIndexAssociation fk = new FKIndexAssociation(this);
            fk.setObjectID(objectID);
            object = fk;
        } else if ("FKArc".equalsIgnoreCase(objectType)) {
            object = this.getArcSet().createArc(objectID);
        } else if ("SchemaObject".equalsIgnoreCase(objectType)) {
            object = this.getSchemaObjectSet().createSchemaObject(objectID);
        }
        if (object != null && name != null && name.length() > 0) {
            object.setName(name);
        }
        return object;
    }

    @Override
    public Map getFolderToTypeMap() {
        if (this.f2tMap == null) {
            this.f2tMap = new LinkedHashMap();
            this.f2tMap.put("schema", "SchemaObject");
            this.f2tMap.put("table", "Table");
            this.f2tMap.put("view", "View");
            this.f2tMap.put("foreignkey", "FKIndexAssociation");
            this.f2tMap.put("arc", "FKArc");
        }
        return this.f2tMap;
    }

    @Override
    public String getStoragePath() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                String relPath = "rel";
                relPath = this.getDesign().getLoadedVersion() < 3.2f ? "relational" : "rel";
                String relID = this.getShortObjectID();
                relID = this.getDesign().getLoadedVersion() < 3.2f ? this.getObjectID() : (this.getDesign().getLoadedVersion() < 3.4f ? this.getPathIDString() : this.getShortObjectID());
                return new File(designPath, relPath + "/" + relID).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getStorageName() {
        String designPath = this.getDesign().getStoragePath();
        if (designPath != null && designPath.length() > 0) {
            try {
                String relPath = this.getShortObjectID();
                relPath = this.getDesign().getLoadedVersion() < 3.4f ? this.getPathIDString() : this.getShortObjectID();
                return new File(designPath, "rel/" + relPath + ".xml").getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object translateIdToObject(String propertyName, String id) {
        if ("selectedRDBMSSite".equalsIgnoreCase(propertyName)) {
            RDBMSSite site = this.getDesign().getRDBMSSiteSet().getByObjectID(id);
            if (site == null) {
                site = this.getDesign().getRDBMSSiteSet().getDefaultRDBMSSite();
            }
            return site;
        }
        return super.translateIdToObject(propertyName, id);
    }

    @Override
    public String translateObjectToID(String propertyName, Object object) {
        if ("selectedRDBMSSite".equalsIgnoreCase(propertyName) && object instanceof RDBMSSite) {
            return ((RDBMSSite)object).getObjectID();
        }
        return super.translateObjectToID(propertyName, object);
    }

    public void createArcsFromTableCheckConstraints() {
        Iterator it = this.getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            ArrayList oldArcs = new ArrayList();
            oldArcs.addAll(table.getArcs());
            Object[] tchecks = table.getCheckConstraints().toArray();
            for (int i = 0; i < tchecks.length; ++i) {
                TableLevelConstraint tch = (TableLevelConstraint)tchecks[i];
                FKArc arc = tch.createArcFromConstraint();
                if (arc == null) continue;
                tch.remove();
                table.setDirty(true);
                if (!oldArcs.contains(arc)) {
                    arc.setName(tch.getName());
                    continue;
                }
                arc.setDirty(true);
            }
        }
    }

    @Override
    public Collection getAllTopLevelObjects() {
        ArrayList collection = new ArrayList();
        this.getSchemaObjectSet().addAllElementsTo(collection);
        this.getTableSet().addAllElementsTo(collection);
        this.getTableViewSet().addAllElementsTo(collection);
        this.getFKIndexAssociationSet().addAllElementsTo(collection);
        this.getArcSet().addAllElementsTo(collection);
        return collection;
    }

    @Override
    public Note createNote() {
        Note note = this.getNoteSet().createNote(null);
        return note;
    }

    public NoteSet getNoteSet() {
        if (this.noteSet == null) {
            this.noteSet = new NoteSet(this);
            this.noteSet.setDesign(this.getDesign());
            this.noteSet.setName(NOTE_SET_NAME);
            this.noteSet.setParent(this);
            this.noteSet.addSetListener(this);
        }
        return this.noteSet;
    }

    public void resolveFKs() {
        Iterator it = this.getFKIndexAssociationSet().iterator();
        while (it.hasNext()) {
            String[] cs;
            KeyObject key;
            String cols;
            String lname;
            FKIndexAssociation fk = (FKIndexAssociation)it.next();
            if (fk.getRemoteTable() != null || (lname = fk.getReferredTableLongName()) == null || lname.isEmpty()) continue;
            FKContainer table = (FKContainer)this.getTableSet().getByLongName(lname);
            if (table == null) {
                table = (FKContainer)this.getTableViewSet().getByLongName(lname);
            }
            if (table == null || (cols = fk.getReferredColumnNames()) == null || cols.isEmpty() || (key = table.getPk_UK_forColumns(cs = cols.split(","))) == null) continue;
            fk.setKeyObject(key);
            if (fk.getLocalFKIndex() != null && fk.getLocalFKIndex().getElementsCollection().size() > 0) {
                FKElement[] elems = fk.getLocalFKIndex().getElementsCollection().toArray(new FKElement[0]);
                fk.swapFKColumnsWith(elems);
            }
            fk.setDirty(true);
            fk.addToAllDPVs();
        }
    }

    public Map getContainersMap() {
        DesignObject dob;
        HashMap<String, DesignObject> map = new HashMap<String, DesignObject>(this.getTableSet().size() + this.getTableViewSet().size());
        Iterator it = this.getTableViewSet().iterator();
        while (it.hasNext()) {
            dob = (DesignObject)it.next();
            map.put(dob.getLongName().toUpperCase(), dob);
        }
        it = this.getTableSet().iterator();
        while (it.hasNext()) {
            dob = (DesignObject)it.next();
            map.put(dob.getLongName().toUpperCase(), dob);
        }
        return map;
    }

    public void addJoins(List<DiagramProcessor.JoinsHolder> jholders) {
        for (DiagramProcessor.JoinsHolder jh : jholders) {
            FKContainer cont = null;
            cont = "TABLE".equalsIgnoreCase(jh.type) ? this.getTableSet().getBySchemaAndName(jh.schema, jh.table) : (FKContainer)this.getTableViewSet().getBySchemaAndName(jh.schema, jh.table);
            cont.getImpliedFKeys().addAll(jh.joins);
            cont.removeFK_DuplicatingJoins();
        }
    }

    @Override
    public DesignPartView getMainView() {
        if (this.mainView == null) {
            this.mainView = new DPVRelational(this);
            this.mainView.setDPVId(this.getIDGenerator().createNewID());
        }
        return this.mainView;
    }

    @Override
    protected DesignPartView createDesignPartSubView(String name) {
        DPVRelationalSubView dpv = new DPVRelationalSubView(this);
        String nameVer = this.getNameVersion(this.subViews, name);
        dpv.setName(nameVer);
        DesignPartViewPlaceHolder dpvPH = new DesignPartViewPlaceHolder((DesignPart)this, dpv);
        dpvPH.setParent(this.subViews);
        this.subViews.add(dpvPH);
        return dpv;
    }

    public List getDropableSets() {
        ArrayList<ModelObject> list = new ArrayList<ModelObject>();
        list.add(this.getTableSet());
        list.add(this.getIndexOnlyPlaceHolderSet());
        list.add(this.getTableViewSet());
        list.add(this.getFKIndexAssociationSet());
        return list;
    }

    public boolean isSDWCompare() {
        return this.isSDWCompare;
    }

    public void setSDWCompare(boolean isSDWCompare) {
        this.isSDWCompare = isSDWCompare;
    }
}

