/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.List;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSequence;
import oracle.dbtools.crest.model.design.compare.storage.oracle.SequenceComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PermissionsOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public class CSSBSequenceOracle10vg
extends AbstractCSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceSeqSel = (CompareObjectSelection)object;
        SequenceOracle sourceSequence = (SequenceOracle)sourceSeqSel.getObject();
        this.storageDesign = sourceSequence.getStorageDesign();
        if (sourceSeqSel.canBeCreate()) {
            this.appendComment(oldbuffer, sourceSequence);
            StringBuffer buffer = new StringBuffer();
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "CREATE");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "SEQUENCE");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(sourceSequence));
            String advancedComment = buffer.toString();
            boolean includeDefault = this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL();
            this.appendStartWith(buffer, sourceSequence, prettyPrint);
            this.appendIncrementBy(buffer, sourceSequence, includeDefault, prettyPrint);
            this.appendMaxValue(buffer, sourceSequence, includeDefault, prettyPrint);
            this.appendMinValue(buffer, sourceSequence, includeDefault, prettyPrint);
            this.appendCycle(buffer, sourceSequence, includeDefault, prettyPrint);
            this.appendCache(buffer, sourceSequence, sourceSequence, includeDefault, prettyPrint);
            this.appendOrder(buffer, sourceSequence, includeDefault, prettyPrint);
            this.appendSession(buffer, sourceSequence, includeDefault, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
            CSSBSequenceOracle10vg.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementCreateSequence();
            CSSBSequenceOracle10vg.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendPermissions(oldbuffer, sourceSequence, prettyPrint);
        } else {
            boolean needAlter = false;
            boolean needRecreate = false;
            SequenceComparatorOracle propsComparator = (SequenceComparatorOracle)sourceSeqSel.getPropertiesComparator();
            List propsList = propsComparator.getPropertiesList();
            for (EngPropertyHolder ph : propsList) {
                if (!ph.isModified() || !ph.isSelected() || ph.isFiltered()) continue;
                if (ph.getName().equals(PropertyNames.NAME) || ph.getName().equals(PropertyNames.START_WITH)) {
                    needRecreate = true;
                    continue;
                }
                if (ph.getName().equals(PropertyNames.USER_NAME)) {
                    if (!this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) continue;
                    needRecreate = true;
                    continue;
                }
                needAlter = true;
            }
            if (needRecreate) {
                SequenceOracle seqForUser;
                UserOracle user;
                CSSBDropSequence cssbDropSequence = new CSSBDropSequence();
                cssbDropSequence.doAppend(oldbuffer, object, prettyPrint);
                this.appendComment(oldbuffer, sourceSequence);
                StringBuffer buffer = new StringBuffer();
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "CREATE");
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "SEQUENCE");
                if (this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL() && (user = (seqForUser = propsComparator.getSequenceForProperty(PropertyNames.USER_NAME)).getUser()) != null) {
                    CSSBSequenceOracle10vg.appendString(buffer, this.storageDesign.getFormatedName(user));
                    CSSBSequenceOracle10vg.appendString(buffer, '.');
                }
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(propsComparator.getSequenceForProperty(PropertyNames.NAME)));
                String advancedComment = buffer.toString();
                boolean includeDefault = this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL();
                this.appendStartWith(buffer, propsComparator.getSequenceForProperty(PropertyNames.START_WITH), prettyPrint);
                this.appendIncrementBy(buffer, propsComparator.getSequenceForProperty(PropertyNames.INCREMENT_BY), includeDefault, prettyPrint);
                this.appendMaxValue(buffer, propsComparator.getSequenceForProperty(PropertyNames.MAX_VALUE), includeDefault, prettyPrint);
                this.appendMinValue(buffer, propsComparator.getSequenceForProperty(PropertyNames.MIN_VALUE), includeDefault, prettyPrint);
                this.appendCycle(buffer, propsComparator.getSequenceForProperty(PropertyNames.CYCLE), includeDefault, prettyPrint);
                this.appendCache(buffer, propsComparator.getSequenceForProperty(PropertyNames.NOCACHE), propsComparator.getSequenceForProperty(PropertyNames.CACHE), includeDefault, prettyPrint);
                this.appendOrder(buffer, propsComparator.getSequenceForProperty(PropertyNames.ORDER), includeDefault, prettyPrint);
                this.appendSession(buffer, propsComparator.getSequenceForProperty(PropertyNames.SESSION), includeDefault, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
                CSSBSequenceOracle10vg.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementCreateSequence();
                CSSBSequenceOracle10vg.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendPermissions(oldbuffer, sourceSequence, prettyPrint);
            } else if (needAlter) {
                SequenceOracle targetSequence = (SequenceOracle)sourceSeqSel.getCorrespondentNode().getObject();
                StringBuffer buffer = new StringBuffer();
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "ALTER");
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "SEQUENCE");
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(targetSequence));
                String advancedComment = buffer.toString();
                boolean cacheDone = false;
                for (EngPropertyHolder ph : propsList) {
                    if (!ph.isModified() || !ph.isSelected() || ph.isFiltered()) continue;
                    if (ph.getName().equals(PropertyNames.INCREMENT_BY)) {
                        this.appendIncrementBy(buffer, sourceSequence, true, prettyPrint);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.MAX_VALUE)) {
                        this.appendMaxValue(buffer, sourceSequence, true, prettyPrint);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.MIN_VALUE)) {
                        this.appendMinValue(buffer, sourceSequence, true, prettyPrint);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.CYCLE)) {
                        this.appendCycle(buffer, sourceSequence, true, prettyPrint);
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.NOCACHE) || ph.getName().equals(PropertyNames.CACHE)) {
                        if (cacheDone) continue;
                        this.appendCache(buffer, propsComparator.getSequenceForProperty(PropertyNames.NOCACHE), propsComparator.getSequenceForProperty(PropertyNames.CACHE), true, prettyPrint);
                        cacheDone = true;
                        continue;
                    }
                    if (ph.getName().equals(PropertyNames.ORDER)) {
                        this.appendOrder(buffer, sourceSequence, true, prettyPrint);
                        continue;
                    }
                    if (!ph.getName().equals(PropertyNames.SESSION)) continue;
                    this.appendSession(buffer, sourceSequence, true, prettyPrint);
                }
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
                CSSBSequenceOracle10vg.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterSequence();
                CSSBSequenceOracle10vg.appendNewLine(oldbuffer, prettyPrint, 0);
            }
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SequenceOracle;
    }

    private void appendStartWith(StringBuffer buffer, SequenceOracle sequence, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getStartWith())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "START");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "WITH");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, sequence.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getIncrementBy())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "INCREMENT");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "BY");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, sequence.getIncrementBy());
        } else if (includeDefault) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "INCREMENT");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "BY");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "1");
        }
    }

    private void appendMaxValue(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getMaxValue())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "MAXVALUE");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, sequence.getMaxValue());
        } else if (includeDefault) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
    }

    private void appendMinValue(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault, boolean prettyPrint) {
        if (this.isNotEmpty(sequence.getMinValue())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "MINVALUE");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, sequence.getMinValue());
        } else if (includeDefault) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "NOMINVALUE");
        }
    }

    private void appendCycle(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(sequence.getCycle())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "CYCLE");
        } else if (includeDefault) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "NOCYCLE");
        }
    }

    private void appendCache(StringBuffer buffer, SequenceOracle sequenceNoCache, SequenceOracle sequenceCache, boolean includeDefault, boolean prettyPrint) {
        if ("YES".equals(sequenceNoCache.getNoCache())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "NOCACHE");
        } else if (this.isNotEmpty(sequenceCache.getCache())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "CACHE");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, sequenceCache.getCache());
        } else if (includeDefault) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "CACHE");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "20");
        }
    }

    private void appendOrder(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(sequence.getOrder())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "ORDER");
        } else if (includeDefault) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "NOORDER");
        }
    }

    private void appendSession(StringBuffer buffer, SequenceOracle sequence, boolean includeDefault, boolean prettyPrint) {
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            if ("YES".equalsIgnoreCase(sequence.getSession())) {
                CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "SESSION");
            } else if (includeDefault) {
                CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "GLOBAL");
            }
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, SequenceOracle sequence, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        for (PermissionsOraclev10g permissions : ((StorageDesignOracle)this.storageDesign).getPermissionsSet()) {
            if (permissions.getSequence() == null || !permissions.getSequence().equals(sequence)) continue;
            if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                CSSBSequenceOracle10vg.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBSequenceOracle10vg.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, permissions);
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "GRANT");
                CSSBSequenceOracle10vg.appendStringWithSpace(buffer, permissions.getPrivileges());
                this.appendObject(buffer, permissions, prettyPrint);
                this.appendTo(buffer, permissions, this.storageDesign);
                advancedComment = buffer.toString();
                this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
            }
            if (permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
            this.appendComment(buffer, permissions);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "GRANT");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, permissions.getPrivilegesWithGrantOption());
            this.appendObject(buffer, permissions, prettyPrint);
            this.appendTo(buffer, permissions, this.storageDesign);
            this.appendGrantOption(buffer, permissions);
            advancedComment = buffer.toString();
            this.appendHierrarchyOption(buffer, permissions, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
        }
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if (permissions.getSequence() != null) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "ON");
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(permissions.getSequence()));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev10g permissions) {
        if (permissions.getRole() == null) {
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev10g permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            CSSBSequenceOracle10vg.appendNewLine(buffer, prettyPrint, 1);
            CSSBSequenceOracle10vg.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }
}

