/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.Comparator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;

public abstract class ModelIDObjectSet
extends ModelObjectSet {
    public static ObjectIDComparator OBJECT_ID_COMPARATOR = new ObjectIDComparator();

    @Override
    public void add(ModelObject object) {
        if (object instanceof ModelIDObject) {
            ModelIDObject idObject = (ModelIDObject)object;
            if (idObject.getDesign() == null) {
                idObject.setDesign(this.getDesign());
            }
            if (idObject.getObjectID() == null && this.getDesign() != null) {
                idObject.createGlobalID();
            }
        }
        super.add(object);
    }

    public abstract ModelIDObject createElement(String var1);

    public boolean containsId(String id) {
        return null != this.getById(id);
    }

    public ModelIDObject getById(String id) {
        for (ModelIDObject object : this) {
            if (!object.getObjectID().equals(id)) continue;
            return object;
        }
        return null;
    }

    public ModelIDObject getByShortId(String id) {
        if (id != null) {
            for (ModelIDObject object : this) {
                if (!id.equals(object.getShortObjectID())) continue;
                return object;
            }
        }
        return null;
    }

    public ModelIDObject getByRemoteObjectId(String remoteID) {
        if (remoteID != null && !"".equals(remoteID)) {
            for (ModelIDObject object : this) {
                if (!remoteID.equals(object.getRemoteObjectID())) continue;
                return object;
            }
        }
        return null;
    }

    public boolean remove(String ObjectID) {
        for (ModelIDObject object : this) {
            if (!object.getObjectID().equals(ObjectID)) continue;
            return this.remove(object);
        }
        return false;
    }

    @Override
    public Comparator getElementSorter() {
        return LONG_NAME_COMPARATOR;
    }

    public boolean canCreateElement() {
        return false;
    }

    @Override
    public boolean canSort() {
        if (this.getDesign() != null) {
            return !this.getDesign().isLoading();
        }
        return false;
    }

    static class ObjectIDComparator
    implements Comparator {
        ObjectIDComparator() {
        }

        public int compare(Object one, Object two) {
            if (one instanceof ModelIDObject && two instanceof ModelIDObject) {
                return ((ModelIDObject)one).getObjectID().compareTo(((ModelIDObject)two).getObjectID());
            }
            return one.toString().compareTo(two.toString());
        }
    }
}

