/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import jakarta.json.JsonObject;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Logger;
import oracle.dbtools.crest.exports.ddl.scheduling.SchedulerDDLMaker;
import oracle.dbtools.crest.exports.ddl.scheduling.SchedulingSchemaDDL;
import oracle.dbtools.crest.exports.ddl.scheduling.compare.SchedulerCDDLMaker;
import oracle.dbtools.crest.imports.metadata.RequestManager;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedulerChainAll;
import oracle.dbtools.crest.imports.metadata.scheduling.MOH_PLSQL_Dependencies;
import oracle.dbtools.crest.model.scheduling.JSONToPropertiesObject;
import oracle.dbtools.crest.model.scheduling.SchedulerChain;
import oracle.dbtools.crest.model.scheduling.SchedulerFileWatcher;
import oracle.dbtools.crest.model.scheduling.SchedulerJob;
import oracle.dbtools.crest.model.scheduling.SchedulerJobClass;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.crest.model.scheduling.SchedulerProgram;
import oracle.dbtools.crest.model.scheduling.SchedulerSchedule;
import oracle.dbtools.crest.model.scheduling.SchedulerWindow;
import oracle.dbtools.crest.model.scheduling.SchedulerWindowGroup;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerJobCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerObjectCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerProgramCompare;
import oracle.dbtools.crest.model.scheduling.compare.SchedulerWindowGroupCompare;

public class SDW_SchedUtil {
    public static String CHAIN_ALL_JSON = "chain_all_json";
    public static String PLSQL_DEPENDENCIES = "plsql_dependencies";
    public static String PLSQL_BLOCK_DEPENDENCIES = "plsql_block_dependencies";
    public static String PLSQL_SCHEMA_DEPENDENCIES = "plsql_schema_dependencies";
    public static String CHAIN_RULES = "chain_rules";
    public static String SCHEMA_DDL = "schema_ddl";
    public static String SCHEDULER_CHAIN = "scheduler_chain";

    public static boolean isSupportedType(String type) {
        return type != null && "scheduler_job".equalsIgnoreCase(type) || "scheduler_program".equalsIgnoreCase(type) || "scheduler_schedule".equalsIgnoreCase(type) || "scheduler_file_watcher".equalsIgnoreCase(type) || "scheduler_window".equalsIgnoreCase(type) || "scheduler_job_class".equalsIgnoreCase(type) || "scheduler_window_group".equalsIgnoreCase(type) || CHAIN_ALL_JSON.equalsIgnoreCase(type) || CHAIN_RULES.equalsIgnoreCase(type) || SCHEMA_DDL.equalsIgnoreCase(type) || SCHEDULER_CHAIN.equalsIgnoreCase(type) || PLSQL_DEPENDENCIES.equalsIgnoreCase(type) || PLSQL_BLOCK_DEPENDENCIES.equalsIgnoreCase(type) || PLSQL_SCHEMA_DEPENDENCIES.equalsIgnoreCase(type);
    }

    public static String getNewObjectDDL(Connection conn, String objectType, JsonObject jdoc) {
        SchedulerObject obj = SDW_SchedUtil.createObject(objectType);
        JSONToPropertiesObject tr = new JSONToPropertiesObject();
        tr.processProperties(obj, jdoc);
        ArrayList<SchedulerObject> objects = new ArrayList<SchedulerObject>();
        objects.add(obj);
        SchedulerDDLMaker ddlm = new SchedulerDDLMaker();
        ddlm.generateDDLContent(objects);
        return ddlm.getContent();
    }

    static SchedulerObject createObject(String type) {
        SchedulerObject obj = null;
        if (type.equals("scheduler_job")) {
            return new SchedulerJob();
        }
        if (type.equals("scheduler_program")) {
            return new SchedulerProgram();
        }
        if (type.equals("scheduler_schedule")) {
            return new SchedulerSchedule();
        }
        if (type.equals("scheduler_file_watcher")) {
            return new SchedulerFileWatcher();
        }
        if (type.equals("scheduler_window")) {
            return new SchedulerWindow();
        }
        if (type.equals("scheduler_job_class")) {
            return new SchedulerJobClass();
        }
        if (type.equals("scheduler_window_group")) {
            return new SchedulerWindowGroup();
        }
        if (type.equals(SCHEDULER_CHAIN)) {
            return new SchedulerChain();
        }
        return obj;
    }

    static SchedulerObjectCompare createObjectCompare(String type, SchedulerObject source, SchedulerObject target) {
        SchedulerObjectCompare obj = null;
        if (type.equals("scheduler_job")) {
            return new SchedulerJobCompare(source, target);
        }
        if (type.equals("scheduler_program")) {
            return new SchedulerProgramCompare(source, target);
        }
        if (type.equals("scheduler_schedule")) {
            return new SchedulerObjectCompare(source, target);
        }
        if (type.equals("scheduler_file_watcher")) {
            return new SchedulerObjectCompare(source, target);
        }
        if (type.equals("scheduler_window")) {
            return new SchedulerObjectCompare(source, target);
        }
        if (type.equals("scheduler_window_group")) {
            return new SchedulerWindowGroupCompare(source, target);
        }
        if (type.equals("scheduler_job_class")) {
            return new SchedulerObjectCompare(source, target);
        }
        return obj;
    }

    public static String getExistingObjectDDL(Connection conn, String type, String schema, String name, Logger log) {
        if (SCHEMA_DDL.equals(type)) {
            return SchedulingSchemaDDL.getSchemaDDL(conn, schema);
        }
        DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
        SchedulerObject job = handler.getSchedulerObject(conn, type, schema, name);
        ArrayList<SchedulerObject> objects = new ArrayList<SchedulerObject>();
        objects.add(job);
        SchedulerDDLMaker ddlc = new SchedulerDDLMaker();
        ddlc.generateDDLContent(objects);
        return ddlc.getContent();
    }

    public static String getCompareObjectDDL(Connection conn, String objectType, JsonObject jdoc, String schemaName, String objectName) {
        SchedulerObject source = SDW_SchedUtil.createObject(objectType);
        JSONToPropertiesObject tr = new JSONToPropertiesObject();
        tr.processProperties(source, jdoc);
        DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
        SchedulerObject job = handler.getSchedulerObject(conn, objectType, schemaName, objectName);
        SchedulerObjectCompare comp = SDW_SchedUtil.createObjectCompare(objectType, source, job);
        ArrayList<SchedulerObjectCompare> objects = new ArrayList<SchedulerObjectCompare>();
        objects.add(comp);
        SchedulerCDDLMaker ddlc = new SchedulerCDDLMaker();
        ddlc.generateDDLContent(objects);
        return ddlc.getContent();
    }

    public static void addPLSQLObjectDependencies(Connection conn, RequestManager.ContentWrapper cw, String schema, String name, String type, String dictionaryType, Logger log) {
        if (!(schema == null || schema.isEmpty() || name == null || name.isEmpty() || type == null || type.isEmpty())) {
            DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
            if (PLSQL_DEPENDENCIES.equalsIgnoreCase(type)) {
                if (dictionaryType.equalsIgnoreCase("job")) {
                    MOH_PLSQL_Dependencies moh = new MOH_PLSQL_Dependencies(handler);
                    String res = moh.getJobPLSQL_Dependencies(conn, cw, schema, name, dictionaryType);
                    cw.writeBytes(res);
                } else if (dictionaryType.equalsIgnoreCase("program")) {
                    MOH_PLSQL_Dependencies moh = new MOH_PLSQL_Dependencies(handler);
                    String res = moh.getProgramPLSQL_Dependencies(conn, cw, schema, name, dictionaryType);
                    cw.writeBytes(res);
                } else {
                    MOH_PLSQL_Dependencies moh = new MOH_PLSQL_Dependencies(handler);
                    String res = moh.getObjectDependencies(conn, cw, schema, name, dictionaryType);
                    cw.writeBytes(res);
                }
            }
        }
    }

    public static void addPLSQLBlockDependencies(Connection conn, RequestManager.ContentWrapper cw) {
        String owner = cw.getParameter("schema");
        String type = cw.getParameter("type");
        DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
        if (PLSQL_BLOCK_DEPENDENCIES.equalsIgnoreCase(type)) {
            MOH_PLSQL_Dependencies moh = new MOH_PLSQL_Dependencies(handler);
            String res = moh.getPLSQL_blockDependencies(conn, cw, owner);
            cw.writeBytes(res);
        }
    }

    public static void addPLSQLSchemaDependencies(Connection conn, RequestManager.ContentWrapper cw) {
        String owner = cw.getParameter("schema");
        String type = cw.getParameter("type");
        DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
        if (PLSQL_SCHEMA_DEPENDENCIES.equalsIgnoreCase(type)) {
            MOH_PLSQL_Dependencies moh = new MOH_PLSQL_Dependencies(handler);
            String res = moh.getPLSQL_SchemaDependencies(conn, cw, owner);
            cw.writeBytes(res);
        }
    }

    public static boolean addObjectDetails(Connection conn, PrintWriter wr, String type, String schema, String name, Logger log) {
        if (!(schema == null || schema.isEmpty() || name == null || name.isEmpty() || type == null || type.isEmpty())) {
            DBMExtractionHandlerScheduling handler = new DBMExtractionHandlerScheduling(conn);
            if (CHAIN_ALL_JSON.equalsIgnoreCase(type)) {
                MOHSchedulerChainAll moh = new MOHSchedulerChainAll(handler);
                wr.print(moh.getChainAllJSON(conn, schema, name));
                return true;
            }
            if (CHAIN_RULES.equalsIgnoreCase(type)) {
                MOHSchedulerChainAll moh = new MOHSchedulerChainAll(handler);
                wr.print(moh.getChainValidationRules(conn, schema, name));
                return true;
            }
            SchedulerObject job = handler.getSchedulerObject(conn, type, schema, name);
            if (job != null) {
                wr.print(job.toJSONString(true));
                return true;
            }
            return false;
        }
        return false;
    }

    public static String getSchemaSchedulingDDL(Connection conn, RequestManager.ContentWrapper cw, String schema) {
        return SchedulingSchemaDDL.getSchemaDDL(conn, cw, schema);
    }

    public static void main(String[] args) {
    }
}

