/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.scheduling;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.scheduling.DBMExtractionHandlerScheduling;
import oracle.dbtools.crest.imports.metadata.scheduling.MOHSchedHandler;
import oracle.dbtools.crest.model.scheduling.SchedulerObject;
import oracle.dbtools.util.Closeables;

public class MOHSchedulerChainAll
extends MOHSchedHandler {
    public static final String OBJECT_TYPE = "CHAIN_ALL_JSON";
    public static final String DBA_TABLE = "SYS.DBA_SCHEDULER_CHAINS";
    public static final String ALL_TABLE = "SYS.ALL_SCHEDULER_CHAINS";
    HashSet<String> stepSet = new HashSet();
    List<StepHelp> steps = new ArrayList<StepHelp>();
    List<RuleHelp> rules = new ArrayList<RuleHelp>();
    List<ValidationRule> validationRules = new ArrayList<ValidationRule>();
    private static final JsonBuilderFactory jsonFactory = Json.createBuilderFactory(null);

    public MOHSchedulerChainAll(DBMExtractionHandlerScheduling dbmeHandler) {
        super(dbmeHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getChainAllJSON(Connection conn, String owner, String chainName) {
        ResultSet rs;
        PreparedStatement ps;
        String res;
        block7: {
            block8: {
                this.stepSet.clear();
                this.steps.clear();
                this.rules.clear();
                this.validationRules.clear();
                res = "";
                ps = null;
                rs = null;
                String sql = "select ords_sdw_scheduler.get_chain_json(?,?) json from dual";
                ps = conn.prepareStatement(sql);
                ps.setString(1, owner);
                ps.setString(2, chainName);
                rs = ps.executeQuery();
                if (!rs.next()) break block7;
                String value = null;
                Clob clob = rs.getClob(1);
                if (clob == null) break block8;
                value = clob.getSubString(1L, (int)clob.length());
                clob.free();
                if (value == null || value.isEmpty()) break block8;
                JsonObject copy = this.copyChain(conn, value);
                String string = copy.toString();
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                return string;
            }
            try {
                break block7;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, ps});
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getChainValidationRules(Connection conn, String owner, String chainName) {
        ResultSet rs;
        PreparedStatement ps;
        String res;
        block7: {
            block8: {
                JsonArray rules;
                this.stepSet.clear();
                this.steps.clear();
                this.rules.clear();
                this.validationRules.clear();
                res = "[]";
                ps = null;
                rs = null;
                String sql = "select ords_sdw_scheduler.get_chain_json(?,?) json from dual";
                ps = conn.prepareStatement(sql);
                ps.setString(1, owner);
                ps.setString(2, chainName);
                rs = ps.executeQuery();
                if (!rs.next()) break block7;
                String value = null;
                Clob clob = rs.getClob(1);
                if (clob == null || (value = clob.getSubString(1L, (int)clob.length())) == null || value.isEmpty() || (rules = this.getValidationRules(conn, value)) == null) break block8;
                String string = rules.toString();
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                return string;
            }
            try {
                break block7;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, ps});
        return res;
    }

    JsonObject copyChain(Connection conn, String value) {
        JsonObject jdoc = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            jdoc = Json.createReader((InputStream)stream).readObject();
            if (jdoc != null) {
                return this.copyChain(conn, jdoc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    JsonObject copyChain(Connection conn, JsonObject jdoc) {
        JsonArray ar;
        JsonObjectBuilder ob = jsonFactory.createObjectBuilder();
        jdoc.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            JsonValue val = (JsonValue)e.getValue();
            if (key.equalsIgnoreCase("steps") && val instanceof JsonArray) {
                JsonArray ar = this.processChainSteps(conn, val);
                ob.add(key, (JsonValue)ar);
            } else {
                if (key.equalsIgnoreCase("rules") && val instanceof JsonArray) {
                    this.processRules((JsonArray)val);
                }
                ob.add(key, val);
            }
        });
        List<ValidationRule> vrules = this.checkValidationRules(this.steps, this.rules);
        if (vrules.size() > 0 && (ar = this.buildValidationRules(vrules)) != null && ar.size() > 0) {
            ob.add("validation_rules", (JsonValue)ar);
        }
        return ob.build();
    }

    JsonArray getValidationRules(Connection conn, String value) {
        JsonObject jdoc = null;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
            jdoc = Json.createReader((InputStream)stream).readObject();
            if (jdoc != null) {
                jdoc.entrySet().forEach(e -> {
                    String key = (String)e.getKey();
                    JsonValue val = (JsonValue)e.getValue();
                    if (key.equalsIgnoreCase("steps") && val instanceof JsonArray) {
                        this.processChainSteps(conn, val);
                    } else if (key.equalsIgnoreCase("rules") && val instanceof JsonArray) {
                        this.processRules((JsonArray)val);
                    }
                });
                List<ValidationRule> vrules = this.checkValidationRules(this.steps, this.rules);
                JsonArray ar = this.buildValidationRules(vrules);
                return ar;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    JsonArray buildValidationRules(List<ValidationRule> vrules) {
        JsonArrayBuilder arb = jsonFactory.createArrayBuilder();
        try {
            for (ValidationRule vr : vrules) {
                JsonObjectBuilder ob = jsonFactory.createObjectBuilder();
                ob.add("name", vr.name);
                ob.add("type", vr.type);
                if (vr.objects.isEmpty()) continue;
                ob.add("objects", vr.objects);
                JsonObject jo = ob.build();
                arb.add((JsonValue)jo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arb.build();
    }

    public List<ValidationRule> checkValidationRules(List<StepHelp> steps, List<RuleHelp> rules) {
        ArrayList<ValidationRule> vrules = new ArrayList<ValidationRule>();
        this.checkRulesWithMissingStep(vrules, steps, rules);
        this.checkStepsWithoutStart(vrules, steps, rules);
        this.checkStepsWithoutTransition(vrules, steps, rules);
        this.checkStepsWithDisabledProgram(vrules, steps, rules);
        this.checkStepsDependingOnInvalidObjects(vrules, steps, rules);
        return vrules;
    }

    void checkStepsDependingOnInvalidObjects(List<ValidationRule> vrules, List<StepHelp> steps, List<RuleHelp> rules) {
        ValidationRule vr = new ValidationRule();
        vr.name = "Steps depending on invalid objects";
        vr.type = "Warning";
        for (StepHelp sh : steps) {
            if (sh.procedureName != null && "INVALID".equalsIgnoreCase(sh.procedureStatus)) {
                String str = "Step " + sh.stepName + " Program " + sh.progName + " - invalid procedure " + sh.progAction;
                vr.objects = vr.objects.isEmpty() ? str : vr.objects + "\n" + str;
            }
            if (sh.dependencies.size() <= 0) continue;
            for (OHelp oh : sh.dependencies) {
                if (oh.type != null && !oh.type.isEmpty() && "INVALID".equalsIgnoreCase(oh.status)) {
                    String str = "Step " + sh.stepName + " - invalid " + oh.type + " " + oh.owner + "." + oh.name;
                    vr.objects = vr.objects.isEmpty() ? str : vr.objects + "\n" + str;
                }
                if (oh.items == null || oh.items.size() <= 0) continue;
                for (OHelp ohd : oh.items) {
                    if (ohd.type == null || ohd.type.isEmpty() || !"INVALID".equalsIgnoreCase(ohd.status)) continue;
                    String str = "Step " + sh.stepName + " Program " + sh.progName + " - invalid " + ohd.type + " " + ohd.owner + "." + ohd.name;
                    if (vr.objects.isEmpty()) {
                        vr.objects = str;
                        continue;
                    }
                    vr.objects = vr.objects + "\n" + str;
                }
            }
        }
        if (!vr.objects.isEmpty()) {
            vrules.add(vr);
        }
    }

    void checkStepsWithDisabledProgram(List<ValidationRule> vrules, List<StepHelp> steps, List<RuleHelp> rules) {
        ValidationRule vr = new ValidationRule();
        vr.name = "Steps with disabled Program";
        vr.type = "Warning";
        for (StepHelp sh : steps) {
            if (sh.progName == null || sh.progEnabled == null || sh.pEnabled) continue;
            String str = "Step " + sh.stepName + " uses disabled program " + sh.progOwner + "." + sh.progName;
            if (vr.objects.isEmpty()) {
                vr.objects = str;
                continue;
            }
            vr.objects = vr.objects + "\n" + str;
        }
        if (!vr.objects.isEmpty()) {
            vrules.add(vr);
        }
    }

    void checkRulesWithMissingStep(List<ValidationRule> vrules, List<StepHelp> steps, List<RuleHelp> rules) {
        ValidationRule vr = new ValidationRule();
        vr.name = "Usage of missing steps in chain rule";
        vr.type = "Error";
        for (RuleHelp rh : rules) {
            String name;
            String[] parts;
            String res = null;
            if (rh.sources != null && !rh.sources.isEmpty()) {
                for (String part : parts = rh.sources.split(",")) {
                    name = MOHSchedulerChainAll.getName(part).toUpperCase();
                    if ("BEGIN".equalsIgnoreCase(name) || this.stepSet.contains(name)) continue;
                    res = res == null ? rh.getLongName() + " - " + name : res + ", " + name;
                }
            }
            if (rh.targets != null && !rh.targets.isEmpty()) {
                for (String part : parts = rh.targets.split(",")) {
                    name = MOHSchedulerChainAll.getName(part).toUpperCase();
                    if ("END".equalsIgnoreCase(name) || this.stepSet.contains(name)) continue;
                    res = res == null ? rh.getLongName() + " - " + name : res + ", " + name;
                }
            }
            if (res == null) continue;
            vr.objects = vr.objects + "\n" + res;
        }
        if (!vr.objects.isEmpty()) {
            vrules.add(vr);
        }
    }

    void checkStepsWithoutStart(List<ValidationRule> vrules, List<StepHelp> steps, List<RuleHelp> rules) {
        ValidationRule vr = new ValidationRule();
        HashSet<String> valid = new HashSet<String>();
        vr.name = "Steps without start";
        vr.type = "Error";
        for (RuleHelp rh : rules) {
            String[] parts;
            if (rh.targets == null || rh.targets.isEmpty()) continue;
            for (String part : parts = rh.targets.split(",")) {
                String name = MOHSchedulerChainAll.getName(part).toUpperCase();
                if (!this.stepSet.contains(name)) continue;
                valid.add(name);
            }
        }
        TreeSet<String> set = new TreeSet<String>(this.stepSet);
        set.removeAll(valid);
        if (set.size() > 0) {
            for (String name : set) {
                if (vr.objects.isEmpty()) {
                    vr.objects = name;
                    continue;
                }
                vr.objects = vr.objects + "\n" + name;
            }
            vrules.add(vr);
        }
    }

    void checkStepsWithoutTransition(List<ValidationRule> vrules, List<StepHelp> steps, List<RuleHelp> rules) {
        ValidationRule vr = new ValidationRule();
        HashSet<String> valid = new HashSet<String>();
        vr.name = "Steps without transition to another step or to the end";
        vr.type = "Error";
        for (RuleHelp rh : rules) {
            String[] parts;
            if (rh.sources == null || rh.sources.isEmpty()) continue;
            for (String part : parts = rh.sources.split(",")) {
                String name = MOHSchedulerChainAll.getName(part).toUpperCase();
                if (!this.stepSet.contains(name)) continue;
                valid.add(name);
            }
        }
        TreeSet<String> set = new TreeSet<String>(this.stepSet);
        set.removeAll(valid);
        if (set.size() > 0) {
            for (String name : set) {
                if (vr.objects.isEmpty()) {
                    vr.objects = name;
                    continue;
                }
                vr.objects = vr.objects + "\n" + name;
            }
            vrules.add(vr);
        }
    }

    JsonArray processChainSteps(Connection conn, JsonValue val) {
        HashSet<String> userSet = new HashSet<String>();
        JsonArrayBuilder arb = jsonFactory.createArrayBuilder();
        try {
            if (val instanceof JsonArray) {
                this.collectSteps((JsonArray)val, this.steps);
                if (this.steps.size() > 0) {
                    boolean dba = this.isDBA(conn);
                    MOHSchedulerChainAll.getUsers(conn, userSet, dba);
                    for (StepHelp sh : this.steps) {
                        JsonArray ar = null;
                        List<OHelp> helps = MOHSchedulerChainAll.processStep(conn, sh, userSet, dba);
                        if (helps.size() > 0) {
                            ar = MOHSchedulerChainAll.buildArray(helps);
                        }
                        if (ar != null && ar.size() > 0) {
                            JsonObject st = MOHSchedulerChainAll.copyJsonObject(sh.step, "procedure_used_tables", (JsonValue)ar);
                            arb.add((JsonValue)st);
                            continue;
                        }
                        arb.add((JsonValue)sh.step);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arb.build();
    }

    void processRules(JsonArray arr) {
        try {
            arr.forEach(arrval -> {
                try {
                    if (arrval instanceof JsonObject) {
                        RuleHelp rh = new RuleHelp();
                        JsonObject jrule = (JsonObject)arrval;
                        this.rules.add(rh);
                        String ruleName = jrule.getString("rule_name");
                        ruleName = MOHSchedulerChainAll.getName(ruleName);
                        try {
                            rh.owner = jrule.getString("rule_owner");
                            rh.name = ruleName;
                            rh.conditiion = jrule.getString("condition");
                            rh.action = jrule.getString("action");
                            rh.sources = jrule.getString("sources");
                            rh.targets = jrule.getString("targets");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static JsonObject copyJsonObject(JsonObject jdoc, String addKey, JsonValue addValue) {
        JsonObjectBuilder ob = jsonFactory.createObjectBuilder();
        jdoc.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            JsonValue val = (JsonValue)e.getValue();
            ob.add(key, val);
        });
        ob.add(addKey, addValue);
        return ob.build();
    }

    static JsonArray buildArray(List<OHelp> helps) {
        JsonArray ar = null;
        JsonArrayBuilder arb = jsonFactory.createArrayBuilder();
        try {
            for (OHelp oh : helps) {
                JsonArray arit;
                if (oh.type == null || oh.type.isEmpty()) continue;
                JsonObjectBuilder ob = jsonFactory.createObjectBuilder().add("owner", oh.owner).add("name", oh.name).add("type", oh.type != null ? oh.type : "").add("status", oh.status != null ? oh.status : "");
                if (oh.items != null && (arit = MOHSchedulerChainAll.buildArray(oh.items)) != null) {
                    ob.add("items", (JsonValue)arit);
                }
                JsonObject obj = ob.build();
                arb.add((JsonValue)obj);
            }
            ar = arb.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ar;
    }

    static boolean containsNonTable(List<OHelp> helps) {
        for (OHelp oh : helps) {
            if (oh.type == null || oh.type.isEmpty() || "TABLE".equalsIgnoreCase(oh.type)) continue;
            return true;
        }
        return false;
    }

    void collectSteps(JsonArray jarr, List<StepHelp> steps) {
        jarr.forEach(arrval -> {
            block7: {
                try {
                    JsonObject step;
                    if (!(arrval instanceof JsonObject)) break block7;
                    StepHelp st = new StepHelp();
                    st.step = step = (JsonObject)arrval;
                    steps.add(st);
                    String stepName = step.getString("step_name");
                    stepName = MOHSchedulerChainAll.getName(stepName);
                    this.stepSet.add(stepName.toUpperCase());
                    try {
                        JsonValue ss = (JsonValue)step.get((Object)"program_name");
                        if (ss != JsonValue.NULL) {
                            st.stepName = step.getString("step_name");
                            st.progOwner = step.getString("program_owner");
                            st.progName = step.getString("program_name");
                            st.progType = step.getString("program_type", "");
                            st.progEnabled = step.getString("program_enabled", "false");
                            st.pEnabled = "TRUE".equalsIgnoreCase(st.progEnabled);
                            st.progAction = step.getString("program_action", "");
                            if ("STORED_PROCEDURE".equalsIgnoreCase(st.progType)) {
                                st.procedureName = st.progAction;
                                JsonValue val = (JsonValue)step.get((Object)"procedure_status");
                                if (val != null && val != JsonValue.NULL) {
                                    st.procedureStatus = step.getString("procedure_status", "");
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static String getName(String name) {
        if (name != null) {
            return Token.getName(name);
        }
        return name;
    }

    static String getString(JsonObject obj, String key) {
        JsonValue val = (JsonValue)obj.get((Object)key);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    static List<OHelp> processStep(Connection conn, StepHelp sh, Set<String> userSet, boolean dba) {
        ArrayList<OHelp> helps = new ArrayList<OHelp>();
        if (sh != null && sh.progType != null) {
            if (sh.progType.equalsIgnoreCase("PLSQL_BLOCK")) {
                String progOwner = sh.progOwner;
                HashMap<String, OHelp> nameMap = new HashMap<String, OHelp>();
                SqlRecognizer r = new SqlRecognizer(sh.progAction);
                Map objects = r.getObjectReferences();
                for (String name : objects.values()) {
                    OHelp oh;
                    if (name.equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE") || name.equalsIgnoreCase("SYS_CONTEXT") || nameMap.get((oh = MOHSchedulerChainAll.getOHelp(name, progOwner, userSet)).getLongName()) != null) continue;
                    nameMap.put(oh.getLongName(), oh);
                    helps.add(oh);
                }
                if (helps.size() > 0) {
                    sh.dependencies = helps;
                    MOHSchedulerChainAll.getObjectType(conn, nameMap, helps, dba);
                    MOHSchedulerChainAll.getDepencencies(conn, nameMap, helps, dba);
                }
            } else if (sh.progType.equalsIgnoreCase("STORED_PROCEDURE")) {
                JsonArray jarr;
                List<OHelp> list;
                HashMap nameMap = new HashMap();
                if (sh.step != null && (list = MOHSchedulerChainAll.processProcedureStep(jarr = sh.step.getJsonArray("procedure_used_tables"))).size() > 0) {
                    sh.dependencies = list;
                }
            }
        }
        return helps;
    }

    static List<OHelp> processProcedureStep(JsonArray arr) {
        ArrayList<OHelp> helps = new ArrayList<OHelp>();
        try {
            if (arr != null) {
                arr.forEach(arrval -> {
                    block6: {
                        try {
                            if (!(arrval instanceof JsonObject)) break block6;
                            OHelp rh = new OHelp();
                            JsonObject jobj = (JsonObject)arrval;
                            try {
                                List<OHelp> items;
                                rh.owner = jobj.getString("owner");
                                rh.name = jobj.getString("name");
                                rh.type = jobj.getString("type");
                                JsonValue val = (JsonValue)jobj.get((Object)"status");
                                if (val != null && val != JsonValue.NULL) {
                                    rh.status = jobj.getString("status");
                                }
                                helps.add(rh);
                                JsonArray jarr = jobj.getJsonArray("items");
                                if (jarr != null && jarr != JsonValue.NULL && (items = MOHSchedulerChainAll.processProcedureStep(jarr)).size() > 0) {
                                    helps.addAll(items);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return helps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getDepencencies(Connection conn, Map<String, OHelp> nameMap, List<OHelp> helps, boolean dba) {
        String sql = "select REFERENCED_OWNER, REFERENCED_NAME, REFERENCED_TYPE from " + (dba ? "SYS.DBA_DEPENDENCIES" : "SYS.ALL_DEPENDENCIES") + "\r\n   where owner = ? and name =  ? and type <> 'PACKAGE'  and referenced_name not in    \r\n    ('SYS_STUB_FOR_PURITY_ANALYSIS','STANDARD','JSON_OBJECT_T','JSON_ELEMENT_T','DUAL','ODCIVARCHAR2LIST', 'JSON_ARRAY_T')  \r\n    and referenced_type in ('TABLE','VIEW','PACKAGE','PROCEDURE','FUNCTION') and referenced_owner <> 'SYS'\r\n    and REFERENCED_NAME <> name";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement(sql);
            for (OHelp oh : helps) {
                if (oh.type == null || !oh.type.equalsIgnoreCase("VIEW") && !oh.type.equalsIgnoreCase("VIEW") && !oh.type.equalsIgnoreCase("PROCEDURE") && !oh.type.equalsIgnoreCase("FUNCTION") && !oh.type.equalsIgnoreCase("PACKAGE BODY")) continue;
                ps.setString(1, oh.owner);
                ps.setString(2, oh.name);
                rs = ps.executeQuery();
                if (rs == null) continue;
                ArrayList<OHelp> items = new ArrayList<OHelp>();
                while (rs.next()) {
                    try {
                        OHelp o = new OHelp();
                        o.owner = rs.getString(1);
                        o.name = rs.getString(2);
                        o.type = rs.getString(3);
                        items.add(o);
                        if (nameMap.get(o.getLongName()) != null) continue;
                        nameMap.put(o.getLongName(), o);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (items.size() > 0) {
                    oh.items = items;
                }
                rs.close();
                if (items.size() <= 0) continue;
                MOHSchedulerChainAll.getObjectType(conn, nameMap, items, dba);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                throw throwable;
            }
            Closeables.close((Object[])new AutoCloseable[]{rs, ps});
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, ps});
    }

    static String getInClause(List<OHelp> helps) {
        String res = null;
        for (OHelp oh : helps) {
            if (res == null) {
                res = "(('" + oh.owner + "','" + oh.name + "')";
                continue;
            }
            res = (String)res + ",('" + oh.owner + "','" + oh.name + "')";
        }
        res = res + ")";
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getObjectType(Connection conn, Map<String, OHelp> nameMap, List<OHelp> helps, boolean dba) {
        ResultSet rs;
        PreparedStatement ps;
        block8: {
            String sql = "with function f1 return clob is\ncl1 clob;\ncursor ss is  \n      select owner||'.'|| object_name||','|| object_type||','||status||'!!!' as res from " + (dba ? "SYS.DBA_OBJECTS" : "SYS.ALL_OBJECTS") + "  \n       where (owner,object_name) in ";
            String sql2 = "\nBEGIN\n    CL1 := '';\n    FOR SR IN SS LOOP\n        IF CL1 is null THEN\n            CL1 := SR.res;\n        ELSE\n            CL1 := CL1 ||  SR.res;\n        END IF;\n    END LOOP;\n    RETURN CL1;\nEND;\nselect f1 from dual";
            sql = sql + MOHSchedulerChainAll.getInClause(helps) + " \n and object_type <> 'PACKAGE' ;" + sql2;
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                if (!rs.next()) break block8;
                String value = null;
                try {
                    Clob clob = rs.getClob(1);
                    if (clob != null && (value = clob.getSubString(1L, (int)clob.length())) != null && !value.isEmpty()) {
                        String[] vals;
                        for (String val : vals = value.split("!!!")) {
                            String[] parts = val.split(",");
                            OHelp oh = nameMap.get(parts[0]);
                            if (oh == null) continue;
                            oh.type = parts[1];
                            oh.status = parts[2];
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, ps});
    }

    static OHelp getOHelp(String value, String progOwner, Set<String> userSet) {
        OHelp oh = new OHelp();
        if (value.indexOf(46) > 0) {
            String[] parts = value.split("\\.");
            if (parts.length == 3) {
                oh.owner = MOHSchedulerChainAll.getNamePart(parts[0]);
                oh.name = MOHSchedulerChainAll.getNamePart(parts[1]);
            } else if (parts.length == 2) {
                String sch = MOHSchedulerChainAll.getNamePart(parts[0]);
                if (userSet.contains(sch)) {
                    oh.owner = sch;
                    oh.name = MOHSchedulerChainAll.getNamePart(parts[1]);
                } else {
                    oh.owner = progOwner;
                    oh.name = MOHSchedulerChainAll.getNamePart(parts[0]);
                }
            }
        } else {
            oh.owner = progOwner;
            oh.name = MOHSchedulerChainAll.getNamePart(value);
        }
        return oh;
    }

    static String getNamePart(String val) {
        if (val.startsWith("\"")) {
            return Token.getName(val);
        }
        return val.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getUsers(Connection conn, Set<String> userSet, boolean dba) {
        ResultSet rs;
        PreparedStatement ps;
        block9: {
            String sql = "with function f1(dba varchar2) return clob is\ncl1 clob;\ncursor sa is  \n      select username  from SYS.ALL_USERS;\ncursor sd is  \n      select username  from SYS.DBA_USERS;      \nBEGIN\n    CL1 := '';\n    if dba = 'TRUE' then\n        FOR SR IN SA LOOP\n            IF CL1 is null THEN\n                CL1 := SR.USERNAME;\n            ELSE\n                CL1 := CL1 || ',' || SR.USERNAME;\n            END IF;\n        END LOOP;\n    else\n        FOR SR IN SD LOOP\n            IF CL1 is null THEN\n                CL1 := SR.USERNAME;\n            ELSE\n                CL1 := CL1 || ',' || SR.USERNAME;\n            END IF;\n        END LOOP;\n    end if;\n    RETURN CL1;\nEND;\nselect f1(" + (dba ? "'TRUE'" : "'FALSE'") + ") from dual";
            ps = null;
            rs = null;
            try {
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                if (!rs.next()) break block9;
                String value = null;
                try {
                    Clob clob = rs.getClob(1);
                    if (clob != null) {
                        value = clob.getSubString(1L, (int)clob.length());
                        if (value != null && !value.isEmpty()) {
                            String[] vals;
                            for (String val : vals = value.split(",")) {
                                userSet.add(val);
                            }
                        }
                        clob.free();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new AutoCloseable[]{rs, ps});
                    throw throwable;
                }
                Closeables.close((Object[])new AutoCloseable[]{rs, ps});
            }
        }
        Closeables.close((Object[])new AutoCloseable[]{rs, ps});
    }

    @Override
    public List<SchedulerObject> generate(Connection conn, List<DBObject> selectedObjects) throws Exception {
        boolean dba = this.isDBA(conn);
        String sql = this.getSQL(dba);
        ArrayList<SchedulerObject> res = new ArrayList<SchedulerObject>();
        Object statement = null;
        Object rs = null;
        Closeables.close((Object[])new AutoCloseable[]{rs, statement});
        return res;
    }

    String getSQL(boolean dba) {
        String sql = "select \r\nOWNER,\r\nWINDOW_NAME,\r\nRESOURCE_PLAN,\r\nSCHEDULE_OWNER,\r\nSCHEDULE_NAME,\r\nSCHEDULE_TYPE,\r\nto_char( START_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as START_DATE,\nREPEAT_INTERVAL,\r\nto_char(END_DATE ,'IYYY-MM-DD\"T\"HH24:MI:SS TZR') as END_DATE,\nDURATION,\r\nWINDOW_PRIORITY,\r\nENABLED,\r\nCOMMENTS from " + (dba ? DBA_TABLE : ALL_TABLE) + " \nwhere owner = ? and WINDOW_NAME = ?";
        return sql;
    }

    public static class ValidationRule {
        String type;
        String name;
        String objects = "";
    }

    public static class OHelp {
        String owner;
        String name;
        String type;
        String status = "";
        List<OHelp> items;

        public String toString() {
            return this.getLongName();
        }

        String getLongName() {
            Object res = this.owner;
            if (res == null || ((String)res).isEmpty()) {
                return this.name;
            }
            res = (String)res + "." + this.name;
            return res;
        }
    }

    public static class RuleHelp {
        String owner;
        String name;
        String conditiion;
        String action;
        String sources;
        String targets;

        public String toString() {
            return this.getLongName();
        }

        String getLongName() {
            Object res = this.owner;
            if (res != null && !((String)res).isEmpty()) {
                res = (String)res + "." + this.name;
            }
            return res;
        }
    }

    public static class StepHelp {
        JsonObject step;
        String stepName;
        String progOwner;
        String progName;
        String progType;
        String progAction;
        String progEnabled;
        boolean pEnabled;
        List<OHelp> dependencies = new ArrayList<OHelp>();
        String procedureName;
        String procedureStatus;
    }
}

