/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.offline;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.offline.DB2FileReader;
import oracle.dbtools.migration.workbench.offline.Messages;
import oracle.dbtools.migration.workbench.offline.XMLHandler;

public class Db2OfflineCapturer
extends AbstractOfflineCapturer {
    private String m_inputDirectory;
    private DB2FileReader m_parser;
    private MdSchema m_ctxSchema;
    private DBObjectId m_ctxSchemaId;
    private DBObjectId m_ctxConnectionId;
    private MdCatalog m_ctxCatalog;
    private Properties m_properties;
    protected Connection m_repositoryConnection = null;

    protected String captureInitializeImpl(String string, Properties properties) throws OfflineCaptureException {
        this.m_inputDirectory = string;
        this.m_parser = new DB2FileReader(this.m_inputDirectory, this.getEncoding());
        this.m_properties = properties;
        ArrayList arrayList = this.getSelectedDatabaseList();
        if (arrayList != null) {
            for (String string2 : arrayList) {
                this.addDatabaseToCapture(string2);
            }
        }
        return "Db2Offline";
    }

    public void captureStarting() {
        String string = this.getNextDatabase();
    }

    public void cleanUp() throws OfflineCaptureException {
        this.m_parser.closeStreams();
    }

    public String[] generateScripts(String string, int n) throws OfflineCaptureException {
        String[] stringArray = this.getFilesToWrite(n);
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (String string2 : stringArray) {
            String string3 = string2.substring(string2.lastIndexOf(47) + 1);
            stringArray2[n2++] = string3;
            this.writeFile(string, string2, string3);
        }
        return stringArray2;
    }

    protected String[] getFilesToWrite(int n) {
        String string = "/oracle/dbtools/migration/workbench/db2v9/resources/";
        String[] stringArray = n == 2 ? new String[]{string + "startDump.sh", string + "getForeignKeys.sh", string + "getProcedures.sh", string + "db2v9.ocp"} : new String[]{string + "startDump.bat", string + "db2v9.ocp"};
        return stringArray;
    }

    public String[] getScriptFiles(int n) throws OfflineCaptureException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        block23: {
            this.getContextValues(captureContext);
            try {
                if ("MD_CATALOGS".equals(string)) {
                    String string2 = null;
                    this.m_parser.setFileToRead("connect.dat");
                    string2 = this.m_parser.lastLine(this.m_parser.getLineReader());
                    if (string2 != null) {
                        this.captureCatalog(captureContext, string2);
                        return;
                    }
                    break block23;
                }
                if ("MD_SCHEMAS".equals(string)) {
                    this.m_parser.setFileToRead("schemas.dat");
                    BufferedReader bufferedReader = this.m_parser.getLineReader();
                    try {
                        String string3;
                        while ((string3 = bufferedReader.readLine()) != null && string3.trim().length() > 0) {
                            this.captureSchema(captureContext, string3);
                        }
                        break block23;
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                        break block23;
                    }
                }
                if ("MD_TABLES".equals(string)) {
                    this.captureTables(captureContext);
                    this.captureIndexes(captureContext);
                    this.captureConstraints(captureContext);
                    this.captureTriggers(captureContext);
                } else if ("MD_VIEWS".equals(string)) {
                    this.captureViews(captureContext);
                } else if (string.equals("MD_INDEXES")) {
                } else if (string.equals("MD_TRIGGERS")) {
                } else if (string.equals("MD_STORED_PROGRAMS")) {
                    this.captureStoredProgram(captureContext);
                } else if (string.equals("MD_CONSTRAINTS")) {
                } else if (string.equals("MD_SYNONYMS")) {
                    this.captureSynonyms(captureContext);
                }
            }
            finally {
                this.m_parser.closeStreams();
            }
        }
    }

    private void captureIndexes(final CaptureContext captureContext) throws PersistenceException {
        Object object;
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        CloseableIterator closeableIterator = persistenceUtility.getTablesForSchemaId(this.m_ctxSchemaId);
        final HashMap<String, DBObjectId> hashMap = new HashMap<String, DBObjectId>();
        while (closeableIterator.hasNext()) {
            object = (MdTable)closeableIterator.next();
            String string = object.getTableName();
            hashMap.put(string, object.getKey());
        }
        closeableIterator.close();
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/indexes.dat");
        object = new HashMap();
        this.m_parser.doParse(new XMLHandler(8, (Map)object, persistenceUtility){
            final /* synthetic */ Map val$indexMap;
            final /* synthetic */ PersistenceUtility val$util;
            {
                this.val$indexMap = map2;
                this.val$util = persistenceUtility;
                super(n);
            }

            @Override
            public void rowCompleted() throws PersistenceException {
                DBObjectId dBObjectId;
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                String string = stringArray[1];
                String string2 = stringArray[2];
                String string3 = stringArray[4];
                String string4 = stringArray[5];
                String string5 = stringArray[6];
                String string6 = stringArray[7];
                DBObjectId dBObjectId2 = (DBObjectId)hashMap.get(string3);
                if (dBObjectId2 == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, Messages.getString("Db295OfflineCapturer.11", new String[]{string}));
                    return;
                }
                MdIndexe mdIndexe = (MdIndexe)this.val$indexMap.get(string);
                if (mdIndexe == null) {
                    mdIndexe = new MdIndexe(dBObjectId2);
                    mdIndexe.setIndexName(string);
                    if (string4.equals("U")) {
                        mdIndexe.setIndexType("UNIQUE");
                    } else if (string4.equals("P")) {
                        mdIndexe.setIndexType("PRIMARY");
                    } else {
                        mdIndexe.setIndexType("NON_UNIQUE");
                    }
                    mdIndexe.addProperty(new AdditionalProperty("INDEX_TYPE", string2), Db2OfflineCapturer.this.m_ctxConnectionId);
                    dBObjectId = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), mdIndexe.getIndexName());
                    captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
                    mdIndexe = (MdIndexe)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdIndexe);
                    dBObjectId.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)dBObjectId);
                    this.val$indexMap.put(string, mdIndexe);
                }
                dBObjectId = this.val$util.getIdForColumn(mdIndexe.getTableId(), string5);
                MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), dBObjectId, Integer.valueOf(Integer.parseInt(string6)));
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), mdIndexe.getIndexName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdIndexDetail = (MdIndexDetail)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdIndexDetail);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        });
    }

    private void captureConstraints(CaptureContext captureContext) {
        this.capturePrimaryKeyConstraints(captureContext);
        this.captureForeignKeyConstraints(captureContext);
        this.captureCheckConstraints(captureContext);
    }

    private void captureCheckConstraints(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/checkConstraints.dat");
        this.m_parser.doParse(new XMLHandler(5){
            Map<String, MdConstraint> constrNameList;
            {
                super(n);
                this.constrNameList = new HashMap<String, MdConstraint>();
            }

            @Override
            public void rowCompleted() throws PersistenceException {
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null || stringArray[3] == null || stringArray[4] == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Constraint invalid: " + stringArray[0]);
                    return;
                }
                PersistenceUtility persistenceUtility = Db2OfflineCapturer.this.getStorer().getPersistenceUtility();
                String string = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[3];
                DBObjectId dBObjectId = persistenceUtility.getIdForTable(Db2OfflineCapturer.this.m_ctxSchemaId, string3);
                MdConstraint mdConstraint = new MdConstraint(dBObjectId, "DB2LANG");
                mdConstraint.setConstraintType("CHECK");
                mdConstraint.setName(string);
                mdConstraint.setConstraintText(string2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdConstraint = (MdConstraint)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdConstraint);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        });
    }

    private void captureForeignKeyConstraints(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/foreignKeys.dat");
        this.m_parser.doParse(new XMLHandler(11){
            Map<String, MdConstraint> constrNameList;
            {
                super(n);
                this.constrNameList = new HashMap<String, MdConstraint>();
            }

            @Override
            public void rowCompleted() throws PersistenceException {
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null || stringArray[3] == null || stringArray[4] == null || stringArray[5] == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Constraint invalid: " + stringArray[0]);
                    return;
                }
                String string = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[4];
                String string4 = stringArray[5];
                String string5 = stringArray[6];
                String string6 = stringArray[7];
                String string7 = stringArray[8];
                String string8 = stringArray[9];
                String string9 = stringArray[10];
                PersistenceUtility persistenceUtility = Db2OfflineCapturer.this.getStorer().getPersistenceUtility();
                DBObjectId dBObjectId = persistenceUtility.getIdForSchema((DBObjectId)captureContext.getContextVariable("CATALOGID"), string3);
                DBObjectId dBObjectId2 = persistenceUtility.getIdForTable(dBObjectId, string4);
                if (string8.trim().equals("F")) {
                    MdConstraint mdConstraint;
                    DBObjectId dBObjectId3 = persistenceUtility.getIdForTable(Db2OfflineCapturer.this.m_ctxSchemaId, string2);
                    if (this.constrNameList.get(string) == null) {
                        mdConstraint = new MdConstraint(dBObjectId3, "DB2LANG");
                        mdConstraint.setName(string);
                        mdConstraint.setConstraintType("FOREIGN KEY");
                        mdConstraint.setComments(string9);
                        mdConstraint.setReftableId(dBObjectId2);
                        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
                        captureContext.getAudience().fireListeners(captureEvent);
                        mdConstraint = (MdConstraint)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdConstraint);
                        this.constrNameList.put(string, mdConstraint);
                        captureEvent.setEventId(4);
                        captureContext.getAudience().fireListeners(captureEvent);
                    }
                    if ((mdConstraint = this.constrNameList.get(string)) != null) {
                        int n = Integer.parseInt(string7);
                        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string5);
                        captureContext.getAudience().fireListeners(captureEvent);
                        MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                        mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                        mdConstraintDetail = (MdConstraintDetail)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                        captureEvent.setEventId(4);
                        captureContext.getAudience().fireListeners(captureEvent);
                        captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string6);
                        captureContext.getAudience().fireListeners(captureEvent);
                        mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n + 1));
                        mdConstraintDetail.setRefFlag("Y");
                        DBObjectId dBObjectId4 = persistenceUtility.getIdForColumn(dBObjectId2, string6);
                        mdConstraintDetail.setColumnId(dBObjectId4);
                        mdConstraintDetail = (MdConstraintDetail)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                        captureEvent.setEventId(4);
                        captureContext.getAudience().fireListeners(captureEvent);
                    }
                } else {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, Messages.getString("Db295OfflineCapturer.14", new String[]{string, string8}));
                    return;
                }
            }
        });
    }

    private void capturePrimaryKeyConstraints(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/primarykeys.dat");
        this.m_parser.doParse(new XMLHandler(7){
            Map<String, MdConstraint> constrNameList;
            {
                super(n);
                this.constrNameList = new HashMap<String, MdConstraint>();
            }

            @Override
            public void rowCompleted() throws PersistenceException {
                CaptureEvent captureEvent;
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null || stringArray[3] == null || stringArray[4] == null || stringArray[5] == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Constraint invalid: " + stringArray[0]);
                    return;
                }
                String string = stringArray[0];
                PersistenceUtility persistenceUtility = Db2OfflineCapturer.this.getStorer().getPersistenceUtility();
                String string2 = stringArray[1];
                String string3 = stringArray[2];
                String string4 = stringArray[3];
                String string5 = stringArray[4];
                String string6 = stringArray[5];
                String string7 = stringArray[6];
                String string8 = null;
                if ("P".equals(string2.trim())) {
                    string8 = "PK";
                } else if ("U".equals(string2.trim())) {
                    string8 = "UNIQUE";
                }
                String string9 = string + string4 + string3;
                MdConstraint mdConstraint = this.constrNameList.get(string9);
                DBObjectId dBObjectId = persistenceUtility.getIdForTable(Db2OfflineCapturer.this.m_ctxSchemaId, string4);
                if (mdConstraint == null && string8 != null) {
                    if (dBObjectId == null) {
                        Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, Messages.getString("Db295OfflineCapturer.17", new String[]{string4, string}));
                        return;
                    }
                    MdConstraint mdConstraint2 = new MdConstraint(dBObjectId, "DB2LANG");
                    mdConstraint2.setName(string);
                    mdConstraint2.setConstraintType(string8);
                    mdConstraint2.setComments(string7);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint2.getName());
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdConstraint2 = (MdConstraint)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdConstraint2);
                    this.constrNameList.put(string9, mdConstraint2);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                } else if (string8 == null) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, Messages.getString("Db295OfflineCapturer.14", new String[]{string, string2}));
                    return;
                }
                mdConstraint = this.constrNameList.get(string9);
                if (mdConstraint != null) {
                    int n = Integer.parseInt(string6);
                    captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), string5);
                    captureContext.getAudience().fireListeners(captureEvent);
                    MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(n));
                    DBObjectId dBObjectId2 = persistenceUtility.getIdForColumn(dBObjectId, string5);
                    mdConstraintDetail.setColumnId(dBObjectId2);
                    mdConstraintDetail = (MdConstraintDetail)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                }
            }
        });
    }

    private void getContextValues(CaptureContext captureContext) throws PersistenceException {
        this.m_ctxSchemaId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        this.m_ctxConnectionId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        this.m_ctxCatalog = (MdCatalog)captureContext.getContextVariable("CATALOG");
        this.m_ctxSchema = null;
        if (this.m_ctxSchemaId != null) {
            try {
                this.m_ctxSchema = MdSchema.retrieveExistingInstance((PersistenceManager)MigrationAddin.getPersistenceManager(), (DBObjectId)this.m_ctxSchemaId);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, noSuchObjectException.getStackTrace()[0].toString(), noSuchObjectException);
            }
        }
    }

    private void captureTriggers(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/triggers.dat");
        this.m_parser.doParse(new XMLHandler(10){

            @Override
            public void rowCompleted() throws PersistenceException {
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                String string = stringArray[1];
                String string2 = stringArray[2];
                String string3 = stringArray[4];
                String string4 = stringArray[5];
                String string5 = stringArray[7];
                String string6 = stringArray[8];
                PersistenceUtility persistenceUtility = Db2OfflineCapturer.this.getStorer().getPersistenceUtility();
                DBObjectId dBObjectId = persistenceUtility.getIdForTable(Db2OfflineCapturer.this.m_ctxSchemaId, string3);
                MdTrigger mdTrigger = new MdTrigger(dBObjectId, string4, "DB2LANG");
                mdTrigger.setTriggerName(string);
                mdTrigger.setComments(string6);
                mdTrigger.setTriggerEvent(string4);
                mdTrigger.setNativeSql(string5);
                mdTrigger.setCreatedBy(string2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string);
                captureContext.getAudience().fireListeners(captureEvent);
                Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdTrigger);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        });
    }

    private void captureStoredProgram(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/routines.dat");
        this.m_parser.doParse(new XMLHandler(6){

            @Override
            public void rowCompleted() throws PersistenceException {
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                String string = stringArray[1];
                String string2 = stringArray[2];
                String string3 = stringArray[3];
                String string4 = stringArray[5];
                MdStoredProgram mdStoredProgram = new MdStoredProgram(Db2OfflineCapturer.this.m_ctxSchemaId, "DB2LANG");
                mdStoredProgram.setName(string);
                mdStoredProgram.setProgramtype(string2);
                mdStoredProgram.setNativeSql(string3);
                if (string4 != null && string4.length() > 0) {
                    mdStoredProgram.setComments(string4);
                }
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), mdStoredProgram.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdStoredProgram = (MdStoredProgram)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        });
    }

    private void captureViews(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/views.dat");
        this.m_parser.doParse(new XMLHandler(6){

            @Override
            public void rowCompleted() throws PersistenceException {
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                String string = stringArray[1];
                String string2 = stringArray[2];
                String string3 = stringArray[3];
                MdView mdView = new MdView(Db2OfflineCapturer.this.m_ctxSchemaId, "DB2LANG");
                mdView.setViewName(string);
                mdView.setNativeSql(string2);
                mdView.setCreatedBy(string3);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), mdView.getViewName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdView = (MdView)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        });
    }

    private void captureTables(final CaptureContext captureContext) {
        Object object = "";
        if (this.m_ctxCatalog != null && !this.m_ctxCatalog.getDummyFlag().equals("Y")) {
            object = this.m_ctxCatalog.getCatalogName() + ".";
        }
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        object = (String)object + this.m_ctxSchema.getName() + ".";
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/tables.dat");
        Object object2 = object;
        this.m_parser.doParse(new XMLHandler(8, (String)object2){
            String previousTableName;
            int _currentOrder;
            DBObjectId tableId;
            final /* synthetic */ String val$fQualifiedName;
            {
                this.val$fQualifiedName = string;
                super(n);
                this._currentOrder = 0;
            }

            @Override
            public void rowCompleted() throws PersistenceException {
                CaptureAudience captureAudience;
                MdTable mdTable;
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                String string = this.val$fQualifiedName + stringArray[1];
                if (!string.equals(this.previousTableName)) {
                    this._currentOrder = 0;
                    this.previousTableName = string;
                    mdTable = new MdTable(Db2OfflineCapturer.this.m_ctxSchemaId, stringArray[1], string);
                    captureAudience = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TABLES"), mdTable.getTableName());
                    captureContext.getAudience().fireListeners((CaptureEvent)captureAudience);
                    mdTable = (MdTable)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdTable);
                    this.tableId = mdTable.getKey();
                    captureAudience.setEventId(4);
                    captureContext.getAudience().fireListeners((CaptureEvent)captureAudience);
                }
                ++this._currentOrder;
                mdTable = new MdColumn(this.tableId, stringArray[2], Integer.valueOf(this._currentOrder));
                captureAudience = captureContext.getAudience();
                mdTable.setColumnType(String.valueOf(stringArray[3]));
                mdTable.setPrecision(Integer.valueOf(stringArray[4]));
                mdTable.setScale(Integer.valueOf(stringArray[5]));
                mdTable.setNullable(stringArray[6]);
                mdTable.setDefaultValue(stringArray[7]);
                CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN", mdTable.getColumnName());
                captureAudience.fireListeners(captureEvent);
                Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdTable);
                captureEvent.setEventId(4);
                captureAudience.fireListeners(captureEvent);
            }
        });
    }

    private void captureSynonyms(final CaptureContext captureContext) {
        if (this.m_ctxSchema == null) {
            this.m_parser.closeStreams();
            return;
        }
        this.m_parser.setFileToRead(this.m_ctxSchema.getName() + "/synonyms.dat");
        final PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        final DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
        final DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        this.m_parser.doParse(new XMLHandler(3){

            @Override
            public void rowCompleted() throws PersistenceException {
                if (captureContext.shouldCancel()) {
                    throw new CancellationException("Cancelled");
                }
                String[] stringArray = this.getRowData();
                String string = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[2];
                DBObjectId dBObjectId3 = persistenceUtility.getIdForTable(persistenceUtility.getIdForSchema(dBObjectId, string2), string3);
                MdSynonym mdSynonym = new MdSynonym(dBObjectId2, string, dBObjectId3, "MD_TABLES");
                mdSynonym.setNativeKey(persistenceUtility.getIdForSchema(dBObjectId, string2).toString());
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SYNONYM"), mdSynonym.getName());
                captureContext.getAudience().fireListeners(captureEvent);
                mdSynonym = (MdSynonym)Db2OfflineCapturer.this.getStorer().storeObject((PersistableObject)mdSynonym);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
            }
        });
    }

    private boolean captureCatalog(CaptureContext captureContext, String string) throws PersistenceException {
        if (string == null || string.equals("")) {
            return false;
        }
        MdCatalog mdCatalog = new MdCatalog(this.m_ctxConnectionId);
        mdCatalog.setDummyFlag("Y");
        mdCatalog.setCatalogName("DB2");
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), "DB2");
        captureContext.getAudience().fireListeners(captureEvent);
        mdCatalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)mdCatalog);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        return true;
    }

    private void captureSchema(CaptureContext captureContext, String string) throws PersistenceException {
        String string2 = string.trim();
        MdSchema mdSchema = new MdSchema(this.m_ctxCatalog.getKey());
        mdSchema.setName(string2);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_SCHEMAS"), mdSchema.getName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdSchema = (MdSchema)this.getStorer().storeObject((PersistableObject)mdSchema);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        captureContext.setContextVariable("SCHEMAID", (Object)mdSchema.getKey());
    }

    public String getModelName() throws CaptureException {
        String string = this.m_properties.getProperty("OfflinePluginIdentifier");
        MigrationPlugin migrationPlugin = MigrationAddin.findPlugin((String)string);
        String string2 = null;
        if (migrationPlugin != null) {
            string2 = "V" + migrationPlugin.getPublishedVersion();
        }
        return "DB2" + string2;
    }

    public String getSourceURL() throws CaptureException {
        return "/tmp/DB2";
    }

    public String writeFile(String string, String string2, String string3) throws OfflineCaptureException {
        InputStream inputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            Object object;
            inputStream = new BufferedInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(string2));
            File file = null;
            file = new File(string + File.separator + string3);
            if (!file.exists()) {
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                object = new byte[10000];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) > -1) {
                    ((BufferedOutputStream)filterOutputStream).write((byte[])object, 0, n);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                inputStream.close();
            }
            object = file.getPath();
            String string4 = object;
            return string4;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new OfflineCaptureException((Exception)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new OfflineCaptureException((Exception)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

