/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.ldap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Vector;
import javax.crypto.spec.DHParameterSpec;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.DHPrivateKey;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class LDAPUtils {
    public static void addUserCert(X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.addUserCert(cert.getSubjectX500Principal(), cert, ctx);
    }

    public static void addUserCert(X500Principal subject, X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.addCert(subject, cert, "userCertificate", ctx);
    }

    public static void addCACert(X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.addCACert(cert.getSubjectX500Principal(), cert, ctx);
    }

    public static void addCACert(X500Principal subject, X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.addCert(subject, cert, "cACertificate", ctx);
    }

    public static void addCert(X509Certificate cert, String attr, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.addCert(cert.getSubjectX500Principal(), cert, attr, ctx);
    }

    public static void addCert(X500Principal subject, X509Certificate cert, String attr, DirContext ctx) throws IOException, NamingException {
        try {
            ModificationItem[] mod = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(attr + ";binary", cert.getEncoded()))};
            ctx.modifyAttributes(subject.toString(), mod);
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    public static Vector getUserCerts(X500Principal subject, DirContext ctx) throws IOException, NamingException {
        return LDAPUtils.getCerts(subject, "userCertificate", ctx);
    }

    public static Vector getCACerts(X500Principal subject, DirContext ctx) throws IOException, NamingException {
        return LDAPUtils.getCerts(subject, "cACertificate", ctx);
    }

    public static Vector getCerts(X500Principal subject, String attr, DirContext ctx) throws IOException, NamingException {
        Vector<Certificate> certs = new Vector<Certificate>();
        String[] attrNames = new String[]{attr + ";binary"};
        Attribute a = ctx.getAttributes(subject.toString(), attrNames).get(attr + ";binary");
        if (a == null) {
            return null;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            NamingEnumeration<?> v = a.getAll();
            while (v.hasMoreElements()) {
                byte[] data = (byte[])v.nextElement();
                certs.addElement(cf.generateCertificate(new ByteArrayInputStream(data)));
            }
        }
        catch (CertificateException ed) {
            throw new IOException(ed.toString());
        }
        return certs;
    }

    public static CRL getCRL(X500Principal crlDist, DirContext ctx) throws IOException, NamingException {
        String[] attrNames = new String[]{"certificateRevocationList;binary"};
        Attribute a = ctx.getAttributes(crlDist.toString(), attrNames).get("certificateRevocationList;binary");
        if (a == null) {
            return null;
        }
        byte[] data = (byte[])a.get();
        if (data == null) {
            return null;
        }
        return new CRL((InputStream)new ByteArrayInputStream(data));
    }

    public static void removeUserCert(X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeUserCert(cert.getSubjectX500Principal(), cert, ctx);
    }

    public static void removeUserCert(X500Principal subject, X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeCert(subject, cert, "userCertificate", ctx);
    }

    public static void removeUserCert(X500Principal subject, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeCert(subject, "userCertificate", ctx);
    }

    public static void removeCACert(X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeCACert(cert.getSubjectX500Principal(), cert, ctx);
    }

    public static void removeCACert(X500Principal subject, X509Certificate cert, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeCert(subject, cert, "cACertificate", ctx);
    }

    public static void removeCACert(X500Principal subject, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeCert(subject, "cACertificate", ctx);
    }

    public static void removeCert(X509Certificate cert, String attr, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.removeCert(cert.getSubjectX500Principal(), cert, attr, ctx);
    }

    public static void removeCert(X500Principal subject, X509Certificate cert, String attr, DirContext ctx) throws IOException, NamingException {
        try {
            ModificationItem[] mod = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attr + ";binary", cert.getEncoded()))};
            ctx.modifyAttributes(subject.toString(), mod);
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }

    public static void removeCert(X500Principal subject, String attr, DirContext ctx) throws IOException, NamingException {
        ModificationItem[] mod = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(attr + ";binary"))};
        ctx.modifyAttributes(subject.toString(), mod);
    }

    public static void addCRL(CRL crl, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.addCRL(crl.getIssuer(), crl, ctx);
    }

    public static void addCRL(X500Name crlDist, CRL crl, DirContext ctx) throws IOException, NamingException {
        ModificationItem[] mod = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("certificateRevocationList;binary", Utils.toBytes((Streamable)crl)))};
        ctx.modifyAttributes(crlDist.toString(), mod);
    }

    public static void updateCRL(CRL crl, DirContext ctx) throws IOException, NamingException {
        LDAPUtils.updateCRL(crl.getIssuer(), crl, ctx);
    }

    public static void updateCRL(X500Name crlDist, CRL crl, DirContext ctx) throws IOException, NamingException {
        ModificationItem[] mod = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("certificateRevocationList;binary", Utils.toBytes((Streamable)crl)))};
        ctx.modifyAttributes(crlDist.toString(), mod);
    }

    public static void createCA(X509Certificate cert, java.security.PrivateKey sk, DirContext ctx) throws IOException, NamingException, SignatureException {
        LDAPUtils.createCA(cert.getSubjectX500Principal(), cert, sk, ctx);
    }

    public static void createCA(X500Principal dn, X509Certificate cert, java.security.PrivateKey sk, DirContext ctx) throws IOException, NamingException, SignatureException {
        try {
            X509 certX509 = new X509(cert.getEncoded());
            LDAPUtils.createCA(dn, cert, sk, new CRL(certX509.getSubject(), LDAPUtils.toPhaosPrivateKey(sk)), ctx);
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new IOException(ex.toString());
        }
    }

    public static void createCA(X509Certificate cert, java.security.PrivateKey sk, CRL crl, DirContext ctx) throws IOException, NamingException, SignatureException {
        LDAPUtils.createCA(cert.getSubjectX500Principal(), cert, sk, crl, ctx);
    }

    public static void createCA(X500Principal dn, X509Certificate cert, java.security.PrivateKey sk, CRL crl, DirContext ctx) throws IOException, NamingException, SignatureException {
        BasicAttributes s = new BasicAttributes(true);
        String[] objClass = new String[]{"top", "certificationAuthority"};
        BasicAttribute oc = new BasicAttribute("objectClass");
        oc.add("top");
        oc.add("certificationAuthority");
        s.put(oc);
        try {
            s.put(new BasicAttribute("cACertificate;binary", cert.getEncoded()));
            s.put(new BasicAttribute("certificateRevocationList;binary", Utils.toBytes((Streamable)crl)));
            X509 certX509 = new X509(cert.getEncoded());
            s.put(new BasicAttribute("authorityRevocationList;binary", Utils.toBytes((Streamable)new CRL(certX509.getIssuer(), LDAPUtils.toPhaosPrivateKey(sk)))));
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new IOException(ex.toString());
        }
        ctx.createSubcontext(dn.toString(), (Attributes)s);
    }

    public static X509Certificate toJCECert(X509 cert) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        return certificate;
    }

    public static PrivateKey toPhaosPrivateKey(java.security.PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)privateKey;
            return new RSAPrivateKey(privKey.getModulus(), privKey.getPrivateExponent(), privKey.getPublicExponent(), privKey.getPrimeP(), privKey.getPrimeQ(), privKey.getPrimeExponentP(), privKey.getPrimeExponentQ(), privKey.getCrtCoefficient());
        }
        if (privateKey instanceof DSAPrivateKey) {
            DSAPrivateKey privKey = (DSAPrivateKey)privateKey;
            DSAParams dp = privKey.getParams();
            return new oracle.security.crypto.core.DSAPrivateKey(privKey.getX(), new oracle.security.crypto.core.DSAParams(dp.getP(), dp.getQ(), dp.getG()));
        }
        if (privateKey instanceof javax.crypto.interfaces.DHPrivateKey) {
            javax.crypto.interfaces.DHPrivateKey privKey = (javax.crypto.interfaces.DHPrivateKey)privateKey;
            DHParameterSpec p = privKey.getParams();
            DHParams params = new DHParams(p.getP(), p.getG(), p.getP().subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L)));
            return new DHPrivateKey(privKey.getX(), params);
        }
        throw new InvalidKeyException("PrivateKey format not supported");
    }

    public static X509 toPhaosCert(X509Certificate cert) throws IOException {
        try {
            X509 X509cert = new X509(cert.getEncoded());
            return X509cert;
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(ex.toString());
        }
    }
}

