/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.model.BooleanModel;
import oracle.bali.ewt.worker.AbstractWorker;
import oracle.bali.ewt.worker.Worker;

public abstract class ControlledWorker
extends AbstractWorker {
    public static final String WORKER_ENABLED_MODEL = "EnabledModel";
    private transient ChangeListener _enabledListener;
    private transient boolean _isModelEnabled = true;

    protected ControlledWorker() {
    }

    public static void setEnabledModel(Worker worker, BooleanModel newEnabledModel) {
        worker.putValue(WORKER_ENABLED_MODEL, newEnabledModel);
    }

    public static BooleanModel getEnabledModel(Worker worker) {
        return (BooleanModel)worker.getValue(WORKER_ENABLED_MODEL);
    }

    public final void setEnabledModel(BooleanModel newEnabledModel) {
        ControlledWorker.setEnabledModel(this, newEnabledModel);
    }

    public final BooleanModel getEnabledModel() {
        return ControlledWorker.getEnabledModel(this);
    }

    @Override
    public boolean isEnabled() {
        return this._isModelEnabled && super.isEnabled();
    }

    @Override
    public Object putValue(Object key, Object newValue) {
        Object oldValue = super.putValue(key, newValue);
        if (WORKER_ENABLED_MODEL.equals(key)) {
            boolean wasEnabled = this.isEnabled();
            BooleanModel oldModel = (BooleanModel)oldValue;
            BooleanModel newModel = (BooleanModel)newValue;
            if (oldModel != newModel) {
                if (this._enabledListener != null) {
                    oldModel.removeChangeListener(this._enabledListener);
                }
                if (newModel != null) {
                    if (this._enabledListener == null) {
                        this._enabledListener = new EnabledListener();
                    }
                    this._isModelEnabled = newModel.getState();
                    newModel.addChangeListener(this._enabledListener);
                } else {
                    this._isModelEnabled = true;
                    this._enabledListener = null;
                }
                this.fireEnabledPropertyChange(wasEnabled);
            }
        }
        return oldValue;
    }

    @Override
    public Object clone() {
        ControlledWorker newWorker = (ControlledWorker)super.clone();
        BooleanModel enabledModel = this.getEnabledModel();
        EnabledListener enabledListener = null;
        if (enabledModel != null) {
            enabledListener = newWorker.new EnabledListener();
            enabledModel.addChangeListener(enabledListener);
        }
        newWorker._enabledListener = enabledListener;
        return newWorker;
    }

    private class EnabledListener
    implements ChangeListener {
        private EnabledListener() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            boolean isModelEnabled = ((BooleanModel)event.getSource()).getState();
            if (ControlledWorker.this._isModelEnabled != isModelEnabled) {
                boolean wasEnabled = ControlledWorker.this.isEnabled();
                ControlledWorker.this._isModelEnabled = isModelEnabled;
                ControlledWorker.this.fireEnabledPropertyChange(wasEnabled);
            }
        }
    }
}

