/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class WizardSplitter
extends JSplitPane {
    private boolean _divLineVisible;

    public WizardSplitter(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.setDividerLineVisible(true);
    }

    @Override
    public void setUI(SplitPaneUI ui) {
        super.setUI(new WizardSplitPaneUI());
        this.revalidate();
    }

    @Override
    public void updateUI() {
        this.setUI(this.getUI());
    }

    public void setDividerLineVisible(boolean visible) {
        if (this._divLineVisible != visible) {
            this._divLineVisible = visible;
            WizardSplitPaneUI.SplitPaneDividerBorder border = (WizardSplitPaneUI.SplitPaneDividerBorder)((BasicSplitPaneUI)this.getUI()).getDivider().getBorder();
            border.setBorderOpaque(visible);
        }
    }

    public boolean isDividerLineVisible() {
        return this._divLineVisible;
    }

    @Override
    public void setDividerLocation(int requested) {
        Component maxComp;
        int currentLoc = this.getDividerLocation();
        if (currentLoc == requested) {
            super.setDividerLocation(requested);
            return;
        }
        boolean growing = requested > currentLoc;
        Component component = maxComp = growing ? this.getLeftComponent() : this.getRightComponent();
        if (maxComp == null) {
            super.setDividerLocation(requested);
            return;
        }
        Dimension maxDim = maxComp.getMaximumSize();
        if (maxDim == null) {
            super.setDividerLocation(requested);
            return;
        }
        int maxCompSize = this._getSizeForPrimaryAxis(maxDim);
        if (growing) {
            if (requested > maxCompSize) {
                super.setDividerLocation(maxCompSize);
                return;
            }
        } else {
            int totalSize = this._getSizeForPrimaryAxis(this.getSize());
            int minPos = totalSize - maxCompSize - this.getDividerSize();
            if (requested < minPos) {
                super.setDividerLocation(minPos);
                return;
            }
        }
        super.setDividerLocation(requested);
    }

    private int _getSizeForPrimaryAxis(Dimension size) {
        return this.getOrientation() == 1 ? size.width : size.height;
    }

    private static class WizardSplitPaneUI
    extends BasicSplitPaneUI {
        private WizardSplitPaneUI() {
        }

        public static ComponentUI createUI(JComponent c) {
            return new WizardSplitPaneUI();
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            WizardSplitter splitter = (WizardSplitter)this.getSplitPane();
            WizardSplitPaneDivider divider = new WizardSplitPaneDivider(this);
            ((SplitPaneDividerBorder)divider.getBorder()).setBorderOpaque(splitter.isDividerLineVisible());
            return divider;
        }

        private class WizardSplitPaneDivider
        extends BasicSplitPaneDivider {
            private int _lastPosition;
            private Border _dividerBorder;

            public WizardSplitPaneDivider(BasicSplitPaneUI ui) {
                super(ui);
                this._dividerBorder = new SplitPaneDividerBorder(UIManager.getColor("SplitPane.shadow"), UIManager.getColor("SplitPane.shadow"));
            }

            @Override
            public void setCursor(Cursor c) {
                if (c == null || c.equals(Cursor.getPredefinedCursor(0))) {
                    c = this.orientation == 1 ? Cursor.getPredefinedCursor(11) : Cursor.getPredefinedCursor(9);
                }
                super.setCursor(c);
            }

            @Override
            protected void processMouseEvent(MouseEvent e) {
                JSplitPane sp = WizardSplitPaneUI.this.getSplitPane();
                int currLoc = 0;
                if (e.getID() == 500 && e.getClickCount() % 2 == 0) {
                    currLoc = sp.getDividerLocation();
                    Insets inset = this.getBorder().getBorderInsets(this);
                    if (this.orientation == 1) {
                        if (currLoc == inset.left) {
                            sp.setDividerLocation(this._lastPosition);
                        } else {
                            this._lastPosition = currLoc;
                            sp.setDividerLocation(inset.left);
                        }
                    } else if (currLoc == sp.getSize().height - this.getHeight()) {
                        sp.setDividerLocation(this._lastPosition);
                    } else {
                        this._lastPosition = currLoc;
                        sp.setDividerLocation(sp.getSize().height);
                    }
                }
                super.processMouseEvent(e);
            }

            @Override
            public void paint(Graphics g) {
                Color bgColor = null;
                bgColor = UIManager.getColor("SplitPane.background");
                if (bgColor == null) {
                    bgColor = this.getBackground();
                }
                if (bgColor != null) {
                    Dimension size = this.getSize();
                    g.setColor(bgColor);
                    g.fillRect(0, 0, size.width, size.height);
                }
                super.paint(g);
            }

            @Override
            public void setBorder(Border border) {
                this._dividerBorder = border;
            }

            @Override
            public Border getBorder() {
                return this._dividerBorder;
            }

            @Override
            public void propertyChange(PropertyChangeEvent pe) {
                boolean toSetCursor;
                Cursor c = null;
                boolean bl = toSetCursor = pe.getSource() == this.splitPane && "orientation".equals(pe.getPropertyName());
                if (toSetCursor) {
                    c = this.getCursor();
                }
                super.propertyChange(pe);
                if (toSetCursor && c != null && !c.equals(Cursor.getPredefinedCursor(0)) && !c.equals(Cursor.getPredefinedCursor(11)) && !c.equals(Cursor.getPredefinedCursor(9))) {
                    this.setCursor(c);
                }
            }
        }

        private static class SplitPaneDividerBorder
        implements Border,
        UIResource {
            private boolean _opaque = true;
            private Color _left;
            private Color _right;

            SplitPaneDividerBorder(Color left, Color right) {
                this._left = left == null ? UIManager.getColor("SplitPane.shadow") : left;
                this._right = right == null ? UIManager.getColor("SplitPane.shadow") : right;
            }

            public void setBorderOpaque(boolean opaque) {
                this._opaque = opaque;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (!this.isBorderOpaque()) {
                    return;
                }
                JSplitPane splitPane = ((BasicSplitPaneDivider)c).getBasicSplitPaneUI().getSplitPane();
                Dimension size = c.getSize();
                Component child = splitPane.getLeftComponent();
                g.setColor(c.getBackground());
                g.drawRect(x, y, width - 1, height - 1);
                if (splitPane.getOrientation() == 1) {
                    if (child != null) {
                        g.setColor(this._left);
                        g.drawLine(0, 0, 0, size.height);
                    }
                    if ((child = splitPane.getRightComponent()) != null) {
                        g.setColor(this._right);
                        g.drawLine(size.width - 1, 0, size.width - 1, size.height);
                    }
                } else {
                    if (child != null) {
                        g.setColor(this._left);
                        g.drawLine(0, 0, size.width, 0);
                    }
                    if ((child = splitPane.getRightComponent()) != null) {
                        g.setColor(this._right);
                        g.drawLine(0, size.height - 1, size.width, size.height - 1);
                    }
                }
            }

            @Override
            public Insets getBorderInsets(Component c) {
                JSplitPane splitPane;
                BasicSplitPaneUI bspui;
                Insets insets = new Insets(0, 0, 0, 0);
                if (c instanceof BasicSplitPaneDivider && (bspui = ((BasicSplitPaneDivider)c).getBasicSplitPaneUI()) != null && (splitPane = bspui.getSplitPane()) != null) {
                    if (splitPane.getOrientation() == 1) {
                        insets.bottom = 0;
                        insets.top = 0;
                        insets.right = 1;
                        insets.left = 1;
                        return insets;
                    }
                    insets.bottom = 1;
                    insets.top = 1;
                    insets.right = 0;
                    insets.left = 0;
                    return insets;
                }
                insets.right = 1;
                insets.left = 1;
                insets.bottom = 1;
                insets.top = 1;
                return insets;
            }

            @Override
            public boolean isBorderOpaque() {
                return this._opaque;
            }
        }
    }
}

