/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;

public class WindowUtils {
    public static final int DIALOG_MAXIMUM_WIDTH;
    public static final int DIALOG_MAXIMUM_HEIGHT;
    private static WindowCloser _sWindowCloser;

    public static Window getActiveWindow() {
        return ActiveWindowTracker.getWindowTracker().getActiveWindow();
    }

    public static void registerApplet(Applet applet) {
        ActiveWindowTracker.getWindowTracker().registerApplet(applet);
    }

    public static void unregisterApplet(Applet applet) {
        ActiveWindowTracker.getWindowTracker().unregisterApplet(applet);
    }

    public static void registerWindow(Window window) {
        ActiveWindowTracker.getWindowTracker().registerWindow(window);
    }

    public static void unregisterWindow(Window window) {
        ActiveWindowTracker.getWindowTracker().unregisterWindow(window);
    }

    public static Window getWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static Frame parentFrame(Component component) {
        while (component != null) {
            if (component instanceof Frame) {
                return (Frame)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public static WindowListener getWindowCloser() {
        if (_sWindowCloser == null) {
            _sWindowCloser = new WindowCloser();
        }
        return _sWindowCloser;
    }

    public static void centerWindow(Window window) {
        int y;
        Dimension size = window.getSize();
        if (size.width == 0 || size.height == 0) {
            return;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - size.width) / 2;
        if (x < 0) {
            x = 0;
        }
        if ((y = (screenSize.height - size.height) / 2) < 0) {
            y = 0;
        }
        window.setLocation(x, y);
    }

    public static void centerWindow(Window window, Component over) {
        GraphicsDevice[] gds;
        if (over == null || !over.isShowing()) {
            WindowUtils.centerWindow(window);
            return;
        }
        Point parentLocation = over.getLocationOnScreen();
        Dimension parentSize = over.getSize();
        Dimension size = window.getSize();
        int x = parentLocation.x + (parentSize.width - size.width) / 2;
        int y = parentLocation.y + (parentSize.height - size.height) / 2;
        Rectangle bounds = new Rectangle(0, 0);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            bounds = bounds.union(gc.getBounds());
        }
        if (x + size.width > bounds.width) {
            x = bounds.width - size.width;
        }
        if (x < bounds.x) {
            x = bounds.x;
        }
        if (y + size.height > bounds.height) {
            y = bounds.height - size.height;
        }
        if (y < bounds.y) {
            y = bounds.y;
        }
        window.setLocation(x, y);
    }

    static boolean shouldRepaintOnActiveChange() {
        Object value = UIManager.getDefaults().get("LookAndFeel.requiresActiveChangeRepaint");
        return Boolean.TRUE.equals(value);
    }

    private WindowUtils() {
    }

    static {
        int width = 800;
        int height = 600;
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        if (size.width < width) {
            width = size.width;
        }
        if (size.height < height) {
            height = size.height;
        }
        DIALOG_MAXIMUM_WIDTH = width;
        DIALOG_MAXIMUM_HEIGHT = height;
    }

    private static class ActiveWindowTracker
    extends WindowAdapter {
        private static ActiveWindowTracker _sWindowTracker;
        private boolean _receivingAppletActivates = false;
        private Window _activeWindow;
        private Applet _applet;
        private Frame _appletFrame;

        private ActiveWindowTracker() {
        }

        static ActiveWindowTracker getWindowTracker() {
            if (_sWindowTracker == null) {
                _sWindowTracker = new ActiveWindowTracker();
            }
            return _sWindowTracker;
        }

        @Override
        public void windowActivated(WindowEvent event) {
            Window oldActiveWindow;
            boolean repaint = WindowUtils.shouldRepaintOnActiveChange();
            Window window = event.getWindow();
            if (window == this._appletFrame) {
                this._receivingAppletActivates = true;
            }
            if ((oldActiveWindow = this._activeWindow) != window) {
                this._activeWindow = window;
                if (repaint) {
                    this._repaint(window);
                }
                if (!this._receivingAppletActivates) {
                    if (oldActiveWindow == null && this._appletFrame != null) {
                        if (repaint) {
                            this._repaint(this._appletFrame);
                        }
                    } else if (this._applet != null && repaint) {
                        this._repaint(this._applet);
                    }
                }
            }
        }

        @Override
        public void windowDeactivated(WindowEvent event) {
            Applet applet;
            boolean repaint = WindowUtils.shouldRepaintOnActiveChange();
            Window window = event.getWindow();
            if (window == this._appletFrame) {
                this._receivingAppletActivates = true;
            }
            if (window == this._activeWindow) {
                this._activeWindow = null;
            }
            if (repaint) {
                this._repaint(window);
            }
            if (!this._receivingAppletActivates && (applet = this._applet) != null && repaint) {
                applet.repaint(200L);
            }
        }

        public Window getActiveWindow() {
            if (!this._receivingAppletActivates && this._activeWindow == null) {
                return this._appletFrame;
            }
            return this._activeWindow;
        }

        public void registerWindow(Window window) {
            window.addWindowListener(this);
            if (this._activeWindow == null && window.getFocusOwner() != null) {
                this._activeWindow = window;
            }
        }

        public void unregisterWindow(Window window) {
            window.removeWindowListener(this);
            if (this._activeWindow == window) {
                this._activeWindow = null;
            }
        }

        public void registerApplet(Applet applet) {
            Frame appletFrame;
            this._applet = applet;
            this._appletFrame = appletFrame = WindowUtils.parentFrame(applet);
            if (appletFrame != null) {
                WindowUtils.registerWindow(appletFrame);
            }
        }

        public void unregisterApplet(Applet applet) {
            if (this._applet == applet) {
                WindowUtils.unregisterWindow(this._appletFrame);
                this._applet = null;
                this._appletFrame = null;
            }
        }

        private void _repaint(Container target) {
            if (target instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)target)).getRootPane().repaint();
            } else {
                target.repaint();
            }
            Component[] children = target.getComponents();
            for (int i = 0; i < children.length; ++i) {
                Component child = children[i];
                if (JComponent.isLightweightComponent(child)) continue;
                if (child instanceof Container) {
                    this._repaint((Container)child);
                    continue;
                }
                child.repaint();
            }
        }
    }

    private static class WindowCloser
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            event.getWindow().hide();
        }
    }
}

