/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.FontMetrics;
import java.text.BreakIterator;
import java.util.Locale;
import oracle.bali.ewt.text.CharacterWrapper;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WrapInfo;
import oracle.bali.ewt.util.StringUtils;

public class WordWrapper
implements TextWrapper {
    private static WordWrapper _sWordWrapper;

    public static TextWrapper getTextWrapper() {
        if (_sWordWrapper == null) {
            _sWordWrapper = new WordWrapper();
        }
        return _sWordWrapper;
    }

    @Override
    public void wrapParagraph(WrapInfo wrapInfo, String text) {
        char[] textChars = text.toCharArray();
        int numChars = textChars.length;
        int currIndex = 0;
        int arrayOffset = 0;
        int wrapWidth = wrapInfo.getWrapWidth();
        FontMetrics metrics = wrapInfo.getFontMetrics();
        Locale locale = wrapInfo.getLocale();
        BreakIterator wordWrapper = BreakIterator.getLineInstance(locale);
        boolean isPreferred = wrapInfo.isCalculatingPreferred();
        wordWrapper.setText(text);
        while (currIndex < numChars) {
            int currLineWidth = 0;
            int oldLineWidth = 0;
            int lastIndex = currIndex;
            int nextIndex = currIndex;
            int wordCount = 0;
            do {
                ++wordCount;
                nextIndex = wordWrapper.next();
                if (nextIndex == -1) {
                    nextIndex = numChars;
                }
                if (nextIndex > 0) {
                    char thisChar = textChars[arrayOffset + nextIndex - 1];
                    while (thisChar == ':' || thisChar == '.' || thisChar == '-') {
                        nextIndex = wordWrapper.next();
                        if (nextIndex == -1) {
                            nextIndex = numChars;
                            break;
                        }
                        thisChar = textChars[arrayOffset + nextIndex - 1];
                    }
                }
                boolean tabInWord = false;
                for (int i = lastIndex; i < nextIndex; ++i) {
                    if (textChars[i + arrayOffset] != '\t') continue;
                    tabInWord = true;
                    break;
                }
                if (tabInWord) {
                    displayString = new String(textChars, currIndex + arrayOffset, nextIndex - currIndex);
                    displayString = StringUtils.getDisplayString(displayString, locale, 1);
                    currLineWidth = metrics.stringWidth(displayString);
                } else {
                    displayString = new String(textChars, lastIndex + arrayOffset, nextIndex - lastIndex);
                    displayString = StringUtils.getDisplayString(displayString, locale, 1);
                    currLineWidth += metrics.stringWidth(displayString);
                }
                if (currLineWidth > wrapWidth && oldLineWidth != 0) {
                    wordWrapper.previous();
                    break;
                }
                lastIndex = nextIndex;
                oldLineWidth = currLineWidth;
            } while (lastIndex < numChars && currLineWidth <= wrapWidth);
            if (wordCount == 1 && currLineWidth > wrapWidth && wrapWidth > 0 && !isPreferred) {
                lastIndex = CharacterWrapper.__getNextIndex(textChars, metrics, wrapWidth, currIndex + arrayOffset, wrapWidth / metrics.charWidth('e')) - arrayOffset;
                if (!wrapInfo.addLine(text, currIndex, lastIndex)) {
                    return;
                }
                text = text.substring(lastIndex);
                currIndex = 0;
                numChars = text.length();
                wordWrapper.setText(text);
                arrayOffset += lastIndex;
                continue;
            }
            if (!wrapInfo.addLine(text, currIndex, lastIndex)) {
                return;
            }
            currIndex = lastIndex;
        }
    }

    private WordWrapper() {
    }
}

