/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import oracle.bali.share.collection.Range;

public class NumberRange
extends Range {
    private Number _lower;
    private Number _upper;

    public NumberRange(Number lower, Number upper) {
        super(lower.intValue(), upper.intValue());
        if (lower.doubleValue() > upper.doubleValue()) {
            throw new IllegalArgumentException();
        }
        this._lower = lower;
        this._upper = upper;
    }

    public Number getLower() {
        return this._lower;
    }

    public Number getUpper() {
        return this._upper;
    }

    public Object clone() throws CloneNotSupportedException {
        return new NumberRange(this.getLower(), this.getUpper());
    }

    public boolean inRange(Number value) {
        return value.doubleValue() >= this._lower.doubleValue() && value.doubleValue() <= this._upper.doubleValue();
    }

    public String toString() {
        return "[" + this._lower + "," + this._upper + "]";
    }
}

