/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.selection;

import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.share.collection.Range;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

public class OneDSelection
implements Cloneable {
    private Range[] _ranges;
    private static RangeComparator _rangeComparator;
    private static OneDSelection _emptySelection;

    public OneDSelection() {
    }

    public OneDSelection(Range range) {
        Range[] ranges = new Range[]{range};
        this._setRanges(ranges);
    }

    public OneDSelection(int item1, int item2) {
        Range[] ranges = new Range[]{OneDSelection._newRange(item1, item2)};
        this._setRanges(ranges);
    }

    public OneDSelection(int item) {
        Range[] ranges = new Range[]{OneDSelection._newRange(item, item)};
        this._setRanges(ranges);
    }

    public OneDSelection(Range[] ranges) {
        Object[] result = null;
        if (ranges != null && ranges.length > 0) {
            result = this._duplicateRangeArray(ranges);
            Sort.qSort((Object[])result, (int)result.length, (Comparator)OneDSelection._getRangeComparator());
        }
        this._setRanges((Range[])result);
    }

    public Enumeration getIndexes() {
        return new Enumerator(this);
    }

    public Object clone() throws CloneNotSupportedException {
        return new OneDSelection(this.getRanges());
    }

    public Range[] getRanges() {
        return this._ranges;
    }

    private void _setRanges(Range[] ranges) {
        this._ranges = ranges;
    }

    public int getSingleItem() {
        Range[] ranges = this.getRanges();
        if (ranges != null && ranges.length > 0) {
            return ranges[0].getLowerLimit();
        }
        return -1;
    }

    public final OneDSelection add(OneDSelection sel) {
        return this.add(sel.getRanges());
    }

    public final OneDSelection add(int sel) {
        Range[] ranges = new Range[]{new Range(sel, sel)};
        return new OneDSelection(Range.addRanges((Range[])this.getRanges(), (Range[])ranges));
    }

    public OneDSelection add(Range[] sel) {
        return new OneDSelection(Range.addRanges((Range[])this.getRanges(), (Range[])sel));
    }

    public final OneDSelection subtract(OneDSelection sel) {
        return this.subtract(sel.getRanges());
    }

    public final OneDSelection subtract(int sel) {
        Range[] arg = new Range[]{new Range(sel, sel)};
        return this.subtract(arg);
    }

    public OneDSelection subtract(Range[] sel) {
        Range[] resultRanges = Range.subtractRanges((Range[])this.getRanges(), (Range[])sel);
        return new OneDSelection(resultRanges);
    }

    public OneDSelection addItems(int start, int number) {
        Range[] ranges = this.getRanges();
        Object[] endResult = null;
        if (ranges != null && ranges.length > 0) {
            Vector<Range> result = new Vector<Range>();
            for (int i = 0; i < ranges.length; ++i) {
                int min = ranges[i].getLowerLimit();
                int max = ranges[i].getUpperLimit();
                if (start <= min) {
                    result.addElement(new Range(min + number, max + number));
                    continue;
                }
                if (start > max) {
                    result.addElement(new Range(min, max));
                    continue;
                }
                result.addElement(new Range(min, start - 1));
                result.addElement(new Range(start + number, max + number));
            }
            endResult = new Range[result.size()];
            result.copyInto(endResult);
        }
        return new OneDSelection((Range[])endResult);
    }

    public OneDSelection removeItems(int start, int number) {
        Range[] ranges = this.getRanges();
        Object[] endResult = null;
        if (ranges != null && ranges.length > 0) {
            Vector<Range> result = new Vector<Range>();
            for (int i = 0; i < ranges.length; ++i) {
                int min = ranges[i].getLowerLimit();
                int max = ranges[i].getUpperLimit();
                if (start + number <= min) {
                    result.addElement(new Range(min - number, max - number));
                    continue;
                }
                if (start > max) {
                    result.addElement(new Range(min, max));
                    continue;
                }
                if (start <= min && start + number - 1 >= max) continue;
                if (start > min && start + number - 1 < max) {
                    result.addElement(new Range(min, start - 1));
                    result.addElement(new Range(start, max - number));
                    continue;
                }
                if (start > min) {
                    result.addElement(new Range(min, start - 1));
                    continue;
                }
                if (start + number - 1 >= max) continue;
                result.addElement(new Range(start, max - number));
            }
            endResult = new Range[result.size()];
            result.copyInto(endResult);
        }
        return new OneDSelection((Range[])endResult);
    }

    public boolean contains(int value) {
        return Range.rangesContain((Range[])this.getRanges(), (int)value);
    }

    public boolean contains(OneDSelection sel) {
        return Range.rangesContain((Range[])this.getRanges(), (Range[])sel.getRanges());
    }

    public boolean isEmpty() {
        return this._ranges == null || this._ranges.length == 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OneDSelection)) {
            return false;
        }
        OneDSelection a = this.subtract((OneDSelection)other);
        OneDSelection b = ((OneDSelection)other).subtract(this);
        return a.isEmpty() && b.isEmpty();
    }

    public int getSelectedItemCount() {
        Range[] ranges = this.getRanges();
        if (ranges == null) {
            return 0;
        }
        int total = 0;
        for (int i = 0; i < ranges.length; ++i) {
            int upper = ranges[i].getUpperLimit();
            int lower = ranges[i].getLowerLimit();
            total += upper - lower + 1;
        }
        return total;
    }

    public int getSelectedItemAtIndex(int index) {
        Range[] ranges = this.getRanges();
        if (ranges == null) {
            return -1;
        }
        int total = 0;
        for (int i = 0; i < ranges.length; ++i) {
            int lower;
            int upper = ranges[i].getUpperLimit();
            if ((total += upper - (lower = ranges[i].getLowerLimit()) + 1) < index + 1) continue;
            return upper - (total - (index + 1));
        }
        return -1;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        boolean addcomma = false;
        Range[] ranges = this.getRanges();
        if (ranges != null && ranges.length > 0) {
            addcomma = true;
            for (int i = 0; i < ranges.length; ++i) {
                Range r = ranges[i];
                result.append("[" + r.getLowerLimit() + ", " + r.getUpperLimit() + "]");
                if (i == ranges.length - 1) continue;
                result.append(",");
            }
        }
        result.append("]");
        return result.toString();
    }

    public static OneDSelection getEmptySelection() {
        if (_emptySelection == null) {
            _emptySelection = new OneDSelection();
        }
        return _emptySelection;
    }

    private static Range _newRange(int a, int b) {
        if (a <= b) {
            return new Range(a, b);
        }
        return new Range(b, a);
    }

    private static Comparator _getRangeComparator() {
        if (_rangeComparator == null) {
            _rangeComparator = new RangeComparator();
        }
        return _rangeComparator;
    }

    private Range[] _duplicateRangeArray(Range[] objects) {
        if (objects == null) {
            return null;
        }
        Range[] result = new Range[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            try {
                if (!(objects[i] instanceof Range)) continue;
                result[i] = (Range)objects[i].clone();
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return result;
    }

    private static class Enumerator
    implements Enumeration {
        private OneDSelection _source;
        private int _indexa;
        private int _indexb;

        public Enumerator(OneDSelection source) {
            this._source = source;
            this._indexa = 0;
            this._indexb = -1;
        }

        @Override
        public boolean hasMoreElements() {
            Range[] ranges = this._source.getRanges();
            return this._indexa < ranges.length && this._indexb == -1;
        }

        public Object nextElement() {
            Range[] ranges = this._source.getRanges();
            if (this._indexa < ranges.length) {
                if (this._indexb == -1) {
                    this._indexb = ranges[this._indexa].getLowerLimit();
                    return IntegerUtils.getInteger((int)this._indexb);
                }
                int max = ranges[this._indexa].getUpperLimit();
                ++this._indexb;
                if (this._indexb > max) {
                    ++this._indexa;
                    if (this._indexa < ranges.length) {
                        this._indexb = ranges[this._indexa].getLowerLimit();
                        return IntegerUtils.getInteger((int)this._indexb);
                    }
                    return null;
                }
                return IntegerUtils.getInteger((int)this._indexb);
            }
            return null;
        }
    }

    private static class RangeComparator
    implements Comparator {
        private RangeComparator() {
        }

        public int compare(Object item1, Object item2) {
            Range a = (Range)item1;
            Range b = (Range)item2;
            if (a.getLowerLimit() < b.getLowerLimit()) {
                return -1;
            }
            if (a.getLowerLimit() > b.getLowerLimit()) {
                return 1;
            }
            return 0;
        }
    }
}

