/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.plaf;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.plaf.BorderAdapter;
import oracle.bali.ewt.util.ImmInsets;

public class GridFocusPainter
extends AbstractBorderPainter {
    private boolean _swingStyle;
    private static BorderPainter _sSwingPainter;
    private static BorderPainter _sJEWTPainter;
    private static final ImmInsets _sSwingInsets;
    private static final ImmInsets _sJEWTInsets;

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        return new BorderAdapter(GridFocusPainter.getBorderPainter(true));
    }

    public static BorderPainter getBorderPainter() {
        return GridFocusPainter.getBorderPainter(false);
    }

    public static BorderPainter getBorderPainter(boolean getSwingPainter) {
        BorderPainter p;
        if (getSwingPainter) {
            if (_sSwingPainter == null) {
                _sSwingPainter = new GridFocusPainter(true);
            }
            p = _sSwingPainter;
        } else {
            if (_sJEWTPainter == null) {
                _sJEWTPainter = new GridFocusPainter(false);
            }
            p = _sJEWTPainter;
        }
        return p;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return false;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return this._swingStyle ? _sSwingInsets : _sJEWTInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int top = y;
        int left = x;
        int bottom = y + height - 1;
        int right = x + width - 1;
        g.setColor(Color.black);
        g.drawLine(left, top, left, bottom);
        g.drawLine(left, top, right, top);
        g.drawLine(right, top, right, bottom);
        g.drawLine(left, bottom, right, bottom);
        if (!this._swingStyle) {
            g.drawLine(left + 1, top, left + 1, bottom);
            g.drawLine(left, top + 1, right, top + 1);
            g.drawLine(right - 1, top, right - 1, bottom);
            g.drawLine(left, bottom - 1, right, bottom - 1);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private GridFocusPainter(boolean swingStyle) {
        this._swingStyle = swingStyle;
    }

    static {
        _sSwingInsets = new ImmInsets(1, 1, 1, 1);
        _sJEWTInsets = new ImmInsets(2, 2, 2, 2);
    }
}

