/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyVetoException;
import java.io.IOException;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.elaf.EWTPivotTableUI;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.JDKPivotCornerDropAdapter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;

class PivotCorner
extends LWComponent
implements DropTargetListener {
    private DropTarget _dropTarget;
    private PivotTable _pivotTable;
    private PivotHeader _pivotHeader;
    private boolean _jdkDnD;
    private JDKPivotCornerDropAdapter _jdkPivotCornerDrop;

    public PivotCorner(PivotTable table) {
        this._pivotTable = table;
        this._dropTarget = new DropTarget(this, this);
        this.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            if (this._dropTarget != null) {
                this._dropTarget.setComponent(null);
                this._dropTarget.removeDropTargetListener(this);
                this._dropTarget = null;
                this._pivotHeader = null;
            }
            this._jdkPivotCornerDrop = new JDKPivotCornerDropAdapter(this, this._pivotTable);
        }
    }

    public void dispose() {
        if (this._dropTarget != null) {
            this._dropTarget.setComponent(null);
            this._dropTarget.removeDropTargetListener(this);
            this._dropTarget = null;
            this._pivotHeader = null;
        }
        if (this._jdkPivotCornerDrop != null) {
            this._jdkPivotCornerDrop.dispose();
            this._jdkPivotCornerDrop = null;
        }
        this._pivotTable = null;
    }

    @Override
    public void paint(Graphics g) {
        EWTPivotTableUI ui = this._pivotTable.getPivotTableUI();
        Painter painter = ui.getCornerPainter(this._pivotTable, 3);
        painter.paint(this.getPaintContext(), g, 0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    public Object getPaintData(Object key) {
        return this._pivotTable.getPaintData(key);
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (!this._acceptDrag(e)) {
            e.rejectDrag();
            return;
        }
        this._updateFeedback(e.getDropTargetContext().getComponent(), e.getLocation());
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this._updatePivotHeader(null, null);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(1);
        this._updatePivotHeader(null, null);
        Transferable transfer = e.getTransferable();
        Object data = null;
        try {
            data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (IOException ioException) {
            data = null;
        }
        catch (UnsupportedFlavorException ufException) {
            data = null;
        }
        boolean success = false;
        if (data != null && data instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)data;
            Object source = pivotTransfer.getSource();
            int sourceIndex = pivotTransfer.getIndex();
            Point p = e.getLocation();
            PivotHeader destination = this._getPivotHeader(e.getDropTargetContext().getComponent(), p);
            int destinationIndex = this._getIndex(destination, p);
            PivotTable pivot = this._pivotTable;
            boolean fireEvent = true;
            if (source == destination) {
                if (sourceIndex < destinationIndex) {
                    --destinationIndex;
                }
                if (sourceIndex == destinationIndex) {
                    fireEvent = false;
                }
            }
            if (fireEvent) {
                try {
                    pivot.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                pivot.firePivotEvent(source, sourceIndex, destination, destinationIndex);
            }
            success = true;
        }
        e.dropComplete(success);
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        if (!this._pivotTable.isEnabled()) {
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    private PivotHeader _getPivotHeader(Component c, Point p) {
        PivotHeader header = null;
        header = p.x >= p.y ? this._getHorizontalHeader() : this._getVerticalHeader();
        return header;
    }

    private void _updateFeedback(Component c, Point p) {
        PivotHeader header = this._getPivotHeader(c, p);
        this._updatePivotHeader(header, p);
    }

    private void _updatePivotHeader(PivotHeader header, Point p) {
        if (this._pivotHeader != header && this._pivotHeader != null) {
            this._pivotHeader.setDropLocation(-1, false);
        }
        this._pivotHeader = header;
        if (this._pivotHeader != null) {
            int index = this._getIndex(header, p);
            this._pivotHeader.setDropLocation(index, false);
        }
    }

    private int _getIndex(PivotHeader header, Point p) {
        int index = -1;
        index = header.getOrientation() == 0 ? header.getRowHeader().getItemAt(1, p.y) : header.getColumnHeader().getItemAt(p.x, 1);
        return index;
    }

    private PivotHeader _getHorizontalHeader() {
        return this._pivotTable.getColumnPivotHeader();
    }

    private PivotHeader _getVerticalHeader() {
        return this._pivotTable.getRowPivotHeader();
    }
}

