/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.MenuUtils;

public abstract class AbstractPivotPopup {
    private static final String _KEY_SWAP_MENU = "PIVOT.MENU_SWAP";
    private static final String _KEY_PIVOT_MENU = "PIVOT.MENU_PIVOT";
    private static final String _KEY_BEFORE = "PIVOT.MENU_BEFORE";
    private static final String _KEY_AFTER = "PIVOT.MENU_AFTER";
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private Listener _listener;
    private JPopupMenu _menu;
    private Object _source;
    private int _sourceIndex;

    public abstract boolean isSwapAllowed();

    public abstract Locale getLocale();

    public abstract Object[] getSources();

    public abstract Component getSourceComponent(Object var1);

    public abstract Object getSource(Component var1);

    public abstract int getSourceIndex(Component var1, int var2, int var3, boolean var4);

    public abstract Object[] getTargets();

    public abstract String getTargetLabel(Object var1);

    public abstract int getTargetDropCount(Object var1);

    public abstract String getTargetDropLabel(Object var1, int var2);

    public abstract void firePivotEvent(Object var1, int var2, Object var3, int var4);

    public abstract void fireSwapEvent(Object var1, int var2, Object var3, int var4);

    protected void initialize() {
        if (this._listener != null) {
            return;
        }
        this._listener = new Listener();
        Object[] sources = this.getSources();
        int count = sources == null ? 0 : sources.length;
        for (int i = 0; i < count; ++i) {
            Component c = this.getSourceComponent(sources[i]);
            this._addListeners(c);
        }
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        Object[] sources = this.getSources();
        int count = sources == null ? 0 : sources.length;
        for (int i = 0; i < count; ++i) {
            Component c = this.getSourceComponent(sources[i]);
            this._removeListeners(c);
        }
        if (this._menu != null) {
            this._menu.setInvoker(null);
            this._removeActionListeners(this._menu, this._listener);
            this._menu.removeAll();
        }
        this._menu = null;
        this._listener = null;
    }

    private void _showMenu(Component c, int x, int y, boolean keyBoard) {
        int targetCount;
        if (this._menu == null) {
            this._menu = new JPopupMenu();
        }
        this._removeActionListeners(this._menu, this._listener);
        this._menu.removeAll();
        int sourceIndex = this.getSourceIndex(c, x, y, keyBoard);
        Object source = this.getSource(c);
        if (sourceIndex == -1 || source == null) {
            return;
        }
        Object[] targets = this.getTargets();
        int n = targetCount = targets == null ? 0 : targets.length;
        if (targetCount == 0) {
            return;
        }
        boolean swapAllowed = this.isSwapAllowed();
        ResourceBundle b = ResourceBundle.getBundle(_BUNDLE, this.getLocale());
        JMenu pivotMenu = new JMenu(this._getTranslatedString(b, _KEY_PIVOT_MENU));
        this._menu.add(pivotMenu);
        JMenu swapMenu = null;
        if (swapAllowed) {
            swapMenu = new JMenu(this._getTranslatedString(b, _KEY_SWAP_MENU));
            this._menu.add(swapMenu);
        }
        MessageFormat beforeFormat = new MessageFormat(this._getTranslatedString(b, _KEY_BEFORE));
        MessageFormat afterFormat = new MessageFormat(this._getTranslatedString(b, _KEY_AFTER));
        Object[] singleArg = new Object[1];
        for (int targetIndex = 0; targetIndex < targetCount; ++targetIndex) {
            int targetDropCount;
            Object target = targets[targetIndex];
            String targetLabel = this.getTargetLabel(target);
            JMenu targetPivotMenu = new JMenu(targetLabel);
            pivotMenu.add(targetPivotMenu);
            JMenu targetSwapMenu = null;
            if (swapAllowed) {
                targetSwapMenu = new JMenu(targetLabel);
                swapMenu.add(targetSwapMenu);
            }
            if ((targetDropCount = this.getTargetDropCount(target)) == 0) {
                item = new JMenuItem(targetLabel);
                item.addActionListener(this._listener);
                item.setActionCommand("PIVOT." + targetIndex + ".0");
                targetPivotMenu.add(item);
            } else {
                for (int i = 0; i < targetDropCount + 1; ++i) {
                    String label;
                    String string = label = i == targetDropCount ? this.getTargetDropLabel(target, i - 1) : this.getTargetDropLabel(target, i);
                    if (source != target || i != sourceIndex && i != sourceIndex + 1) {
                        MessageFormat format = i == targetDropCount ? afterFormat : beforeFormat;
                        singleArg[0] = label;
                        String s = format.format(singleArg);
                        item = new JMenuItem(s);
                        item.addActionListener(this._listener);
                        item.setActionCommand("PIVOT." + targetIndex + "." + i);
                        targetPivotMenu.add(item);
                    }
                    if (!swapAllowed || i == targetDropCount || source == target && i == sourceIndex) continue;
                    item = new JMenuItem(label);
                    item.addActionListener(this._listener);
                    item.setActionCommand("SWAP." + targetIndex + "." + i);
                    targetSwapMenu.add(item);
                }
            }
            if (targetPivotMenu.getMenuComponentCount() == 0) {
                pivotMenu.remove(targetPivotMenu);
            }
            if (!swapAllowed || targetSwapMenu.getMenuComponentCount() != 0) continue;
            swapMenu.remove(targetSwapMenu);
        }
        if (pivotMenu.getMenuComponentCount() == 0) {
            this._menu.remove(pivotMenu);
        }
        if (swapAllowed && swapMenu.getMenuComponentCount() == 0) {
            this._menu.remove(swapMenu);
        }
        if (this._menu.getComponentCount() == 0) {
            return;
        }
        this._source = source;
        this._sourceIndex = sourceIndex;
        MenuUtils.showPopupMenu(this._menu, c, x, y);
    }

    private void _removeActionListeners(JPopupMenu menu, ActionListener listener) {
        for (int i = 0; i < menu.getComponentCount(); ++i) {
            Component c = menu.getComponent(i);
            if (!(c instanceof JMenuItem)) continue;
            ((JMenuItem)c).removeActionListener(listener);
        }
    }

    private void _addListeners(Component item) {
        item.addKeyListener(this._listener);
        item.addMouseListener(this._listener);
        if (item instanceof Container) {
            Container c = (Container)item;
            c.addContainerListener(this._listener);
            for (int i = 0; i < c.getComponentCount(); ++i) {
                this._addListeners(c.getComponent(i));
            }
        }
    }

    private void _removeListeners(Component item) {
        item.removeKeyListener(this._listener);
        item.removeMouseListener(this._listener);
        if (item instanceof Container) {
            Container c = (Container)item;
            c.removeContainerListener(this._listener);
            for (int i = 0; i < c.getComponentCount(); ++i) {
                this._removeListeners(c.getComponent(i));
            }
        }
    }

    private String _getTranslatedString(ResourceBundle b, String key) {
        try {
            return b.getString(key);
        }
        catch (Exception e) {
            return "Key not found";
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    KeyListener,
    ContainerListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean sameDest;
            String cmd = e.getActionCommand();
            boolean pivot = cmd.startsWith("PIVOT");
            int firstPeriod = cmd.indexOf(".");
            int lastPeriod = cmd.lastIndexOf(".");
            String destString = cmd.substring(firstPeriod + 1, lastPeriod);
            int index = -1;
            try {
                index = Integer.parseInt(destString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Object dest = null;
            if (index != -1) {
                dest = AbstractPivotPopup.this.getTargets()[index];
            }
            String temp = cmd.substring(lastPeriod + 1);
            int destIndex = -1;
            try {
                destIndex = Integer.parseInt(temp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dest == null || destIndex == -1) {
                return;
            }
            boolean bl = sameDest = AbstractPivotPopup.this._source == dest;
            if (pivot && sameDest && AbstractPivotPopup.this._sourceIndex < destIndex) {
                --destIndex;
            }
            if (pivot) {
                AbstractPivotPopup.this.firePivotEvent(AbstractPivotPopup.this._source, AbstractPivotPopup.this._sourceIndex, dest, destIndex);
            } else {
                AbstractPivotPopup.this.fireSwapEvent(AbstractPivotPopup.this._source, AbstractPivotPopup.this._sourceIndex, dest, destIndex);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getComponent().isEnabled() && e.getKeyCode() == 121 && e.isShiftDown()) {
                int x = e.getComponent().getWidth() / 3;
                int y = 2 * e.getComponent().getHeight() / 3;
                AbstractPivotPopup.this._showMenu(e.getComponent(), x, y, true);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getComponent().isEnabled() && SwingUtilities.isRightMouseButton(e)) {
                AbstractPivotPopup.this._showMenu(e.getComponent(), e.getX(), e.getY(), false);
            }
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            AbstractPivotPopup.this._addListeners(e.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            AbstractPivotPopup.this._removeListeners(e.getChild());
        }
    }
}

