/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public class IconPainter
extends AbstractPainter {
    private Object _dataKey;

    public IconPainter() {
        this(PaintContext.ICON_KEY);
    }

    public IconPainter(Object dataKey) {
        this._dataKey = dataKey;
    }

    @Override
    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        return this.getMinimumSize(context);
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        Icon icon = this.getIconData(context);
        if (icon != null) {
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            if (width > 0 && height > 0) {
                return new Dimension(width, height);
            }
        }
        return new Dimension(0, 0);
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Icon icon = this.getIconData(context);
        if (icon != null) {
            icon.paintIcon(context.getComponent(), g, x, y);
        }
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 0;
    }

    @Override
    public boolean isTransparent(PaintContext context) {
        return true;
    }

    protected Icon getIconData(PaintContext context) {
        return (Icon)this.getData(context);
    }

    @Override
    protected Object getDataKey() {
        return this._dataKey;
    }

    @Override
    protected Object getData(PaintContext context) {
        Object data = super.getData(context);
        if (data instanceof Icon) {
            return data;
        }
        return null;
    }
}

