/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.ImmInsets;

public class FixedBorderPainter
extends AbstractBorderPainter {
    private ImmInsets _insets;
    private boolean _fillBorder;

    public FixedBorderPainter(int top, int left, int bottom, int right) {
        this._init(top, left, bottom, right, true);
    }

    public FixedBorderPainter(Painter wrappedPainter, int top, int left, int bottom, int right) {
        super(wrappedPainter);
        this._init(top, left, bottom, right, true);
    }

    public FixedBorderPainter(Painter wrappedPainter, int top, int left, int bottom, int right, boolean alwaysAddBorder) {
        super(wrappedPainter, alwaysAddBorder);
        this._init(top, left, bottom, right, true);
    }

    public FixedBorderPainter(Painter wrappedPainter, int top, int left, int bottom, int right, boolean alwaysAddBorder, boolean fillBorder) {
        super(wrappedPainter, alwaysAddBorder);
        this._init(top, left, bottom, right, fillBorder);
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return this._insets;
    }

    @Override
    protected ImmInsets getOwnFillInsets(PaintContext context) {
        if (this._fillBorder) {
            return ImmInsets.getEmptyInsets();
        }
        return this.getOwnInsets(context);
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        ImmInsets insets = this._insets;
        return insets.top != 0 || insets.left != 0 || insets.bottom != 0 || insets.right != 0;
    }

    private void _init(int top, int left, int bottom, int right, boolean fillBorder) {
        this._insets = new ImmInsets(top, left, bottom, right);
        this._fillBorder = fillBorder;
    }
}

