/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.AbstractButtonPaintContext;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.LabelFGChange;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleInsetBorderPainter;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.olaf.PainterComponent;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.olaf.ViewPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FGBGColorChange;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.util.ImmInsets;

public class OracleUIUtils {
    private static final Border _sWideInsetBorder = new oracle.bali.ewt.plaf.BorderAdapter(new OracleInsetBorderPainter(false));
    private static final Border _sNarrowInsetBorder = new oracle.bali.ewt.plaf.BorderAdapter(new OracleInsetBorderPainter(true));
    private static BorderPainter _sFocusPainter;
    private static Painter _sIconPainter;
    private static Painter _sBackgroundPainter;
    private static Painter _sHTMLTextPainter;
    private static Painter _sLabelTextPainter;

    public static int getPaintState(Component component) {
        if (component instanceof JComponent) {
            return OracleUIUtils.getPaintContext((JComponent)component).getPaintState();
        }
        return JPaintContext.getBasePaintState(component);
    }

    public static boolean isLeftToRight(PaintContext context) {
        return context.getReadingDirection() == 1;
    }

    public static int getActualHorizontalAlignment(PaintContext context, int baseAlignment) {
        if (baseAlignment == 10) {
            baseAlignment = OracleUIUtils.isLeftToRight(context) ? 2 : 4;
        } else if (baseAlignment == 11) {
            baseAlignment = OracleUIUtils.isLeftToRight(context) ? 4 : 2;
        }
        return baseAlignment;
    }

    public static boolean pointIsInChild(Container container, int x, int y) {
        int numComponents = container.getComponentCount();
        for (int i = numComponents - 1; i >= 0; --i) {
            int compY;
            int compX;
            Component currComponent = container.getComponent(i);
            if (currComponent == null) continue;
            if (currComponent instanceof JComponent) {
                JComponent jc = (JComponent)currComponent;
                compX = jc.getX();
                compY = jc.getY();
            } else {
                Point location = currComponent.getLocation();
                compX = location.x;
                compY = location.y;
            }
            if (!currComponent.contains(x - compX, y - compY)) continue;
            return true;
        }
        return false;
    }

    public static void putPaintContext(JComponent component) {
        OracleUIUtils.putPaintContext(component, OracleUIUtils._createDefaultContext(component));
    }

    public static void putPaintContext(JComponent component, PaintContext context) {
        JPaintContext.putPaintContext(component, context);
    }

    public static void removePaintContext(JComponent component) {
        JPaintContext.removePaintContext(component);
    }

    public static UIDefaults getUIDefaults(JComponent component) {
        return OracleUIUtils.getPaintContext(component).getPaintUIDefaults();
    }

    public static PaintContext getPaintContext(JComponent component) {
        PaintContext context = JPaintContext.getPaintContext(component);
        if (context != null) {
            return context;
        }
        return OracleUIUtils._createDefaultContext(component);
    }

    public static Dimension getMinimumSize(PainterUI ui, JComponent component) {
        return UIUtils.getMinimumSize(OracleUIUtils._getPainter(ui, component), OracleUIUtils.getPaintContext(component), component);
    }

    public static Dimension getPreferredSize(PainterUI ui, JComponent component) {
        return UIUtils.getPreferredSize(OracleUIUtils._getPainter(ui, component), OracleUIUtils.getPaintContext(component), component);
    }

    public static Dimension getMaximumSize(PainterUI ui, JComponent component) {
        return UIUtils.getMaximumSize(OracleUIUtils._getPainter(ui, component), OracleUIUtils.getPaintContext(component), component);
    }

    public static void paint(PainterUI ui, Graphics g, JComponent component) {
        UIUtils.paint(g, OracleUIUtils._getPainter(ui, component), OracleUIUtils.getPaintContext(component), component);
    }

    public static boolean contains(PainterUI ui, JComponent component, int x, int y) {
        return UIUtils.contains(OracleUIUtils._getPainter(ui, component), OracleUIUtils.getPaintContext(component), component, x, y);
    }

    public static ImmInsets getInsets(JComponent c) {
        return UIUtils.getInsets(c);
    }

    public static void fillBackground(Graphics g, JComponent c) {
        UIUtils.fillBackground(g, c);
    }

    public static Painter getPainter(JComponent component, Object key) {
        Object o = OracleUIUtils.getUIDefaults(component).get(key);
        if (o instanceof Painter) {
            return (Painter)o;
        }
        return null;
    }

    public static Painter getIconPainter() {
        if (_sIconPainter == null) {
            _sIconPainter = new IconPainter();
        }
        return _sIconPainter;
    }

    public static Painter getHTMLTextPainter() {
        if (_sHTMLTextPainter == null) {
            _sHTMLTextPainter = new ViewPainter(new DisablingPainter(new TruncatingTextPainter()));
        }
        return _sHTMLTextPainter;
    }

    public static Painter getLabelTextPainter() {
        if (_sLabelTextPainter == null) {
            _sLabelTextPainter = new LabelFGChange(OracleUIUtils.getHTMLTextPainter());
        }
        return _sLabelTextPainter;
    }

    public static Painter getBackgroundPainter() {
        if (_sBackgroundPainter == null) {
            _sBackgroundPainter = new FGBGColorChange(FilledRectPainter.getPainter(), false);
        }
        return _sBackgroundPainter;
    }

    public static Painter getFocusPainter() {
        if (_sFocusPainter == null) {
            _sFocusPainter = new OracleFocusPainter(NullPainter.getPainter());
        }
        return _sFocusPainter;
    }

    public static Border getNarrowInsetBorder() {
        return _sNarrowInsetBorder;
    }

    public static Border getWideInsetBorder() {
        return _sWideInsetBorder;
    }

    public static Image getImage(String name) {
        return ImageUtils.getImageResource(OracleUIUtils.class, "icons/" + name);
    }

    public static ColorScheme getColorScheme() {
        if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
            return BrowserLookAndFeel.getColorScheme();
        }
        return OracleLookAndFeel.getColorScheme();
    }

    public static Image getColorizedImage(String name, ColorScheme scheme) {
        return ImageUtils.createFilteredImage(OracleUIUtils.getImage(name), scheme.createColorizingFilter());
    }

    public static Object cImageInst(UIDefaults defaults, Object key, String discriminant) {
        int schemeIndex = discriminant.lastIndexOf("%");
        if (schemeIndex < 0) {
            return OracleUIUtils.getColorizedImage(discriminant, OracleUIUtils.getColorScheme());
        }
        String imageName = discriminant.substring(0, schemeIndex);
        ColorScheme scheme = OracleUIUtils.getColorScheme();
        return OracleUIUtils.getColorizedImage(imageName, scheme);
    }

    public static Object cIconInst(UIDefaults defaults, Object key, String discriminant) {
        return new ImageIcon((Image)OracleUIUtils.cImageInst(defaults, key, discriminant));
    }

    public static Object imageInst(UIDefaults defaults, Object key, String discriminant) {
        return OracleUIUtils.getImage(discriminant);
    }

    private static ImmInsets _getInsets(JComponent c, boolean fill) {
        ImmInsets insets = ImmInsets.getEmptyInsets();
        Border border = c.getBorder();
        if (border != null) {
            if (border instanceof BorderAdapter) {
                BorderPainter painter = ((BorderAdapter)border).getBorderPainter();
                insets = fill ? painter.getFillInsets(OracleUIUtils.getPaintContext(c)) : painter.getInsets(OracleUIUtils.getPaintContext(c));
            } else {
                insets = new ImmInsets(border.getBorderInsets(c));
            }
        }
        return insets;
    }

    private static PaintContext _createDefaultContext(JComponent component) {
        if (component instanceof AbstractButton) {
            return new AbstractButtonPaintContext((AbstractButton)component);
        }
        return new JPaintContext(component);
    }

    private static void _addInsets(JComponent component, Dimension d) {
        ImmInsets i = OracleUIUtils.getInsets(component);
        d.width += i.left + i.right;
        d.height += i.top + i.bottom;
    }

    static Painter _getPainter(PainterUI ui, JComponent c) {
        if (c instanceof PainterComponent) {
            return ((PainterComponent)((Object)c)).getPainter();
        }
        return ui.getPainter(c);
    }

    private OracleUIUtils() {
    }
}

