/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleTabPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.TabTextPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.ColorChange;
import oracle.bali.ewt.painter.DirectionalBorderPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.painter.PainterStacker;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.LexiComparator;
import oracle.bali.share.sort.Sort;
import oracle.bali.share.util.IntegerUtils;

public class OracleTabbedPaneUI
extends TabbedPaneUI
implements LayoutManager {
    private Component _visibleComponent;
    private static final int _MINIMUM_TRUNCATION = 4;
    private static final int _TAB_OVERLAP = 3;
    private static final int _SCROLL_BUTTON_MARGIN = 2;
    private TabCtxt _buttonContext;
    private TabCtxt _context;
    private Listeners _listeners;
    private KeyStroke _upKey;
    private KeyStroke _downKey;
    private KeyStroke _altUpKey;
    private KeyStroke _altDownKey;
    private KeyStroke _previousKey;
    private KeyStroke _nextKey;
    private KeyStroke _pageDownKey;
    private KeyStroke _pageUpKey;
    Integer _minimumChars;
    Rectangle _buttonBounds;
    boolean _buttonArmed;
    int _firstVisible;
    int _lastVisible;
    Rectangle[] _rects;
    JTabbedPane _tabPane;
    private static final ImmInsets _sContentInsets = new ImmInsets(3, 3, 3, 3);
    private static Painter _sButtonPainter;
    private static final Painter[] _sPainterCache;
    private static final String _PROPERTY_DONT_TRUNCATE = "DontTruncateTabs";
    private Font _basicFont;
    private Font _boldFont;
    private Icon _visibleIcon;
    private Icon _spacingIcon;
    private ScrollablePopupMenu _popupMenu;
    private static final int _BOTTOM = 0;
    private static final int _TOP = 1;
    private static final int _RIGHT = 2;
    private static final int _LEFT = 3;

    public static ComponentUI createUI(JComponent component) {
        return new OracleTabbedPaneUI();
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("TabbedPane.visibleSet".equals(key)) {
            return new ImageSetIcon(new ImageStrip((Image)OracleUIUtils.cImageInst(defaults, null, "tabvisstrip.gif"), 2));
        }
        return null;
    }

    @Override
    public void installUI(JComponent c) {
        this._tabPane = (JTabbedPane)c;
        c.setLayout(this);
        this._listeners = new Listeners();
        c.addMouseListener(this._listeners);
        c.addFocusListener(this._listeners);
        c.addPropertyChangeListener(this._listeners);
        this._tabPane.addChangeListener(this._listeners);
        this._buttonBounds = new Rectangle();
        this._buttonContext = new TabCtxt(this._tabPane, true);
        this._context = new TabCtxt(this._tabPane, false);
        LookAndFeel.installColorsAndFont(c, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this._installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this._popupMenu != null) {
            this._popupMenu.dispose();
            this._spacingIcon = null;
            this._visibleIcon = null;
            this._boldFont = null;
            this._basicFont = null;
            this._popupMenu = null;
        }
        this._uninstallKeyboardActions();
        c.removeMouseListener(this._listeners);
        c.removeFocusListener(this._listeners);
        c.removePropertyChangeListener(this._listeners);
        this._tabPane.removeChangeListener(this._listeners);
        c.setLayout(null);
        this._tabPane = null;
        this._buttonBounds = null;
        this._listeners = null;
        this._buttonContext.dispose();
        this._buttonContext = null;
        this._context.dispose();
        this._context = null;
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        Rectangle r = this._getTabBounds(i);
        r = r != null ? new Rectangle(r) : new Rectangle();
        return r;
    }

    @Override
    public int getTabRunCount(JTabbedPane pane) {
        return 1;
    }

    @Override
    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        if (this._buttonBounds.contains(x, y)) {
            return -1;
        }
        Rectangle[] rects = this._rects;
        if (rects != null) {
            for (int i = this._firstVisible; i <= this._lastVisible; ++i) {
                if (!rects[i].contains(x, y)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JTabbedPane tabPane = this._tabPane;
        int selectedIndex = tabPane.getSelectedIndex();
        int tabCount = tabPane.getTabCount();
        if (tabCount > 0) {
            Rectangle tabRect;
            if (tabCount != this._rects.length) {
                tabPane.validate();
            }
            Rectangle clipRect = g.getClipBounds();
            for (int i = this._firstVisible; i <= this._lastVisible; ++i) {
                Rectangle tabRect2;
                if (i == selectedIndex || !(tabRect2 = this._rects[i]).intersects(clipRect)) continue;
                this._paintTab(g, i, tabRect2);
            }
            if (selectedIndex >= 0 && (tabRect = this._rects[selectedIndex]).intersects(clipRect)) {
                this._paintTab(g, selectedIndex, tabRect);
            }
            if (this._isScrollButtonVisible()) {
                Rectangle buttonBounds = this._buttonBounds;
                OracleTabbedPaneUI._getButtonPainter().paint(this._getButtonContext(), g, buttonBounds.x, buttonBounds.y, buttonBounds.width, buttonBounds.height);
            }
        }
        this._paintContentBorder(g, selectedIndex);
    }

    public ImmInsets getContentBorderInsets(int tabPlacement) {
        return _sContentInsets;
    }

    void selectNextTab() {
        JTabbedPane tabPane = this._tabPane;
        int current = this._tabPane.getSelectedIndex();
        int tabIndex = this._getNextTabIndex(current);
        while (tabIndex >= 0 && tabIndex != current && !tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this._getNextTabIndex(tabIndex);
        }
        if (tabIndex >= 0) {
            tabPane.setSelectedIndex(tabIndex);
        }
    }

    void selectPreviousTab() {
        JTabbedPane tabPane = this._tabPane;
        int current = this._tabPane.getSelectedIndex();
        int tabIndex = this._getPreviousTabIndex(current);
        while (tabIndex >= 0 && tabIndex != current && !tabPane.isEnabledAt(tabIndex)) {
            tabIndex = this._getPreviousTabIndex(tabIndex);
        }
        if (tabIndex >= 0) {
            tabPane.setSelectedIndex(tabIndex);
        }
    }

    private int _getPreviousTabIndex(int base) {
        return base - 1;
    }

    private int _getNextTabIndex(int base) {
        if (++base == this._tabPane.getTabCount()) {
            return -1;
        }
        return base;
    }

    private void _paintTab(Graphics g, int index, Rectangle tabRect) {
        PaintContext context = this._getTabContext(index);
        this._getPainter(tabRect).paint(context, g, tabRect.x, tabRect.y, tabRect.width, tabRect.height);
    }

    private void _paintContentBorder(Graphics g, int selectedIndex) {
        int endY;
        int startY;
        int endX;
        int startX;
        boolean leftSelected;
        boolean flushRight;
        boolean flushLeft;
        Color cornerPixel;
        Color shadow;
        Color light;
        JTabbedPane tabPane = this._tabPane;
        int width = tabPane.getWidth();
        int height = tabPane.getHeight();
        int tabPlacement = tabPane.getTabPlacement();
        Insets insets = tabPane.getInsets();
        boolean emptyTabPane = tabPane.getTabCount() == 0;
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        if (emptyTabPane) {
            tabPlacement = Integer.MIN_VALUE;
        }
        switch (tabPlacement) {
            case 2: {
                w -= (x += this._getTabBounds((int)0).width) - insets.left;
                break;
            }
            case 4: {
                w -= this._getTabBounds((int)0).width;
                break;
            }
            case 3: {
                h -= this._getTabBounds((int)0).height;
                break;
            }
            case 1: {
                h -= (y += this._getTabBounds((int)0).height) - insets.top;
                break;
            }
        }
        int right = x + w - 1;
        int bottom = y + h - 1;
        PaintContext context = this._getTabContext(0);
        UIDefaults defaults = context.getPaintUIDefaults();
        Color dark = defaults.getColor("TabbedPane.darkShadow");
        Color normal = defaults.getColor("TabbedPane.normalColor");
        Color back = tabPane.getBackground();
        Color singleLine = defaults.getColor("TabbedPane.selectedColor");
        boolean changeCornerColor = Boolean.TRUE.equals(defaults.get("TabbedPane.changeCornerColor"));
        if ((context.getPaintState() & 4) == 0 || !changeCornerColor) {
            light = defaults.getColor("TabbedPane.lightBorder");
            shadow = normal;
            singleLine = defaults.getColor("TabbedPane.selectedColor");
            cornerPixel = defaults.getColor("TabbedPane.cornerPixel");
        } else {
            light = dark;
            shadow = dark;
            cornerPixel = dark;
            singleLine = defaults.getColor("TabbedPane.inactiveSelectedColor");
        }
        g.setColor(back);
        g.fillRect(x + 1, y + 1, w - 2, h - 2);
        boolean flipped = this._flipItems();
        if (emptyTabPane) {
            flushLeft = false;
            flushRight = false;
        } else if (this._isVertical()) {
            flushLeft = this._getTabBounds((int)this._firstVisible).y == y;
            r = this._getTabBounds(this._lastVisible);
            flushRight = r.y + r.height - 1 == bottom;
        } else {
            flushLeft = this._getTabBounds((int)(flipped ? this._lastVisible : this._firstVisible)).x == x;
            r = this._getTabBounds(flipped ? this._firstVisible : this._lastVisible);
            boolean bl = flushRight = r.x + r.width - 1 == right;
        }
        boolean bl = flushLeft && selectedIndex == (flipped ? this._lastVisible : this._firstVisible) ? true : (leftSelected = false);
        boolean rightSelected = flushRight && selectedIndex == (flipped ? this._firstVisible : this._lastVisible);
        Rectangle selectedBounds = emptyTabPane ? null : this._getTabBounds(selectedIndex);
        g.setColor(light);
        if (tabPlacement == 1) {
            if (!leftSelected) {
                g.drawLine(x + 3, y, selectedBounds.x - 1, y);
            }
            if (!rightSelected) {
                g.drawLine(selectedBounds.x + selectedBounds.width, y, right - 3, y);
            }
            g.setColor(singleLine);
            g.drawLine(selectedBounds.x, y, selectedBounds.x + selectedBounds.width - 1, y);
            g.setColor(light);
        } else {
            startX = tabPlacement == 2 && leftSelected ? x : x + 3;
            endX = tabPlacement == 4 && leftSelected ? right : right - 3;
            g.drawLine(startX, y, endX, y);
        }
        if (!leftSelected || tabPlacement != 1 && tabPlacement != 2) {
            if (tabPlacement == 1 || tabPlacement == 2) {
                g.setColor(cornerPixel);
            }
            g.drawLine(x + 1, y + 1, x + 2, y + 1);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
            g.setColor(light);
        }
        if ((tabPlacement == 1 || tabPlacement == 2) && flushLeft && !leftSelected) {
            g.setColor(normal);
            g.drawLine(x, y, x + 2, y);
            g.drawLine(x, y + 1, x, y + 2);
            g.setColor(light);
        }
        if (tabPlacement == 2) {
            if (!leftSelected) {
                g.drawLine(x, y + 3, x, selectedBounds.y - 1);
            }
            if (!rightSelected) {
                g.drawLine(x, selectedBounds.y + selectedBounds.height, x, bottom - 3);
            }
            g.setColor(singleLine);
            g.drawLine(x, selectedBounds.y + (leftSelected ? 1 : 0), x, selectedBounds.y + selectedBounds.height - 1);
            g.setColor(light);
        } else {
            startY = tabPlacement == 1 && leftSelected ? y : y + 3;
            endY = tabPlacement == 3 && leftSelected ? bottom : bottom - 3;
            g.drawLine(x, startY, x, endY);
        }
        if (!(tabPlacement == 2 && rightSelected || tabPlacement == 3 && leftSelected)) {
            if (tabPlacement == 3) {
                g.setColor(cornerPixel);
            }
            g.drawLine(x + 1, bottom - 2, x + 1, bottom - 2);
            if (changeCornerColor) {
                g.setColor(shadow);
            }
            g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
            if (changeCornerColor) {
                g.setColor(light);
            }
            g.drawLine(x + 2, bottom - 1, x + 2, bottom - 1);
            g.setColor(light);
        }
        if (tabPlacement == 2 && flushRight && !rightSelected || tabPlacement == 3 && flushLeft && !leftSelected) {
            g.setColor(normal);
            g.drawLine(x, bottom - 2, x, bottom);
            g.drawLine(x + 1, bottom, x + 2, bottom);
            g.setColor(dark);
        } else {
            g.setColor(dark);
        }
        if (tabPlacement == 3) {
            if (!leftSelected) {
                g.drawLine(x + 3, bottom, selectedBounds.x - 1, bottom);
            }
            if (!rightSelected) {
                g.drawLine(selectedBounds.x + selectedBounds.width, bottom, right - 3, bottom);
            }
            g.setColor(singleLine);
            startX = selectedBounds.x;
            if (startX == x) {
                ++startX;
            }
            g.drawLine(startX, bottom, selectedBounds.x + selectedBounds.width - 1, bottom);
            g.setColor(dark);
        } else {
            startX = tabPlacement == 2 && rightSelected ? x : x + 3;
            endX = tabPlacement == 4 && rightSelected ? right : right - 3;
            g.drawLine(startX, bottom, endX, bottom);
        }
        if (!rightSelected || tabPlacement != 3 && tabPlacement != 4) {
            g.drawLine(right - 1, bottom - 1, right - 2, bottom - 1);
            g.drawLine(right - 1, bottom - 2, right - 1, bottom - 2);
        }
        if ((tabPlacement == 3 || tabPlacement == 4) && flushRight && !rightSelected) {
            g.setColor(normal);
            g.drawLine(bottom, y, right - 2, bottom);
            g.drawLine(right, bottom - 1, right, bottom - 2);
            g.setColor(dark);
        }
        if (tabPlacement == 4) {
            if (!leftSelected) {
                g.drawLine(right, y + 3, right, selectedBounds.y - 1);
            }
            if (!rightSelected) {
                g.drawLine(right, selectedBounds.y + selectedBounds.height, right, bottom - 3);
            }
            g.setColor(singleLine);
            g.drawLine(right, selectedBounds.y + (leftSelected ? 1 : 0), right, selectedBounds.y + selectedBounds.height - 1);
            g.setColor(dark);
        } else {
            startY = tabPlacement == 1 && rightSelected ? y : y + 3;
            endY = tabPlacement == 3 && rightSelected ? bottom : bottom - 3;
            g.drawLine(right, startY, right, endY);
        }
        if (!(tabPlacement == 4 && leftSelected || tabPlacement == 1 && rightSelected)) {
            if (tabPlacement == 4) {
                g.setColor(cornerPixel);
            }
            g.drawLine(right - 1, y + 2, right - 1, y + 2);
            if (changeCornerColor) {
                g.setColor(shadow);
            }
            g.drawLine(right - 1, y + 1, right - 1, y + 1);
            if (changeCornerColor) {
                g.setColor(light);
            }
            g.drawLine(right - 2, y + 1, right - 2, y + 1);
            g.setColor(light);
        }
        if (tabPlacement == 4 && flushLeft && !leftSelected || tabPlacement == 1 && flushRight && !rightSelected) {
            g.setColor(normal);
            g.drawLine(right - 2, y, right, y);
            g.drawLine(right, y + 1, right, y + 2);
        }
    }

    void _installKeyboardActions() {
        JTabbedPane tabPane = this._tabPane;
        boolean vertical = this._isVertical();
        if (vertical) {
            this._altDownKey = KeyStroke.getKeyStroke(39, 8);
            this._altUpKey = KeyStroke.getKeyStroke(37, 8);
            this._nextKey = KeyStroke.getKeyStroke(40, 0);
            this._previousKey = KeyStroke.getKeyStroke(38, 0);
            this._upKey = KeyStroke.getKeyStroke(39, 0);
            this._downKey = KeyStroke.getKeyStroke(37, 0);
        } else {
            this._altDownKey = KeyStroke.getKeyStroke(40, 8);
            this._altUpKey = KeyStroke.getKeyStroke(38, 8);
            if (OracleUIUtils.isLeftToRight(this._getButtonContext())) {
                this._nextKey = KeyStroke.getKeyStroke(39, 0);
                this._previousKey = KeyStroke.getKeyStroke(37, 0);
            } else {
                this._nextKey = KeyStroke.getKeyStroke(37, 0);
                this._previousKey = KeyStroke.getKeyStroke(39, 0);
            }
            this._upKey = KeyStroke.getKeyStroke(38, 0);
            this._downKey = KeyStroke.getKeyStroke(40, 0);
        }
        PrevNext prevNext = new PrevNext();
        tabPane.registerKeyboardAction(prevNext, "Prev", this._previousKey, 0);
        tabPane.registerKeyboardAction(prevNext, "Next", this._nextKey, 0);
        this._pageUpKey = KeyStroke.getKeyStroke(33, 2);
        this._pageDownKey = KeyStroke.getKeyStroke(34, 2);
        tabPane.registerKeyboardAction(prevNext, "Prev", this._pageUpKey, 1);
        tabPane.registerKeyboardAction(prevNext, "Next", this._pageDownKey, 1);
        AbstractAction popDown = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleTabbedPaneUI.this._showScrollMenu();
            }

            @Override
            public boolean isEnabled() {
                return OracleTabbedPaneUI.this._isScrollButtonVisible() && !OracleTabbedPaneUI.this._isPopupVisible();
            }
        };
        tabPane.registerKeyboardAction(popDown, this._upKey, 0);
        tabPane.registerKeyboardAction(popDown, this._downKey, 0);
        AbstractAction togglePopup = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OracleTabbedPaneUI.this._togglePopup();
            }

            @Override
            public boolean isEnabled() {
                return OracleTabbedPaneUI.this._isScrollButtonVisible();
            }
        };
        tabPane.registerKeyboardAction(togglePopup, this._altUpKey, 1);
        tabPane.registerKeyboardAction(togglePopup, this._altDownKey, 1);
    }

    void _uninstallKeyboardActions() {
        JTabbedPane tabPane = this._tabPane;
        tabPane.unregisterKeyboardAction(this._upKey);
        tabPane.unregisterKeyboardAction(this._downKey);
        tabPane.unregisterKeyboardAction(this._altUpKey);
        tabPane.unregisterKeyboardAction(this._altDownKey);
        tabPane.unregisterKeyboardAction(this._previousKey);
        tabPane.unregisterKeyboardAction(this._nextKey);
        tabPane.unregisterKeyboardAction(this._pageUpKey);
        tabPane.unregisterKeyboardAction(this._pageDownKey);
        this._pageDownKey = null;
        this._pageUpKey = null;
        this._nextKey = null;
        this._previousKey = null;
        this._altDownKey = null;
        this._altUpKey = null;
        this._downKey = null;
        this._upKey = null;
    }

    boolean _isScrollButtonVisible() {
        Rectangle buttonBounds = this._buttonBounds;
        return buttonBounds.width != 0 || buttonBounds.height != 0;
    }

    void _showScrollMenu() {
        if (this._isScrollButtonVisible()) {
            JTabbedPane tabPane = this._tabPane;
            Rectangle tabBounds = tabPane.getBounds();
            if (tabBounds.isEmpty()) {
                return;
            }
            tabBounds.setLocation(tabPane.getLocationOnScreen());
            Rectangle buttonBounds = new Rectangle(this._buttonBounds);
            buttonBounds.translate(tabBounds.x, tabBounds.y);
            Rectangle selBounds = this.getTabBounds(tabPane, tabPane.getSelectedIndex());
            selBounds.translate(tabBounds.x, tabBounds.y);
            GraphicsDevice[] gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            GraphicsConfiguration gc = null;
            for (int i = 0; i < gds.length; ++i) {
                GraphicsConfiguration dgc = gds[i].getDefaultConfiguration();
                Rectangle screenBounds = dgc.getBounds();
                if (screenBounds.contains(buttonBounds.x, buttonBounds.y)) {
                    gc = dgc;
                    break;
                }
                if (!screenBounds.intersects(selBounds) && (gc != null || !screenBounds.intersects(tabBounds))) continue;
                gc = dgc;
            }
            if (gc == null) {
                return;
            }
            Rectangle displayBounds = gc.getBounds();
            Insets screenInsets = MenuUtils.getScreenInsets(gc);
            displayBounds.x += screenInsets.left;
            displayBounds.y += screenInsets.top;
            displayBounds.width -= screenInsets.left + screenInsets.right;
            displayBounds.height -= screenInsets.top + screenInsets.bottom;
            if (this._popupMenu == null) {
                UIDefaults defaults = this._getButtonContext().getPaintUIDefaults();
                this._visibleIcon = defaults.getIcon("TabbedPane.visibleSet");
                this._spacingIcon = new SpacingIcon(this._visibleIcon);
                this._popupMenu = new ScrollablePopupMenu();
            }
            if (this._basicFont == null) {
                this._basicFont = tabPane.getFont();
                this._boldFont = new Font(this._basicFont.getName(), this._basicFont.getStyle() | 1, this._basicFont.getSize());
            }
            this._popupMenu.populate();
            Dimension popupSize = this._popupMenu.getPreferredSize();
            if (!FocusUtils.areNewFocusAPIsAvailable()) {
                Container root;
                Container parent = root = tabPane.getParent();
                while (root != null) {
                    parent = root.getParent();
                    if (root instanceof JRootPane && parent != null && (parent instanceof Window || parent instanceof Applet)) {
                        Rectangle avail = root.getBounds();
                        avail.setLocation(root.getLocationOnScreen());
                        SwingUtilities.computeIntersection(displayBounds.x, displayBounds.y, displayBounds.width, displayBounds.height, avail);
                        Dimension min = this._popupMenu.getMinimumSize();
                        if (avail.width < min.width) {
                            avail.width = min.width;
                            avail.x -= Math.max(0, avail.x + avail.width - (displayBounds.x + displayBounds.width));
                        }
                        if (avail.height < min.height) {
                            avail.height = min.height;
                            avail.y -= Math.max(0, avail.y + avail.height - (displayBounds.y + displayBounds.height));
                        }
                        displayBounds = avail;
                        break;
                    }
                    root = parent;
                }
            }
            if (displayBounds.intersects(buttonBounds)) {
                SwingUtilities.computeIntersection(displayBounds.x, displayBounds.y, displayBounds.width, displayBounds.height, buttonBounds);
            } else {
                int outcode = displayBounds.outcode(buttonBounds.x, buttonBounds.y);
                if ((outcode & 1) != 0) {
                    buttonBounds.x = displayBounds.x;
                } else if ((outcode & 4) != 0) {
                    buttonBounds.x = displayBounds.x + displayBounds.width;
                }
                if ((outcode & 2) != 0) {
                    buttonBounds.y = displayBounds.y;
                } else if ((outcode & 8) != 0) {
                    buttonBounds.y = displayBounds.y + displayBounds.height;
                }
                buttonBounds.height = 0;
                buttonBounds.width = 0;
            }
            Dimension bottomArea = new Dimension(displayBounds.width, displayBounds.y + displayBounds.height - (buttonBounds.y + buttonBounds.height));
            Dimension topArea = new Dimension(displayBounds.width, buttonBounds.y - displayBounds.y);
            Dimension rightArea = new Dimension(displayBounds.x + displayBounds.width - (buttonBounds.x + buttonBounds.width), displayBounds.height);
            Dimension leftArea = new Dimension(buttonBounds.x - displayBounds.x, displayBounds.height);
            int[] area = new int[]{Math.min(bottomArea.width, popupSize.width) * Math.min(bottomArea.height, popupSize.height), Math.min(topArea.width, popupSize.width) * Math.min(topArea.height, popupSize.height), Math.min(rightArea.width, popupSize.width) * Math.min(rightArea.height, popupSize.height), Math.min(leftArea.width, popupSize.width) * Math.min(leftArea.height, popupSize.height)};
            int[] prefArea = new int[4];
            switch (tabPane.getTabPlacement()) {
                case 2: {
                    prefArea[0] = 2;
                    prefArea[1] = 1;
                    prefArea[2] = 3;
                    prefArea[3] = 0;
                    break;
                }
                case 4: {
                    prefArea[0] = 3;
                    prefArea[1] = 1;
                    prefArea[2] = 2;
                    prefArea[3] = 0;
                    break;
                }
                case 3: {
                    prefArea[0] = 1;
                    prefArea[1] = 3;
                    prefArea[2] = 0;
                    prefArea[3] = 2;
                    break;
                }
                default: {
                    prefArea[0] = 0;
                    prefArea[1] = 3;
                    prefArea[2] = 1;
                    prefArea[3] = 2;
                }
            }
            int maxArea = area[prefArea[0]];
            int pos = prefArea[0];
            for (int i = 1; i < 4; ++i) {
                if (maxArea >= area[prefArea[i]]) continue;
                maxArea = area[prefArea[i]];
                pos = prefArea[i];
            }
            switch (pos) {
                case 0: {
                    this._popupMenu.preLayout(popupSize, bottomArea);
                    break;
                }
                case 1: {
                    this._popupMenu.preLayout(popupSize, topArea);
                    break;
                }
                case 2: {
                    this._popupMenu.preLayout(popupSize, rightArea);
                    break;
                }
                case 3: {
                    this._popupMenu.preLayout(popupSize, leftArea);
                }
            }
            buttonBounds.translate(-tabBounds.x, -tabBounds.y);
            int x = buttonBounds.x;
            int y = buttonBounds.y;
            if (pos == 0 || pos == 1) {
                x += this._buttonBounds.x + this._buttonBounds.width >= tabBounds.width - this._buttonBounds.x ? buttonBounds.width - Math.min(leftArea.width + buttonBounds.width, popupSize.width) : Math.min(rightArea.width + buttonBounds.width, popupSize.width) - popupSize.width;
                y += pos == 0 ? buttonBounds.height : -popupSize.height;
            } else {
                x += pos == 2 ? buttonBounds.width : -popupSize.width;
                y += this._buttonBounds.y + this._buttonBounds.height >= tabBounds.height - this._buttonBounds.y ? buttonBounds.height - Math.min(topArea.height + buttonBounds.height, popupSize.height) : Math.min(bottomArea.height + buttonBounds.height, popupSize.height) - popupSize.height;
            }
            this._popupMenu.show(tabPane, x, y);
        }
    }

    private void _togglePopup() {
        if (this._isPopupVisible()) {
            this._popupMenu.hidePopup();
        } else {
            this._showScrollMenu();
        }
    }

    private boolean _isPopupVisible() {
        return this._popupMenu != null && this._popupMenu.isVisible();
    }

    void _setButtonArmed(boolean armed) {
        if (armed != this._buttonArmed) {
            this._buttonArmed = armed;
            this._tabPane.repaint(this._buttonBounds.x, this._buttonBounds.y, this._buttonBounds.width, this._buttonBounds.height);
        }
    }

    Icon _getIconForTab(int tabIndex) {
        JTabbedPane tabPane = this._tabPane;
        return !tabPane.isEnabledAt(tabIndex) && tabPane.getDisabledIconAt(tabIndex) != null ? tabPane.getDisabledIconAt(tabIndex) : tabPane.getIconAt(tabIndex);
    }

    private Painter _getPainter(Rectangle tabRect) {
        boolean atRight;
        boolean atLeft;
        Insets i = this._tabPane.getInsets();
        if (this._isVertical()) {
            atLeft = tabRect.y == i.top;
            atRight = tabRect.y + tabRect.height - 1 == this._tabPane.getHeight() - (i.top + i.bottom);
        } else {
            atLeft = tabRect.x == i.left;
            boolean bl = atRight = tabRect.x + tabRect.width - 1 == this._tabPane.getWidth() - (i.left + i.right);
        }
        int position = atLeft ? 1 : (atRight ? 2 : 0);
        return this._getPainter(position);
    }

    Painter _getPainter(int position) {
        int orientation = this._tabPane.getTabPlacement();
        int index = position + 3 * (orientation - 1);
        Painter painter = _sPainterCache[index];
        if (painter == null) {
            OracleTabbedPaneUI._sPainterCache[index] = painter = new OracleTabPainter(new FixedBorderPainter(new TabFocusColorChange(new OracleFocusPainter(new AlignmentPainter(new PainterJoiner(new DirectionalBorderPainter(OracleUIUtils.getIconPainter(), 0, 2, 0, 0, false), new DirectionalBorderPainter(new DisablingPainter(new TabTextPainter()), 0, 2, 0, 0, false), 13)))), 0, 2, 0, 2), orientation, position);
        }
        return painter;
    }

    PaintContext _getButtonContext() {
        return this._buttonContext;
    }

    PaintContext _getTabContext(int tabIndex) {
        this._context.setIndex(tabIndex);
        return this._context;
    }

    JTabbedPane getTabbedPane() {
        return this._tabPane;
    }

    boolean _isVertical() {
        int tabPlacement = this._tabPane.getTabPlacement();
        return tabPlacement == 2 || tabPlacement == 4;
    }

    int _getInnerSize() {
        JTabbedPane pane = this._tabPane;
        ImmInsets insets = OracleUIUtils.getInsets(pane);
        if (this._isVertical()) {
            return pane.getHeight() - (insets.top + insets.bottom);
        }
        return pane.getWidth() - (insets.left + insets.right);
    }

    int _getTabSpace() {
        int space = this._getInnerSize();
        space = this._isVertical() ? (space -= this._buttonBounds.height) : (space -= this._buttonBounds.width);
        return space;
    }

    void repaintTab(int index) {
        Rectangle r = this._getTabBounds(index);
        if (r != null) {
            this._tabPane.repaint(r);
        }
    }

    Rectangle _getTabBounds(int index) {
        if (this._rects != null && index >= 0 && index < this._rects.length) {
            return this._rects[index];
        }
        return null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this._visibleComponent == comp) {
            this._visibleComponent = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateSize(false);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateSize(true);
    }

    protected Dimension calculateSize(boolean minimum) {
        JTabbedPane tabPane = this._tabPane;
        int tabPlacement = tabPane.getTabPlacement();
        Insets insets = tabPane.getInsets();
        ImmInsets borderInsets = this.getContentBorderInsets(tabPlacement);
        Dimension zeroSize = new Dimension(0, 0);
        int height = borderInsets.top + borderInsets.bottom;
        int width = borderInsets.left + borderInsets.right;
        int cWidth = 0;
        int cHeight = 0;
        for (int i = 0; i < tabPane.getTabCount(); ++i) {
            Component component = tabPane.getComponentAt(i);
            Dimension size = zeroSize;
            Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
            if (size == null) continue;
            cHeight = Math.max(size.height, cHeight);
            cWidth = Math.max(size.width, cWidth);
        }
        width += cWidth;
        height += cHeight;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                width += this.calculateMaxTabWidth();
                break;
            }
            default: {
                height += this.calculateMaxTabHeight();
            }
        }
        return new Dimension(width + insets.left + insets.right, height + insets.bottom + insets.top);
    }

    protected int calculateMaxTabWidth() {
        int tabCount = this._tabPane.getTabCount();
        Painter painter = this._getPainter(0);
        int max = 0;
        for (int i = 0; i < tabCount; ++i) {
            PaintContext context = this._getTabContext(i);
            max = Math.max(painter.getPreferredSize((PaintContext)context).width, max);
        }
        return max;
    }

    protected int calculateMaxTabHeight() {
        int tabCount = this._tabPane.getTabCount();
        Painter painter = this._getPainter(0);
        int max = 0;
        for (int i = 0; i < tabCount; ++i) {
            PaintContext context = this._getTabContext(i);
            max = Math.max(painter.getPreferredSize((PaintContext)context).height, max);
        }
        return max;
    }

    @Override
    public void layoutContainer(Container parent) {
        JTabbedPane tabPane = this._tabPane;
        int tabPlacement = tabPane.getTabPlacement();
        Insets insets = tabPane.getInsets();
        int selectedIndex = tabPane.getSelectedIndex();
        Component visibleComponent = this._visibleComponent;
        int tabCount = tabPane.getTabCount();
        this.calculateLayoutInfo();
        if (selectedIndex < 0 || tabCount == 0) {
            this._setVisibleComponent(null);
        } else {
            int totalTabWidth = 0;
            int totalTabHeight = 0;
            ImmInsets borderInsets = this.getContentBorderInsets(tabPlacement);
            Component selectedComponent = tabPane.getComponentAt(selectedIndex);
            boolean shouldChangeFocus = false;
            if (selectedComponent != null) {
                int cx;
                if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                    shouldChangeFocus = true;
                }
                Dimension size = tabPane.getSize();
                this._setVisibleComponent(selectedComponent);
                int cy = switch (tabPlacement) {
                    case 2 -> {
                        totalTabWidth = this._getTabBounds((int)0).width;
                        cx = insets.left + totalTabWidth + borderInsets.left;
                        yield insets.top + borderInsets.top;
                    }
                    case 4 -> {
                        totalTabWidth = this._getTabBounds((int)0).width;
                        cx = insets.left + borderInsets.left;
                        yield insets.top + borderInsets.top;
                    }
                    case 3 -> {
                        totalTabHeight = this._getTabBounds((int)0).height;
                        cx = insets.left + borderInsets.left;
                        yield insets.top + borderInsets.top;
                    }
                    default -> {
                        totalTabHeight = this._getTabBounds((int)0).height;
                        cx = insets.left + borderInsets.left;
                        yield insets.top + totalTabHeight + borderInsets.top;
                    }
                };
                int cw = size.width - totalTabWidth - insets.left - insets.right - borderInsets.left - borderInsets.right;
                int ch = size.height - totalTabHeight - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom;
                selectedComponent.setBounds(cx, cy, cw, ch);
                if (shouldChangeFocus) {
                    if (selectedComponent.isFocusTraversable()) {
                        selectedComponent.requestFocus();
                        shouldChangeFocus = false;
                    } else if (selectedComponent instanceof JComponent && ((JComponent)selectedComponent).requestDefaultFocus()) {
                        shouldChangeFocus = false;
                    }
                    if (shouldChangeFocus) {
                        tabPane.requestFocus();
                    }
                }
            }
        }
    }

    protected void calculateLayoutInfo() {
        boolean vertical;
        int rectsLength;
        int y;
        int x;
        int maxTabPerpSize;
        JTabbedPane tabPane = this._tabPane;
        int tabPlacement = tabPane.getTabPlacement();
        int tabCount = tabPane.getTabCount();
        Dimension size = tabPane.getSize();
        Insets insets = tabPane.getInsets();
        int[] sizes = new int[tabCount];
        this._calculateTabSizes(tabCount, sizes);
        switch (tabPlacement) {
            case 2: {
                maxTabPerpSize = this.calculateMaxTabWidth();
                x = insets.left;
                y = insets.top;
                this._buttonBounds.setLocation(x + maxTabPerpSize - (this._buttonBounds.width + 2), tabPane.getHeight() - insets.bottom - this._buttonBounds.height);
                break;
            }
            case 4: {
                maxTabPerpSize = this.calculateMaxTabWidth();
                x = size.width - insets.right - maxTabPerpSize;
                y = insets.top;
                this._buttonBounds.setLocation(x + 2, tabPane.getHeight() - insets.bottom - this._buttonBounds.height);
                break;
            }
            case 3: {
                maxTabPerpSize = this.calculateMaxTabHeight();
                x = insets.left;
                y = size.height - insets.bottom - maxTabPerpSize;
                this._buttonBounds.setLocation(tabPane.getWidth() - insets.right - this._buttonBounds.width, y + 2);
                break;
            }
            default: {
                maxTabPerpSize = this.calculateMaxTabHeight();
                x = insets.left;
                y = insets.top;
                this._buttonBounds.setLocation(tabPane.getWidth() - insets.right - this._buttonBounds.width, y + maxTabPerpSize - (this._buttonBounds.height + 2));
            }
        }
        Rectangle[] rects = this._rects;
        int n = rectsLength = rects == null ? 0 : rects.length;
        if (tabCount != rectsLength) {
            Rectangle[] tempRectArray = new Rectangle[tabCount];
            if (rects != null) {
                System.arraycopy(rects, 0, tempRectArray, 0, Math.min(rectsLength, tabCount));
            }
            rects = tempRectArray;
            this._rects = tempRectArray;
            for (int rectIndex = rectsLength; rectIndex < tabCount; ++rectIndex) {
                rects[rectIndex] = new Rectangle();
            }
        }
        this._layoutItems(sizes, (vertical = this._isVertical()) ? y : x, vertical ? x : y, maxTabPerpSize, tabCount);
        if (tabCount > 0 && (this._firstVisible != 0 || this._lastVisible != tabCount - 1)) {
            int offset;
            int flippedLast;
            int flippedFirst;
            int flippedEnd;
            if (this._flipItems()) {
                flippedEnd = 0;
                flippedFirst = this._lastVisible;
                flippedLast = this._firstVisible;
            } else {
                flippedEnd = tabCount - 1;
                flippedFirst = this._firstVisible;
                flippedLast = this._lastVisible;
            }
            if (flippedLast == flippedEnd) {
                int maxOffset;
                int tabSpace = this._getTabSpace();
                Rectangle lastRect = this._rects[flippedLast];
                offset = tabSpace - (vertical ? lastRect.y + lastRect.height - 1 + insets.top : lastRect.x + lastRect.width - 1) + insets.left;
                Rectangle firstRect = this._rects[flippedFirst];
                int n2 = maxOffset = vertical ? -firstRect.y + insets.top : -firstRect.x + insets.left;
                if (offset < maxOffset + 3) {
                    offset = maxOffset;
                }
            } else {
                Rectangle firstRect = this._rects[flippedFirst];
                int n3 = offset = vertical ? -firstRect.y + insets.top : -firstRect.x + insets.left;
            }
            if (offset != 0) {
                int xOffset = vertical ? 0 : offset;
                int yOffset = vertical ? offset : 0;
                for (int i = 0; i < tabCount; ++i) {
                    this._rects[i].translate(xOffset, yOffset);
                }
            }
        }
    }

    private void _setVisibleComponent(Component comp) {
        if (this._visibleComponent != comp) {
            if (this._visibleComponent != null) {
                this._visibleComponent.setVisible(false);
            }
            if (comp != null) {
                comp.setVisible(true);
            }
            this._visibleComponent = comp;
        }
    }

    private boolean _flipItems() {
        return !this._isVertical() && this._getTabContext(0).getReadingDirection() == 2;
    }

    private void _calculateTabSizes(int tabCount, int[] sizes) {
        int i;
        this._buttonBounds.setSize(0, 0);
        if (tabCount == 0) {
            return;
        }
        Painter painter = this._getPainter(0);
        boolean vertical = this._isVertical();
        int innerSize = this._getInnerSize();
        if (innerSize < 0) {
            return;
        }
        int overlap = 3;
        innerSize -= overlap;
        int totalSize = 0;
        for (i = 0; i < tabCount; ++i) {
            PaintContext context = this._getTabContext(i);
            Dimension d = painter.getPreferredSize(context);
            sizes[i] = vertical ? d.height : d.width;
            totalSize += sizes[i] - overlap;
        }
        if (totalSize <= innerSize) {
            if (totalSize < innerSize && !vertical) {
                Integer[] indices = new Integer[tabCount];
                int visibleItems = this._getSortedSizes(indices, sizes);
                int maxSize = 0;
                for (i = 0; i < visibleItems; ++i) {
                    maxSize += sizes[indices[i]];
                }
                maxSize = maxSize * 3 / (2 * visibleItems);
                int total = overlap;
                boolean startGrowing = false;
                int growSize = 0;
                for (i = visibleItems - 1; i >= 0; --i) {
                    int index = indices[i];
                    if (startGrowing) {
                        sizes[index] = growSize;
                        continue;
                    }
                    int currSize = sizes[index];
                    if (currSize < maxSize && total + (currSize - overlap) * (i + 1) <= innerSize) {
                        startGrowing = true;
                        growSize = currSize;
                    }
                    total += currSize;
                }
            }
            this._firstVisible = 0;
            this._lastVisible = tabCount - 1;
            return;
        }
        if (vertical) {
            this._buttonBounds.setSize(OracleTabbedPaneUI._getButtonPainter().getPreferredSize(this._getButtonContext()));
            this._doScrolledLayout(tabCount, sizes, sizes);
            return;
        }
        this._calculateMinimumChars(tabCount);
        int[] minSizes = new int[tabCount];
        totalSize = 0;
        for (i = 0; i < tabCount; ++i) {
            PaintContext context = this._getTabContext(i);
            Dimension d = painter.getMinimumSize(context);
            minSizes[i] = vertical ? d.height : d.width;
            totalSize += minSizes[i] - overlap;
        }
        if (totalSize > innerSize) {
            this._buttonBounds.setSize(OracleTabbedPaneUI._getButtonPainter().getPreferredSize(this._getButtonContext()));
            this._doScrolledLayout(tabCount, minSizes, sizes);
            return;
        }
        this._firstVisible = 0;
        this._lastVisible = tabCount - 1;
        Integer[] indices = new Integer[tabCount];
        int visibleItems = this._getSortedSizes(indices, sizes);
        totalSize = 0;
        for (i = 0; i < visibleItems; ++i) {
            int itemsLeft;
            int itemSize = sizes[indices[i]];
            if (totalSize + (itemSize - overlap) * (itemsLeft = visibleItems - i) > innerSize) {
                int shrinkSize = (innerSize - totalSize) / itemsLeft;
                int extraPixels = innerSize - totalSize - shrinkSize * itemsLeft;
                shrinkSize += overlap;
                for (int j = i; j < visibleItems; ++j) {
                    int finalSize = shrinkSize;
                    if (extraPixels-- > 0) {
                        // empty if block
                    }
                    sizes[indices[j].intValue()] = ++finalSize;
                }
                break;
            }
            totalSize += itemSize - overlap;
        }
    }

    private int _getSortedSizes(Integer[] indices, int[] sizes) {
        int visibleItems = 0;
        int tabCount = sizes.length;
        for (int i = 0; i < tabCount; ++i) {
            indices[visibleItems++] = IntegerUtils.getInteger((int)i);
        }
        Sort.qSort((Object[])indices, (int)visibleItems, (Comparator)new SizeComp(sizes));
        return visibleItems;
    }

    private void _calculateMinimumChars(int tabCount) {
        this._minimumChars = null;
        if (tabCount <= 1) {
            return;
        }
        if (Boolean.TRUE.equals(this._tabPane.getClientProperty(_PROPERTY_DONT_TRUNCATE))) {
            return;
        }
        Object[] labels = new String[tabCount];
        for (int i = 0; i < tabCount; ++i) {
            String label = this._tabPane.getTitleAt(i);
            if (label == null) {
                return;
            }
            labels[i] = label;
        }
        Sort.qSort((Object[])labels, (int)tabCount, (Comparator)LexiComparator.getComparator());
        int maxCommon = 4;
        Object previous = labels[0];
        for (int i = 1; i < tabCount; ++i) {
            Object current = labels[i];
            int minLength = Math.min(((String)previous).length(), ((String)current).length());
            for (int j = 0; j < minLength; ++j) {
                if (((String)previous).charAt(j) == ((String)current).charAt(j)) continue;
                if (j <= maxCommon) break;
                maxCommon = j;
                break;
            }
            previous = current;
        }
        this._minimumChars = IntegerUtils.getInteger((int)(maxCommon + 2));
    }

    private void _layoutItems(int[] sizes, int tabPos, int tabPerpPos, int tabPerpSize, int tabCount) {
        int indexIncrement;
        int itemIndex;
        if (tabCount == 0) {
            return;
        }
        boolean vertical = this._isVertical();
        if (!this._flipItems()) {
            itemIndex = 0;
            indexIncrement = 1;
        } else {
            itemIndex = tabCount - 1;
            indexIncrement = -1;
        }
        int overlap = 3;
        if (itemIndex != 0) {
            int totalSize = overlap;
            for (int i = 0; i < tabCount; ++i) {
                totalSize += sizes[i] - overlap;
            }
            int innerSize = this._getTabSpace();
            if (totalSize < innerSize) {
                tabPos = innerSize - totalSize - tabPos - overlap;
            }
        }
        Rectangle[] itemRects = this._rects;
        while (itemIndex >= 0 && itemIndex < tabCount) {
            int newSize = sizes[itemIndex];
            Rectangle itemRect = itemRects[itemIndex];
            if (vertical) {
                itemRect.setBounds(tabPerpPos, tabPos, tabPerpSize, newSize);
            } else {
                itemRect.setBounds(tabPos, tabPerpPos, newSize, tabPerpSize);
            }
            tabPos += newSize - overlap;
            itemIndex += indexIncrement;
        }
    }

    private void _doScrolledLayout(int tabCount, int[] minSizes, int[] prefSizes) {
        int i;
        int total;
        if (tabCount == 0) {
            return;
        }
        int firstItem = this._firstVisible;
        int size = this._getTabSpace();
        int lastItem = this._getLastVisible(tabCount, firstItem, size, minSizes);
        int selected = this._tabPane.getSelectedIndex();
        if (selected != -1 && (selected < firstItem || selected > lastItem)) {
            if (selected < firstItem) {
                firstItem = selected;
                lastItem = this._getLastVisible(tabCount, firstItem, size, minSizes);
            } else {
                firstItem = 0;
                lastItem = selected;
                total = minSizes[lastItem];
                for (i = lastItem - 1; i >= 0; --i) {
                    if ((total += minSizes[i] - 3) <= size) continue;
                    firstItem = i + 1;
                    break;
                }
            }
        } else if (lastItem == tabCount - 1) {
            total = minSizes[lastItem];
            for (i = lastItem - 1; i >= 0; --i) {
                if ((total += minSizes[i] - 3) <= size) continue;
                firstItem = i + 1;
                break;
            }
        }
        total = minSizes[firstItem];
        for (i = firstItem + 1; i <= lastItem; ++i) {
            total += minSizes[i] - 3;
        }
        int remaining = size - total;
        for (int i2 = firstItem; i2 <= lastItem; ++i2) {
            int currSize = minSizes[i2];
            int prefSize = prefSizes[i2];
            if (currSize < prefSize) {
                int increment = Math.min(remaining, prefSize - currSize);
                currSize += increment;
                remaining -= increment;
            }
            prefSizes[i2] = currSize;
        }
        this._firstVisible = firstItem;
        this._lastVisible = lastItem;
    }

    private int _getLastVisible(int tabCount, int fromItem, int size, int[] sizes) {
        int total = sizes[fromItem];
        int toItem = tabCount - 1;
        int overlap = 3;
        for (int i = fromItem + 1; i < tabCount; ++i) {
            if ((total += sizes[i] - overlap) <= size) continue;
            toItem = i - 1;
            break;
        }
        return toItem;
    }

    static Painter _getButtonPainter() {
        if (_sButtonPainter == null) {
            _sButtonPainter = new OracleButtonPainter(new PainterStacker(OracleUIUtils.getBackgroundPainter(), new IconPainter()));
        }
        return _sButtonPainter;
    }

    static {
        _sPainterCache = new Painter[12];
    }

    private class Listeners
    extends MouseAdapter
    implements ChangeListener,
    FocusListener,
    PropertyChangeListener {
        private Listeners() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.invalidate();
            tabPane.revalidate();
            tabPane.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("tabPlacement".equals(e.getPropertyName())) {
                OracleTabbedPaneUI.this._uninstallKeyboardActions();
                OracleTabbedPaneUI.this._installKeyboardActions();
            } else if ("font".equals(e.getPropertyName())) {
                if (OracleTabbedPaneUI.this._popupMenu != null) {
                    OracleTabbedPaneUI.this._popupMenu.setMinimumSize(null);
                }
                OracleTabbedPaneUI.this._boldFont = null;
                OracleTabbedPaneUI.this._basicFont = null;
                if (OracleTabbedPaneUI.this._isPopupVisible()) {
                    OracleTabbedPaneUI.this._popupMenu.hidePopup();
                    OracleTabbedPaneUI.this._showScrollMenu();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            if (e.isConsumed() || !tabPane.isEnabled() || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (OracleTabbedPaneUI.this._buttonBounds.contains(e.getX(), e.getY())) {
                OracleTabbedPaneUI.this._togglePopup();
                e.consume();
            } else {
                int tabIndex = OracleTabbedPaneUI.this.tabForCoordinate(tabPane, e.getX(), e.getY());
                if (tabIndex >= 0 && tabPane.isEnabledAt(tabIndex)) {
                    if (tabIndex == OracleTabbedPaneUI.this._tabPane.getSelectedIndex()) {
                        tabPane.requestFocus();
                        OracleTabbedPaneUI.this.repaintTab(tabIndex);
                    } else {
                        tabPane.setSelectedIndex(tabIndex);
                    }
                }
                e.consume();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            OracleTabbedPaneUI.this.repaintTab(OracleTabbedPaneUI.this._tabPane.getSelectedIndex());
        }

        @Override
        public void focusLost(FocusEvent e) {
            OracleTabbedPaneUI.this.repaintTab(OracleTabbedPaneUI.this._tabPane.getSelectedIndex());
        }
    }

    private class TabCtxt
    extends JPaintContext {
        private int _index;
        private boolean _button;

        public TabCtxt(JTabbedPane pane, boolean button) {
            super(pane);
            this._button = button;
        }

        public void setIndex(int index) {
            this._index = index;
        }

        @Override
        public Color getPaintBackground() {
            UIDefaults defaults = this.getPaintUIDefaults();
            JTabbedPane tabPane = OracleTabbedPaneUI.this.getTabbedPane();
            if (this._button) {
                return defaults.getColor("control");
            }
            if (tabPane.getSelectedIndex() == this._index) {
                if ((super.getPaintState() & 4) == 0) {
                    return defaults.getColor("TabbedPane.selectedColor");
                }
                return defaults.getColor("TabbedPane.inactiveSelectedColor");
            }
            return defaults.getColor("TabbedPane.notSelectedColor");
        }

        @Override
        public int getPaintState() {
            int state = super.getPaintState();
            if (this._button) {
                if (OracleTabbedPaneUI.this._buttonArmed) {
                    state |= 2;
                }
            } else {
                JTabbedPane tabPane = OracleTabbedPaneUI.this.getTabbedPane();
                int index = this._index;
                if (index >= 0 && index < tabPane.getTabCount()) {
                    state = tabPane.getSelectedIndex() == index ? (state |= 0x20) : (state &= 0xFFFFFFBF);
                    if (!tabPane.isEnabledAt(index)) {
                        state |= 1;
                    }
                }
            }
            return state;
        }

        @Override
        public Object getPaintData(Object key) {
            JTabbedPane tabPane = OracleTabbedPaneUI.this.getTabbedPane();
            if (LABEL_KEY.equals(key)) {
                return tabPane.getTitleAt(this._index);
            }
            if (ICON_KEY.equals(key)) {
                if (this._button) {
                    String iconKey = OracleTabbedPaneUI.this._firstVisible == 0 ? "TabbedPane.scrollLeft" : (OracleTabbedPaneUI.this._lastVisible == tabPane.getTabCount() - 1 ? "TabbedPane.scrollRight" : "TabbedPane.scrollBoth");
                    return this.getPaintUIDefaults().get(iconKey);
                }
                return OracleTabbedPaneUI.this._getIconForTab(this._index);
            }
            if (TabTextPainter.MINIMUM_TAB_CHARACTERS.equals(key)) {
                return OracleTabbedPaneUI.this._minimumChars;
            }
            return null;
        }
    }

    private class ScrollablePopupMenu
    extends JPopupMenu {
        private boolean _isDragging;
        private boolean _restoreFocus = true;
        private int[] _indexMapping;
        private Component _prevFocussed;
        private DefaultListModel _listModel;
        private Dimension _minimumSize;
        private FocusManager _focusManager;
        private JList _list;
        private JScrollPane _scroller;
        private MouseInputHandler _mouseHandler;
        private TabPaneKeyHandler _keyHandler;

        public ScrollablePopupMenu() {
            this._configureList();
            this._configurePopup();
        }

        public void populate() {
            int selectedIndex = OracleTabbedPaneUI.this._tabPane.getSelectedIndex();
            this._indexMapping = new int[OracleTabbedPaneUI.this._tabPane.getTabCount()];
            int j = 0;
            for (int i = 0; i < OracleTabbedPaneUI.this._tabPane.getTabCount(); ++i) {
                if (!OracleTabbedPaneUI.this._tabPane.isEnabledAt(i)) continue;
                if (i == selectedIndex) {
                    selectedIndex = j;
                }
                this._indexMapping[j++] = i + 1;
                this._listModel.addElement(OracleTabbedPaneUI.this._tabPane.getTitleAt(i));
            }
            this.add(this._list);
            this._list.setSelectedIndex(selectedIndex);
        }

        public void preLayout(Dimension popupSize, Dimension maxArea) {
            if (popupSize.width > maxArea.width || popupSize.height > maxArea.height) {
                if (this._scroller == null) {
                    this._configureScroller();
                }
                this.removeAll();
                this._scroller.setViewportView(this._list);
                this.add(this._scroller);
                if (popupSize.width > maxArea.width && popupSize.height > maxArea.height) {
                    popupSize.width = maxArea.width;
                    popupSize.height = maxArea.height;
                } else if (popupSize.width > maxArea.width) {
                    popupSize.width = maxArea.width;
                    popupSize.height += this._scroller.getHorizontalScrollBar().getPreferredSize().height;
                    if (popupSize.height > maxArea.height) {
                        popupSize.height = maxArea.height;
                    }
                } else if (popupSize.height > maxArea.height) {
                    popupSize.height = maxArea.height;
                    popupSize.width += this._scroller.getVerticalScrollBar().getPreferredSize().width;
                    if (popupSize.width > maxArea.width) {
                        popupSize.width = maxArea.width;
                    }
                }
            }
            this.setPreferredSize(popupSize);
        }

        @Override
        public Dimension getMinimumSize() {
            if (this._minimumSize == null) {
                int index = this._list.getSelectedIndex();
                Insets popInsets = this.getInsets();
                this._minimumSize = new Dimension(popInsets.left + popInsets.right, popInsets.top + popInsets.bottom);
                Dimension size = this._list.getCellRenderer().getListCellRendererComponent(this._list, "JTabbedPane", index, false, false).getPreferredSize();
                this._minimumSize.width += size.width;
                this._minimumSize.height += size.height * 4;
            }
            return this._minimumSize;
        }

        @Override
        public void setMinimumSize(Dimension minSize) {
            if (minSize == null) {
                this._minimumSize = null;
            } else {
                super.setMinimumSize(minSize);
            }
        }

        @Override
        public void setVisible(boolean isVisible) {
            if (isVisible == this.isVisible()) {
                return;
            }
            if (isVisible) {
                Component root = SwingUtilities.getRoot(OracleTabbedPaneUI.this._tabPane);
                if (root != null) {
                    this._prevFocussed = SwingUtilities.findFocusOwner(root);
                }
                if (FocusUtils.areNewFocusAPIsAvailable()) {
                    FocusUtils.setFocusTraversalKeysEnabled(OracleTabbedPaneUI.this._tabPane, false);
                } else {
                    this._focusManager = FocusManager.getCurrentManager();
                    FocusManager.disableSwingFocusManager();
                }
                this._restoreFocus = true;
                this._installListeners();
                OracleTabbedPaneUI.this._setButtonArmed(true);
            } else {
                if (FocusUtils.areNewFocusAPIsAvailable()) {
                    FocusUtils.setFocusTraversalKeysEnabled(OracleTabbedPaneUI.this._tabPane, true);
                } else {
                    FocusManager.setCurrentManager(this._focusManager);
                }
                this._uninstallListeners();
                this._clearPopup();
                OracleTabbedPaneUI.this._setButtonArmed(false);
            }
            super.setVisible(isVisible);
            this._transferFocus();
        }

        public void hidePopup() {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selection = manager.getSelectedPath();
            for (int i = 0; i < selection.length; ++i) {
                if (selection[i] != this) continue;
                manager.clearSelectedPath();
                break;
            }
        }

        public void dispose() {
            if (this.isVisible()) {
                this.hidePopup();
            }
            this.setLayout(null);
            this._mouseHandler = null;
            this._keyHandler = null;
            this._prevFocussed = null;
            this._list = null;
            this._scroller = null;
        }

        private void _configureList() {
            this._listModel = new DefaultListModel();
            this._list = new JList(this._listModel){

                @Override
                public void processMouseEvent(MouseEvent e) {
                    if (e.isControlDown()) {
                        e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers() ^ 2, e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
                    }
                    super.processMouseEvent(e);
                }
            };
            this._list.setBorder(null);
            this._disableFocus(this._list);
            this._list.setSelectionMode(0);
            this._list.setCellRenderer(new PopupListRenderer());
        }

        private void _configurePopup() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this._disableFocus(this);
            KeyStroke key = KeyStroke.getKeyStroke("alt pressed ALT");
            this.getInputMap(2).put(key, "none");
        }

        private void _configureScroller() {
            this._scroller = new JScrollPane();
            this._scroller.setBorder(null);
            this._disableFocus(this._scroller);
        }

        private void _disableFocus(JComponent component) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                FocusUtils.setFocusable(component, false);
            } else {
                component.setRequestFocusEnabled(false);
            }
        }

        private void _installListeners() {
            if (this._keyHandler == null) {
                this._keyHandler = new TabPaneKeyHandler();
            }
            if (this._mouseHandler == null) {
                this._mouseHandler = new MouseInputHandler();
            }
            OracleTabbedPaneUI.this._tabPane.addKeyListener(this._keyHandler);
            OracleTabbedPaneUI.this._tabPane.addMouseListener(this._mouseHandler);
            OracleTabbedPaneUI.this._tabPane.addMouseMotionListener(this._mouseHandler);
            this._list.addMouseListener(this._mouseHandler);
            this._list.addMouseMotionListener(this._mouseHandler);
        }

        private void _uninstallListeners() {
            OracleTabbedPaneUI.this._tabPane.removeKeyListener(this._keyHandler);
            OracleTabbedPaneUI.this._tabPane.removeMouseListener(this._mouseHandler);
            OracleTabbedPaneUI.this._tabPane.removeMouseMotionListener(this._mouseHandler);
            this._list.removeMouseListener(this._mouseHandler);
            this._list.removeMouseMotionListener(this._mouseHandler);
        }

        private void _transferFocus() {
            boolean isVisible = this.isVisible();
            if (!isVisible && this._restoreFocus && this._prevFocussed != null) {
                this._prevFocussed.requestFocus();
            } else {
                if (isVisible) {
                    this._list.ensureIndexIsVisible(this._list.getSelectedIndex());
                }
                OracleTabbedPaneUI.this._tabPane.requestFocus();
            }
        }

        private void _clearPopup() {
            this._listModel.clear();
            this.removeAll();
            this.setPreferredSize(null);
            this._isDragging = false;
            this._indexMapping = null;
        }

        private void _selectTab(int selectedIndex) {
            if (selectedIndex != -1) {
                if ((selectedIndex = this._indexMapping[selectedIndex] - 1) != OracleTabbedPaneUI.this._tabPane.getSelectedIndex() && selectedIndex >= 0 && selectedIndex < OracleTabbedPaneUI.this._tabPane.getTabCount()) {
                    if (selectedIndex < OracleTabbedPaneUI.this._firstVisible || selectedIndex > OracleTabbedPaneUI.this._lastVisible) {
                        OracleTabbedPaneUI.this._firstVisible = Math.max(0, selectedIndex - (OracleTabbedPaneUI.this._lastVisible - OracleTabbedPaneUI.this._firstVisible) / 2);
                    }
                    OracleTabbedPaneUI.this._tabPane.setSelectedIndex(selectedIndex);
                }
                this._restoreFocus = false;
            }
        }

        private class MouseInputHandler
        extends MouseInputAdapter {
            private MouseInputHandler() {
            }

            @Override
            public void mouseDragged(MouseEvent me) {
                if (me.getSource() == OracleTabbedPaneUI.this._tabPane) {
                    Point loc = SwingUtilities.convertPoint(OracleTabbedPaneUI.this._tabPane, me.getPoint(), ScrollablePopupMenu.this._list);
                    if (ScrollablePopupMenu.this._isDragging || ScrollablePopupMenu.this._list.getVisibleRect().contains(loc)) {
                        ScrollablePopupMenu.this._isDragging = true;
                        ScrollablePopupMenu.this._list.dispatchEvent(new MouseEvent(ScrollablePopupMenu.this._list, me.getID(), me.getWhen(), me.getModifiers(), loc.x, loc.y, me.getClickCount(), me.isPopupTrigger()));
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (me.getSource() == ScrollablePopupMenu.this._list) {
                    ScrollablePopupMenu.this._list.clearSelection();
                }
            }

            @Override
            public void mouseMoved(MouseEvent me) {
                if (me.getSource() == ScrollablePopupMenu.this._list) {
                    int index = ScrollablePopupMenu.this._list.locationToIndex(me.getPoint());
                    if (index == -1) {
                        ScrollablePopupMenu.this._list.clearSelection();
                    } else if (ScrollablePopupMenu.this._list.getSelectedIndex() != index) {
                        ScrollablePopupMenu.this._list.setSelectedIndex(index);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.getSource() == ScrollablePopupMenu.this._list) {
                    if (ScrollablePopupMenu.this._list.getVisibleRect().contains(me.getPoint())) {
                        ScrollablePopupMenu.this._selectTab(ScrollablePopupMenu.this._list.getSelectedIndex());
                        ScrollablePopupMenu.this.hidePopup();
                    }
                } else if (me.getSource() == OracleTabbedPaneUI.this._tabPane && ScrollablePopupMenu.this._isDragging) {
                    Point loc = SwingUtilities.convertPoint(OracleTabbedPaneUI.this._tabPane, me.getPoint(), ScrollablePopupMenu.this._list);
                    ScrollablePopupMenu.this._list.dispatchEvent(new MouseEvent(ScrollablePopupMenu.this._list, me.getID(), me.getWhen(), me.getModifiers(), loc.x, loc.y, me.getClickCount(), me.isPopupTrigger()));
                    ScrollablePopupMenu.this._isDragging = false;
                }
            }
        }

        private class TabPaneKeyHandler
        extends KeyAdapter {
            private TabPaneKeyHandler() {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                switch (ke.getKeyCode()) {
                    case 27: {
                        ScrollablePopupMenu.this.hidePopup();
                    }
                    case 9: {
                        ke.consume();
                        return;
                    }
                }
                if (ke.getModifiers() != 0) {
                    return;
                }
                int currIndex = ScrollablePopupMenu.this._list.getSelectedIndex();
                if (currIndex == -1) {
                    return;
                }
                int maxIndex = ScrollablePopupMenu.this._list.getModel().getSize() - 1;
                int nextIndex = currIndex;
                switch (ke.getKeyCode()) {
                    case 38: {
                        nextIndex = currIndex == 0 ? maxIndex : currIndex - 1;
                        break;
                    }
                    case 40: {
                        nextIndex = currIndex == maxIndex ? 0 : currIndex + 1;
                        break;
                    }
                    case 33: {
                        int first = ScrollablePopupMenu.this._list.getFirstVisibleIndex();
                        if (currIndex == first) {
                            Rectangle r = ScrollablePopupMenu.this._list.getVisibleRect();
                            r.y = Math.max(0, r.y - r.height);
                            nextIndex = ScrollablePopupMenu.this._list.locationToIndex(r.getLocation());
                            break;
                        }
                        nextIndex = first;
                        break;
                    }
                    case 34: {
                        int last = ScrollablePopupMenu.this._list.getLastVisibleIndex();
                        if (currIndex == last) {
                            Rectangle r = ScrollablePopupMenu.this._list.getVisibleRect();
                            r.y += r.height + r.height - 1;
                            nextIndex = ScrollablePopupMenu.this._list.locationToIndex(r.getLocation());
                            if (nextIndex != -1) break;
                            nextIndex = maxIndex;
                            break;
                        }
                        nextIndex = last;
                        break;
                    }
                    case 36: {
                        nextIndex = 0;
                        break;
                    }
                    case 35: {
                        nextIndex = maxIndex;
                        break;
                    }
                    case 10: 
                    case 32: {
                        ScrollablePopupMenu.this._selectTab(ScrollablePopupMenu.this._list.getSelectedIndex());
                        ScrollablePopupMenu.this.hidePopup();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                ke.consume();
                if (nextIndex != -1 && nextIndex != currIndex) {
                    ScrollablePopupMenu.this._list.setSelectedIndex(nextIndex);
                    ScrollablePopupMenu.this._list.ensureIndexIsVisible(nextIndex);
                }
            }
        }

        private class PopupListRenderer
        extends JLabel
        implements ListCellRenderer {
            public PopupListRenderer() {
                this.setOpaque(true);
                this.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 15));
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size;
                if (this.getText() == null || "".equals(this.getText())) {
                    this.setText(" ");
                    size = super.getPreferredSize();
                    this.setText("");
                } else {
                    size = super.getPreferredSize();
                }
                return size;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(UIManager.getColor("textHighlight"));
                    this.setForeground(UIManager.getColor("textHighlightText"));
                } else {
                    this.setBackground(UIManager.getColor("control"));
                    this.setForeground(UIManager.getColor("controlText"));
                }
                this.setText(value == null ? "" : value.toString());
                index = ScrollablePopupMenu.this._indexMapping[index] - 1;
                if (index >= OracleTabbedPaneUI.this._firstVisible && index <= OracleTabbedPaneUI.this._lastVisible) {
                    this.setIcon(OracleTabbedPaneUI.this._visibleIcon);
                    this.setFont(OracleTabbedPaneUI.this._boldFont);
                } else {
                    this.setIcon(OracleTabbedPaneUI.this._spacingIcon);
                    this.setFont(OracleTabbedPaneUI.this._basicFont);
                }
                return this;
            }
        }
    }

    private class PrevNext
    implements ActionListener {
        private PrevNext() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!OracleTabbedPaneUI.this._isPopupVisible()) {
                if ("Next".equals(e.getActionCommand())) {
                    OracleTabbedPaneUI.this.selectNextTab();
                } else {
                    OracleTabbedPaneUI.this.selectPreviousTab();
                }
            }
        }
    }

    private class TabFocusColorChange
    extends ColorChange {
        public TabFocusColorChange(Painter wrapped) {
            super(wrapped);
        }

        @Override
        protected Color getColor(PaintContext context) {
            if ((context.getPaintState() & 0x20) != 0) {
                return context.getPaintUIDefaults().getColor("TabbedPane.selectedTextColor");
            }
            return context.getPaintUIDefaults().getColor("TabbedPane.foreground");
        }
    }

    private static class SizeComp
    implements Comparator {
        private int[] _sizes;

        public SizeComp(int[] sizes) {
            this._sizes = sizes;
        }

        public int compare(Object item1, Object item2) {
            int index1 = (Integer)item1;
            int index2 = (Integer)item2;
            return this._sizes[index1] - this._sizes[index2];
        }
    }
}

