/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.OracleWindowBorder;
import oracle.bali.ewt.olaf.TitleBar;
import oracle.bali.ewt.plaf.BorderAdapter;

public class OracleDesktopIconUI
extends BasicDesktopIconUI {
    private JComponent _iconPane;

    public static ComponentUI createUI(JComponent component) {
        return new OracleDesktopIconUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        component.setBorder(new BorderAdapter(new OracleWindowBorder(this._iconPane)));
        component.setOpaque(false);
        LookAndFeel.installColors(component, "DesktopIcon.background", "DesktopIcon.background");
        OracleUIUtils.putPaintContext(component);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    @Override
    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        this._iconPane = new TitleBar(this.frame);
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this._iconPane, "Center");
    }

    @Override
    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this._iconPane);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this._iconPane.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension prefSize = super.getPreferredSize(c);
        int prefHeight = this._iconPane.getPreferredSize().height;
        Border border = this.desktopIcon.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(this.desktopIcon);
            prefHeight += insets.top + insets.bottom;
        }
        return new Dimension(prefSize.width, prefHeight);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this._iconPane.getMaximumSize();
    }

    private OracleDesktopIconUI() {
    }
}

