/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.imageCanvas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.scrolling.ScrollableComponent;
import oracle.bali.share.thread.Task;
import oracle.bali.share.thread.TaskEvent;
import oracle.bali.share.thread.TaskScheduler;

public class ImageCanvas
extends ScrollableComponent
implements Accessible {
    public static final int DONT_SCALE = 0;
    public static final int PRESERVE_ASPECT_RATIO = 1;
    public static final int SCALE_TO_FIT = 2;
    private LoadingTask _loadingTask;
    private Image _image;
    private float _yAlign = 0.0f;
    private float _xAlign = 0.0f;
    private double _xScale;
    private double _yScale;
    private double _xAdjust;
    private double _yAdjust;
    private int _scalingMode = 0;
    private Painter _painter;
    private Painter _scaler;
    private static final int _DEFAULT_SCALING = 0;
    private static final Painter _sPainter = ImageCanvas._createImagePainter(0);
    private static final int _MINIMUM_WIDTH = 10;
    private static final int _MINIMUM_HEIGHT = 10;

    public ImageCanvas() {
        this(null);
    }

    public ImageCanvas(Image image) {
        this._image = image;
        this.setOpaque(true);
        this._xScale = 1.0;
        this._xAdjust = 1.0;
        this._yScale = 1.0;
        this._yAdjust = 1.0;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        Image old = this._image;
        this._image = image;
        this.invalidateCanvas();
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleVisibleData", old, this._image);
        }
    }

    public void setScalingMode(int scalingMode) {
        if (scalingMode != this._scalingMode) {
            this._scalingMode = scalingMode;
            this._painter = scalingMode == 0 ? null : ImageCanvas._createImagePainter(scalingMode);
            this.repaint();
        }
    }

    public int getScalingMode() {
        return this._scalingMode;
    }

    public void setInteriorAlignmentX(float xAlign) {
        if (this._xAlign != xAlign) {
            this._xAlign = xAlign;
            this.repaint();
        }
    }

    public float getInteriorAlignmentX() {
        return this._xAlign;
    }

    public void setInteriorAlignmentY(float yAlign) {
        if (this._yAlign != yAlign) {
            this._yAlign = yAlign;
            this.repaint();
        }
    }

    public float getInteriorAlignmentY() {
        return this._yAlign;
    }

    public double getXScalingFactor() {
        return this._xScale;
    }

    public void setXScalingFactor(double xScale) {
        this._xAdjust *= xScale / this._xScale;
        this._xScale = xScale;
        this._createScalingPainter();
        this.invalidateCanvas();
    }

    public double getYScalingFactor() {
        return this._yScale;
    }

    public void setYScalingFactor(double yScale) {
        this._yAdjust *= yScale / this._yScale;
        this._yScale = yScale;
        this._createScalingPainter();
        this.invalidateCanvas();
    }

    @Override
    public final float getAlignmentX() {
        return this.getInteriorAlignmentX();
    }

    @Override
    public final float getAlignmentY() {
        return this.getInteriorAlignmentY();
    }

    @Override
    public final boolean isHScrollable() {
        return true;
    }

    @Override
    public final boolean isVScrollable() {
        return true;
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 3) != 0) {
            this.invalidateCanvas();
        } else if ((flags & 0x38) != 0) {
            if (this._loadingTask == null) {
                this._loadingTask = new LoadingTask();
            }
            this._loadingTask.schedule();
        }
        return (flags & 0xA0) == 0;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int prefWidth = 0;
        int prefHeight = 0;
        if (this._image != null) {
            prefWidth = (int)((double)this._image.getWidth(this) * this._xScale);
            prefHeight = (int)((double)this._image.getHeight(this) * this._yScale);
        }
        return this.convertInnerToOuterSize(prefWidth, prefHeight);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getScalingMode() != 0;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getScalingMode() != 0;
    }

    @Override
    public Dimension layoutCanvas() {
        Dimension size = this.getInnerSize();
        if (this.getScalingMode() == 0 && this._image != null) {
            int width = this._image.getWidth(this);
            size.width = Math.max(size.width, (int)((double)width * this._xScale));
            int height = this._image.getHeight(this);
            size.height = Math.max(size.height, (int)((double)height * this._yScale));
        }
        return size;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageCanvas();
        }
        return this.accessibleContext;
    }

    @Override
    protected void paintCanvasInterior(Graphics g) {
        Dimension size = this.getCanvasSize();
        this.getPainter().paint(this.getPaintContext(), g, 0, 0, size.width, size.height);
    }

    @Override
    protected Object getPaintData(Object key) {
        if (PaintContext.IMAGE_KEY.equals(key)) {
            return this._image;
        }
        return super.getPaintData(key);
    }

    protected Painter getPainter() {
        Painter painter = this._painter;
        if (painter == null && (painter = this._scaler) == null) {
            painter = _sPainter;
        }
        return painter;
    }

    @Override
    public void setCanvasSize(int width, int height) {
        Point origin = this.getCanvasOrigin();
        super.setCanvasSize(width, height);
        Dimension inner = this.getInnerSize();
        if (this._xAdjust != 1.0) {
            origin.x = Math.max((int)((double)origin.x * this._xAdjust), Math.min(0, inner.width - width));
            this._xAdjust = 1.0;
        }
        if (this._yAdjust != 1.0) {
            origin.y = Math.max((int)((double)origin.y * this._yAdjust), Math.min(0, inner.height - height));
            this._yAdjust = 1.0;
        }
        this.setCanvasOrigin(origin.x, origin.y);
    }

    private void _createScalingPainter() {
        if (this._scaler == null) {
            this._scaler = new AlignmentPainter(new Scaler());
        }
    }

    private static Painter _createImagePainter(int scalingMode) {
        ImagePainter painter = new ImagePainter(PaintContext.IMAGE_KEY, scalingMode);
        painter.setProgressiveLoading(true);
        return new AlignmentPainter(painter);
    }

    private class LoadingTask
    implements Task {
        private boolean _scheduled;

        private LoadingTask() {
        }

        public synchronized void schedule() {
            if (!this._scheduled) {
                this._scheduled = true;
                TaskScheduler.getDefaultTaskScheduler().schedule((Task)this, 100);
            }
        }

        public synchronized void runTask(TaskEvent e) {
            ImageCanvas.this.repaint();
            this._scheduled = false;
        }
    }

    protected class AccessibleImageCanvas
    extends JComponent.AccessibleJComponent {
        protected AccessibleImageCanvas() {
            super(ImageCanvas.this);
        }
    }

    private class Scaler
    extends AbstractWrappingPainter {
        public Scaler() {
            super(new ImagePainter(2));
        }

        @Override
        public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
            Dimension d = this.getPreferredSize(context);
            d.width = (int)((double)d.width * ImageCanvas.this.getXScalingFactor());
            d.height = (int)((double)d.height * ImageCanvas.this.getYScalingFactor());
            return d;
        }
    }
}

