/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.event.KeyEvent;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.selection.Cell;

public class WrappingGridKeyHandler
extends StandardGridKeyHandler {
    private static WrappingGridKeyHandler _sManager;
    private static WrappingGridKeyHandler _sTabManager;

    public WrappingGridKeyHandler() {
        this(false);
    }

    protected WrappingGridKeyHandler(boolean treatTabAsArrow) {
        super(treatTabAsArrow);
    }

    public static GridKeyHandler getGridKeyHandler() {
        if (_sManager == null) {
            _sManager = new WrappingGridKeyHandler();
        }
        return _sManager;
    }

    public static GridKeyHandler getGridKeyTabHandler() {
        if (_sTabManager == null) {
            _sTabManager = new WrappingGridKeyHandler(true);
        }
        return _sTabManager;
    }

    @Override
    protected Cell up(Grid grid, Cell focusCell, KeyEvent e) {
        Cell result = super.up(grid, focusCell, e);
        if (result == focusCell) {
            int columnCount = grid.getColumnCount();
            int rowCount = grid.getRowCount();
            int rindex = grid.getPreviousVisibleRow(rowCount);
            int cindex = grid.getPreviousVisibleColumn(focusCell.column);
            if (cindex == -1) {
                cindex = grid.getPreviousVisibleColumn(columnCount);
            }
            result = new Cell(cindex, rindex);
        }
        return result;
    }

    @Override
    protected Cell down(Grid grid, Cell focusCell, KeyEvent e) {
        Cell result = super.down(grid, focusCell, e);
        if (result == focusCell) {
            int rindex = grid.getNextVisibleRow(-1);
            int cindex = grid.getNextVisibleColumn(focusCell.column);
            if (cindex == -1) {
                cindex = grid.getNextVisibleColumn(-1);
            }
            result = new Cell(cindex, rindex);
        }
        return result;
    }

    @Override
    protected Cell left(Grid grid, Cell focusCell, KeyEvent e) {
        Cell result = super.left(grid, focusCell, e);
        if (result == focusCell) {
            int columnCount = grid.getColumnCount();
            int rowCount = grid.getRowCount();
            int rindex = grid.getPreviousVisibleRow(focusCell.row);
            int cindex = grid.getPreviousVisibleColumn(columnCount);
            if (rindex == -1) {
                rindex = grid.getPreviousVisibleRow(rowCount);
            }
            result = new Cell(cindex, rindex);
        }
        return result;
    }

    @Override
    protected Cell right(Grid grid, Cell focusCell, KeyEvent e) {
        Cell result = super.right(grid, focusCell, e);
        if (result == focusCell) {
            int rindex = grid.getNextVisibleRow(focusCell.row);
            int cindex = grid.getNextVisibleColumn(-1);
            if (rindex == -1) {
                rindex = grid.getNextVisibleColumn(-1);
            }
            result = new Cell(cindex, rindex);
        }
        return result;
    }
}

