/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.drawer.Drawer;
import oracle.bali.ewt.elaf.EWTDrawerUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.basic.DrawerBorderPainter;
import oracle.bali.ewt.elaf.basic.WhiteFilter;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.FilledRectPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.FixedColorPainter;
import oracle.bali.ewt.painter.FixedImagePainter;
import oracle.bali.ewt.painter.InnerEdgeBorderPainterJoiner;
import oracle.bali.ewt.painter.PainterStacker;

public class WindowsEWTDrawerUI
extends ComponentUI
implements EWTDrawerUI {
    private Border _outerBorder;
    private Border[] _borders = new Border[4];
    private static Border[] _sBorders = new Border[4];
    private static Image[] _sArrowImages = new Image[4];

    public static ComponentUI createUI(JComponent component) {
        return new WindowsEWTDrawerUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        this.installDefaults((Drawer)component);
        this._outerBorder = UIManager.getBorder("Button.border");
        Border oldBorder = component.getBorder();
        if (oldBorder == null || oldBorder instanceof UIResource) {
            component.setBorder(this.getBorder(component));
        }
    }

    protected void installDefaults(AbstractButton b) {
        String pp = this.getPropertyPrefix();
        if (b.getMargin() == null || b.getMargin() instanceof UIResource) {
            b.setMargin(UIManager.getInsets(pp + "margin"));
        }
        LookAndFeel.installColorsAndFont(b, pp + "background", pp + "foreground", pp + "font");
        LookAndFeel.installBorder(b, pp + "border");
        Object rollover = UIManager.get(pp + "rollover");
        if (rollover != null) {
            LookAndFeel.installProperty(b, "rolloverEnabled", rollover);
        }
        LookAndFeel.installProperty(b, "iconTextGap", 4);
    }

    @Override
    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        for (int i = 0; i < this._borders.length; ++i) {
            this._borders[i] = null;
        }
        this._outerBorder = null;
    }

    @Override
    public Border getDrawerBorder(JComponent component) {
        int orientation = WindowsEWTDrawerUI.getOrientation(component);
        return DrawerBorderPainter.getDrawerBorder(orientation);
    }

    @Override
    public JButton getPopUpArrowButton(JComponent component) {
        int orientation = (WindowsEWTDrawerUI.getOrientation(component) + 1) % 4 + 1;
        Image image = WindowsEWTDrawerUI.getArrowImage(orientation);
        JButton button = new JButton(new ImageIcon(image));
        button.setBackground(Color.black);
        button.setBorder(null);
        button.setMargin(new Insets(1, 1, 1, 1));
        button.setHorizontalAlignment(2);
        button.setVerticalAlignment(1);
        return button;
    }

    @Override
    public Border getBorder(JComponent component) {
        int orientation = WindowsEWTDrawerUI.getOrientation(component);
        int index = orientation - 1;
        Border border = this._borders[index];
        if (border == null) {
            Border innerBorder = _sBorders[index];
            if (innerBorder == null) {
                PainterStacker arrowPainter = new PainterStacker(new FixedColorPainter(FilledRectPainter.getPainter(), Color.black), new FixedImagePainter(WindowsEWTDrawerUI.getArrowImage(orientation), 0));
                InnerEdgeBorderPainterJoiner borderPainter = new InnerEdgeBorderPainterJoiner(null, null, new FixedBorderPainter(arrowPainter, -1, -3, -1, -3), switch (orientation) {
                    case 2 -> 3;
                    case 4 -> 0;
                    case 3 -> 2;
                    default -> 1;
                });
                WindowsEWTDrawerUI._sBorders[index] = innerBorder = new BorderAdapter(borderPainter);
            }
            this._borders[index] = border = new BorderUIResource.CompoundBorderUIResource(this._outerBorder, innerBorder);
        }
        return border;
    }

    protected static int getOrientation(JComponent component) {
        return ((Drawer)component).getOrientation();
    }

    @Override
    public int getPopUpOverlap(JComponent component) {
        return WindowsEWTDrawerUI.getArrowImage(4).getWidth(null) + 1;
    }

    @Override
    public int getPerpendicularInsets(JComponent component) {
        return 0;
    }

    protected static Image getArrowImage(int orientation) {
        Image arrowImage = _sArrowImages[orientation - 1];
        if (arrowImage == null) {
            arrowImage = BasicUIUtils.getArrow(orientation);
            WindowsEWTDrawerUI._sArrowImages[orientation - 1] = arrowImage = ImageUtils.createFilteredImage(arrowImage, new WhiteFilter());
        }
        return arrowImage;
    }

    protected String getPropertyPrefix() {
        return "EWTDrawer.";
    }

    protected WindowsEWTDrawerUI() {
    }
}

