/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.elaf.basic.BasicEWTArrowBoxUI;
import oracle.bali.ewt.elaf.basic.BasicUIUtils;
import oracle.bali.ewt.elaf.windows.WindowsInsetBorderPainter;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.scrolling.ArrowBox;

public class WindowsEWTArrowBoxUI
extends BasicEWTArrowBoxUI {
    private static final Border _BORDER = new BorderUIResource(new BorderAdapter(new WindowsInsetBorderPainter(false)));
    private static WindowsEWTArrowBoxUI _sInstance;
    private static Insets _sMargin;
    private static final Icon[] _sIcons;

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new WindowsEWTArrowBoxUI();
        }
        return _sInstance;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("EWTArrowBox.border".equals(key)) {
            return _BORDER;
        }
        return null;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        Color old = g.getColor();
        g.setColor(c.getBackground());
        g.fillRect(c.getX(), c.getY(), c.getWidth(), c.getHeight());
        g.setColor(old);
    }

    @Override
    public AbstractButton getIncrementButton(JComponent component) {
        return this._createButton(component, true);
    }

    @Override
    public AbstractButton getDecrementButton(JComponent component) {
        return this._createButton(component, false);
    }

    protected Insets getButtonMargin() {
        return _sMargin;
    }

    protected WindowsEWTArrowBoxUI() {
    }

    private AbstractButton _createButton(JComponent component, boolean increment) {
        ArrowBox ab = (ArrowBox)component;
        boolean horizontal = ab.getOrientation() == 0;
        Button b = new Button();
        b.setIcon(this._getCachedIcon(increment, horizontal));
        b.setBorder(UIManager.getBorder("Button.border"));
        b.setMargin(this.getButtonMargin());
        return b;
    }

    private Icon _getCachedIcon(boolean increment, boolean horizontal) {
        Icon icon;
        int cacheIndex = 0;
        if (increment) {
            ++cacheIndex;
        }
        if (horizontal) {
            cacheIndex += 2;
        }
        if ((icon = _sIcons[cacheIndex]) == null) {
            int orientation = increment ? (horizontal ? 4 : 3) : (horizontal ? 2 : 1);
            WindowsEWTArrowBoxUI._sIcons[cacheIndex] = icon = new ImageSetIcon(new ImageStrip(BasicUIUtils.getArrowStrip(orientation), 1));
        }
        return icon;
    }

    static {
        _sMargin = new Insets(0, 0, 0, 0);
        _sIcons = new Icon[4];
    }

    private static class Button
    extends JButton {
        private Button() {
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }
}

