/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

class OracleCornerPainter
extends AbstractPainter {
    public static final int UPPER_LEFT = 3;
    public static final int UPPER_RIGHT = 1;
    public static final int LOWER_LEFT = 0;
    public static final int LOWER_RIGHT = 2;
    private static Painter _sLowerLeft;
    private static Painter _sLowerRight;
    private static Painter _sUpperLeft;
    private static Painter _sUpperRight;
    private int _corner;

    private OracleCornerPainter(int whichCorner) {
        this._corner = whichCorner;
    }

    public static Painter getPainter() {
        return OracleCornerPainter.getPainter(3);
    }

    public static Painter getPainter(int whichCorner) {
        Painter painter = null;
        switch (whichCorner) {
            case 3: {
                if (_sUpperLeft == null) {
                    _sUpperLeft = new OracleCornerPainter(3);
                }
                painter = _sUpperLeft;
                break;
            }
            case 1: {
                if (_sUpperRight == null) {
                    _sUpperRight = new OracleCornerPainter(1);
                }
                painter = _sUpperRight;
                break;
            }
            case 0: {
                if (_sLowerLeft == null) {
                    _sLowerLeft = new OracleCornerPainter(0);
                }
                painter = _sLowerLeft;
                break;
            }
            case 2: {
                if (_sLowerRight == null) {
                    _sLowerRight = new OracleCornerPainter(2);
                }
                painter = _sLowerRight;
            }
        }
        return painter;
    }

    @Override
    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(0, 0);
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return 128;
    }

    @Override
    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        Object data = context.getPaintData(EWTTableUI.KEY_DRAW_RAISED);
        boolean raised = data instanceof Boolean ? (Boolean)data : true;
        switch (this._corner) {
            case 3: {
                this._paintUpperLeft(context, g, x, y, width, height, raised);
                break;
            }
            case 1: {
                this._paintUpperRight(context, g, x, y, width, height, raised);
                break;
            }
            case 0: {
                this._paintLowerLeft(context, g, x, y, width, height, raised);
                break;
            }
            case 2: {
                this._paintLowerRight(context, g, x, y, width, height, raised);
            }
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintUpperLeft(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised) {
        Object data;
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color background = context.getPaintBackground();
        int state = context.getPaintState();
        Color cornerColor = null;
        if ((state & 1) == 0 && (data = context.getPaintData("table.cornerBorderColor")) instanceof Color) {
            cornerColor = (Color)data;
        }
        if (cornerColor == null) {
            cornerColor = defaults.getColor("normalIntensity");
        }
        g.setColor(background);
        g.fillRect(x, y, width, height);
        g.setColor(cornerColor);
        g.drawLine(x + 1, bottom, right, bottom);
        g.drawLine(right, y + 1, right, bottom);
        if (raised && (state & 4) == 0) {
            g.setColor(defaults.getColor("controlShadow"));
            g.drawLine(x, y, x, y + 1);
            g.drawLine(x + 1, y, x + 1, y);
            g.setColor(Color.white);
            g.drawLine(x, y + 2, x, bottom);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(x + 2, y, right, y);
            g.setColor(background);
            g.drawLine(right, y, right, y);
            g.drawLine(x, bottom, x, bottom);
        } else {
            if ((state & 4) == 0) {
                g.setColor(cornerColor);
            } else {
                g.setColor(background);
            }
            g.drawLine(x, y, x, bottom - 1);
            g.drawLine(x + 1, y, right - 1, y);
            g.setColor(cornerColor);
            g.drawLine(right, y, right, y);
            g.drawLine(x, bottom, x, bottom);
        }
    }

    private void _paintUpperRight(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised) {
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color background = defaults.getColor("TableHeader.background");
        Color shadow = defaults.getColor("normalIntensity");
        Color lightHighlight = defaults.getColor("controlLtHighlight");
        Color darkShadow = defaults.getColor("controlDkShadow");
        g.setColor(background);
        g.fillRect(x, y, width, height);
        g.setColor(shadow);
        g.drawLine(right - 1, y, right, y);
        g.drawLine(right, y + 1, right, y + 1);
        int state = context.getPaintState();
        if (raised && (state & 4) == 0) {
            g.setColor(shadow);
            g.drawLine(right, y, right, bottom);
            g.drawLine(x, bottom - 1, right, bottom - 1);
            g.setColor(darkShadow);
            g.drawLine(x, bottom, right, bottom);
            g.setColor(Color.white);
            g.drawLine(x, y, x, bottom - 2);
            g.drawLine(x + 1, y, right - 2, y);
            g.drawLine(right - 1, y + 1, right - 1, y + 1);
        } else {
            g.setColor(shadow);
            g.drawLine(x, y, x, bottom);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(x, bottom - 1, right, bottom - 1);
        }
    }

    private void _paintLowerLeft(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised) {
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color background = defaults.getColor("TableHeader.background");
        Color shadow = defaults.getColor("normalIntensity");
        Color lightHighlight = defaults.getColor("controlLtHighlight");
        Color darkShadow = defaults.getColor("controlDkShadow");
        g.setColor(background);
        g.fillRect(x, y, width, height);
        int state = context.getPaintState();
        if (raised && (state & 4) != 0) {
            g.setColor(shadow);
            g.drawLine(x, y, right, y);
            g.drawLine(right, y, right, bottom);
            g.drawLine(right - 1, y, right - 1, bottom);
        } else {
            g.setColor(shadow);
            g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right - 1, y, right - 1, bottom);
            g.setColor(darkShadow);
            g.drawLine(right, y, right, bottom);
            g.setColor(Color.white);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, bottom - 2);
            g.drawLine(x + 1, bottom - 1, x + 1, bottom - 1);
            g.setColor(background);
            g.drawLine(right, y, right, y);
        }
    }

    private void _paintLowerRight(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised) {
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("normalIntensity");
        Color lightHighlight = defaults.getColor("controlLtHighlight");
        Color darkShadow = defaults.getColor("controlDkShadow");
        g.setColor(context.getPaintBackground());
        g.fillRect(x, y, width, height);
        g.setColor(shadow);
        g.drawLine(right - 1, bottom, right, bottom);
        g.drawLine(right, bottom - 1, right, bottom - 1);
        int state = context.getPaintState();
        if (raised && (state & 4) == 0) {
            g.setColor(shadow);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right - 1, y, right - 1, bottom - 1);
            g.drawLine(right - 2, bottom - 1, right - 2, bottom - 1);
            g.setColor(Color.white);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, bottom - 2);
            g.setColor(control);
            g.drawLine(right - 1, y, right - 1, y);
        } else {
            g.drawLine(right, y, right, bottom);
        }
    }
}

