/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDropTarget;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.JDKDropper;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.dnd.JFCSupport;

public class DTreeDropSupport {
    private DTree _tree;
    static final int __DROP_OFFSET = 5;
    static final int __INTO_INDEX = -1;
    private JDKDropper _jdkDropper;
    private boolean _jdkDnD;
    private DropTargetListener _listener;
    private DropTarget _dropTarget;

    public DTreeDropSupport(DTree tree) {
        this._tree = tree;
        this._listener = new Dropper();
        this._dropTarget = new DropTarget(tree, this._listener);
    }

    public void enableJDKDnD() {
        if (!this._jdkDnD) {
            this._jdkDnD = true;
            if (this._dropTarget != null) {
                this._dropTarget.setComponent(null);
                this._dropTarget.removeDropTargetListener(this._listener);
                this._dropTarget = null;
            }
            this._jdkDropper = new JDKDropper(this);
        }
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isEnabled() {
        if (!this._jdkDnD) {
            DTree tree = this.getTree();
            DropTarget target = JFCSupport.getEWTDropTarget(tree);
            return target.isActive();
        }
        return this._jdkDropper.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        if (!this._jdkDnD) {
            DTree tree = this.getTree();
            DropTarget target = JFCSupport.getEWTDropTarget(tree);
            target.setActive(enabled);
        } else {
            this._jdkDropper.setEnabled(enabled);
        }
    }

    protected DTreeDropTarget getDTreeDropTarget(DTreeItem item) {
        return item.getDropTarget();
    }

    private class Dropper
    implements DropTargetListener {
        private Dropper() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this._handleDrag(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this._handleDrag(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this._handleDrag(dtde);
        }

        @Override
        public void dragExit(DropTargetEvent dtde) {
            DTree tree = DTreeDropSupport.this.getTree();
            tree.setDropHighlightItem(null);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            DTree tree = DTreeDropSupport.this.getTree();
            tree.setDropHighlightItem(null);
            Point location = dtde.getLocation();
            DTreeItem item = this._getItemAt(location);
            if (item != null) {
                Point itemPos;
                int dropIndex;
                int targetAction;
                DTreeItem dropItem;
                DTreeDropTarget dropTarget;
                DataFlavor[] flavors = dtde.getCurrentDataFlavors();
                int sourceActions = dtde.getSourceActions();
                int dropAction = dtde.getDropAction();
                int dropStyle = this._getDropStyle(item, location, flavors, dropAction, sourceActions);
                if (dropStyle != 0 && (dropTarget = DTreeDropSupport.this.getDTreeDropTarget(dropItem = this._getDropItem(item, dropStyle))) != null && ((targetAction = dropTarget.getTargetAction(dropItem, dropIndex = this._getDropIndex(item, dropStyle), itemPos = this._convertOuterToItem(dropItem, location), flavors, dropAction, sourceActions)) & sourceActions) != 0) {
                    dtde.acceptDrop(targetAction);
                    boolean success = dropTarget.handleDrop(dropItem, dropIndex, itemPos, dtde.getTransferable(), targetAction);
                    dtde.getDropTargetContext().dropComplete(success);
                    return;
                }
            }
            dtde.rejectDrop();
        }

        private void _checkTargetAction(int targetAction, int sourceActions) {
        }

        private int _getDropStyle(DTreeItem item, Point location, DataFlavor[] flavors, int dropAction, int sourceActions) {
            boolean before;
            int action;
            int dropStyle = 0;
            DTree tree = DTreeDropSupport.this.getTree();
            Point canvasPos = tree.convertOuterToCanvas(location.x, location.y);
            Point itemPos = new Point(canvasPos.x - item.getX(), canvasPos.y - item.getY());
            DTreeDropTarget itemTarget = DTreeDropSupport.this.getDTreeDropTarget(item);
            if (itemTarget != null && (action = itemTarget.getTargetAction(item, -1, itemPos, flavors, dropAction, sourceActions)) != 0) {
                dropStyle = 1;
            }
            if ((before = this._isDropBefore(item, itemPos)) || this._isDropAfter(item, itemPos) || dropStyle == 0) {
                Point parentPos;
                int action2;
                int itemIndex = item.getIndex();
                int dropIndex = before ? itemIndex : itemIndex + 1;
                DTreeItem parent = item.getParent();
                DTreeDropTarget parentTarget = DTreeDropSupport.this.getDTreeDropTarget(parent);
                if (parentTarget != null && (action2 = parentTarget.getTargetAction(parent, dropIndex, parentPos = new Point(canvasPos.x - parent.getX(), canvasPos.y - parent.getY()), flavors, dropAction, sourceActions)) != 0) {
                    int n = dropStyle = before ? 2 : 3;
                }
            }
            if (dropStyle != 0) {
                DTreeItem dropItem = dropStyle == 1 ? item : item.getParent();
                DTreeSelection dragItems = (DTreeSelection)tree.getClientProperty("_ewtDTreeDragItems");
                if (dragItems != null && dragItems.isItemDescendent(dropItem)) {
                    return 0;
                }
            }
            return dropStyle;
        }

        private DTreeItem _getItemAt(Point location) {
            DTree tree = DTreeDropSupport.this.getTree();
            Point canvasPos = tree.convertOuterToCanvas(location.x, location.y);
            DTreeItem item = tree.getItemAt(canvasPos.x, canvasPos.y);
            if (item != null) {
                return item;
            }
            return null;
        }

        private void _handleDrag(DropTargetDragEvent dtde) {
            Point itemPos;
            int dropIndex;
            int targetAction;
            DTreeItem dropItem;
            DTreeDropTarget dropTarget;
            int sourceActions;
            int dropAction;
            DataFlavor[] flavors;
            int dropStyle;
            DTree tree = DTreeDropSupport.this.getTree();
            Point location = dtde.getLocation();
            DTreeItem item = this._getItemAt(location);
            if (item != null && (dropStyle = this._getDropStyle(item, location, flavors = dtde.getCurrentDataFlavors(), dropAction = dtde.getDropAction(), sourceActions = dtde.getSourceActions())) != 0 && (dropTarget = DTreeDropSupport.this.getDTreeDropTarget(dropItem = this._getDropItem(item, dropStyle))) != null && ((targetAction = dropTarget.getTargetAction(dropItem, dropIndex = this._getDropIndex(item, dropStyle), itemPos = this._convertOuterToItem(dropItem, location), flavors, dropAction, sourceActions)) & sourceActions) != 0) {
                dtde.acceptDrag(targetAction);
                tree.setDropHighlightStyle(dropStyle);
                tree.setDropHighlightItem(item);
                return;
            }
            dtde.rejectDrag();
            tree.setDropHighlightItem(null);
        }

        private boolean _isDropBefore(DTreeItem item, Point location) {
            return location.y >= 0 && location.y < 5;
        }

        private boolean _isDropAfter(DTreeItem item, Point location) {
            Dimension size = item.getSize();
            return location.y > size.height - 5 && location.y < size.height;
        }

        private int _getDropIndex(DTreeItem item, int dropStyle) {
            switch (dropStyle) {
                case 1: {
                    return -1;
                }
                case 2: {
                    return item.getIndex();
                }
                case 3: {
                    return item.getIndex() + 1;
                }
            }
            return -1;
        }

        private DTreeItem _getDropItem(DTreeItem item, int dropStyle) {
            return dropStyle == 1 ? item : item.getParent();
        }

        private Point _convertOuterToItem(DTreeItem item, Point outerPos) {
            DTree tree = DTreeDropSupport.this.getTree();
            Point canvasPos = tree.convertOuterToCanvas(outerPos.x, outerPos.y);
            return new Point(canvasPos.x - item.getX(), canvasPos.y - item.getY());
        }
    }
}

