/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.chooser.color.CMYComponent;
import oracle.bali.ewt.chooser.color.ColorComponent;
import oracle.bali.ewt.chooser.color.ColorEditor;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.HSBComponent;
import oracle.bali.ewt.chooser.color.HTMLHexComponent;
import oracle.bali.ewt.chooser.color.ImageComponent;
import oracle.bali.ewt.chooser.color.RGBComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class CustomColorPane
extends LWComponent
implements Accessible {
    public static final int COLOR_PICKER_RGB = 1;
    public static final int COLOR_PICKER_HSB = 2;
    public static final int COLOR_PICKER_CMY = 4;
    public static final int COLOR_PICKER_RGBHEX = 8;
    public static final int RGB_TOOLTIP = 0;
    public static final int RGB_HEX_TOOLTIP = 1;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final String PROPERTY_COLOR_PALETTE = "customColorPalette";
    public static final String PROPERTY_CUSTOM_COLOR_NAMES = "customColorNames";
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_TITLE = "CUSTOMCOLORPANE.TITLE";
    private static final String _KEY_STANDARD_PALETTE = "CUSTOMCOLORPANE.STANDARD_PALETTE";
    private static final String _KEY_CUSTOM_PALETTE = "CUSTOMCOLORPANE.CUSTOM_PALETTE";
    private static final String _KEY_COLOR_NAME = "CUSTOMCOLORPANE.COLOR_NAME";
    private static final String _KEY_CUSTOM_BUTTON = "CUSTOMCOLORPANE.CUSTOM_BUTTON";
    private static final int _CUSTOM_ROW_COUNT = 2;
    private static final Color _DEFAULT_COLOR = Color.white;
    private static final String _STANDARD_PALETTE_NAME = "Standard_Palette";
    private static final String _CUSTOM_PALETTE_NAME = "Custom_Palette";
    private static final String _COLOR_NAME = "Color_Name_Field";
    private static final String _CUSTOM_BUTTON_NAME = "Add_to_Custom_Button";
    private static final Dimension _EMPTY_SIZE = new Dimension();
    private boolean _initialized;
    private boolean _ignoreEvents;
    private EventHandler _eventHandler = new EventHandler();
    private JLabel _colorGridLabel;
    private ColorGrid _colorGrid;
    private JLabel _customGridLabel;
    private ColorGrid _customGrid;
    private JPanel _nameComponent;
    private JLabel _nameLabel;
    private JTextField _nameField;
    private boolean _colorNameDirty;
    private boolean _colorNameVisible = true;
    private ImageComponent _imageComponent;
    private ColorComponent _colorComponent;
    private JButton _customColorButton;
    private RGBComponent _rgbComponent;
    private HSBComponent _hsbComponent;
    private CMYComponent _cmyComponent;
    private HTMLHexComponent _rgbHexComponent;
    private ArrayList _colorEditors;
    private JPanel _customColorEditorPanel;
    private GridBagConstraints _customConstraints;

    public CustomColorPane() {
        this(null, null, null);
    }

    public CustomColorPane(Color selected) {
        this(null, null, selected);
    }

    public CustomColorPane(TwoDModel palette, Color selected) {
        this(palette, null, selected);
    }

    public CustomColorPane(TwoDModel palette, TwoDModel customPalette, Color selected) {
        this._createUI();
        this.setToolTipMode(0);
        this.setColorPalette(palette);
        this.setCustomColorPalette(customPalette);
        this.setCurrentColor(selected);
        this.setSelectedColor(selected);
        this._updateNameAndCustomButton();
        this._initialized = true;
    }

    public static int showDialog(Component parent, CustomColorPane pane) {
        return CustomColorPane.showDialog(parent, pane, null, false);
    }

    public static int showDialog(Component parent, CustomColorPane pane, String dialogTitle, boolean resizable) {
        if (pane == null) {
            throw new IllegalArgumentException("CustomColorPane must be non-null");
        }
        Locale l = LocaleUtils.getDefaultableLocale((Component)pane);
        if (dialogTitle == null) {
            ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, l);
            dialogTitle = b.getString(_KEY_TITLE);
        }
        JEWTDialog d = JEWTDialog.createDialog(parent, dialogTitle, 7);
        d.setLocale(l);
        d.setContent(pane);
        d.setCenterOver(parent);
        d.setResizable(resizable);
        d.setInitialFocus(pane._getInitialFocus());
        int ret = d.runDialog() ? 1 : 2;
        d.dispose();
        return ret;
    }

    public void setCurrentColor(Color color) {
        if (color == null) {
            color = _DEFAULT_COLOR;
        }
        this._colorComponent.setOriginalColor(color);
    }

    public Color getCurrentColor() {
        return this._colorComponent.getOriginalColor();
    }

    public void setSelectedColor(Color color) {
        if (color != null && color.equals(this.getSelectedColor())) {
            return;
        }
        this._updateSelectedColor(null, color);
    }

    public Color getSelectedColor() {
        return this._colorComponent.getColor();
    }

    public void setColorPalette(TwoDModel colors) {
        this._colorGrid.setColorPalette(colors);
    }

    public TwoDModel getColorPalette() {
        return this._colorGrid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel colors) {
        boolean visible;
        boolean bl = visible = colors != null && colors.getColumnCount() > 0 && colors.getRowCount() > 0;
        if (visible != this._customGrid.isVisible()) {
            this._customGridLabel.setVisible(visible);
            this._customGrid.setVisible(visible);
            this._customColorButton.setVisible(visible);
            this._updateNameVisibility();
        }
        this._customGrid.setColorPalette(colors);
    }

    public TwoDModel getCustomColorPalette() {
        return this._customGrid.getColorPalette();
    }

    public void setColorNameVisible(boolean visible) {
        this._colorNameVisible = visible;
        this._updateNameVisibility();
    }

    public boolean isColorNameVisible() {
        return this._nameComponent.isVisible();
    }

    public void setCustomColorNames(TwoDModel colorNames) {
        this._setCustomColorNames(colorNames, true);
    }

    public TwoDModel getCustomColorNames() {
        return this._customGrid.__getColorNames();
    }

    public String getCustomColorName() {
        if (!this._customGrid.isVisible()) {
            return null;
        }
        TwoDModel colorNames = this.getCustomColorNames();
        if (colorNames != null) {
            Object data;
            int col = this._customGrid.__getSelectedColumn();
            int row = this._customGrid.__getSelectedRow();
            if (col != -1 && row != -1 && col < colorNames.getColumnCount() && row < colorNames.getRowCount() && (data = colorNames.getData(col, row)) instanceof String) {
                return (String)data;
            }
        }
        return null;
    }

    public void setToolTipMode(int mode) {
        this._colorGrid.setToolTipMode(mode);
        this._customGrid.setToolTipMode(mode);
    }

    public int getToolTipMode() {
        return this._colorGrid.getToolTipMode();
    }

    public void setColorPickerMask(int mask) {
        Color color = this.getSelectedColor();
        boolean rgb = (mask & 1) != 0;
        boolean hsb = (mask & 2) != 0;
        boolean cmy = (mask & 4) != 0;
        boolean rgbHex = (mask & 8) != 0;
        this._rgbComponent.setVisible(rgb);
        if (rgb) {
            this._rgbComponent.setColor(color);
        }
        this._hsbComponent.setVisible(hsb);
        if (hsb) {
            this._hsbComponent.setColor(color);
        }
        this._cmyComponent.setVisible(cmy);
        if (cmy) {
            this._cmyComponent.setColor(color);
        }
        this._rgbHexComponent.setVisible(rgbHex);
        if (rgbHex) {
            this._rgbHexComponent.setColor(color);
        }
    }

    public int getColorPickerMask() {
        int colorPickers = 0;
        if (this._rgbComponent.isVisible()) {
            colorPickers |= 1;
        }
        if (this._hsbComponent.isVisible()) {
            colorPickers |= 2;
        }
        if (this._cmyComponent.isVisible()) {
            colorPickers |= 4;
        }
        if (this._rgbHexComponent.isVisible()) {
            colorPickers |= 8;
        }
        return colorPickers;
    }

    public void addCustomColorEditor(ColorEditor editor) {
        if (editor == null) {
            return;
        }
        if (this._colorEditors == null) {
            this._colorEditors = new ArrayList(2);
        } else if (this._colorEditors.contains(editor)) {
            return;
        }
        this._colorEditors.add(editor);
        this._customColorEditorPanel.add(editor.getComponent(), this._customConstraints);
        editor.setColor(this.getSelectedColor());
        editor.addPropertyChangeListener(this._eventHandler);
        this.revalidate();
        this.repaint();
    }

    public void removeCustomColorEditor(ColorEditor editor) {
        if (editor == null || this._colorEditors == null || !this._colorEditors.contains(editor)) {
            return;
        }
        this._colorEditors.remove(editor);
        this._customColorEditorPanel.remove(editor.getComponent());
        editor.removePropertyChangeListener(this._eventHandler);
        this.revalidate();
        this.repaint();
    }

    public ColorEditor[] getCustomColorEditors() {
        return this._colorEditors == null ? null : this._colorEditors.toArray(new ColorEditor[0]);
    }

    public void dispose() {
        if (this._eventHandler == null) {
            return;
        }
        this._colorGridLabel = null;
        this._colorGrid.removePropertyChangeListener(this._eventHandler);
        this._colorGrid.dispose();
        this._colorGrid = null;
        TwoDModel customNames = this.getCustomColorNames();
        if (customNames != null) {
            customNames.removeModelListener(this._eventHandler);
        }
        this._customGridLabel = null;
        this._customGrid.removePropertyChangeListener(this._eventHandler);
        this._customGrid.dispose();
        this._customGrid = null;
        this._nameLabel = null;
        this._nameField.getDocument().removeDocumentListener(this._eventHandler);
        this._nameField = null;
        this._imageComponent.removePropertyChangeListener(this._eventHandler);
        this._imageComponent = null;
        this._colorComponent.removePropertyChangeListener(this._eventHandler);
        this._colorComponent = null;
        this._customColorButton.removeActionListener(this._eventHandler);
        this._customColorButton = null;
        this._rgbComponent.removePropertyChangeListener(this._eventHandler);
        this._rgbComponent = null;
        this._cmyComponent.removePropertyChangeListener(this._eventHandler);
        this._cmyComponent = null;
        this._hsbComponent.removePropertyChangeListener(this._eventHandler);
        this._hsbComponent = null;
        this._rgbHexComponent.removePropertyChangeListener(this._eventHandler);
        this._rgbHexComponent = null;
        ColorEditor[] editors = this.getCustomColorEditors();
        int count = editors == null ? 0 : editors.length;
        for (int i = 0; i < count; ++i) {
            editors[i].removePropertyChangeListener(this._eventHandler);
        }
        if (this._colorEditors != null) {
            this._colorEditors.clear();
        }
        this._colorEditors = null;
        this._customColorEditorPanel = null;
        this._customConstraints = null;
        this._eventHandler = null;
    }

    @Override
    public void setLayout(LayoutManager layout) {
        throw new IllegalArgumentException("setLayout() not supported");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._updateLabels(this.getLocale());
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this._initialized) {
            this._updateLabels(locale);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this._colorGridLabel.setEnabled(enable);
        this._colorGrid.setEnabled(enable);
        this._customGridLabel.setEnabled(enable);
        this._customGrid.setEnabled(enable);
        this._updateNameAndCustomButton();
        this._imageComponent.setEnabled(enable);
        this._colorComponent.setEnabled(enable);
        this._rgbComponent.setEnabled(enable);
        this._hsbComponent.setEnabled(enable);
        this._cmyComponent.setEnabled(enable);
        this._rgbHexComponent.setEnabled(enable);
        ColorEditor[] customEditors = this.getCustomColorEditors();
        int count = customEditors == null ? 0 : customEditors.length;
        for (int i = 0; i < count; ++i) {
            customEditors[i].getComponent().setEnabled(enable);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCustomColorPane();
        }
        return this.accessibleContext;
    }

    private void _createUI() {
        this._createComponents();
        this._layoutComponents();
    }

    private void _createComponents() {
        this._colorGridLabel = new JLabel();
        this._colorGrid = new ColorGrid();
        this._colorGrid.setName(_STANDARD_PALETTE_NAME);
        this._colorGrid.__setSelectedSlotEnabled(true);
        this._colorGridLabel.setLabelFor(this._colorGrid);
        this._colorGrid.addPropertyChangeListener(this._eventHandler);
        this._customGridLabel = new JLabel();
        this._customGrid = new ColorGrid(true);
        this._customGrid.setName(_CUSTOM_PALETTE_NAME);
        this._customGrid.__setSelectedSlotEnabled(true);
        this._customGridLabel.setLabelFor(this._customGrid);
        this._customGrid.addPropertyChangeListener(this._eventHandler);
        this._nameComponent = new JPanel();
        this._nameLabel = new JLabel();
        this._nameField = new JTextField(7);
        this._nameField.setName(_COLOR_NAME);
        this._nameLabel.setLabelFor(this._nameField);
        this._nameField.getDocument().addDocumentListener(this._eventHandler);
        this._imageComponent = new ImageComponent();
        this._imageComponent.addPropertyChangeListener(this._eventHandler);
        this._colorComponent = new ColorComponent();
        this._colorComponent.addPropertyChangeListener(this._eventHandler);
        this._customColorButton = new JButton();
        this._customColorButton.setName(_CUSTOM_BUTTON_NAME);
        this._customColorButton.putClientProperty(PushButton.LEFTMOST_BUTTON_KEY, Boolean.TRUE);
        this._customColorButton.putClientProperty(PushButton.RIGHTMOST_BUTTON_KEY, Boolean.TRUE);
        this._customColorButton.addActionListener(this._eventHandler);
        this._rgbComponent = new RGBComponent();
        this._rgbComponent.addPropertyChangeListener(this._eventHandler);
        this._hsbComponent = new HSBComponent();
        this._hsbComponent.addPropertyChangeListener(this._eventHandler);
        this._cmyComponent = new CMYComponent();
        this._cmyComponent.addPropertyChangeListener(this._eventHandler);
        this._rgbHexComponent = new HTMLHexComponent();
        this._rgbHexComponent.addPropertyChangeListener(this._eventHandler);
    }

    private void _layoutComponents() {
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)this._createTopPanel(), "Center");
        content.add((Component)this._createBottomPanel(), "South");
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)content, "West");
        super.setLayout(new BorderLayout());
        this.add((Component)temp, "North");
    }

    private JPanel _createTopPanel() {
        TopLeftPanel left = new TopLeftPanel();
        ImageComponent rightTop = this._imageComponent;
        JPanel rightBottom = new JPanel(new BorderLayout(0, 12));
        rightBottom.add((Component)this._colorComponent, "Center");
        rightBottom.add((Component)this._customColorButton, "South");
        JPanel panel = new JPanel(new TopLayout(24, 10));
        panel.add((Component)left, "Left");
        panel.add((Component)rightTop, "RightTop");
        panel.add((Component)rightBottom, "RightBottom");
        return panel;
    }

    private JPanel _createBottomPanel() {
        JPanel mainPanel = new JPanel(new BottomLayout(24, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 0, 0));
        mainPanel.add(this._rgbComponent);
        mainPanel.add(this._hsbComponent);
        mainPanel.add(this._cmyComponent);
        mainPanel.add(this._rgbHexComponent);
        this._customColorEditorPanel = new JPanel(new GridBagLayout());
        this._customConstraints = new GridBagConstraints();
        this._customConstraints.anchor = 18;
        this._customConstraints.insets = new Insets(0, 0, 0, 24);
        mainPanel.add((Component)this._customColorEditorPanel, 0);
        return mainPanel;
    }

    private void _updateLabels(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle bundle = ResourceBundle.getBundle(_RESOURCE, locale);
        String translatedText = null;
        translatedText = bundle.getString(_KEY_STANDARD_PALETTE);
        this._colorGridLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._colorGridLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = bundle.getString(_KEY_CUSTOM_PALETTE);
        this._customGridLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._customGridLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = bundle.getString(_KEY_COLOR_NAME);
        this._nameLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._nameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = bundle.getString(_KEY_CUSTOM_BUTTON);
        this._customColorButton.setText(StringUtils.stripMnemonic((String)translatedText));
        this._customColorButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this._rgbComponent.setLocale(locale);
        this._hsbComponent.setLocale(locale);
        this._cmyComponent.setLocale(locale);
        this._rgbHexComponent.setLocale(locale);
        this._imageComponent.setLocale(locale);
        this._colorComponent.setLocale(locale);
        ColorEditor[] customEditors = this.getCustomColorEditors();
        int count = customEditors == null ? 0 : customEditors.length;
        for (int i = 0; i < count; ++i) {
            customEditors[i].getComponent().setLocale(locale);
        }
        this._colorGrid.setLocale(locale);
        this._customGrid.setLocale(locale);
    }

    private Component _getInitialFocus() {
        if (this._customGrid.isVisible() && this._customGrid.__getSelectedColumn() != -1 && this._customGrid.__getSelectedRow() != -1) {
            return this._customGrid;
        }
        return this._colorGrid;
    }

    private void _updateNameVisibility() {
        boolean visible;
        boolean bl = visible = this._colorNameVisible && this._customGrid.isVisible();
        if (visible != this.isColorNameVisible()) {
            this._nameComponent.setVisible(visible);
            this._updateColorNameField();
        }
    }

    private void _updateSelectedColor(Object src, Color newColor) {
        if (!this._ignoreEvents) {
            this._ignoreEvents = true;
            if (newColor == null) {
                newColor = _DEFAULT_COLOR;
            }
            Color oldColor = this.getSelectedColor();
            this._updateColorGrids(src, newColor);
            this._updateColorEditors(src, newColor);
            this._ignoreEvents = false;
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, oldColor, newColor);
        }
    }

    private void _updateColorGrids(Object srcGrid, Color newColor) {
        block8: {
            if (srcGrid == this._colorGrid) {
                this._customGrid.setSelectedColor(null);
            } else if (srcGrid == this._customGrid) {
                this._colorGrid.setSelectedColor(null);
            } else {
                try {
                    this._colorGrid.setSelectedColor(newColor);
                    this._customGrid.setSelectedColor(null);
                }
                catch (IllegalArgumentException e) {
                    this._colorGrid.setSelectedColor(null);
                    if (!this._customGrid.isVisible()) break block8;
                    try {
                        this._customGrid.setSelectedColor(newColor);
                    }
                    catch (IllegalArgumentException ee) {
                        this._customGrid.setSelectedColor(null);
                    }
                }
            }
        }
    }

    private void _updateColorEditors(Object srcEditor, Color newColor) {
        ColorEditor[] customEditors;
        if (srcEditor != this._rgbComponent && this._rgbComponent.isVisible()) {
            this._rgbComponent.setColor(newColor);
        }
        if (srcEditor != this._hsbComponent && this._hsbComponent.isVisible()) {
            this._hsbComponent.setColor(newColor);
        }
        if (srcEditor != this._cmyComponent && this._cmyComponent.isVisible()) {
            this._cmyComponent.setColor(newColor);
        }
        if (srcEditor != this._rgbHexComponent && this._rgbHexComponent.isVisible()) {
            this._rgbHexComponent.setColor(newColor);
        }
        if (srcEditor != this._imageComponent) {
            this._imageComponent.setColor(newColor);
        }
        if (srcEditor != this._colorComponent) {
            this._colorComponent.setColor(newColor);
        }
        int count = (customEditors = this.getCustomColorEditors()) == null ? 0 : customEditors.length;
        for (int i = 0; i < count; ++i) {
            ColorEditor ce = customEditors[i];
            if (srcEditor == ce || !ce.getComponent().isVisible()) continue;
            ce.setColor(newColor);
        }
    }

    private void _updateCustomSlot() {
        this._updateNameAndCustomButton();
        this._updateColorNameField();
    }

    private void _updateNameAndCustomButton() {
        boolean enable = this.isEnabled() && this._customGrid.isVisible() && this._customGrid.__getSelectedSlotColumn() != -1 && this._customGrid.__getSelectedSlotRow() != -1;
        this._customColorButton.setEnabled(enable);
        this._nameLabel.setEnabled(enable);
        this._nameField.setEnabled(enable);
    }

    private void _setCustomColorNames(TwoDModel colorNames, boolean fireEvent) {
        TwoDModel old = this.getCustomColorNames();
        if (old != colorNames) {
            if (old != null) {
                old.removeModelListener(this._eventHandler);
            }
            if (colorNames != null) {
                colorNames.addModelListener(this._eventHandler);
            }
            this._customGrid.__setColorNames(colorNames);
            if (fireEvent) {
                this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, old, colorNames);
            }
        }
    }

    private void _updateCustomColorName(String name) {
        int col = this._customGrid.__getSelectedColumn();
        int row = this._customGrid.__getSelectedRow();
        if (col != -1 && row != -1 && name != null && (name = name.trim()).length() > 0) {
            TwoDModel colorNames = this.getCustomColorNames();
            int gridCols = this._customGrid.getColumnCount();
            int gridRows = this._customGrid.getRowCount();
            ArrayTwoDModel newModel = null;
            if (colorNames == null) {
                newModel = new ArrayTwoDModel(gridCols, gridRows);
            } else {
                int nameCols = colorNames.getColumnCount();
                int nameRows = colorNames.getRowCount();
                if (col > nameCols - 1 || row > nameRows - 1) {
                    nameCols = Math.max(nameCols, gridCols);
                    nameRows = Math.max(nameRows, gridRows);
                    newModel = new ArrayTwoDModel(nameCols, nameRows);
                    ColorPickerUtils.copyModel(colorNames, newModel);
                }
            }
            if (newModel != null) {
                colorNames = newModel;
                this._setCustomColorNames(colorNames, false);
            }
            colorNames.setData(col, row, name);
            this.firePropertyChange(PROPERTY_CUSTOM_COLOR_NAMES, null, colorNames);
        }
    }

    private void _updateColorNameField() {
        if (this.isColorNameVisible()) {
            String name = null;
            TwoDModel colorNames = this.getCustomColorNames();
            if (colorNames != null) {
                Object data;
                int col = this._customGrid.__getSelectedSlotColumn();
                int row = this._customGrid.__getSelectedSlotRow();
                if (col != -1 && row != -1 && col < colorNames.getColumnCount() && row < colorNames.getRowCount() && (data = colorNames.getData(col, row)) instanceof String) {
                    name = (String)data;
                }
            }
            this._nameField.setText(name);
        }
        this._colorNameDirty = false;
    }

    private class EventHandler
    implements PropertyChangeListener,
    ActionListener,
    TwoDModelListener,
    DocumentListener {
        private EventHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            Object src = pe.getSource();
            if (src instanceof ColorGrid) {
                if ("model".equals(name)) {
                    if (src == CustomColorPane.this._customGrid) {
                        CustomColorPane.this.firePropertyChange(CustomColorPane.PROPERTY_COLOR_PALETTE, pe.getOldValue(), pe.getNewValue());
                    }
                } else if (CustomColorPane.PROPERTY_SELECTED_COLOR.equals(name)) {
                    CustomColorPane.this._updateSelectedColor(src, (Color)pe.getNewValue());
                } else if ("slotChanged".equals(name)) {
                    ColorGrid grid = src == CustomColorPane.this._colorGrid ? CustomColorPane.this._customGrid : CustomColorPane.this._colorGrid;
                    grid.__setSelectedSlot(-1, -1, false);
                    CustomColorPane.this._updateCustomSlot();
                }
            } else if (src instanceof ColorEditor && "color".equals(name)) {
                CustomColorPane.this._updateSelectedColor(src, (Color)pe.getNewValue());
            }
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src == CustomColorPane.this._customColorButton && CustomColorPane.this._customGrid.__replaceSelectedSlotColor(CustomColorPane.this.getSelectedColor())) {
                if (CustomColorPane.this._colorNameDirty) {
                    CustomColorPane.this._updateCustomColorName(CustomColorPane.this._nameField.getText());
                    CustomColorPane.this._colorNameDirty = false;
                }
                CustomColorPane.this.firePropertyChange(CustomColorPane.PROPERTY_COLOR_PALETTE, null, CustomColorPane.this.getCustomColorPalette());
            }
        }

        @Override
        public void columnsAdded(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void columnsRemoved(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void rowsAdded(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void rowsRemoved(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void invalidateColumns(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void invalidateRows(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void invalidateCells(TwoDModelEvent me) {
            CustomColorPane.this._updateColorNameField();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CustomColorPane.this._colorNameDirty = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CustomColorPane.this._colorNameDirty = true;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CustomColorPane.this._colorNameDirty = true;
        }
    }

    private class AccessibleCustomColorPane
    extends JComponent.AccessibleJComponent {
        private AccessibleCustomColorPane() {
            super(CustomColorPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }

    private class TopLeftPanel
    extends JPanel {
        private boolean _horizontal;

        public TopLeftPanel() {
            this.setLayout(new BorderLayout(0, 5));
            JPanel gridPanel = this._createColorGridPanel();
            this.add((Component)gridPanel, "Center");
            CustomColorPane.this._nameComponent.setLayout(new BorderLayout(12, 5));
            CustomColorPane.this._nameComponent.add((Component)CustomColorPane.this._nameLabel, "West");
            this.layoutNameComponent(true);
            this.add((Component)CustomColorPane.this._nameComponent, "South");
        }

        public boolean isNameComponentHorizontal() {
            return this._horizontal;
        }

        public void layoutNameComponent(boolean horizontal) {
            if (this._horizontal != horizontal) {
                this._horizontal = horizontal;
                this.remove(CustomColorPane.this._nameField);
                String pos = horizontal ? "Center" : "South";
                CustomColorPane.this._nameComponent.add((Component)CustomColorPane.this._nameField, pos);
            }
        }

        public int getNameLabelHeight() {
            return CustomColorPane.this._nameLabel.getPreferredSize().height;
        }

        public int getNameFieldHeight() {
            return CustomColorPane.this._nameField.getPreferredSize().height;
        }

        public int getVerticalGap() {
            return 5;
        }

        private JPanel _createColorGridPanel() {
            JPanel main = new JPanel(new BorderLayout(0, 5));
            main.add((Component)CustomColorPane.this._colorGridLabel, "North");
            main.add((Component)CustomColorPane.this._colorGrid, "West");
            JPanel custom = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.anchor = 18;
            gbc.insets = new Insets(5, 0, 0, 0);
            custom.add((Component)CustomColorPane.this._customGridLabel, gbc);
            custom.add((Component)CustomColorPane.this._customGrid, gbc);
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)main, "North");
            content.add((Component)custom, "West");
            return content;
        }
    }

    private class TopLayout
    implements LayoutManager {
        public static final String LEFT = "Left";
        public static final String RIGHT_TOP = "RightTop";
        public static final String RIGHT_BOTTOM = "RightBottom";
        private int _hGap;
        private int _vGap;
        private Component _left;
        private Component _rightBottom;
        private Component _rightTop;

        public TopLayout(int hGap, int vGap) {
            this._hGap = hGap;
            this._vGap = vGap;
        }

        @Override
        public void addLayoutComponent(String constr, Component comp) {
            if (LEFT.equals(constr)) {
                this._left = comp;
            } else if (RIGHT_TOP.equals(constr)) {
                this._rightTop = comp;
            } else if (RIGHT_BOTTOM.equals(constr)) {
                this._rightBottom = comp;
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this._left) {
                this._left = null;
            } else if (comp == this._rightTop) {
                this._rightTop = null;
            } else if (comp == this._rightBottom) {
                this._rightBottom = null;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension size = new Dimension();
            Component left = this._getComponent(LEFT);
            Component rightTop = this._getComponent(RIGHT_TOP);
            Component rightBottom = this._getComponent(RIGHT_BOTTOM);
            Dimension leftSize = left != null ? left.getPreferredSize() : _EMPTY_SIZE;
            Dimension rightTopSize = rightTop != null ? rightTop.getPreferredSize() : _EMPTY_SIZE;
            Dimension rightBottomSize = rightBottom != null ? rightBottom.getPreferredSize() : _EMPTY_SIZE;
            int rightHeight = rightTopSize.height + this._vGap + rightBottomSize.height;
            if (left instanceof TopLeftPanel) {
                TopLeftPanel leftPanel = (TopLeftPanel)left;
                boolean recalculate = false;
                int diff = rightHeight - leftSize.height;
                if (diff > 0) {
                    if (leftPanel.isNameComponentHorizontal()) {
                        int labelHt = leftPanel.getNameLabelHeight();
                        int fieldHt = leftPanel.getNameFieldHeight();
                        int horizontalHt = Math.max(labelHt, fieldHt);
                        int verticalHt = labelHt + leftPanel.getVerticalGap() + fieldHt;
                        if (verticalHt <= diff + horizontalHt) {
                            leftPanel.layoutNameComponent(false);
                            recalculate = true;
                        }
                    }
                } else if (!leftPanel.isNameComponentHorizontal()) {
                    leftPanel.layoutNameComponent(true);
                    recalculate = true;
                }
                if (recalculate) {
                    leftSize = leftPanel.getPreferredSize();
                }
            }
            int rightWidth = Math.max(rightTopSize.width, rightBottomSize.width);
            size.width = leftSize.width + this._hGap + rightWidth;
            size.height = Math.max(leftSize.height, rightHeight);
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension rightBottomSize;
            Insets insets = parent.getInsets();
            int x = insets.left;
            int y = insets.top;
            Component left = this._getComponent(LEFT);
            Component rightTop = this._getComponent(RIGHT_TOP);
            Component rightBottom = this._getComponent(RIGHT_BOTTOM);
            Dimension leftSize = left != null ? left.getPreferredSize() : _EMPTY_SIZE;
            Dimension rightTopSize = rightTop != null ? rightTop.getPreferredSize() : _EMPTY_SIZE;
            Dimension dimension = rightBottomSize = rightBottom != null ? rightBottom.getPreferredSize() : _EMPTY_SIZE;
            if (left != null) {
                left.setBounds(x, y, leftSize.width, leftSize.height);
                x += leftSize.width + this._hGap;
            }
            if (rightTop != null) {
                rightTop.setBounds(x, y, rightTopSize.width, rightTopSize.height);
                y += rightTopSize.height + this._vGap;
            }
            if (rightBottom != null) {
                if (rightTop instanceof ImageComponent && leftSize.width < Math.max(rightTopSize.width, rightBottomSize.width)) {
                    ImageComponent comp = (ImageComponent)rightTop;
                    int diff = comp.__getImageCanvasWidth() - rightBottomSize.width;
                    x += diff > 0 ? diff / 2 : 0;
                }
                rightBottom.setBounds(x, y, rightBottomSize.width, rightBottomSize.height);
            }
        }

        private Component _getComponent(String pos) {
            Component comp = null;
            if (LEFT.equals(pos)) {
                comp = this._left;
            } else if (RIGHT_TOP.equals(pos)) {
                comp = this._rightTop;
            } else if (RIGHT_BOTTOM.equals(pos)) {
                comp = this._rightBottom;
            }
            if (comp != null && comp.isVisible()) {
                return comp;
            }
            return null;
        }
    }

    private class BottomLayout
    implements LayoutManager {
        public static final int CUSTOM_EDITORS = 0;
        private int _hGap;
        private int _vGap;

        public BottomLayout(int hGap, int vGap) {
            this._hGap = hGap;
            this._vGap = vGap;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component customEditors;
            Component rgbHex;
            Component cmy;
            Component hsb;
            Dimension size = new Dimension();
            int numCols = 0;
            int numRows = 0;
            Component rgb = this._getComponent(1);
            if (rgb != null) {
                Dimension d = rgb.getPreferredSize();
                size.width += d.width;
                size.height = Math.max(size.height, d.height);
                ++numCols;
            }
            if ((hsb = this._getComponent(2)) != null) {
                Dimension d = hsb.getPreferredSize();
                size.width += d.width;
                size.height = Math.max(size.height, d.height);
                ++numCols;
            }
            if ((cmy = this._getComponent(4)) != null) {
                Dimension d = cmy.getPreferredSize();
                size.width += d.width;
                size.height = Math.max(size.height, d.height);
                ++numCols;
            }
            if (numCols != 0) {
                ++numRows;
                size.width += (numCols - 1) * this._hGap;
            }
            if ((rgbHex = this._getComponent(8)) != null) {
                Dimension d = rgbHex.getPreferredSize();
                size.width = Math.max(size.width, d.width);
                size.height += d.height;
                ++numRows;
            }
            if ((customEditors = this._getComponent(0)) != null) {
                Dimension d = customEditors.getPreferredSize();
                size.width = Math.max(size.width, d.width);
                size.height += d.height;
                ++numRows;
            }
            if (numRows != 0) {
                size.height += (numRows - 1) * this._vGap;
                Insets inset = parent.getInsets();
                size.width += inset.left + inset.right;
                size.height += inset.top + inset.bottom;
            }
            return size;
        }

        @Override
        public void layoutContainer(Container parent) {
            Component cmy;
            Component hsb;
            Insets inset = parent.getInsets();
            int x = inset.left;
            int y = inset.top;
            int height = 0;
            Component rgb = this._getComponent(1);
            if (rgb != null) {
                Dimension d = rgb.getPreferredSize();
                rgb.setBounds(x, y, d.width, d.height);
                x += d.width + this._hGap;
                height = Math.max(height, d.height);
            }
            if ((hsb = this._getComponent(2)) != null) {
                Dimension d = hsb.getPreferredSize();
                hsb.setBounds(x, y, d.width, d.height);
                x += d.width + this._hGap;
                height = Math.max(height, d.height);
            }
            if ((cmy = this._getComponent(4)) != null) {
                Dimension d = cmy.getPreferredSize();
                cmy.setBounds(x, y, d.width, d.height);
                x += d.width;
                height = Math.max(height, d.height);
            }
            if (rgb != null || hsb != null || cmy != null) {
                y += height + this._vGap;
            }
            x = inset.left;
            Component rgbHex = this._getComponent(8);
            if (rgbHex != null) {
                Dimension d = rgbHex.getPreferredSize();
                rgbHex.setBounds(x, y, d.width, d.height);
                y += d.height + this._vGap;
            }
            x = inset.left;
            Component customEditors = this._getComponent(0);
            if (customEditors != null) {
                Dimension d = customEditors.getPreferredSize();
                customEditors.setBounds(x, y, d.width, d.height);
            }
        }

        private Component _getComponent(int editor) {
            JPanel comp = null;
            if (editor == 1) {
                comp = CustomColorPane.this._rgbComponent;
            } else if (editor == 2) {
                comp = CustomColorPane.this._hsbComponent;
            } else if (editor == 4) {
                comp = CustomColorPane.this._cmyComponent;
            } else if (editor == 8) {
                comp = CustomColorPane.this._rgbHexComponent;
            } else if (editor == 0 && CustomColorPane.this._customColorEditorPanel != null && CustomColorPane.this._customColorEditorPanel.getComponentCount() > 0) {
                comp = CustomColorPane.this._customColorEditorPanel;
            }
            if (comp != null && comp.isVisible()) {
                return comp;
            }
            return null;
        }
    }
}

